/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.smi.OID;

public class DefaultMOTableModel<R extends MOTableRow>
implements MOTableModel<R> {
    protected SortedMap<OID, R> rows = Collections.synchronizedSortedMap(new TreeMap());
    protected int columnCount = 0;

    public synchronized R addRow(R row) {
        this.columnCount = Math.max(row.size(), this.columnCount);
        return (R)((MOTableRow)this.rows.put(row.getIndex(), row));
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public synchronized R getRow(OID index) {
        return (R)((MOTableRow)this.rows.get(index));
    }

    @Override
    public synchronized OID firstIndex() {
        if (this.rows.size() > 0) {
            return this.rows.firstKey();
        }
        return null;
    }

    @Override
    public synchronized Iterator<R> iterator() {
        return this.rows.values().iterator();
    }

    @Override
    public synchronized R firstRow() {
        OID index = this.firstIndex();
        if (index != null) {
            return (R)((MOTableRow)this.rows.get(index));
        }
        return null;
    }

    @Override
    public synchronized OID lastIndex() {
        if (this.rows.size() > 0) {
            return this.rows.lastKey();
        }
        return null;
    }

    @Override
    public synchronized R lastRow() {
        OID index = this.lastIndex();
        if (index != null) {
            return (R)((MOTableRow)this.rows.get(index));
        }
        return null;
    }

    @Override
    public boolean containsRow(OID index) {
        return this.rows.containsKey(index);
    }

    @Override
    public synchronized Iterator<R> tailIterator(OID lowerBound) {
        if (lowerBound == null) {
            return this.iterator();
        }
        return this.rows.tailMap(lowerBound).values().iterator();
    }

    public synchronized void dump(OutputStream os) throws IOException {
        os.write(("Dump of " + this.getClass().getName() + ":\n").getBytes());
        for (Map.Entry<OID, R> e : this.rows.entrySet()) {
            os.write((e.getKey() + " # " + e.getValue() + "\n").getBytes());
        }
    }
}

