/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.treetable;

import com.klg.jclass.swing.DefaultTreeTableSelectionModel;
import com.klg.jclass.swing.JCTreeTable;
import com.klg.jclass.swing.JCTreeTableSelectionModel;
import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.swing.DefaultRowSortTableModel;
import com.klg.jclass.util.swing.JCAction;
import com.klg.jclass.util.swing.JCRowSortModel;
import com.klg.jclass.util.swing.JCRowSortTableModel;
import com.klg.jclass.util.treetable.DefaultTreeIconRenderer;
import com.klg.jclass.util.treetable.EmptyTreeTableModel;
import com.klg.jclass.util.treetable.JCTreeIconRenderer;
import com.klg.jclass.util.treetable.JCTreeTableModel;
import com.klg.jclass.util.treetable.TableFromTreeTable;
import com.klg.jclass.util.treetable.TreeWithSortableChildren;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.TableModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreePath;

public class TreeTableSupport
implements TableModel,
JCRowSortTableModel,
TableModelListener,
RowMapper,
Serializable {
    public static final int TREE = 1;
    public static final int TABLE = 2;
    public static final int NODE_LINES_SHOW = 1;
    public static final int NODE_LINES_HIDE = 2;
    public static final int NODE_LINES_USE_PLAF = 3;
    protected boolean sortable = true;
    protected int sortOrder = 1;
    protected int[][] keyColumnsArray;
    protected boolean autoSort = true;
    protected int showNodeLines = 3;
    protected JComponent visualComponent;
    protected int view = 1;
    protected JCTreeTableModel treetable = null;
    protected TableModel table;
    protected TreeModelListener treeListener = new TreeListener();
    protected JCListenerList tableListeners = null;
    protected int treeColumn = 0;
    protected JCListenerList treeExpansionListeners;
    protected JCListenerList treeSelectionListeners;
    protected JCListenerList treeWillExpandListeners;
    protected boolean rootVisible = true;
    protected boolean showsRootHandles = false;
    protected JCTreeIconRenderer iconRenderer = new DefaultTreeIconRenderer();
    protected boolean scrollsOnExpand;
    protected Icon expandedIcon;
    protected Icon collapsedIcon;
    protected int leftLevelSpacing;
    protected int rightLevelSpacing;
    protected int levelIndent;
    protected Icon openIcon;
    protected Icon closedIcon;
    protected Icon leafIcon;
    protected Color lineColor;
    protected int lineThickness;
    protected Stroke lineStroke;
    protected boolean drawLines;
    protected Color tableBackground;
    private boolean isMotif = false;
    protected int cellHeight;
    protected RemovableVector rowMap = null;
    protected Hashtable expandedState = null;
    static /* synthetic */ Class class$javax$swing$tree$TreePath;

    public TreeTableSupport(JComponent jComponent, JCTreeTableModel jCTreeTableModel) {
        this(jComponent);
        this.setTreeTableModel(jCTreeTableModel);
    }

    public TreeTableSupport(JComponent jComponent) {
        this.visualComponent = jComponent;
        this.inferLookAndFeel();
    }

    public void inferLookAndFeel() {
        this.expandedIcon = (Icon)UIManager.get("Tree.expandedIcon");
        if (this.expandedIcon == null) {
            this.expandedIcon = new DefaultIcon(false);
        }
        this.collapsedIcon = (Icon)UIManager.get("Tree.collapsedIcon");
        if (this.collapsedIcon == null) {
            this.collapsedIcon = new DefaultIcon(true);
        }
        this.leftLevelSpacing = (Integer)UIManager.get("Tree.leftChildIndent");
        this.rightLevelSpacing = (Integer)UIManager.get("Tree.rightChildIndent");
        this.openIcon = (Icon)UIManager.get("Tree.openIcon");
        this.closedIcon = (Icon)UIManager.get("Tree.closedIcon");
        this.leafIcon = (Icon)UIManager.get("Tree.leafIcon");
        this.lineColor = (Color)UIManager.get("Tree.hash");
        this.scrollsOnExpand = (Boolean)UIManager.get("Tree.scrollsOnExpand");
        this.levelIndent = this.leftLevelSpacing + this.rightLevelSpacing;
        this.tableBackground = (Color)UIManager.get("Table.background");
        this.cellHeight = Math.max(this.openIcon.getIconHeight(), this.closedIcon.getIconHeight());
        this.cellHeight = Math.max(this.cellHeight, this.leafIcon.getIconHeight());
        if (JCEnvironment.isMetal()) {
            this.drawLines = false;
        } else if (JCEnvironment.isMotif()) {
            this.drawLines = true;
            this.lineThickness = 2;
            this.isMotif = true;
            this.lineStroke = new BasicStroke(this.lineThickness, 0, 2, 5.0f, null, 0.0f);
        } else {
            this.drawLines = true;
            this.lineThickness = 1;
            float[] fArray = new float[]{this.lineThickness, this.lineThickness};
            this.lineStroke = new BasicStroke(this.lineThickness, 0, 2, 5.0f, fArray, 0.0f);
        }
        if (this.showNodeLines != 3) {
            this.drawLines = this.showNodeLines == 1;
        }
    }

    public int[] getRowsForPaths(TreePath[] treePathArray) {
        if (treePathArray == null) {
            return null;
        }
        int[] nArray = new int[treePathArray.length];
        int n = 0;
        int n2 = 0;
        while (n < treePathArray.length) {
            int n3 = this.getRowForPath(treePathArray[n]);
            if (n3 >= 0) {
                nArray[n2++] = n3;
            }
            ++n;
        }
        if (n != n2) {
            int[] nArray2 = new int[n2];
            int n4 = 0;
            while (n4 < n2) {
                nArray2[n4] = nArray[n4];
                ++n4;
            }
            nArray = nArray2;
        }
        return nArray;
    }

    public void setShowNodeLines(int n) {
        if (this.showNodeLines == n) {
            return;
        }
        if (n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("Invalid value for showNodeLines");
        }
        this.showNodeLines = n;
        if (this.showNodeLines == 3) {
            this.inferLookAndFeel();
        }
        this.drawLines = this.showNodeLines == 1;
    }

    public int getShowNodeLines() {
        return this.showNodeLines;
    }

    public int getMaxIconHeight() {
        return this.cellHeight;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(boolean bl) {
        this.sortable = bl;
    }

    protected void initTableViewModels() {
        if (this.table != null) {
            this.table.removeTableModelListener(this);
        }
        this.table = new TableFromTreeTable(this.treetable);
        if (!(this.table instanceof JCRowSortTableModel)) {
            this.table = new DefaultRowSortTableModel(this.table);
        }
        this.table.addTableModelListener(this);
    }

    public void setView(int n) {
        if (this.view == n) {
            return;
        }
        if (n != 2 && n != 1) {
            throw new IllegalArgumentException("view must be one of TREE or TABLE");
        }
        this.view = n;
        if (n == 2) {
            this.initTableViewModels();
        }
        this.postTableModelChanged(new TableModelEvent(this));
    }

    public int getView() {
        return this.view;
    }

    public void setTreeTableModel(JCTreeTableModel jCTreeTableModel) {
        if (jCTreeTableModel == null) {
            jCTreeTableModel = new EmptyTreeTableModel(EmptyTreeTableModel.makeDefaultTree());
        }
        if (this.sortable && this.view == 1 && !(jCTreeTableModel instanceof JCRowSortModel)) {
            jCTreeTableModel = new TreeWithSortableChildren(jCTreeTableModel);
        }
        if (this.treetable == jCTreeTableModel) {
            return;
        }
        this.treetable = jCTreeTableModel;
        jCTreeTableModel.addTreeModelListener(this.treeListener);
        if (this.view == 2) {
            this.initTableViewModels();
        }
        this.clearExpandedState(false);
    }

    public void clearExpandedState() {
        this.clearExpandedState(true);
    }

    protected void clearExpandedState(boolean bl) {
        this.expandedState = new Hashtable();
        this.mapTreeTable(bl);
        if (this.visualComponent instanceof JCTreeTable) {
            JCTreeTable jCTreeTable = (JCTreeTable)this.visualComponent;
            jCTreeTable.removeEditor();
            JCTreeTableSelectionModel jCTreeTableSelectionModel = jCTreeTable.getTreeSelectionModel();
            if (jCTreeTableSelectionModel != null) {
                jCTreeTable.setTreeTableSelectionModel(new DefaultTreeTableSelectionModel());
            }
        }
    }

    protected void mapTreeTable(boolean bl) {
        DefaultRowSortTableModel defaultRowSortTableModel;
        TableModel tableModel;
        Object object = this.treetable.getRoot();
        this.rowMap = new RemovableVector();
        TreePath treePath = new TreePath(object);
        if (this.rootVisible) {
            this.rowMap.add(treePath);
        } else if (!this.treetable.isLeaf(object)) {
            this.expandedState.put(treePath, Boolean.TRUE);
        }
        Vector vector = new Vector();
        this.getExpandedKids(treePath, vector);
        this.rowMap.addAll(vector);
        if (this.table instanceof DefaultRowSortTableModel && (tableModel = (defaultRowSortTableModel = (DefaultRowSortTableModel)this.table).getModel()) instanceof TableFromTreeTable) {
            TableFromTreeTable tableFromTreeTable = (TableFromTreeTable)tableModel;
            tableFromTreeTable.resetMappings();
        }
        if (bl) {
            this.postTableModelChanged(new TableModelEvent(this));
        }
    }

    public JCTreeTableModel getTreeTableModel() {
        return this.treetable;
    }

    public TableModel getTableModel() {
        return this.table;
    }

    public boolean hasBeenExpanded(TreePath treePath) {
        return treePath != null && this.expandedState.get(treePath) != null;
    }

    protected void postTableModelChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent == null) {
            return;
        }
        Enumeration enumeration = JCListenerList.elements(this.tableListeners);
        while (enumeration.hasMoreElements()) {
            TableModelListener tableModelListener = (TableModelListener)enumeration.nextElement();
            tableModelListener.tableChanged(tableModelEvent);
        }
    }

    public void setTreeIconRenderer(JCTreeIconRenderer jCTreeIconRenderer) {
        this.iconRenderer = jCTreeIconRenderer;
    }

    public JCTreeIconRenderer getTreeIconRenderer() {
        return this.iconRenderer;
    }

    public TreePath getPathForRow(int n) {
        return this.getPathForRow(this.view, n);
    }

    protected TreePath getPathForRow(int n, int n2) {
        DefaultRowSortTableModel defaultRowSortTableModel;
        TableModel tableModel;
        if (n == 1) {
            return (TreePath)this.rowMap.elementAt(n2);
        }
        if (this.table instanceof DefaultRowSortTableModel && (tableModel = (defaultRowSortTableModel = (DefaultRowSortTableModel)this.table).getModel()) instanceof TableFromTreeTable) {
            TableFromTreeTable tableFromTreeTable = (TableFromTreeTable)tableModel;
            int n3 = defaultRowSortTableModel.getUnsortedRow(n2);
            return tableFromTreeTable.rowToTreePath(n3);
        }
        return null;
    }

    public int getRowForPath(TreePath treePath) {
        return this.getRowForPath(this.view, treePath);
    }

    protected int getRowForPath(int n, TreePath treePath) {
        DefaultRowSortTableModel defaultRowSortTableModel;
        TableModel tableModel;
        if (n == 1) {
            int n2 = 0;
            while (n2 < this.rowMap.size()) {
                if (this.rowMap.elementAt(n2).equals(treePath)) {
                    return n2;
                }
                ++n2;
            }
        } else if (this.table instanceof DefaultRowSortTableModel && (tableModel = (defaultRowSortTableModel = (DefaultRowSortTableModel)this.table).getModel()) instanceof TableFromTreeTable) {
            TableFromTreeTable tableFromTreeTable = (TableFromTreeTable)tableModel;
            int n3 = tableFromTreeTable.treePathToRow(treePath);
            return defaultRowSortTableModel.getSortedRow(n3);
        }
        return -1;
    }

    public boolean isExpanded(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Object v = this.expandedState.get(treePath);
        if (v == null) {
            return false;
        }
        if (!((Boolean)v).booleanValue()) {
            return false;
        }
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 != null) {
            return this.isExpanded(treePath2);
        }
        return true;
    }

    public boolean getAutoSort() {
        if (!this.sortable) {
            this.autoSort = false;
        }
        return this.autoSort;
    }

    public void setAutoSort(boolean bl) {
        if (this.autoSort == bl) {
            return;
        }
        this.autoSort = bl;
        JCRowSortModel jCRowSortModel = this.getRowSortModel();
        if (jCRowSortModel != null) {
            jCRowSortModel.setAutoSort(bl);
        }
    }

    public void setKeyColumns(int n, int[] nArray) {
        if (this.keyColumnsArray == null) {
            this.keyColumnsArray = new int[this.treetable.getColumnCount()][];
        }
        this.keyColumnsArray[n] = nArray;
        JCRowSortModel jCRowSortModel = this.getRowSortModel();
        if (jCRowSortModel != null) {
            jCRowSortModel.setKeyColumns(n, nArray);
        }
    }

    public int[] getKeyColumns(int n) {
        return this.keyColumnsArray[n];
    }

    protected JCRowSortModel getRowSortModel() {
        if (this.sortable && this.view == 1 && this.treetable instanceof JCRowSortModel) {
            return (JCRowSortModel)((Object)this.treetable);
        }
        if (this.sortable && this.view == 2 && this.table != null) {
            return (JCRowSortModel)((Object)this.table);
        }
        return null;
    }

    public boolean isDataSorted() {
        JCRowSortModel jCRowSortModel = this.getRowSortModel();
        if (jCRowSortModel != null) {
            return jCRowSortModel.isDataSorted();
        }
        return false;
    }

    public void setDataSorted(boolean bl) {
        JCRowSortModel jCRowSortModel = this.getRowSortModel();
        if (jCRowSortModel != null) {
            jCRowSortModel.setDataSorted(bl);
        }
    }

    public int getSortColumn() {
        JCRowSortModel jCRowSortModel = this.getRowSortModel();
        if (jCRowSortModel != null) {
            return jCRowSortModel.getSortColumn();
        }
        return -1;
    }

    public void setSortColumn(int n) {
        if (!this.sortable) {
            return;
        }
        if (this.getSortColumn() == n) {
            return;
        }
        JCRowSortModel jCRowSortModel = this.getRowSortModel();
        if (jCRowSortModel != null) {
            jCRowSortModel.setSortColumn(n);
        }
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int n) {
        if (this.sortOrder == n) {
            return;
        }
        JCRowSortModel jCRowSortModel = this.getRowSortModel();
        if (jCRowSortModel != null) {
            jCRowSortModel.setSortOrder(n);
        }
        this.sortOrder = n;
    }

    public void toggleSortOrder() {
        this.sortOrder = this.sortOrder == 1 ? -1 : 1;
        JCRowSortModel jCRowSortModel = this.getRowSortModel();
        if (jCRowSortModel != null) {
            jCRowSortModel.setSortOrder(this.sortOrder);
        }
    }

    public int getUnsortedRow(int n) {
        if (this.table == null) {
            return -1;
        }
        JCRowSortTableModel jCRowSortTableModel = (JCRowSortTableModel)((Object)this.table);
        return jCRowSortTableModel.getUnsortedRow(n);
    }

    public int getSortedRow(int n) {
        if (this.table == null) {
            return -1;
        }
        JCRowSortTableModel jCRowSortTableModel = (JCRowSortTableModel)((Object)this.table);
        return jCRowSortTableModel.getSortedRow(n);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        TableModelEvent tableModelEvent2 = new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), tableModelEvent.getColumn(), tableModelEvent.getType());
        Enumeration enumeration = JCListenerList.elements(this.tableListeners);
        while (enumeration.hasMoreElements()) {
            TableModelListener tableModelListener = (TableModelListener)enumeration.nextElement();
            tableModelListener.tableChanged(tableModelEvent2);
        }
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.tableListeners = JCListenerList.add(this.tableListeners, tableModelListener);
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.tableListeners = JCListenerList.remove(this.tableListeners, tableModelListener);
    }

    public Class getColumnClass(int n) {
        Class clazz = null;
        clazz = this.view == 1 && n == this.getTreeColumn() ? (class$javax$swing$tree$TreePath == null ? (class$javax$swing$tree$TreePath = TreeTableSupport.class$("javax.swing.tree.TreePath")) : class$javax$swing$tree$TreePath) : this.treetable.getColumnClass(n);
        return clazz;
    }

    public int getColumnCount() {
        return this.treetable.getColumnCount();
    }

    public String getColumnName(int n) {
        return this.treetable.getColumnName(n);
    }

    public int getRowCount() {
        if (this.view == 1) {
            return this.rowMap.size();
        }
        if (this.table != null) {
            return this.table.getRowCount();
        }
        return 0;
    }

    public Object getValueAt(int n, int n2) {
        if (this.view == 1) {
            if (n2 == this.getTreeColumn()) {
                return this.rowMap.elementAt(n);
            }
            return this.treetable.getValueAt(this.getNode(n), n2);
        }
        if (this.table != null) {
            return this.table.getValueAt(n, n2);
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.view == 1) {
            return this.treetable.isCellEditable(this.getNode(n), n2);
        }
        if (this.table != null) {
            return this.table.isCellEditable(n, n2);
        }
        return false;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (this.view == 1) {
            this.treetable.setValueAt(object, this.getNode(n), n2);
        } else if (this.table != null) {
            this.table.setValueAt(object, n, n2);
        }
    }

    protected static Object getParent(TreePath treePath) {
        if (treePath.getPathCount() == 1) {
            return null;
        }
        return treePath.getPathComponent(treePath.getPathCount() - 2);
    }

    protected static Object getNode(TreePath treePath) {
        return treePath.getLastPathComponent();
    }

    protected Object getNode(int n) {
        TreePath treePath = (TreePath)this.rowMap.elementAt(n);
        if (treePath == null) {
            return null;
        }
        return treePath.getLastPathComponent();
    }

    protected int getLevel(int n) {
        TreePath treePath = this.getPathForRow(n);
        return treePath.getPathCount();
    }

    protected void toggleState(int n) {
        if (this.isExpanded(this.getPathForRow(1, n))) {
            this.collapseRow(n);
        } else {
            this.expandRow(n);
        }
    }

    public boolean processClickInTreeColumn(MouseEvent mouseEvent, int n, int n2, Point point, int n3) {
        JCTreeTable jCTreeTable;
        if (n < 0 || n2 < 0) {
            return false;
        }
        if (this.view != 1) {
            return false;
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return false;
        }
        if (this.treetable.isLeaf(this.getNode(n))) {
            return false;
        }
        if (this.visualComponent instanceof JCTreeTable && (jCTreeTable = (JCTreeTable)this.visualComponent).isExpandInTreeColumnOnly() && jCTreeTable.getTreeColumn() != n2) {
            return false;
        }
        if (!this.isPointInControlBox(point, n, n2, n3, this.getLevel(n)) && mouseEvent.getClickCount() <= 1) {
            return false;
        }
        this.toggleState(n);
        mouseEvent.consume();
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean isPointInControlBox(Point var1_1, int var2_2, int var3_3, int var4_4, int var5_5) {
        block7: {
            --var5_5;
            if (!this.showsRootHandles) {
                --var5_5;
            }
            if (!this.rootVisible) {
                --var5_5;
            }
            var6_6 = true;
            var7_7 = 0;
            var8_8 = null;
            if (this.visualComponent instanceof JTable) {
                var6_6 = this.visualComponent.getComponentOrientation().isLeftToRight();
                var8_8 = ((JTable)this.visualComponent).getColumnModel();
                var7_7 = var8_8.getColumn(var3_3).getWidth();
            }
            var9_9 = this.expandedIcon.getIconWidth();
            var10_10 = this.expandedIcon.getIconHeight();
            var11_11 = this.levelIndent / 2 + var5_5 * this.levelIndent;
            if (!var6_6) {
                var11_11 = var7_7 - var11_11;
            }
            var11_11 -= var9_9 / 2;
            var12_12 = var4_4 / 2 - var10_10 / 2;
            if (!(this.visualComponent instanceof JCTreeTable)) break block7;
            var13_13 = (JCTreeTable)this.visualComponent;
            if (var3_3 != var13_13.getTreeColumn()) {
                return false;
            }
            var14_15 = var6_6 != false ? 0 : var8_8.getColumnCount() - 1;
            var1_1.y -= var2_2 * var13_13.getRowHeight();
            if (JCEnvironment.getJavaVersion() >= 130) ** GOTO lbl37
            var15_16 = var13_13.getIntercellSpacing();
            var11_11 += var15_16.width / 2;
            while (var6_6 == false ? var14_15 > var3_3 : var14_15 < var3_3) {
                var11_11 += var8_8.getColumn(var14_15).getWidth() + var15_16.width;
                v0 = var14_15 = var6_6 != false ? var14_15 + 1 : var14_15 - 1;
            }
            var1_1.y -= var2_2 * var15_16.height;
            break block7;
lbl-1000:
            // 1 sources

            {
                var11_11 += var8_8.getColumn(var14_15).getWidth();
                v1 = var14_15 = var6_6 != false ? var14_15 + 1 : var14_15 - 1;
lbl37:
                // 2 sources

                ** while (var6_6 == false ? var14_15 > var3_3 : var14_15 < var3_3)
            }
        }
        var13_14 = var1_1.x >= var11_11 && var1_1.x < var11_11 + var9_9;
        var14_15 = var1_1.y >= var12_12 && var1_1.y < var12_12 + var10_10 ? 1 : 0;
        return var13_14 != false && var14_15 != 0;
    }

    protected void addKids(Object object, TreePath treePath, Vector vector) {
        int n = this.treetable.getChildCount(object);
        int n2 = 0;
        while (n2 < n) {
            Object object2 = this.treetable.getChild(object, n2);
            TreePath treePath2 = treePath.pathByAddingChild(object2);
            vector.add(treePath2);
            if (this.isExpanded(treePath2)) {
                this.addKids(object2, treePath2, vector);
            }
            ++n2;
        }
    }

    public void expandRow(int n) {
        this.expandPathRow(this.getPathForRow(1, n), n);
    }

    protected int countKidsToRemove(Object object, TreePath treePath) {
        int n;
        int n2 = n = this.treetable.getChildCount(object);
        int n3 = 0;
        while (n3 < n) {
            Object object2 = this.treetable.getChild(object, n3);
            TreePath treePath2 = treePath.pathByAddingChild(object2);
            if (this.isExpanded(treePath2)) {
                n2 += this.countKidsToRemove(object2, treePath2);
            }
            ++n3;
        }
        return n2;
    }

    public void collapseRow(int n) {
        this.collapsePathRow(this.getPathForRow(1, n), n);
    }

    public void collapsePathRow(TreePath treePath, int n) {
        if (!this.isExpanded(treePath)) {
            return;
        }
        TreeExpansionEvent treeExpansionEvent = new TreeExpansionEvent(this.visualComponent, treePath);
        Enumeration enumeration = JCListenerList.elements(this.treeWillExpandListeners);
        while (enumeration.hasMoreElements()) {
            TreeWillExpandListener treeWillExpandListener = (TreeWillExpandListener)enumeration.nextElement();
            try {
                treeWillExpandListener.treeWillCollapse(treeExpansionEvent);
            }
            catch (ExpandVetoException expandVetoException) {
                return;
            }
        }
        int n2 = this.countKidsToRemove(this.getNode(n), treePath);
        this.expandedState.put(treePath, Boolean.FALSE);
        this.rowMap.remove(n + 1, n + 1 + n2);
        TableModelEvent tableModelEvent = new TableModelEvent(this, n + 1, n + n2, -1, -1);
        this.postTableModelChanged(tableModelEvent);
        enumeration = JCListenerList.elements(this.treeExpansionListeners);
        while (enumeration.hasMoreElements()) {
            TreeExpansionListener treeExpansionListener = (TreeExpansionListener)enumeration.nextElement();
            treeExpansionListener.treeCollapsed(treeExpansionEvent);
        }
    }

    protected static boolean isLastChild(JCTreeTableModel jCTreeTableModel, TreePath treePath) {
        Object object = TreeTableSupport.getParent(treePath);
        if (object == null) {
            return true;
        }
        return jCTreeTableModel.getIndexOfChild(object, TreeTableSupport.getNode(treePath)) == jCTreeTableModel.getChildCount(object) - 1;
    }

    public void prepareCellForRender(Graphics graphics, int n, int n2) {
        graphics.setColor(this.tableBackground);
        graphics.fillRect(0, 0, n, n2);
    }

    protected Icon getNodeIcon(TreePath treePath, Object object, Class clazz, boolean bl, boolean bl2) {
        if (this.iconRenderer == null) {
            return null;
        }
        Icon icon = null;
        icon = bl ? this.leafIcon : (bl2 ? this.openIcon : this.closedIcon);
        Icon icon2 = this.iconRenderer.getNodeIcon(this.treetable, TreeTableSupport.getNode(treePath), object, clazz, bl, bl2, icon);
        return icon2;
    }

    public void renderHierarchy(Graphics graphics, Rectangle rectangle, TreePath treePath, Object object, Class clazz) {
        int n;
        graphics.setColor(this.lineColor);
        Stroke stroke = null;
        if (this.lineStroke != null && graphics instanceof Graphics2D) {
            stroke = ((Graphics2D)graphics).getStroke();
            ((Graphics2D)graphics).setStroke(this.lineStroke);
        }
        int n2 = treePath.getPathCount() - 1;
        boolean bl = this.isExpanded(treePath);
        boolean bl2 = this.treetable.isLeaf(TreeTableSupport.getNode(treePath));
        int n3 = 0;
        if (this.rootVisible) {
            n3 = 0;
        } else if (!this.showsRootHandles) {
            n3 = 1;
        }
        boolean bl3 = this.visualComponent.getComponentOrientation().isLeftToRight();
        int n4 = rectangle.y;
        int n5 = rectangle.height / 2 + n4;
        int n6 = rectangle.height + n4;
        int n7 = rectangle.width;
        int n8 = this.levelIndent / 2;
        int n9 = -1;
        TreePath treePath2 = treePath;
        int n10 = this.getNodeIndent(treePath);
        int n11 = 1;
        while (n11 < n2 - n3) {
            if (!TreeTableSupport.isLastChild(this.treetable, treePath2 = treePath2.getParentPath())) {
                n9 = n10 - n11 * this.levelIndent - n8;
                if (!bl3) {
                    n9 = n7 - n9;
                }
                if (this.drawLines) {
                    graphics.drawLine(n9, n4, n9, n6);
                }
            }
            ++n11;
        }
        if ((n2 != 0 || this.showsRootHandles) && (n2 != 1 || this.rootVisible || this.showsRootHandles)) {
            n9 = n10 - n8;
            if (!bl3) {
                n9 = n7 - n9;
            }
            if (this.drawLines) {
                if (TreeTableSupport.isLastChild(this.treetable, treePath)) {
                    graphics.drawLine(n9, n4, n9, n5);
                } else {
                    graphics.drawLine(n9, n4, n9, n6);
                }
            }
            if (this.drawLines) {
                int n12 = bl3 ? n8 : -n8;
                graphics.drawLine(n9, n5, n9 + n12, n5);
            }
            if (this.lineStroke != null && graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).setStroke(stroke);
            }
            if (!bl2) {
                Icon icon = bl ? this.expandedIcon : this.collapsedIcon;
                n = n9 - icon.getIconWidth() / 2;
                int n13 = n5 - icon.getIconHeight() / 2;
                icon.paintIcon(this.visualComponent, graphics, n, n13);
            }
        }
        if (this.iconRenderer == null) {
            return;
        }
        Icon icon = this.getNodeIcon(treePath, object, clazz, bl2, bl);
        if (icon != null) {
            n9 = bl3 ? n10 : n7 - n10 - icon.getIconWidth();
            n = 0;
            String string = "MotifTreeLeafIcon";
            if (this.isMotif && bl2 && JCEnvironment.isWorking(string) == 2) {
                n = 1;
                graphics.translate(n9, 0);
            }
            icon.paintIcon(this.visualComponent, graphics, n9, rectangle.y);
            if (n != 0) {
                graphics.translate(-n9, 0);
            }
        }
    }

    public int getNodeIndent(TreePath treePath) {
        if (treePath == null) {
            return 0;
        }
        int n = treePath.getPath().length;
        if (!this.rootVisible) {
            --n;
        }
        if (!this.showsRootHandles) {
            --n;
        }
        return n * this.getLevelIndent();
    }

    public int getRendererIndent(TreePath treePath) {
        return this.getRendererIndent(treePath, null, null);
    }

    public int getRendererIndent(TreePath treePath, Object object, Class clazz) {
        if (treePath == null) {
            return 0;
        }
        int n = this.getNodeIndent(treePath);
        if (this.iconRenderer != null) {
            Icon icon = this.getNodeIcon(treePath, object, clazz, this.treetable.isLeaf(TreeTableSupport.getNode(treePath)), this.isExpanded(treePath));
            n += icon.getIconWidth();
        }
        return n;
    }

    public int getLevelIndent() {
        return this.levelIndent;
    }

    public Class getTreeColumnClass() {
        return this.treetable.getColumnClass(this.getTreeColumn());
    }

    public Object getTreeColumnValue(Object object) {
        return this.treetable.getValueAt(object, this.getTreeColumn());
    }

    public int getTreeColumn() {
        return this.treeColumn;
    }

    public Enumeration getExpandedDescendants(TreePath treePath) {
        if (!this.isExpanded(treePath)) {
            return null;
        }
        Vector vector = new Vector();
        this.getExpandedKids(treePath, vector);
        return vector.elements();
    }

    protected void getExpandedKids(TreePath treePath, Vector vector) {
        if (!this.isExpanded(treePath)) {
            return;
        }
        Object object = treePath.getLastPathComponent();
        int n = this.treetable.getChildCount(object);
        int n2 = 0;
        while (n2 < n) {
            Object object2 = this.treetable.getChild(object, n2);
            TreePath treePath2 = treePath.pathByAddingChild(object2);
            vector.add(treePath2);
            if (!this.treetable.isLeaf(object2)) {
                this.getExpandedKids(treePath2, vector);
            }
            ++n2;
        }
    }

    public void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.treeExpansionListeners = JCListenerList.add(this.treeExpansionListeners, treeExpansionListener);
    }

    public void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.treeExpansionListeners = JCListenerList.remove(this.treeExpansionListeners, treeExpansionListener);
    }

    public void addTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.treeWillExpandListeners = JCListenerList.add(this.treeWillExpandListeners, treeWillExpandListener);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.treeWillExpandListeners = JCListenerList.remove(this.treeWillExpandListeners, treeWillExpandListener);
    }

    public void collapsePath(TreePath treePath) {
        this.collapsePathRow(treePath, this.getRowForPath(1, treePath));
    }

    public void expandPath(TreePath treePath) {
        if (this.isExpanded(treePath)) {
            // empty if block
        }
        int n = this.getRowForPath(1, treePath);
        this.expandPathRow(treePath, n);
    }

    protected void expandPathRow(TreePath treePath, int n) {
        int n2;
        Object object;
        if (this.isExpanded(treePath)) {
            return;
        }
        if (n == -1) {
            TreePath treePath2 = null;
            int n3 = -1;
            int n4 = this.rootVisible ? 0 : 1;
            while (n4 < treePath.getPathCount() - 1) {
                Object object2 = treePath.getPathComponent(n4);
                if (treePath2 == null) {
                    treePath2 = new TreePath(treePath.getPathComponent(0));
                    if (n4 != 0) {
                        treePath2 = treePath2.pathByAddingChild(object2);
                    }
                    n3 = this.getRowForPath(1, treePath2);
                } else {
                    treePath2 = treePath2.pathByAddingChild(treePath.getPathComponent(n4));
                    n3 = this.getRowForPath(1, treePath2);
                }
                if (!this.isExpanded(treePath2)) {
                    this.expandPathRow(treePath2, n3);
                }
                ++n4;
            }
            int n5 = treePath.getPathCount();
            if (n5 > 1) {
                n += n3 + 2 + this.treetable.getIndexOfChild(treePath.getPathComponent(n5 - 2), treePath.getPathComponent(n5 - 1));
            }
        }
        int n6 = n + 1;
        TreeExpansionEvent treeExpansionEvent = new TreeExpansionEvent(this.visualComponent, treePath);
        Enumeration enumeration = JCListenerList.elements(this.treeWillExpandListeners);
        while (enumeration.hasMoreElements()) {
            TreeWillExpandListener treeWillExpandListener = (TreeWillExpandListener)enumeration.nextElement();
            try {
                treeWillExpandListener.treeWillExpand(treeExpansionEvent);
            }
            catch (ExpandVetoException expandVetoException) {
                return;
            }
        }
        Object object3 = TreeTableSupport.getNode(treePath);
        this.expandedState.put(treePath, Boolean.TRUE);
        if (!this.isExpanded(treePath)) {
            return;
        }
        TreePath treePath3 = null;
        boolean bl = false;
        boolean bl2 = false;
        JTable jTable = null;
        ListSelectionModel listSelectionModel = null;
        if (this.visualComponent instanceof JTable) {
            jTable = (JTable)this.visualComponent;
            listSelectionModel = jTable.getSelectionModel();
        }
        if (jTable != null && this.view == 1 && listSelectionModel.isSelectedIndex(n6)) {
            treePath3 = this.getPathForRow(n6);
            if (listSelectionModel.getSelectionMode() == 0) {
                bl = true;
            } else {
                bl2 = true;
            }
        }
        Vector vector = new Vector();
        this.addKids(object3, treePath, vector);
        this.rowMap.addAll(n6, vector);
        TableModelEvent tableModelEvent = new TableModelEvent(this, n6, n + vector.size(), -1, 1);
        this.postTableModelChanged(tableModelEvent);
        enumeration = JCListenerList.elements(this.treeExpansionListeners);
        while (enumeration.hasMoreElements()) {
            object = (TreeExpansionListener)enumeration.nextElement();
            object.treeExpanded(treeExpansionEvent);
        }
        if (jTable != null && this.view == 1) {
            int n7 = this.getRowForPath(treePath3);
            if (bl) {
                jTable.setRowSelectionInterval(n7, n7);
            } else if (bl2 && n7 - n6 > 0) {
                int n8 = listSelectionModel.getAnchorSelectionIndex();
                n2 = listSelectionModel.getLeadSelectionIndex();
                if (n8 >= n7 && n2 >= n7) {
                    listSelectionModel.removeSelectionInterval(n6, n7 - 1);
                    listSelectionModel.setAnchorSelectionIndex(n8);
                    listSelectionModel.setLeadSelectionIndex(n2);
                }
            }
        }
        if (this.getScrollsOnExpand() && jTable != null && this.visualComponent.getParent() instanceof JViewport) {
            object = (JViewport)this.visualComponent.getParent();
            if (!(((Component)object).getParent() instanceof JScrollPane)) {
                return;
            }
            Point point = ((JViewport)object).getViewPosition();
            n2 = ((JViewport)object).getExtentSize().height;
            Rectangle rectangle = jTable.getCellRect(n + vector.size(), 0, true);
            if (rectangle.y + rectangle.height <= point.y + n2) {
                return;
            }
            Rectangle rectangle2 = jTable.getCellRect(n, 0, true);
            Rectangle rectangle3 = new Rectangle(rectangle);
            rectangle3.height = n2;
            int n9 = rectangle.y - rectangle2.y + rectangle.height;
            rectangle3.y = n9 <= n2 ? rectangle.y + rectangle.height - n2 - point.y : rectangle2.y - point.y;
            ((JViewport)object).scrollRectToVisible(rectangle3);
        }
    }

    public boolean getScrollsOnExpand() {
        return this.scrollsOnExpand;
    }

    public void setScrollsOnExpand(boolean bl) {
        boolean bl2 = this.scrollsOnExpand;
        this.scrollsOnExpand = bl;
        this.visualComponent.firePropertyChange("scrollsOnExpand", bl2, bl);
    }

    public boolean isRootVisible() {
        return this.rootVisible;
    }

    public void setRootVisible(boolean bl) {
        boolean bl2 = this.rootVisible;
        this.rootVisible = bl;
        this.visualComponent.firePropertyChange("rootVisible", bl2, bl);
        if (this.treetable != null) {
            this.mapTreeTable(true);
        }
    }

    public boolean getShowsRootHandles() {
        return this.showsRootHandles;
    }

    public void setShowsRootHandles(boolean bl) {
        if (bl == this.showsRootHandles) {
            return;
        }
        boolean bl2 = this.showsRootHandles;
        this.showsRootHandles = bl;
        this.visualComponent.firePropertyChange("showsRootHandles", bl2, this.showsRootHandles);
        this.visualComponent.invalidate();
    }

    public void scrollPathToVisible(TreePath treePath) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class DefaultIcon
    implements Icon {
        protected final int size = 9;
        protected final int halfsize = 4;
        protected boolean collapsed;

        public DefaultIcon(boolean bl) {
            this.collapsed = bl;
        }

        public int getIconHeight() {
            return 9;
        }

        public int getIconWidth() {
            return 9;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.clearRect(n - 4, n2, 8, 8);
            graphics.drawRect(n - 4, n2, 8, 8);
            graphics.drawLine(n - 4 + 2, n2 + 4, n + 4 - 2, n2 + 4);
            if (this.collapsed) {
                graphics.drawLine(n, n2 + 2, n, n2 + 9 - 3);
            }
        }
    }

    class RemovableVector
    extends Vector {
        RemovableVector() {
        }

        public void remove(int n, int n2) {
            this.removeRange(n, n2);
        }
    }

    class ToggleViewAction
    extends JCAction {
        public ToggleViewAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (TreeTableSupport.this.view == 2) {
                TreeTableSupport.this.setView(1);
            } else {
                TreeTableSupport.this.setView(2);
            }
        }
    }

    class TreeListener
    implements TreeModelListener,
    Serializable {
        TreeListener() {
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            TreeTableSupport.this.mapTreeTable(true);
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            TreeTableSupport.this.mapTreeTable(true);
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreeTableSupport.this.mapTreeTable(true);
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            TreeTableSupport.this.mapTreeTable(true);
        }
    }
}

