/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.treetable;

import com.klg.jclass.util.treetable.JCTreeTableModel;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;

public class TableFromTreeTable
implements TableModel {
    protected JCTreeTableModel treetable = null;
    protected ArrayList rowMap = null;
    protected int hashInt = 0;
    protected Hashtable treeMap = null;

    public TableFromTreeTable(JCTreeTableModel jCTreeTableModel) {
        this.treetable = jCTreeTableModel;
    }

    protected void addKids(TreePath treePath, Object object) {
        int n = this.treetable.getChildCount(object);
        int n2 = 0;
        while (n2 < n) {
            Object object2 = this.treetable.getChild(object, n2);
            TreePath treePath2 = treePath.pathByAddingChild(object2);
            this.rowMap.add(treePath2);
            this.treeMap.put(treePath2, new Integer(this.hashInt++));
            if (!this.treetable.isLeaf(object2)) {
                this.addKids(treePath2, object2);
            }
            ++n2;
        }
    }

    protected void initMappings() {
        this.rowMap = new ArrayList();
        this.treeMap = new Hashtable();
        this.hashInt = 0;
        TreePath treePath = new TreePath(this.treetable.getRoot());
        this.rowMap.add(treePath);
        this.treeMap.put(treePath, new Integer(this.hashInt++));
        this.addKids(treePath, this.treetable.getRoot());
    }

    protected void resetMappings() {
        this.rowMap = null;
        this.treeMap = null;
        this.hashInt = 0;
    }

    protected Object rowToNode(int n) {
        return this.rowToTreePath(n).getLastPathComponent();
    }

    protected TreePath rowToTreePath(int n) {
        if (this.rowMap == null) {
            this.initMappings();
        }
        if (n > this.rowMap.size()) {
            throw new IndexOutOfBoundsException("row = " + n + " > " + this.rowMap.size());
        }
        return (TreePath)this.rowMap.get(n);
    }

    protected int treePathToRow(TreePath treePath) {
        Integer n;
        if (this.treeMap == null) {
            this.initMappings();
        }
        if (treePath != null && (n = (Integer)this.treeMap.get(treePath)) != null) {
            return n;
        }
        return -1;
    }

    public int getRowCount() {
        if (this.rowMap == null) {
            this.initMappings();
        }
        return this.rowMap.size();
    }

    public int getColumnCount() {
        return this.treetable.getColumnCount();
    }

    public String getColumnName(int n) {
        return this.treetable.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this.treetable.getColumnClass(n);
    }

    public boolean isCellEditable(int n, int n2) {
        return this.treetable.isCellEditable(this.rowToNode(n), n2);
    }

    public Object getValueAt(int n, int n2) {
        return this.treetable.getValueAt(this.rowToNode(n), n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.treetable.setValueAt(object, this.rowToNode(n), n2);
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
    }
}

