/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.cell.EditorRendererRegistry;
import com.klg.jclass.cell.JCCellEditor;
import com.klg.jclass.cell.JCCellRenderer;
import com.klg.jclass.cell.swing.JCCellEditorToJTable;
import com.klg.jclass.cell.swing.JCCellRendererToJTable;
import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.JCVersion;
import com.klg.jclass.util.swing.DefaultRowSortTableModel;
import com.klg.jclass.util.swing.JCBrace;
import com.klg.jclass.util.swing.JCElasticLayout;
import com.klg.jclass.util.swing.JCMessageHelper;
import com.klg.jclass.util.swing.JCRowSortTableModel;
import com.klg.jclass.util.swing.JCTableColumn;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JCSortableTable
extends JTable {
    protected Icon upIcon = new SortIcon(true);
    protected Icon downIcon = new SortIcon(false);
    protected JCRowSortTableModel sortModel;
    protected MouseListener tableHeaderMouseListener;
    private static final Border emptyBorder = new EmptyBorder(0, 0, 0, 0);

    public JCSortableTable() {
        if (JCEnvironment.isDesignTime()) {
            Vector<String> vector = new Vector<String>();
            vector.addElement("Row 1, Column 1");
            vector.addElement("Row 1, Column 2");
            Vector<String> vector2 = new Vector<String>();
            vector2.addElement("Row 2, Column 1");
            vector2.addElement("Row 2, Column 2");
            Vector<Vector<String>> vector3 = new Vector<Vector<String>>();
            vector3.addElement(vector);
            vector3.addElement(vector2);
            Vector<String> vector4 = new Vector<String>();
            vector4.addElement("Column 1");
            vector4.addElement("Column 2");
            this.setModel(new DefaultTableModel(vector3, vector4));
        }
    }

    public JCSortableTable(TableModel tableModel) {
        super(tableModel);
    }

    public JCSortableTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        if (!this.checkColumnModel(tableColumnModel)) {
            throw new IllegalArgumentException("Column model incompatible with JCSortableTable.  Use createSortableTableColumn() to create table columns.");
        }
    }

    public JCSortableTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        if (!this.checkColumnModel(tableColumnModel)) {
            throw new IllegalArgumentException("Column model incompatible with JCSortableTable.  Use createSortableTableColumn() to create table columns.");
        }
    }

    public JCSortableTable(int n, int n2) {
        super(n, n2);
    }

    public JCSortableTable(Vector vector, Vector vector2) {
        super(vector, vector2);
    }

    public JCSortableTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
    }

    public Dimension getPreferredSize() {
        if (JCEnvironment.isDesignTime()) {
            return new Dimension(200, 200);
        }
        return super.getPreferredSize();
    }

    public void setAbout(String string) {
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    public void setModel(TableModel tableModel) {
        if (tableModel instanceof JCRowSortTableModel) {
            this.sortModel = (JCRowSortTableModel)((Object)tableModel);
            super.setModel(tableModel);
        } else {
            this.sortModel = new DefaultRowSortTableModel(tableModel);
            super.setModel((TableModel)((Object)this.sortModel));
        }
        this.removeTableHeaderMouseListener();
        this.addTableHeaderMouseListener();
    }

    public int getSortedRow(int n) {
        return this.sortModel.getSortedRow(n);
    }

    public int getUnsortedRow(int n) {
        return this.sortModel.getUnsortedRow(n);
    }

    public boolean getAutoSort() {
        return this.sortModel.getAutoSort();
    }

    public void setAutoSort(boolean bl) {
        this.sortModel.setAutoSort(bl);
    }

    public void setKeyColumns(int n, int[] nArray) {
        ((JCRowSortTableModel)((Object)this.dataModel)).setKeyColumns(n, nArray);
    }

    public int[] getKeyColumns(int n) {
        return ((JCRowSortTableModel)((Object)this.dataModel)).getKeyColumns(n);
    }

    public Icon getUpIcon() {
        return this.upIcon;
    }

    public void setUpIcon(Icon icon) {
        this.upIcon = icon;
    }

    public Icon getDownIcon() {
        return this.downIcon;
    }

    public void setDownIcon(Icon icon) {
        this.downIcon = icon;
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        if (this.getTableHeaderMouseListener() != null) {
            this.removeTableHeaderMouseListener();
        }
        super.setTableHeader(jTableHeader);
        this.addTableHeaderMouseListener();
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        Object object;
        ComponentOrientation componentOrientation = this.getComponentOrientation();
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        TableCellEditor tableCellEditor = tableColumn.getCellEditor();
        if (tableCellEditor == null && tableColumn instanceof JCTableColumn) {
            String string;
            Class<?> clazz;
            object = EditorRendererRegistry.getCentralRegistry();
            JCCellEditor jCCellEditor = ((EditorRendererRegistry)object).getCellEditorInstance(clazz = this.getColumnClass(n2), string = ((JCTableColumn)tableColumn).getRegistryType());
            tableCellEditor = jCCellEditor == null ? null : new JCCellEditorToJTable(jCCellEditor);
        }
        if (tableCellEditor == null) {
            tableCellEditor = this.getDefaultEditor(this.getColumnClass(n2));
        }
        object = tableCellEditor.getTableCellEditorComponent(this, null, false, n, n2);
        JCSortableTable.setComponentOrientation((Component)object, componentOrientation, false);
        return tableCellEditor;
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        Object object;
        ComponentOrientation componentOrientation = this.getComponentOrientation();
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
        if (tableCellRenderer == null && tableColumn instanceof JCTableColumn) {
            String string;
            Class<?> clazz;
            object = EditorRendererRegistry.getCentralRegistry();
            JCCellRenderer jCCellRenderer = ((EditorRendererRegistry)object).getCellRendererInstance(clazz = this.getColumnClass(n2), string = ((JCTableColumn)tableColumn).getRegistryType());
            if (jCCellRenderer == null) {
                tableCellRenderer = null;
            } else {
                JCCellRendererToJTable jCCellRendererToJTable = new JCCellRendererToJTable(jCCellRenderer);
                int n3 = componentOrientation.isLeftToRight() ? 2 : 4;
                jCCellRendererToJTable.setHorizontalAlignment(n3);
                tableCellRenderer = jCCellRendererToJTable;
            }
        }
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getDefaultRenderer(this.getColumnClass(n2));
        }
        object = tableCellRenderer.getTableCellRendererComponent(this, null, false, false, n, n2);
        JCSortableTable.setComponentOrientation((Component)object, componentOrientation, false);
        return tableCellRenderer;
    }

    protected void configureEnclosingScrollPane() {
        this.removeTableHeaderMouseListener();
        super.configureEnclosingScrollPane();
        this.addTableHeaderMouseListener();
    }

    protected void addTableHeaderMouseListener() {
        if (this.getTableHeader() != null) {
            if (this.getTableHeaderMouseListener() == null) {
                this.setTableHeaderMouseListener(this.createTableHeaderMouseListener());
            }
            this.getTableHeader().addMouseListener(this.getTableHeaderMouseListener());
        }
    }

    protected void removeTableHeaderMouseListener() {
        if (this.getTableHeader() != null) {
            this.getTableHeader().removeMouseListener(this.getTableHeaderMouseListener());
        }
    }

    protected MouseListener getTableHeaderMouseListener() {
        return this.tableHeaderMouseListener;
    }

    protected void setTableHeaderMouseListener(MouseListener mouseListener) {
        this.tableHeaderMouseListener = mouseListener;
    }

    protected MouseAdapter createTableHeaderMouseListener() {
        return new TableHeaderMouseListener();
    }

    public void sort(int n) {
        if (!(this.dataModel instanceof JCRowSortTableModel)) {
            String string = "TableModel is not an instance of JCRowSortTableModel";
            throw new IllegalArgumentException(string);
        }
        if (this.isEditing() && this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            String string = "Sort cannot be performed while a cell is editing.";
            JCMessageHelper.showError("Error", string);
            return;
        }
        n = this.convertColumnIndexToModel(n);
        JCRowSortTableModel jCRowSortTableModel = (JCRowSortTableModel)((Object)this.dataModel);
        if (jCRowSortTableModel.getSortColumn() == n) {
            jCRowSortTableModel.toggleSortOrder();
        } else {
            jCRowSortTableModel.setSortColumn(n);
        }
        if (!jCRowSortTableModel.isDataSorted()) {
            jCRowSortTableModel.setDataSorted(true);
        }
    }

    public void unsort() {
        if (!(this.dataModel instanceof JCRowSortTableModel)) {
            String string = "TableModel is not an instance of JCRowSortTableModel";
            throw new IllegalArgumentException(string);
        }
        ((JCRowSortTableModel)((Object)this.dataModel)).setDataSorted(false);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        int n;
        this.clearSortIcons();
        if (this.sortModel.isDataSorted() && (n = ((JCRowSortTableModel)((Object)this.dataModel)).getSortColumn()) >= 0) {
            this.setSortIcon(this.convertColumnIndexToView(n), ((JCRowSortTableModel)((Object)this.dataModel)).getSortOrder());
        }
        super.tableChanged(tableModelEvent);
    }

    public void createDefaultColumnsFromModel() {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            TableColumnModel tableColumnModel = this.getColumnModel();
            tableColumnModel.removeColumnModelListener(this);
            while (tableColumnModel.getColumnCount() > 0) {
                tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
            }
            int n = 0;
            while (n < tableModel.getColumnCount()) {
                TableColumn tableColumn = this.createSortableTableColumn(n);
                this.addColumn(tableColumn);
                ++n;
            }
            tableColumnModel.addColumnModelListener(this);
        }
    }

    protected boolean checkColumnModel(TableColumnModel tableColumnModel) {
        if (tableColumnModel != null) {
            int n = 0;
            while (n < tableColumnModel.getColumnCount()) {
                TableColumn tableColumn = tableColumnModel.getColumn(n);
                if (!(tableColumn instanceof JCTableColumn)) {
                    return false;
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < tableColumnModel.getColumnCount()) {
                TableColumn tableColumn = tableColumnModel.getColumn(n2);
                if (!(tableColumn instanceof SortableTableColumn) && tableColumn.getHeaderRenderer() == null) {
                    boolean bl = this.getComponentOrientation().isLeftToRight();
                    tableColumn.setHeaderRenderer(new SortableHeaderRenderer(bl));
                }
                ++n2;
            }
        }
        return true;
    }

    public void setColumnModel(TableColumnModel tableColumnModel) {
        if (!this.checkColumnModel(tableColumnModel)) {
            throw new IllegalArgumentException("Column model incompatible with JCSortableTable.  Use createSortableTableColumn() to create table columns.");
        }
        super.setColumnModel(tableColumnModel);
    }

    public TableColumn createSortableTableColumn(int n) {
        return new SortableTableColumn(n);
    }

    protected void clearSortIcons() {
        int n = 0;
        while (n < this.columnModel.getColumnCount()) {
            this.setSortIcon(n, 0);
            ++n;
        }
    }

    protected void setSortIcon(int n) {
        this.setSortIcon(n, ((JCRowSortTableModel)((Object)this.dataModel)).getSortOrder());
    }

    protected void setSortIcon(Component component, Icon icon) {
        if (component instanceof SortableColumnHeader) {
            ((SortableColumnHeader)((Object)component)).setSortIcon(icon);
            this.tableHeader.repaint();
        } else if (component instanceof JLabel) {
            ((JLabel)component).setHorizontalTextPosition(10);
            ((JLabel)component).setIcon(icon);
            this.tableHeader.repaint();
        } else if (component instanceof JButton) {
            ((JButton)component).setHorizontalTextPosition(10);
            ((JButton)component).setIcon(icon);
            ((AbstractTableModel)this.dataModel).fireTableDataChanged();
            this.tableHeader.repaint();
        } else if (component instanceof Container && ((Container)component).getComponentCount() != 0) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this.setSortIcon(componentArray[n], icon);
                ++n;
            }
        }
    }

    protected void setSortIcon(int n, int n2) {
        Icon icon = null;
        if (n2 == 1) {
            icon = this.getDownIcon();
        } else if (n2 == -1) {
            icon = this.getUpIcon();
        }
        TableColumn tableColumn = this.columnModel.getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer != null) {
            Component component = tableCellRenderer.getTableCellRendererComponent(this, tableColumn.getHeaderValue(), false, false, -1, n);
            this.setSortIcon(component, icon);
        }
    }

    protected static void setComponentOrientation(Component component, ComponentOrientation componentOrientation, boolean bl) {
        if (component == null || componentOrientation == null) {
            return;
        }
        ComponentOrientation componentOrientation2 = component.getComponentOrientation();
        if (componentOrientation.isLeftToRight() != componentOrientation2.isLeftToRight() && (bl || componentOrientation2 == ComponentOrientation.UNKNOWN)) {
            component.setComponentOrientation(componentOrientation);
            component.repaint();
        }
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        super.setComponentOrientation(componentOrientation);
        this.reLayoutColumnRenderers();
        if (this.isEditing()) {
            Component component = this.getEditorComponent();
            JCSortableTable.setComponentOrientation(component, componentOrientation, false);
        }
        this.revalidate();
        this.getTableHeader().repaint();
        this.repaint();
    }

    protected void reLayoutColumnRenderers() {
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
            if (!(tableCellRenderer instanceof JCCellRendererToJTable)) continue;
            boolean bl = this.getComponentOrientation().isLeftToRight();
            int n = bl ? 2 : 4;
            ((JCCellRendererToJTable)tableCellRenderer).setHorizontalAlignment(n);
        }
    }

    public static interface SortableColumnHeader {
        public void setSortIcon(Icon var1);
    }

    protected class SortableHeaderRenderer
    extends JPanel
    implements TableCellRenderer,
    SortableColumnHeader,
    Serializable {
        protected JLabel label = new JLabel("label");
        protected JButton sortButton = new JButton();
        protected JCBrace brace = JCBrace.createHorizontalBrace(3);
        protected Icon sortIcon = null;
        protected boolean currentLayoutLeft;

        public SortableHeaderRenderer() {
            this(true);
        }

        public SortableHeaderRenderer(boolean bl) {
            JCElasticLayout jCElasticLayout = new JCElasticLayout(0);
            jCElasticLayout.setAlignment(0);
            this.setLayout(jCElasticLayout);
            this.sortButton.setBorder(emptyBorder);
            this.sortButton.setVerticalAlignment(0);
            this.currentLayoutLeft = this.label.getComponentOrientation().isLeftToRight();
            this.reLayout(bl);
        }

        public boolean isCurrentLayoutLeft() {
            return this.currentLayoutLeft;
        }

        protected void setProperties(JTable jTable) {
            if (jTable == null) {
                return;
            }
            JTableHeader jTableHeader = jTable.getTableHeader();
            if (jTableHeader != null) {
                this.label.setForeground(jTableHeader.getForeground());
                this.label.setBackground(jTableHeader.getBackground());
                this.label.setFont(jTableHeader.getFont());
                this.sortButton.setBackground(jTableHeader.getBackground());
                this.sortButton.setForeground(jTableHeader.getForeground());
                this.setBackground(jTableHeader.getBackground());
                this.setForeground(jTableHeader.getForeground());
            }
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Serializable serializable;
            if (jTable != null) {
                JCTableColumn jCTableColumn;
                int n3;
                serializable = jTable.getColumnModel().getColumn(n2);
                if (serializable != null && serializable instanceof JCTableColumn && (n3 = (jCTableColumn = (JCTableColumn)serializable).getHeaderLabelHorizontalAlignment()) >= 0) {
                    this.label.setHorizontalAlignment(n3);
                }
                this.setProperties(jTable);
            }
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.label.setText(object == null ? "" : object.toString());
            serializable = this.getComponentOrientation();
            boolean bl3 = true;
            bl3 = jTable == null || serializable != ComponentOrientation.UNKNOWN ? ((ComponentOrientation)serializable).isLeftToRight() : jTable.getComponentOrientation().isLeftToRight();
            if (bl3 != this.currentLayoutLeft) {
                this.reLayout(bl3);
            }
            return this;
        }

        public void setSortIcon(Icon icon) {
            this.sortIcon = icon;
            if (icon != null) {
                this.sortButton.setIcon(icon);
            }
            this.reLayout(this.currentLayoutLeft);
        }

        public void reLayout(boolean bl) {
            this.removeAll();
            if (bl != this.currentLayoutLeft) {
                ComponentOrientation componentOrientation = bl ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.RIGHT_TO_LEFT;
                JCSortableTable.setComponentOrientation(this.label, componentOrientation, true);
            }
            if (bl) {
                this.add((Component)this.label, JCElasticLayout.HORIZONTALLY_ELASTIC_CONSTRAINT);
            }
            if (this.sortIcon != null) {
                this.add(this.sortButton);
                this.add(this.brace);
            }
            if (!bl) {
                this.add((Component)this.label, JCElasticLayout.HORIZONTALLY_ELASTIC_CONSTRAINT);
                this.add(JCBrace.createHorizontalBrace(1));
            }
            this.currentLayoutLeft = bl;
        }
    }

    protected class SortableTableColumn
    extends JCTableColumn
    implements Serializable {
        public SortableTableColumn(int n) {
            super(n);
            this.setHeaderRenderer(this.createDefaultHeaderRenderer());
        }

        protected TableCellRenderer createDefaultHeaderRenderer() {
            boolean bl = ComponentOrientation.UNKNOWN.isLeftToRight();
            if (JCSortableTable.this != null) {
                bl = JCSortableTable.this.getComponentOrientation().isLeftToRight();
            }
            SortableHeaderRenderer sortableHeaderRenderer = new SortableHeaderRenderer(bl);
            return sortableHeaderRenderer;
        }
    }

    public class SortIcon
    implements Icon,
    Serializable {
        protected boolean isUp;
        protected Color color = Color.black;
        protected Color outlineColor = Color.gray;
        protected int width = 6;
        protected int height = 6;
        protected int[] xpoints = new int[3];
        protected int[] ypoints = new int[3];

        public SortIcon(boolean bl) {
            this.isUp = bl;
        }

        public SortIcon(boolean bl, Color color, Color color2) {
            this.isUp = bl;
            this.color = color;
            this.outlineColor = color2;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            if (color != null) {
                this.color = color;
            }
        }

        public Color getOutlineColor() {
            return this.outlineColor;
        }

        public void setOutlineColor(Color color) {
            if (color != null) {
                this.outlineColor = color;
            }
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.isUp) {
                this.xpoints[0] = n;
                this.ypoints[0] = n2 + this.height;
                this.xpoints[1] = n + this.width / 2;
                this.ypoints[1] = n2;
                this.xpoints[2] = n + this.width;
                this.ypoints[2] = n2 + this.height;
            } else {
                this.xpoints[0] = n;
                this.ypoints[0] = n2;
                this.xpoints[1] = n + this.width / 2;
                this.ypoints[1] = n2 + this.height;
                this.xpoints[2] = n + this.width;
                this.ypoints[2] = n2;
            }
            graphics.setColor(this.color);
            graphics.fillPolygon(this.xpoints, this.ypoints, 3);
            graphics.setColor(this.outlineColor);
            graphics.drawPolygon(this.xpoints, this.ypoints, 3);
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }
    }

    protected class TableHeaderMouseListener
    extends MouseAdapter
    implements Serializable {
        protected boolean isPopupTrigger;

        protected TableHeaderMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.isPopupTrigger = mouseEvent.isPopupTrigger();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.isPopupTrigger = this.isPopupTrigger || mouseEvent.isPopupTrigger();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (!this.isPopupTrigger && (n = JCSortableTable.this.columnAtPoint(mouseEvent.getPoint())) >= 0) {
                JCSortableTable.this.sort(n);
            }
        }
    }
}

