/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.JCVersion;
import com.klg.jclass.util.swing.JCBrace;
import com.klg.jclass.util.swing.JCFontChooser;
import com.klg.jclass.util.swing.JCFontEvent;
import com.klg.jclass.util.swing.JCIconCreator;
import com.klg.jclass.util.swing.JCRowLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JToggleButton;

public class JCFontChooserBar
extends JCFontChooser
implements ActionListener,
ItemListener {
    public static final int NONE = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNDERLINE = 4;
    public static final int ALL = 7;
    private static final String[] boldIcon = new String[]{"             ", "             ", "             ", "  XXXXXXXX   ", "   XXX  XXX  ", "   XXX  XXX  ", "   XXX  XXX  ", "   XXXXXXX   ", "   XXX  XXX  ", "   XXX  XXX  ", "   XXX  XXX  ", "  XXXXXXXX   ", "             ", "             ", "             "};
    private static final String[] italicIcon = new String[]{"             ", "             ", "             ", "       XXXXXX", "        XXX  ", "       XXX   ", "      XXX    ", "     XXX     ", "    XXX      ", "   XXX       ", "  XXX        ", "XXXXXX       ", "             ", "             ", "             "};
    private static final String[] underlineIcon = new String[]{"             ", "             ", "             ", "  XXXX XXXX  ", "   XX   XX   ", "   XX   XX   ", "   XX   XX   ", "   XX   XX   ", "   XX   XX   ", "   XX   XX   ", "   XX   XX   ", "    XXXXX    ", "             ", "  XXXXXXXXX  ", "             "};
    protected JComboBox nameCombobox;
    protected JComboBox sizeCombobox;
    protected JToggleButton boldStyleButton;
    protected JToggleButton italicStyleButton;
    protected JToggleButton underlineStyleButton;
    protected int styleControls = 7;
    protected boolean toolTipEnabled;

    public JCFontChooserBar() {
        this.init();
    }

    public JCFontChooserBar(Font font) {
        super(font);
        this.init();
    }

    public JCFontChooserBar(Font font, boolean bl) {
        super(font, bl);
        this.init();
    }

    public JCFontChooserBar(String string, int n, int n2, boolean bl) {
        super(string, n, n2, bl);
        this.init();
    }

    protected void init() {
        this.setLayout(new JCRowLayout());
        this.nameCombobox = new JComboBox();
        this.setNameList();
        this.setNameCombobox();
        this.nameCombobox.addItemListener(this);
        this.add(this.nameCombobox);
        this.sizeCombobox = new JComboBox();
        int n = 0;
        while (n < JCFontChooser.getSizeList().length) {
            this.sizeCombobox.addItem(JCFontChooser.getSizeList()[n]);
            ++n;
        }
        this.sizeCombobox.setEditable(true);
        this.sizeCombobox.addItemListener(this);
        this.add(this.sizeCombobox);
        this.add(JCBrace.createHorizontalBrace(8));
        JCIconCreator jCIconCreator = new JCIconCreator(13, 15);
        jCIconCreator.setColor('X', Color.black);
        jCIconCreator.setPixels(boldIcon);
        this.boldStyleButton = new JToggleButton(jCIconCreator.getIcon());
        this.boldStyleButton.addActionListener(this);
        this.add(this.boldStyleButton);
        jCIconCreator.clear();
        jCIconCreator.setPixels(italicIcon);
        this.italicStyleButton = new JToggleButton(jCIconCreator.getIcon());
        this.italicStyleButton.addActionListener(this);
        this.add(this.italicStyleButton);
        jCIconCreator.clear();
        jCIconCreator.setPixels(underlineIcon);
        this.underlineStyleButton = new JToggleButton(jCIconCreator.getIcon());
        this.underlineStyleButton.addActionListener(this);
        this.add(this.underlineStyleButton);
        this.setFontChooserBar();
        this.setToolTipEnabled(true);
        Dimension dimension = this.nameCombobox.getPreferredSize();
        this.sizeCombobox.setPreferredSize(new Dimension(dimension.height * 2 + 10, dimension.height));
        this.boldStyleButton.setPreferredSize(new Dimension(dimension.height, dimension.height));
        this.italicStyleButton.setPreferredSize(new Dimension(dimension.height, dimension.height));
        this.underlineStyleButton.setPreferredSize(new Dimension(dimension.height, dimension.height));
    }

    protected void setNameCombobox() {
        this.nameCombobox.setModel(new DefaultComboBoxModel<String>(this.getNameList()));
        this.nameCombobox.setSelectedItem(this.getFontName());
    }

    public void setNameList(String[] stringArray) {
        super.setNameList(stringArray);
        this.setNameCombobox();
    }

    protected void updateControls() {
        this.remove(this.boldStyleButton);
        this.remove(this.italicStyleButton);
        this.remove(this.underlineStyleButton);
        if ((this.styleControls & 1) != 0) {
            this.add(this.boldStyleButton);
        }
        if ((this.styleControls & 2) != 0) {
            this.add(this.italicStyleButton);
        }
        if ((this.styleControls & 4) != 0) {
            this.add(this.underlineStyleButton);
        }
        this.invalidate();
    }

    public void setAbout(String string) {
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    public void setStyleControls(int n) {
        this.styleControls = n;
        this.updateControls();
    }

    public int getStyleControls() {
        return this.styleControls;
    }

    protected void setFontChooserBar() {
        this.nameCombobox.setSelectedItem(this.getFontName());
        this.sizeCombobox.setSelectedItem(new Integer(this.getFontSize()).toString());
        this.boldStyleButton.setSelected(this.isBold());
        this.italicStyleButton.setSelected(this.isItalic());
        this.underlineStyleButton.setSelected(this.isUnderline());
    }

    public void setToolTipEnabled(boolean bl) {
        this.toolTipEnabled = bl;
        if (bl) {
            this.nameCombobox.setToolTipText("Font");
            this.sizeCombobox.setToolTipText("Font Size");
            this.boldStyleButton.setToolTipText("Bold");
            this.italicStyleButton.setToolTipText("Italic");
            this.underlineStyleButton.setToolTipText("Underline");
        } else {
            this.nameCombobox.setToolTipText(null);
            this.sizeCombobox.setToolTipText(null);
            this.boldStyleButton.setToolTipText(null);
            this.italicStyleButton.setToolTipText(null);
            this.underlineStyleButton.setToolTipText(null);
        }
    }

    public boolean isToolTipEnabled() {
        return this.toolTipEnabled;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.boldStyleButton) {
            this.setOldFont();
            this.setBold(((JToggleButton)actionEvent.getSource()).isSelected());
            this.fireJCFontEvent(4);
        } else if (actionEvent.getSource() == this.italicStyleButton) {
            this.setOldFont();
            this.setItalic(((JToggleButton)actionEvent.getSource()).isSelected());
            this.fireJCFontEvent(5);
        } else if (actionEvent.getSource() == this.underlineStyleButton) {
            this.setOldFont();
            this.setUnderline(((JToggleButton)actionEvent.getSource()).isSelected());
            this.fireJCFontEvent(6);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getSource() == this.nameCombobox) {
                this.setOldFont();
                this.setFontName(itemEvent.getItem().toString());
                this.fireJCFontEvent(2);
            } else if (itemEvent.getSource() == this.sizeCombobox) {
                try {
                    this.setOldFont();
                    this.setFontSize(Integer.parseInt(itemEvent.getItem().toString()));
                    this.fireJCFontEvent(3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    protected void fireJCFontEvent(int n) {
        JCFontEvent jCFontEvent = new JCFontEvent(this, n, this.oldFont, this.oldUnderline, this.getSelectedFont(), this.isUnderline(), true);
        this.fireJCFontChangingEvent(jCFontEvent);
        if (jCFontEvent.isCancelFontChange()) {
            this.setFontValues(this.oldFont, this.oldUnderline);
            this.setFontChooserBar();
        } else if (jCFontEvent.isFontChanged()) {
            this.setFontValues(jCFontEvent.getFont(), jCFontEvent.getUnderline());
            this.setFontChooserBar();
        }
        if (!jCFontEvent.isCancelFontChange()) {
            this.fireJCFontChangedEvent(new JCFontEvent(this, n, this.oldFont, this.oldUnderline, this.getSelectedFont(), this.isUnderline(), false));
        }
    }

    public void setSelectedFont(String string, int n, int n2, boolean bl) {
        this.setOldFont();
        super.setSelectedFont(string, n, n2, bl);
        this.setFontChooserBar();
        this.fireJCFontEvent(1);
    }

    public void setSelectedFont(Font font, boolean bl) {
        this.setSelectedFont(font.getName(), font.getStyle(), font.getSize(), bl);
    }

    public void setSelectedFont(Font font) {
        this.setSelectedFont(font.getName(), font.getStyle(), font.getSize(), JCFontChooser.isUnderline(font));
    }
}

