/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.JCLocaleManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public abstract class JCAction
implements Action,
Serializable {
    public static final String DEFAULT = "Default";
    public static final String NAME = "Name";
    public static final String SHORT_DESCRIPTION = "ShortDescription";
    public static final String LONG_DESCRIPTION = "LongDescription";
    public static final String SMALL_ICON = "SmallIcon";
    public static final String ACCELERATOR = "Accelerator";
    public static final String MNEMONIC = "Mnemonic";
    protected Vector values = new Vector(5);
    protected boolean enabled = true;
    protected PropertyChangeSupport property = new PropertyChangeSupport(this);
    protected String name;

    public JCAction(String string) {
        this.name = string;
    }

    public JCAction(String string, Integer n, KeyStroke keyStroke) {
        this(null);
        this.putValue(NAME, string);
        this.putValue(MNEMONIC, n);
        this.putValue(ACCELERATOR, keyStroke);
    }

    public JCAction(String string, int n, KeyStroke keyStroke) {
        this(string, new Integer(n), keyStroke);
    }

    public Object getValue(String string) {
        JCLocaleManager jCLocaleManager = JCLocaleManager.getDefault();
        if (this.name != null && jCLocaleManager != null) {
            if (string.equals(NAME)) {
                String string2;
                try {
                    string2 = jCLocaleManager.getString(this.name);
                }
                catch (Exception exception) {
                    string2 = this.name;
                }
                if (string2 == null) {
                    string2 = this.name;
                }
                return string2;
            }
            if (string.equals(ACCELERATOR)) {
                KeyStroke keyStroke;
                try {
                    keyStroke = jCLocaleManager.getKeyStroke(this.name + ACCELERATOR);
                }
                catch (Exception exception) {
                    keyStroke = null;
                }
                return keyStroke;
            }
            if (string.equals(MNEMONIC)) {
                Integer n;
                try {
                    n = (Integer)jCLocaleManager.getObject(this.name + MNEMONIC);
                }
                catch (Exception exception) {
                    n = new Integer(-1);
                }
                return n;
            }
        }
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            Value value = (Value)iterator.next();
            if (!value.key.equals(string)) continue;
            return value.value;
        }
        return null;
    }

    public void putValue(String string, Object object) {
        Value value;
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            value = (Value)iterator.next();
            if (!value.key.equals(string)) continue;
            this.property.firePropertyChange(string, value.value, object);
            value.value = object;
            return;
        }
        this.property.firePropertyChange(string, null, object);
        value = new Value(string, object);
        this.values.addElement(value);
    }

    public void setEnabled(boolean bl) {
        if (this.enabled != bl) {
            this.property.firePropertyChange("enabled", new Boolean(this.enabled), new Boolean(bl));
            this.enabled = bl;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.property.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.property.removePropertyChangeListener(propertyChangeListener);
    }

    public JButton createButton(boolean bl) {
        ActionButton actionButton = new ActionButton((String)this.getValue(NAME));
        actionButton.addActionListener(this);
        if (bl) {
            try {
                actionButton.setMnemonic((Integer)this.getValue(MNEMONIC));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return actionButton;
    }

    public JButton createButton() {
        return this.createButton(true);
    }

    public JMenu createMenu() {
        JMenu jMenu = new JMenu((String)this.getValue(NAME));
        jMenu.addActionListener(this);
        try {
            jMenu.setMnemonic((Integer)this.getValue(MNEMONIC));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jMenu;
    }

    public JMenuItem createMenuItem() {
        JMenuItem jMenuItem = new JMenuItem((String)this.getValue(NAME));
        jMenuItem.addActionListener(this);
        try {
            jMenuItem.setMnemonic((Integer)this.getValue(MNEMONIC));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            jMenuItem.setAccelerator((KeyStroke)this.getValue(ACCELERATOR));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jMenuItem;
    }

    protected class ActionMenuItem
    extends JMenuItem
    implements PropertyChangeListener {
        public ActionMenuItem(String string) {
            super(string);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals(JCAction.NAME)) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.setText(string2);
                this.repaint();
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.setEnabled(bl);
                this.repaint();
            } else if (propertyChangeEvent.getPropertyName().equals(JCAction.SMALL_ICON)) {
                Icon icon = (Icon)propertyChangeEvent.getNewValue();
                this.setIcon(icon);
                this.invalidate();
                this.repaint();
            }
        }
    }

    protected class ActionMenu
    extends JMenu
    implements PropertyChangeListener {
        public ActionMenu(String string) {
            super(string);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals(JCAction.NAME)) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.setText(string2);
                this.repaint();
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.setEnabled(bl);
                this.repaint();
            } else if (propertyChangeEvent.getPropertyName().equals(JCAction.SMALL_ICON)) {
                Icon icon = (Icon)propertyChangeEvent.getNewValue();
                this.setIcon(icon);
                this.invalidate();
                this.repaint();
            }
        }
    }

    protected class ActionButton
    extends JButton
    implements PropertyChangeListener {
        public ActionButton(String string) {
            super(string);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals(JCAction.NAME)) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.setText(string2);
                this.repaint();
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.setEnabled(bl);
                this.repaint();
            } else if (propertyChangeEvent.getPropertyName().equals(JCAction.SMALL_ICON)) {
                Icon icon = (Icon)propertyChangeEvent.getNewValue();
                this.setIcon(icon);
                this.invalidate();
                this.repaint();
            }
        }
    }

    protected class Value
    implements Serializable {
        protected String key;
        protected Object value;

        public Value(String string, Object object) {
            this.key = string;
            this.value = object;
        }
    }
}

