/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.UIManager;

public class ArrowIcon
implements Icon,
Serializable {
    public static final int UP = 0;
    public static final int DOWN = 1;
    protected int width = 6;
    protected int height = 4;
    protected int direction = 0;

    public ArrowIcon(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("ArrowIcon's direction must be one of UP or DOWN.");
        }
        this.direction = n;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        int n3 = this.getIconWidth();
        Color color = component.getForeground();
        if (!component.isEnabled()) {
            color = UIManager.getColor("Button.disabledText");
        }
        graphics.setColor(color);
        graphics.translate(n, n2);
        if (this.direction == 1) {
            graphics.drawLine(0, 0, n3 - 2, 0);
            graphics.drawLine(1, 1, 1 + (n3 - 4), 1);
            graphics.drawLine(2, 2, 2 + (n3 - 6), 2);
        } else {
            graphics.drawLine(2, 0, 2 + (n3 - 6), 0);
            graphics.drawLine(1, 1, 1 + (n3 - 4), 1);
            graphics.drawLine(0, 2, n3 - 2, 2);
        }
        graphics.translate(-n, -n2);
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }
}

