/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.legend;

import com.klg.jclass.util.Changeable;
import com.klg.jclass.util.ImageMapInfo;
import com.klg.jclass.util.legend.JCLegendItem;
import com.klg.jclass.util.legend.JCLegendPopulator;
import com.klg.jclass.util.legend.JCLegendRenderer;
import com.klg.jclass.util.swing.TextRenderer;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;

public abstract class JCLegend
extends JComponent
implements Changeable,
Serializable {
    public static final int NORTH = 16;
    public static final int SOUTH = 32;
    public static final int EAST = 1;
    public static final int WEST = 2;
    public static final int NORTHEAST = 17;
    public static final int NORTHWEST = 18;
    public static final int SOUTHEAST = 33;
    public static final int SOUTHWEST = 34;
    public static final int NORTHSOUTH_MASK = 240;
    public static final int EASTWEST_MASK = 15;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int NONE = 0;
    public static final int BOX = 1;
    public static final int IMAGE = 2;
    public static final int IMAGE_OUTLINED = 3;
    public static final int CUSTOM_SYMBOL = 4;
    public static final int CUSTOM_ALL = 5;
    public static final int BOX_PLAIN = 6;
    public static final int LINE = 7;
    protected int anchor = 1;
    protected int orientation = 1;
    protected TextRenderer textRend = null;
    protected List legendItems = null;
    protected Dimension ps = new Dimension();
    protected int symbolSize = 8;
    protected int ascent = 0;
    protected int descent = 0;
    protected ImageMapInfo imageMapInfo = null;
    protected boolean cachedVertical = false;
    protected transient Font cachedFont;
    protected boolean updateParent = true;
    protected boolean changed = true;
    protected int changedFlag = 0;
    protected Dimension preferredSize = null;
    protected CellRendererPane cellRendererPane = null;
    protected JCLegendPopulator legendPopulator = null;
    protected JCLegendRenderer legendRenderer = null;
    private transient Graphics prevSetGraphics = null;
    protected Locale locale = Locale.getDefault();

    public JCLegend() {
        this.setOpaque(false);
        this.setVisible(false);
        this.cellRendererPane = new CellRendererPane();
        this.add(this.cellRendererPane);
    }

    public void setLegendPopulator(JCLegendPopulator jCLegendPopulator) {
        this.legendPopulator = jCLegendPopulator;
    }

    public JCLegendPopulator getLegendPopulator() {
        return this.legendPopulator;
    }

    public void setLegendRenderer(JCLegendRenderer jCLegendRenderer) {
        this.legendRenderer = jCLegendRenderer;
    }

    public JCLegendRenderer getLegendRenderer() {
        return this.legendRenderer;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public void setAnchor(int n) {
        if (n == this.anchor) {
            return;
        }
        this.checkAnchor(n);
        this.setChanged(true, 9);
    }

    protected void checkAnchor(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 16: 
            case 17: 
            case 18: 
            case 32: 
            case 33: 
            case 34: {
                this.anchor = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Anchor value in JCLegend.  Should be one of NORTH, SOUTH, EAST, WEST, NORTHEAST, SOUTHEAST, NORTHWEST or SOUTHWEST");
            }
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        if (n == this.orientation) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: {
                this.orientation = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for Orientation in JCLegend.  Should be one of VERTICAL or HORIZONTAL");
            }
        }
        this.setChanged(true, 2);
    }

    public ImageMapInfo getImageMapInfo() {
        return this.imageMapInfo;
    }

    public void setImageMapInfo(ImageMapInfo imageMapInfo) {
        this.imageMapInfo = imageMapInfo;
    }

    public int getSymbolSize() {
        return this.symbolSize;
    }

    public void recalc() {
        if (!this.isChanged(2) && this.isValid()) {
            return;
        }
        Insets insets = this.getInsets();
        this.ps = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        if (!this.isVisible()) {
            this.setChanged(false, 0);
            return;
        }
        this.setUpLegendVariables();
        Dimension dimension = this.layoutLegend(this.legendItems, this.cachedVertical, this.cachedFont);
        this.ps.width += dimension.width;
        this.ps.height += dimension.height;
        this.setChanged(false, 0);
    }

    protected void setUpLegendVariables() {
        boolean bl;
        this.cachedVertical = bl = this.orientation == 1;
        this.cachedFont = this.getFont();
        if (this.cachedFont == null) {
            this.cachedFont = new Font("dialog", 0, 12);
        }
        FontMetrics fontMetrics = null;
        try {
            Graphics graphics = this.getGraphics();
            fontMetrics = graphics != null ? graphics.getFontMetrics(this.cachedFont) : this.getToolkit().getFontMetrics(this.cachedFont);
            graphics.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fontMetrics == null) {
            return;
        }
        this.descent = fontMetrics.getDescent();
        this.symbolSize = this.ascent = fontMetrics.getAscent();
        if (this.legendPopulator != null) {
            this.legendItems = this.legendPopulator.getLegendItems(fontMetrics);
        }
    }

    public List getLegendItems() {
        return this.legendItems;
    }

    public abstract Dimension layoutLegend(List var1, boolean var2, Font var3);

    public void paintComponent(Graphics graphics) {
        if (!this.isVisible() || graphics == null) {
            return;
        }
        Container container = this.getParent();
        if (container == null) {
            return;
        }
        if (this.isOpaque()) {
            if (!graphics.getColor().equals(this.getBackground())) {
                graphics.setColor(this.getBackground());
            }
            Rectangle rectangle = this.getBounds();
            graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        }
        boolean bl = false;
        Rectangle rectangle = this.getDrawingArea();
        if (!bl) {
            bl = true;
            graphics = graphics.create();
            graphics.translate(rectangle.x, rectangle.y);
            graphics.clipRect(0, 0, rectangle.width + 1, rectangle.height + 1);
        }
        if (this.legendRenderer != null) {
            int n = 0;
            while (n < this.legendItems.size()) {
                List list = (List)this.legendItems.get(n);
                int n2 = 0;
                while (n2 < list.size()) {
                    JCLegendItem jCLegendItem = (JCLegendItem)list.get(n2);
                    if (jCLegendItem.drawType == 5) {
                        this.legendRenderer.drawLegendItem(graphics, this.cachedFont, jCLegendItem);
                    } else {
                        this.drawLegendItem(graphics, this.cachedFont, jCLegendItem);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        if (bl) {
            graphics.dispose();
        }
        this.setChanged(false, 0);
    }

    public void drawLegendItem(Graphics graphics, Font font, JCLegendItem jCLegendItem) {
        Color color = null;
        if (graphics.getColor() != this.getForeground()) {
            graphics.setColor(this.getForeground());
        }
        if (graphics.getFont() != font) {
            graphics.setFont(font);
        }
        if (color == null && this.legendRenderer != null) {
            color = this.legendRenderer.getOutlineColor(jCLegendItem);
        }
        if (color == null) {
            color = this.getForeground();
        }
        if (this.isTitleItem(jCLegendItem)) {
            if (jCLegendItem.contents instanceof String) {
                String string = (String)jCLegendItem.contents;
                if (TextRenderer.isHTML(string)) {
                    if (this.textRend == null) {
                        this.textRend = new TextRenderer();
                    }
                    this.textRend.drawHTMLText(graphics, this.getCellRendererPane(), this, string, jCLegendItem.pos.x + jCLegendItem.textPos.x, jCLegendItem.pos.y + jCLegendItem.textPos.y, jCLegendItem.textDim.width, jCLegendItem.textDim.height);
                } else if (string.length() > 0) {
                    graphics.drawString(string, jCLegendItem.pos.x + jCLegendItem.textPos.x, jCLegendItem.pos.y + jCLegendItem.textPos.y + this.ascent);
                }
            }
        } else {
            int n = jCLegendItem.pos.x + jCLegendItem.symbolPos.x;
            int n2 = jCLegendItem.pos.y + jCLegendItem.symbolPos.y;
            if (jCLegendItem.drawType == 1 || jCLegendItem.drawType == 6) {
                if (this.legendRenderer != null) {
                    this.legendRenderer.setFillGraphics(graphics, jCLegendItem);
                }
                graphics.fillRect(n, n2, jCLegendItem.symbolDim.width - 1, jCLegendItem.symbolDim.height - 1);
                if (jCLegendItem.drawType == 1) {
                    graphics.setColor(color);
                }
                graphics.drawRect(n, n2, jCLegendItem.symbolDim.width - 1, jCLegendItem.symbolDim.height - 1);
            } else if (jCLegendItem.drawType == 7) {
                if (this.legendRenderer != null) {
                    this.legendRenderer.setFillGraphics(graphics, jCLegendItem);
                }
                graphics.drawLine(n, n2 + (jCLegendItem.symbolDim.height - 1) / 2, n + jCLegendItem.symbolDim.width - 1, n2 + (jCLegendItem.symbolDim.height - 1) / 2);
            } else if (jCLegendItem.drawType == 2) {
                if (jCLegendItem.symbol != null && jCLegendItem.symbol instanceof Image) {
                    graphics.drawImage((Image)jCLegendItem.symbol, n, n2, null);
                }
            } else if (jCLegendItem.drawType == 3) {
                if (jCLegendItem.symbol != null && jCLegendItem.symbol instanceof Image) {
                    graphics.drawImage((Image)jCLegendItem.symbol, n, n2, null);
                    graphics.setColor(color);
                    graphics.drawRect(n, n2, jCLegendItem.symbolDim.width - 1, jCLegendItem.symbolDim.height - 1);
                }
            } else if (jCLegendItem.drawType == 4 && this.legendRenderer != null) {
                this.legendRenderer.drawLegendItemSymbol(graphics, font, jCLegendItem);
            }
            if (graphics.getColor() != this.getForeground()) {
                graphics.setColor(this.getForeground());
            }
            if (graphics.getFont() != font) {
                graphics.setFont(font);
            }
            if (jCLegendItem.contents instanceof String) {
                String string = (String)jCLegendItem.contents;
                if (TextRenderer.isHTML(string)) {
                    if (this.textRend == null) {
                        this.textRend = new TextRenderer();
                    }
                    this.textRend.drawHTMLText(graphics, this.getCellRendererPane(), this, string, jCLegendItem.pos.x + jCLegendItem.textPos.x, jCLegendItem.pos.y + jCLegendItem.textPos.y, jCLegendItem.textDim.width, jCLegendItem.textDim.height);
                } else if (string.length() > 0) {
                    graphics.drawString(string, jCLegendItem.pos.x + jCLegendItem.textPos.x, jCLegendItem.pos.y + jCLegendItem.textPos.y + this.ascent);
                }
            } else if (this.legendRenderer != null) {
                this.legendRenderer.drawLegendItemText(graphics, font, jCLegendItem);
            }
        }
    }

    public boolean isTitleItem(JCLegendItem jCLegendItem) {
        if (this.legendPopulator != null) {
            return this.legendPopulator.isTitleItem(jCLegendItem);
        }
        return false;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.preferredSize;
        if (dimension != null) {
            return dimension;
        }
        this.recalc();
        return new Dimension(this.ps);
    }

    public void setPreferredSize(Dimension dimension) {
        this.preferredSize = dimension;
    }

    public TextRenderer getTextRenderer() {
        if (this.textRend == null) {
            this.textRend = new TextRenderer();
        }
        return this.textRend;
    }

    public JCLegendItem pick(Point point) {
        Rectangle rectangle = this.getDrawingArea();
        point.x -= rectangle.x;
        point.y -= rectangle.y;
        JCLegendItem jCLegendItem = null;
        int n = 0;
        while (n < this.legendItems.size()) {
            List list = (List)this.legendItems.get(n);
            int n2 = 0;
            while (n2 < list.size()) {
                JCLegendItem jCLegendItem2 = (JCLegendItem)list.get(n2);
                Rectangle rectangle2 = jCLegendItem2.pickRectangle;
                if (rectangle2 == null && jCLegendItem2.pos != null && jCLegendItem2.dim != null) {
                    rectangle2 = new Rectangle(jCLegendItem2.pos, jCLegendItem2.dim);
                }
                if (rectangle2 != null && rectangle2.contains(point.x, point.y)) {
                    jCLegendItem = jCLegendItem2;
                    break;
                }
                ++n2;
            }
            ++n;
        }
        return jCLegendItem;
    }

    public Rectangle getDrawingArea() {
        Rectangle rectangle = new Rectangle();
        this.getDrawingArea(rectangle);
        return rectangle;
    }

    public void getDrawingArea(Rectangle rectangle) {
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        rectangle.setBounds(insets.left, insets.top, Math.max(0, dimension.width - (insets.left + insets.right)), Math.max(0, dimension.height - (insets.top + insets.bottom)));
    }

    public CellRendererPane getCellRendererPane() {
        return this.cellRendererPane;
    }

    public Graphics getGraphics() {
        if (this.prevSetGraphics == null) {
            return super.getGraphics();
        }
        return this.prevSetGraphics.create();
    }

    public void setGraphics(Graphics graphics) {
        this.prevSetGraphics = graphics;
    }

    public boolean getChanged() {
        return this.changed;
    }

    public boolean getChanged(int n) {
        return (this.changedFlag & n) == n;
    }

    public final boolean isChanged() {
        return this.getChanged();
    }

    public final boolean isChanged(int n) {
        return this.getChanged(n);
    }

    public void setChanged(boolean bl, int n) {
        if (bl != this.getChanged() || !this.getChanged(n)) {
            this.changed = bl;
            this.changedFlag = bl ? (this.changedFlag |= n) : n;
        }
        if (bl && this.getParent() != null && this.updateParent) {
            this.updateParent(n);
        }
    }

    public void setChanged(boolean bl, int n, boolean bl2) {
        if (bl2) {
            this.setChanged(bl, n);
        } else {
            this.changed = bl;
            this.changedFlag = bl ? (this.changedFlag |= n) : n;
        }
    }

    public void updateParent(int n) {
        Container container = this.getParent();
        if (container != null) {
            Changeable changeable = null;
            if (container instanceof Changeable) {
                changeable = (Changeable)((Object)container);
            }
            if ((n & 2) > 0 || (n & 8) > 0) {
                container.invalidate();
                if (changeable != null && !changeable.isBatched() || changeable == null) {
                    container.validate();
                    container.repaint();
                }
            } else if ((n & 1) > 0 && (changeable != null && !changeable.isBatched() || changeable == null)) {
                container.repaint();
            }
        }
    }

    public boolean isBatched() {
        return false;
    }

    public void setLocale(Locale locale) {
        if (this.locale == locale || locale == null) {
            return;
        }
        try {
            this.locale = locale;
        }
        catch (MissingResourceException missingResourceException) {
            this.locale = Locale.getDefault();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.changed;
        int n = this.changedFlag;
        this.changed = true;
        this.changedFlag = 2;
        objectOutputStream.defaultWriteObject();
        this.changed = bl;
        this.changedFlag = n;
    }
}

