/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.formulae;

import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.ExpressionList;
import com.klg.jclass.util.formulae.ExpressionReference;
import com.klg.jclass.util.formulae.MathExpressionList;
import com.klg.jclass.util.formulae.MathValue;
import com.klg.jclass.util.formulae.Operation;
import com.klg.jclass.util.formulae.RealComparator;
import com.klg.jclass.util.formulae.Result;
import java.util.Collections;
import java.util.Iterator;

public class Sort
extends Operation {
    public Sort(Expression expression) {
        super(expression);
    }

    public Sort(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    public Result evaluate() {
        if (this.leftOperand == null && this.rightOperand == null) {
            throw new IllegalArgumentException("Sort is not defined on zero operands");
        }
        MathExpressionList mathExpressionList = new MathExpressionList();
        if (this.leftOperand != null) {
            this.addElements(mathExpressionList, this.leftOperand);
        }
        if (this.rightOperand != null) {
            this.addElements(mathExpressionList, this.rightOperand);
        }
        Collections.sort(mathExpressionList, new RealComparator());
        return mathExpressionList;
    }

    private void addElements(ExpressionList expressionList, Expression expression) {
        if (expression instanceof MathValue) {
            expressionList.add(expression);
        } else if (expression instanceof Operation || expression instanceof ExpressionReference) {
            expressionList.add(expression.evaluate());
        } else if (expression instanceof ExpressionList) {
            Iterator iterator = ((ExpressionList)expression).iterator();
            while (iterator.hasNext()) {
                Expression expression2 = (Expression)iterator.next();
                this.addElements(expressionList, expression2);
            }
        } else {
            throw new IllegalArgumentException("Sort:  Unrecognised math type in ExpressionList");
        }
    }
}

