/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.formulae;

import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.ExpressionList;
import com.klg.jclass.util.formulae.ExpressionReference;
import com.klg.jclass.util.formulae.MathExpressionList;
import com.klg.jclass.util.formulae.MathScalar;
import com.klg.jclass.util.formulae.MathValue;
import com.klg.jclass.util.formulae.Operation;
import com.klg.jclass.util.formulae.Result;
import java.util.Iterator;

public class Root
extends Operation {
    public Root(Expression expression) {
        super(expression);
    }

    public Root(Number number) {
        super(number);
    }

    public Result evaluate() {
        if (this.leftOperand == null && this.rightOperand == null) {
            throw new IllegalArgumentException("Square root is not defined on zero operands");
        }
        if (this.leftOperand != null && this.rightOperand != null) {
            throw new IllegalArgumentException("Square root is not a binary operator");
        }
        if (this.leftOperand == null) {
            return this.getResult(this.rightOperand);
        }
        return this.getResult(this.leftOperand);
    }

    private Result getResult(Expression expression) {
        if (expression instanceof Operation || expression instanceof ExpressionReference) {
            expression = expression.evaluate();
        }
        if (expression instanceof MathValue) {
            MathValue mathValue = (MathValue)expression;
            return this.doRoot(mathValue);
        }
        if (expression instanceof ExpressionList) {
            ExpressionList expressionList = (ExpressionList)expression;
            Iterator iterator = expressionList.iterator();
            MathExpressionList mathExpressionList = new MathExpressionList();
            while (iterator.hasNext()) {
                Expression expression2 = (Expression)iterator.next();
                ((ExpressionList)mathExpressionList).add(this.getResult(expression2));
            }
            return mathExpressionList;
        }
        throw new IllegalArgumentException("Unrecognised math type to Square root");
    }

    private MathValue doRoot(MathValue mathValue) {
        if (!(mathValue instanceof MathScalar)) {
            throw new IllegalArgumentException("Can't take the square root of a vector or matrix.");
        }
        MathScalar mathScalar = (MathScalar)mathValue;
        Number number = this.rootSimple(mathScalar.realValue);
        return new MathScalar(number);
    }

    private Number rootSimple(Number number) {
        Double d = null;
        d = new Double(Math.sqrt(number.doubleValue()));
        return d;
    }
}

