/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.calendar;

import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.calendar.BoundsValidator;
import com.klg.jclass.util.calendar.CalendarComponent;
import com.klg.jclass.util.calendar.JCCalendar;
import com.klg.jclass.util.value.CalendarValueModel;
import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueListener;
import com.klg.jclass.util.value.JCValueModel;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;

public class TimeSpin
extends JSpinner
implements CalendarComponent,
JCValueListener,
ChangeListener {
    private static int defaultColumns = 10;
    protected JCValueModel valueModel;
    protected BoundsValidator boundsValidator = new BoundsValidator(this);
    protected boolean ignoreChange = false;
    static /* synthetic */ Class class$java$util$Date;

    public TimeSpin() {
        this(new Date());
    }

    public TimeSpin(Date date) {
        this(date, Locale.getDefault());
    }

    public TimeSpin(Date date, Locale locale) {
        if (JCEnvironment.getJavaVersion() < 140) {
            throw new IllegalStateException("TimeSpin is incompatible with JDKs prior to 1.4.0");
        }
        if (date == null) {
            throw new IllegalArgumentException("Null date in TimeSpin constructor");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.setLocale(locale);
        this.valueModel = new CalendarValueModel();
        this.valueModel.addValueListener(this);
        SpinnerDateModel spinnerDateModel = new SpinnerDateModel();
        spinnerDateModel.setValue(date);
        this.setModel(spinnerDateModel);
    }

    public void setCalendarModel(JCValueModel jCValueModel) {
        if (!(jCValueModel instanceof CalendarValueModel)) {
            throw new IllegalArgumentException("Must use a CalendarValueModel");
        }
        if (this.valueModel == jCValueModel) {
            return;
        }
        if (this.valueModel != null) {
            this.valueModel.removeValueListener(this);
        }
        this.valueModel = jCValueModel;
        this.valueModel.addValueListener(this);
        Calendar calendar = (Calendar)jCValueModel.getValue();
        Date date = (Date)JCCalendar.convertCalendarToObject(calendar, class$java$util$Date == null ? (class$java$util$Date = TimeSpin.class$("java.util.Date")) : class$java$util$Date);
        this.getModel().setValue(date);
    }

    public void setModel(SpinnerModel spinnerModel) {
        if (spinnerModel == null) {
            throw new IllegalArgumentException("Can't set null model");
        }
        if (!(spinnerModel instanceof SpinnerDateModel)) {
            throw new IllegalArgumentException("Must set SpinnerDateModel");
        }
        SpinnerModel spinnerModel2 = this.getModel();
        if (spinnerModel2 == spinnerModel) {
            return;
        }
        if (spinnerModel2 != null) {
            spinnerModel2.removeChangeListener(this);
        }
        super.setModel(spinnerModel);
        spinnerModel.addChangeListener(this);
        if (this.valueModel != null) {
            Date date = ((SpinnerDateModel)spinnerModel).getDate();
            Calendar calendar = Calendar.getInstance(this.getLocale());
            calendar.setTime(date);
            this.valueModel.setValue(calendar);
        }
    }

    public Calendar getMinimumDate() {
        return this.boundsValidator.getMinimumDate();
    }

    public void setMinimumDate(Calendar calendar) {
        this.boundsValidator.setMinimumDate(calendar);
    }

    public Calendar getMaximumDate() {
        return this.boundsValidator.getMaximumDate();
    }

    public void setMaximumDate(Calendar calendar) {
        this.boundsValidator.setMaximumDate(calendar);
    }

    public void setSpecialDates(JCCalendar jCCalendar) {
    }

    public void addActionListener(ActionListener actionListener) {
    }

    public void removeActionListener(ActionListener actionListener) {
    }

    public void valueChanging(JCValueEvent jCValueEvent) {
        if (!this.boundsValidator.isValid((Calendar)jCValueEvent.getNewValue())) {
            jCValueEvent.setAllowChange(false);
            Toolkit toolkit = this.getToolkit();
            if (toolkit != null) {
                toolkit.beep();
            }
        }
    }

    public void valueChanged(JCValueEvent jCValueEvent) {
        Date date;
        Calendar calendar = (Calendar)jCValueEvent.getNewValue();
        SpinnerDateModel spinnerDateModel = (SpinnerDateModel)this.getModel();
        Date date2 = (Date)spinnerDateModel.getValue();
        if (!date2.equals(date = calendar.getTime())) {
            spinnerDateModel.setValue(date);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Date date;
        if (this.ignoreChange) {
            return;
        }
        Calendar calendar = (Calendar)this.valueModel.getValue();
        SpinnerDateModel spinnerDateModel = (SpinnerDateModel)this.getModel();
        Date date2 = (Date)spinnerDateModel.getValue();
        if (!date2.equals(date = calendar.getTime())) {
            Calendar calendar2 = Calendar.getInstance(this.getLocale());
            calendar2.setTime(date2);
            Calendar calendar3 = (Calendar)calendar.clone();
            calendar3.set(11, calendar2.get(11));
            calendar3.set(12, calendar2.get(12));
            calendar3.set(13, calendar2.get(13));
            calendar3.set(9, calendar2.get(9));
            if (this.boundsValidator.isValid(calendar3)) {
                this.valueModel.setValue(calendar3);
            } else {
                this.ignoreChange = true;
                spinnerDateModel.setValue(date);
                this.ignoreChange = false;
            }
        }
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        DateFormat dateFormat = DateFormat.getTimeInstance(2, this.getLocale());
        this.setFormat(dateFormat);
        if (dateFormat instanceof SimpleDateFormat) {
            this.setColumns((SimpleDateFormat)dateFormat);
        } else {
            this.setColumns(defaultColumns);
        }
    }

    public void setFormat(DateFormat dateFormat) {
        JSpinner.DefaultEditor defaultEditor;
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat();
        }
        if ((defaultEditor = (JSpinner.DefaultEditor)this.getEditor()) != null) {
            JFormattedTextField jFormattedTextField = defaultEditor.getTextField();
            DateFormatter dateFormatter = new DateFormatter(dateFormat);
            DefaultFormatterFactory defaultFormatterFactory = new DefaultFormatterFactory(dateFormatter);
            jFormattedTextField.setFormatterFactory(defaultFormatterFactory);
        }
    }

    public void setColumns(SimpleDateFormat simpleDateFormat) {
        if (simpleDateFormat == null) {
            return;
        }
        String string = simpleDateFormat.toPattern();
        this.setColumns(string == null ? defaultColumns : string.length());
    }

    public void setColumns(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Number of columns must be non-negative");
        }
        JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)this.getEditor();
        if (defaultEditor != null) {
            JFormattedTextField jFormattedTextField = defaultEditor.getTextField();
            jFormattedTextField.setColumns(n);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        JComponent jComponent = this.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)jComponent;
            JFormattedTextField jFormattedTextField = defaultEditor.getTextField();
            jFormattedTextField.setFont(font);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

