/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.calendar;

import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueListener;
import java.awt.Component;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.Calendar;

public class BoundsValidator
implements JCValueListener,
Serializable {
    protected Calendar minimumDate;
    protected Calendar maximumDate;
    protected Component parent;

    public BoundsValidator() {
    }

    public BoundsValidator(Component component) {
        this.parent = component;
    }

    public BoundsValidator(Calendar calendar, Calendar calendar2) {
        this(null, calendar, calendar2);
    }

    public BoundsValidator(Component component, Calendar calendar, Calendar calendar2) {
        this.parent = component;
        this.minimumDate = calendar;
        this.maximumDate = calendar2;
    }

    public Component getParent() {
        return this.parent;
    }

    public void setParent(Component component) {
        this.parent = component;
    }

    protected boolean checkDates(Calendar calendar, Calendar calendar2) {
        boolean bl = true;
        if (calendar != null && calendar2 != null && calendar.after(calendar2)) {
            bl = false;
        }
        return bl;
    }

    public Calendar getMinimumDate() {
        return this.minimumDate;
    }

    public void setMinimumDate(Calendar calendar) {
        if (!this.checkDates(calendar, this.maximumDate)) {
            throw new IllegalArgumentException("Minimum date must be before maximum date!");
        }
        this.minimumDate = calendar;
    }

    public Calendar getMaximumDate() {
        return this.maximumDate;
    }

    public void setMaximumDate(Calendar calendar) {
        if (!this.checkDates(this.minimumDate, calendar)) {
            throw new IllegalArgumentException("Maximum date must be after minimum date!");
        }
        this.maximumDate = calendar;
    }

    public boolean isValid(Calendar calendar) {
        if (calendar == null) {
            return false;
        }
        return (this.maximumDate == null || !this.maximumDate.before(calendar)) && (this.minimumDate == null || !this.minimumDate.after(calendar));
    }

    public void valueChanging(JCValueEvent jCValueEvent) {
        if (!this.isValid((Calendar)jCValueEvent.getNewValue())) {
            Toolkit toolkit;
            jCValueEvent.setAllowChange(false);
            if (this.parent != null && (toolkit = this.parent.getToolkit()) != null) {
                toolkit.beep();
            }
        }
    }

    public void valueChanged(JCValueEvent jCValueEvent) {
    }
}

