/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util;

import com.klg.jclass.util.AssertionException;
import java.io.PrintStream;

public class JCDebug {
    protected static boolean enabled = false;
    protected static String[] tags = null;
    protected static int level = Integer.MAX_VALUE;
    protected static PrintStream stream = System.out;

    public static void setEnabled(boolean bl) {
        enabled = bl;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setPrintStream(PrintStream printStream) {
        stream = printStream;
    }

    public static PrintStream getPrintStream() {
        return stream;
    }

    public static void setLevel(int n) {
        level = n;
    }

    public static int getLevel() {
        return level;
    }

    public static void setTags(String[] stringArray) {
        tags = stringArray;
    }

    public static void setTag(String string) {
        if (string == null) {
            JCDebug.setTags(null);
        } else {
            String[] stringArray = new String[]{string};
            JCDebug.setTags(stringArray);
        }
    }

    public static String[] getTags() {
        return tags;
    }

    public static final void assertThat(boolean bl) {
        if (enabled && !bl) {
            throw new AssertionException();
        }
    }

    public static final void assertThat(boolean bl, String string) {
        if (enabled && !bl) {
            throw new AssertionException(string);
        }
    }

    public static void printStackTrace() {
        try {
            throw new NullPointerException("Forced Stack Trace");
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace(stream);
            return;
        }
    }

    public static void printStackTrace(String string) {
        try {
            throw new NullPointerException(string);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace(stream);
            return;
        }
    }

    public static void printStackTrace(String string, Throwable throwable) {
        if (!JCDebug.isPrintableTag(string)) {
            return;
        }
        throwable.printStackTrace(stream);
    }

    public static void print(int n, String string, String string2) {
        if (!JCDebug.isPrintableLevel(n)) {
            return;
        }
        if (!JCDebug.isPrintableTag(string)) {
            return;
        }
        stream.print(string2);
    }

    public static void print(int n, String string) {
        JCDebug.print(n, null, string);
    }

    public static void print(String string, String string2) {
        JCDebug.print(0, string, string2);
    }

    public static void print(String string) {
        JCDebug.print(0, null, string);
    }

    public static void println(int n, String string, String string2) {
        if (!JCDebug.isPrintableLevel(n)) {
            return;
        }
        if (!JCDebug.isPrintableTag(string)) {
            return;
        }
        stream.println(string2);
    }

    public static void println(int n, String string) {
        JCDebug.println(n, null, string);
    }

    public static void println(String string, String string2) {
        JCDebug.println(0, string, string2);
    }

    public static void println(String string) {
        JCDebug.println(0, null, string);
    }

    protected static boolean isPrintableLevel(int n) {
        if (!enabled) {
            return false;
        }
        return n <= level;
    }

    protected static boolean isPrintableTag(String string) {
        if (!enabled) {
            return false;
        }
        if (string == null) {
            return true;
        }
        if (tags == null) {
            return false;
        }
        int n = 0;
        while (n < tags.length) {
            if (string != null && string.equals(tags[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

