/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.SelectionModel;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class JCSelection
implements SelectionModel,
Serializable {
    protected JCTable table;
    protected Vector selected_cells = null;
    protected int policy = 0;
    protected int last_selected_row = -1;
    protected int last_selected_column = -1;

    public JCSelection() {
    }

    public JCSelection(JCTable jCTable) {
        this.table = jCTable;
    }

    public JCTable getTable() {
        return this.table;
    }

    public void setTable(JCTable jCTable) {
        this.table = jCTable;
    }

    public int getSelectionPolicy() {
        return this.policy;
    }

    public void setSelectionPolicy(int n) {
        if (this.selected_cells != null) {
            this.clearSelection();
        }
        this.policy = n;
    }

    public boolean addColumnSelection(int n, int n2) {
        return this.addSelection(-1, n, Integer.MAX_VALUE, n2);
    }

    public boolean addRowSelection(int n, int n2) {
        return this.addSelection(n, -1, n2, Integer.MAX_VALUE);
    }

    public boolean addSelection(int n, int n2, int n3, int n4) {
        if (n == n3 && n == -1) {
            n3 = Integer.MAX_VALUE;
        }
        if (n2 == n4 && n2 == -1) {
            n4 = Integer.MAX_VALUE;
        }
        return this.addSelection(new JCCellRange(n, n2, n3, n4));
    }

    public boolean addSelection(JCCellRange jCCellRange) {
        JCSelectEvent jCSelectEvent;
        if (this.selected_cells == null) {
            return false;
        }
        if (this.policy != 3) {
            return false;
        }
        if (this.table.selectListeners != null) {
            jCSelectEvent = new JCSelectEvent(this.table, 1, jCCellRange.start_row, jCCellRange.start_column, jCCellRange.end_row, jCCellRange.end_column, 1);
            this.table.fireJCSelectEvent(jCSelectEvent);
            if (jCSelectEvent.isCancelled()) {
                return false;
            }
        }
        this.selected_cells.addElement(jCCellRange);
        if (this.table.selectListeners != null) {
            jCSelectEvent = new JCSelectEvent(this.table, 2, jCCellRange.start_row, jCCellRange.start_column, jCCellRange.end_row, jCCellRange.end_column, 1);
            this.table.fireJCSelectEvent(jCSelectEvent);
            if (jCSelectEvent.isCancelled()) {
                this.selected_cells.removeElement(jCCellRange);
                return false;
            }
        }
        this.table.getCellAreaHandler().getCellAreaRenderer().repaintRange(jCCellRange);
        return true;
    }

    public void cleanup() {
        if (this.selected_cells == null) {
            return;
        }
        int n = this.selected_cells.size();
        if (n < 2) {
            return;
        }
        JCCellRange jCCellRange = (JCCellRange)this.selected_cells.lastElement();
        int n2 = n - 2;
        while (n2 >= 0) {
            if (jCCellRange.equals(this.selected_cells.elementAt(n2))) {
                this.selected_cells.removeElementAt(n2);
            }
            --n2;
        }
    }

    public void clearSelection() {
        this.clearSelection(true);
    }

    /*
     * Unable to fully structure code
     */
    public void clearSelection(boolean var1_1) {
        if (this.selected_cells == null) {
            return;
        }
        var2_2 = new Vector<JCCellRange>();
        var3_3 = (Vector)this.selected_cells.clone();
        var5_4 = null;
        var6_5 = 0;
        while (var6_5 < var3_3.size()) {
            block9: {
                var4_6 = (JCCellRange)var3_3.elementAt(var6_5);
                if (this.table.selectListeners == null) break block9;
                var5_4 = new JCSelectEvent(this.table, 1, var4_6.start_row, var4_6.start_column, var4_6.end_row, var4_6.end_column, 3);
                if (!var1_1) ** GOTO lbl-1000
                this.table.fireJCSelectEvent(var5_4);
                if (var5_4.isCancelled()) {
                    var2_2.addElement(var4_6);
                } else lbl-1000:
                // 2 sources

                {
                    var5_4.type = 2;
                    this.table.fireJCSelectEvent(var5_4);
                    if (var5_4.isCancelled()) {
                        var2_2.addElement(var4_6);
                    }
                }
            }
            ++var6_5;
        }
        if (var2_2.size() == 0) {
            this.selected_cells = null;
            var7_7 = 0;
            while (var7_7 < var3_3.size()) {
                var4_6 = (JCCellRange)var3_3.elementAt(var7_7);
                var8_8 = this.table.getCellAreaHandler().getCellAreaRenderer();
                var9_9 = Math.min(var4_6.start_row, var4_6.end_row);
                var10_10 = Math.max(var4_6.start_row, var4_6.end_row);
                var11_11 = Math.min(var4_6.start_column, var4_6.end_column);
                var12_12 = Math.max(var4_6.start_column, var4_6.end_column);
                var8_8.repaintRange(var9_9, var11_11, var10_10, var12_12);
                ++var7_7;
            }
        } else {
            this.selected_cells = (Vector)var2_2.clone();
            this.table.repaint();
        }
        if (var1_1 && var5_4 != null) {
            var5_4.type = 3;
            this.table.fireJCSelectEvent(var5_4);
        }
        var2_2 = null;
        var3_3 = null;
        this.last_selected_row = -1;
        this.last_selected_column = -1;
    }

    public boolean extendSelection(int n, int n2) {
        int n3;
        if (this.selected_cells == null || this.selected_cells.size() == 0) {
            return false;
        }
        switch (this.policy) {
            case 0: 
            case 1: {
                return false;
            }
        }
        JCCellRange jCCellRange = (JCCellRange)this.selected_cells.lastElement();
        if (this.isLabel(jCCellRange.start_row, jCCellRange.start_column) && !this.isLabel(n, n2)) {
            if (jCCellRange.start_row == -1) {
                n = -1;
            } else if (jCCellRange.start_column == -1) {
                n2 = -1;
            } else {
                return false;
            }
        }
        if (this.table.selectListeners != null) {
            JCSelectEvent jCSelectEvent = new JCSelectEvent(this.table, 2, jCCellRange.start_row, jCCellRange.start_column, n, n2, 2);
            this.table.fireJCSelectEvent(jCSelectEvent);
            if (jCSelectEvent.isCancelled()) {
                return false;
            }
        }
        int n4 = jCCellRange.start_row;
        int n5 = jCCellRange.start_column;
        int n6 = jCCellRange.end_row;
        int n7 = jCCellRange.end_column;
        if (n6 < n4) {
            n3 = n4;
            n4 = n6;
            n6 = n3;
        }
        if (n7 < n5) {
            n3 = n5;
            n5 = n7;
            n7 = n3;
        }
        if (n == -1) {
            jCCellRange.end_column = n2;
        } else if (n2 == -1) {
            jCCellRange.end_row = n;
        } else {
            jCCellRange.end_row = n;
            jCCellRange.end_column = n2;
        }
        n4 = Math.min(n, n4);
        n6 = Math.max(n, n6);
        n5 = Math.min(n2, n5);
        n7 = Math.max(n2, n7);
        this.table.getCellAreaHandler().getCellAreaRenderer().repaintRange(n4, n5, n6, n7);
        return true;
    }

    public Collection getSelectedCells() {
        return this.selected_cells;
    }

    public boolean isSelected(int n, int n2) {
        if (this.selected_cells == null) {
            return false;
        }
        int n3 = 0;
        while (n3 < this.selected_cells.size()) {
            JCCellRange jCCellRange = (JCCellRange)this.selected_cells.elementAt(n3);
            if (jCCellRange.inside(n, n2)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean selectAll() {
        return this.setSelection(-1, -1, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public boolean setColumnSelection(int n, int n2) {
        return this.setSelection(-1, n, Integer.MAX_VALUE, n2);
    }

    public boolean setRowSelection(int n, int n2) {
        return this.setSelection(n, -1, n2, Integer.MAX_VALUE);
    }

    public boolean setSelection(int n, int n2, int n3, int n4) {
        if (n == n3 && n == -1) {
            n3 = Integer.MAX_VALUE;
        }
        if (n2 == n4 && n2 == -1) {
            n4 = Integer.MAX_VALUE;
        }
        return this.setSelection(new JCCellRange(n, n2, n3, n4));
    }

    public boolean setSelection(Collection collection) {
        if (this.selected_cells != null) {
            this.clearSelection(false);
        }
        boolean bl = true;
        Iterator iterator = collection.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            JCCellRange jCCellRange = (JCCellRange)iterator.next();
            if (bl2) {
                if (!this.setSelection(jCCellRange)) {
                    bl = false;
                }
                bl2 = false;
                continue;
            }
            if (this.addSelection(jCCellRange)) continue;
            bl = false;
        }
        if (!bl) {
            this.clearWithNoNotification();
        }
        return bl;
    }

    public boolean setSelection(JCCellRange jCCellRange) {
        JCSelectEvent jCSelectEvent;
        switch (this.policy) {
            case 0: {
                return false;
            }
            case 1: {
                if (jCCellRange.start_row == jCCellRange.end_row && jCCellRange.start_column == jCCellRange.end_column) break;
                return false;
            }
        }
        if (this.table.selectListeners != null) {
            jCSelectEvent = new JCSelectEvent(this.table, 1, jCCellRange.start_row, jCCellRange.start_column, jCCellRange.end_row, jCCellRange.end_column, 0);
            this.table.fireJCSelectEvent(jCSelectEvent);
            if (jCSelectEvent.isCancelled()) {
                return false;
            }
        }
        if (this.selected_cells != null) {
            this.clearSelection(false);
            if (this.selected_cells != null) {
                return false;
            }
        }
        this.selected_cells = new Vector();
        this.selected_cells.addElement(jCCellRange);
        if (this.table.selectListeners != null) {
            jCSelectEvent = new JCSelectEvent(this.table, 2, jCCellRange.start_row, jCCellRange.start_column, jCCellRange.end_row, jCCellRange.end_column, 0);
            this.table.fireJCSelectEvent(jCSelectEvent);
            if (jCSelectEvent.isCancelled()) {
                this.selected_cells.removeElement(jCCellRange);
                return false;
            }
        }
        this.table.repaintSelected();
        return true;
    }

    public boolean select(int n, int n2, int n3) {
        if (this.policy == 0) {
            return false;
        }
        if (n2 == -999 || n3 == -999) {
            return true;
        }
        if (n2 == this.last_selected_row && n3 == this.last_selected_column && n != 4) {
            return true;
        }
        if (n2 == -999 || n3 == -999) {
            return true;
        }
        boolean bl = false;
        int n4 = n2;
        int n5 = n3;
        JCCellRange jCCellRange = this.table.getSpanHandler().getSpannedRange(n2, n3);
        if (jCCellRange != null) {
            n2 = jCCellRange.start_row;
            n3 = jCCellRange.start_column;
            n4 = jCCellRange.end_row;
            n5 = jCCellRange.end_column;
        }
        if (n == 4) {
            this.last_selected_row = -999;
            this.last_selected_column = -999;
        } else {
            this.last_selected_row = n4;
            this.last_selected_column = n5;
        }
        switch (n) {
            case 0: {
                bl = this.setSelection(n2, n3, n4, n5);
                break;
            }
            case 2: {
                bl = this.extendSelection(n2, n3);
                break;
            }
            case 1: {
                bl = this.addSelection(n2, n3, n4, n5);
                break;
            }
            case 4: {
                this.cleanup();
                if (this.table.selectListeners != null && this.selected_cells != null) {
                    JCCellRange jCCellRange2 = (JCCellRange)this.selected_cells.lastElement();
                    JCSelectEvent jCSelectEvent = new JCSelectEvent(this.table, 3, jCCellRange2.start_row, jCCellRange2.start_column, n2, n3, 4);
                    this.table.fireJCSelectEvent(jCSelectEvent);
                }
                bl = true;
            }
        }
        if (!bl) {
            this.last_selected_row = -999;
            this.last_selected_column = -999;
        }
        return bl;
    }

    protected void clearWithNoNotification() {
        this.selected_cells = null;
    }

    protected boolean isLabel(int n, int n2) {
        return n == -1 || n2 == -1;
    }

    public void moveColumns(int n, int n2, int n3) {
    }

    public void moveRows(int n, int n2, int n3) {
    }

    public void remapColumns(int[] nArray) {
    }

    public void remapRows(int[] nArray) {
    }

    public void shiftColumn(int n, int n2, int n3) {
    }

    public void shiftRow(int n, int n2, int n3) {
    }

    public void swapColumns(int n, int n2) {
    }

    public void swapRows(int n, int n2) {
    }
}

