/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.cell.JCCellEditor;
import com.klg.jclass.cell.JCCellEditorEvent;
import com.klg.jclass.cell.JCCellEditorListener;
import com.klg.jclass.table.CellArea;
import com.klg.jclass.table.CellAreaHandler;
import com.klg.jclass.table.CellAreaRenderer;
import com.klg.jclass.table.EditTraverseHandler;
import com.klg.jclass.table.FocusModel;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCEditCellEvent;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.JCTraverseCellEvent;
import com.klg.jclass.table.TableCellInfoModel;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import javax.swing.JComponent;

public abstract class EditTraverseHandlerAbstract
implements EditTraverseHandler,
FocusListener,
JCCellEditorListener,
Serializable {
    protected JCTable table;
    protected JCCellEditor editor;
    protected Component component;
    protected int edit_row;
    protected int edit_column;

    public EditTraverseHandlerAbstract(JCTable jCTable) {
        this.table = jCTable;
    }

    public JCCellEditor getCellEditor() {
        return this.editor;
    }

    protected void addKeyAndFocusListeners(Component component, KeyListener keyListener, FocusListener focusListener) {
        if (component == null) {
            return;
        }
        component.removeKeyListener(keyListener);
        component.addKeyListener(keyListener);
        component.removeFocusListener(focusListener);
        component.addFocusListener(focusListener);
    }

    protected abstract void addListeners(Component var1, KeyListener var2, FocusListener var3);

    public void setCellEditor(JCCellEditor jCCellEditor) {
        if (jCCellEditor != null) {
            this.component = jCCellEditor.getComponent();
            if (this.component != null) {
                this.addListeners(this.component, this.table.keyHandler, this);
            }
            jCCellEditor.addCellEditorListener(this);
        } else {
            if (this.editor != null) {
                this.editor.removeCellEditorListener(this);
            }
            if (this.component != null) {
                this.component.removeKeyListener(this.table.keyHandler);
            }
            this.component = null;
        }
        this.editor = jCCellEditor;
        this.edit_row = this.table.getCurrentRow();
        this.edit_column = this.table.getCurrentColumn();
    }

    public int getEditRow() {
        return this.edit_row;
    }

    public int getEditColumn() {
        return this.edit_column;
    }

    public void initializeEditor(AWTEvent aWTEvent, TableCellInfoModel tableCellInfoModel, Object object) {
        this.editor.initialize(aWTEvent, tableCellInfoModel, object);
    }

    public boolean traverse(int n, int n2, boolean bl, AWTEvent aWTEvent, int n3, boolean bl2) {
        Serializable serializable;
        if (n == -999 || n2 == -999) {
            return false;
        }
        if (aWTEvent != null && aWTEvent instanceof KeyEvent && ((KeyEvent)(serializable = (KeyEvent)aWTEvent)).getKeyCode() == 16) {
            return false;
        }
        serializable = this.table.getSpannedRange(n, n2);
        if (serializable != null) {
            n = ((JCCellRange)serializable).start_row;
            n2 = ((JCCellRange)serializable).start_column;
        }
        if (!this.traverseInitial(n, n2, bl, n3)) {
            return false;
        }
        n = this.table.getCurrentRow();
        Component component = this.table.getComponent(n, n2 = this.table.getCurrentColumn());
        if (component != null) {
            this.table.getFocusManager().requestFocus(component);
            this.table.setCurrentCell(n, n2);
            return true;
        }
        if (aWTEvent == null && bl2) {
            this.table.clearSelectedCells();
        }
        if (this.table.auto_edit) {
            bl2 = true;
        }
        if (!this.table.getDataView().isEditable() || !this.table.getCellStyle(n, n2).isEditable()) {
            bl2 = false;
        }
        if (bl2) {
            JCEditCellEvent jCEditCellEvent = null;
            if (this.table.editCellListeners != null) {
                jCEditCellEvent = new JCEditCellEvent(this.table, 1, n, n2);
                this.table.fireJCEditCellEvent(jCEditCellEvent);
                if (jCEditCellEvent.isCancelled()) {
                    jCEditCellEvent.type = 3;
                    this.table.fireJCEditCellEvent(jCEditCellEvent);
                    return false;
                }
            }
            JCCellEditor jCCellEditor = this.table.getDataView().getCellEditor(n, n2);
            if (this.editor != null && this.editor != jCCellEditor) {
                this.cancel();
            }
            Object object = this.table.getDataView().getTableDataItem(n, n2);
            this.setCellEditor(jCCellEditor);
            CellAreaHandler cellAreaHandler = this.table.getCellAreaHandler();
            TableCellInfoModel tableCellInfoModel = cellAreaHandler.getTableCellInfo();
            tableCellInfoModel.initialize(this.table, object, n, n2);
            if (this.editor != null) {
                Rectangle rectangle = cellAreaHandler.getBounds(n, n2);
                this.initializeEditor(aWTEvent, tableCellInfoModel, object);
                if (this.component != null) {
                    Color color = this.table.getCellStyle(n, n2).getBackground();
                    if (color instanceof SystemColor) {
                        color = new Color(color.getRGB());
                    }
                    this.component.setVisible(false);
                    CellArea cellArea = cellAreaHandler.find(n, n2);
                    if (this.component.getParent() != this.table) {
                        if (this.component instanceof JComponent) {
                            ((JComponent)this.component).setBorder(null);
                        }
                        cellArea.add(this.component, 0);
                    }
                    if (this.setValues(cellArea, n, n2, rectangle) && this.component != null) {
                        this.component.setVisible(true);
                        this.setFocusOnEditor(this.component);
                    }
                }
            }
            if (jCEditCellEvent != null) {
                jCEditCellEvent.type = 2;
                jCEditCellEvent.editComponent = this.component;
                this.table.fireJCEditCellEvent(jCEditCellEvent);
            }
        }
        return true;
    }

    public void traverseInitial() {
        int n = 0;
        int n2 = 0;
        if (this.table.isTraversable(n, n2)) {
            this.traverseInitial(n, n2, false, 11);
        } else {
            JCCellPosition jCCellPosition = this.table.keyHandler.findTraversableCell(4, n, n2);
            if (jCCellPosition == null) {
                return;
            }
            this.traverseInitial(jCCellPosition.row, jCCellPosition.column, false, 11);
        }
    }

    protected boolean traverseInitial(int n, int n2, boolean bl, int n3) {
        Serializable serializable;
        if (n < 0 || n >= this.table.getNumRows() || n2 < 0 || n2 >= this.table.getNumColumns()) {
            return false;
        }
        if (!this.table.getCellStyle(n, n2).isTraversable()) {
            return false;
        }
        CellAreaRenderer cellAreaRenderer = this.table.getCellAreaHandler().getCellAreaRenderer();
        int n4 = this.table.current_row;
        int n5 = this.table.current_column;
        this.table.current_row = n;
        this.table.current_column = n2;
        if (this.isValidCell(n4, n5) && (n4 != n || n5 != n2)) {
            serializable = this.table.getComponent(n4, n5);
            if (serializable != null) {
                this.table.getFocusManager().requestFocus();
            }
            cellAreaRenderer.repaintCell(n4, n5, true);
        }
        if (bl) {
            this.table.setSelection(n, n2, n, n2);
        }
        if (!this.table.makeVisible(n, n2)) {
            return false;
        }
        serializable = null;
        if (this.table.traverseListeners != null) {
            serializable = new JCTraverseCellEvent(this.table, 1, n4, n5, n, n2, n3);
            this.table.fireJCTraverseCellEvent((JCTraverseCellEvent)serializable);
            if (((JCTraverseCellEvent)serializable).isCancelled()) {
                ((JCTraverseCellEvent)serializable).next_row = n4;
                ((JCTraverseCellEvent)serializable).next_column = n5;
            }
            n = ((JCTraverseCellEvent)serializable).next_row;
            n2 = ((JCTraverseCellEvent)serializable).next_column;
            this.table.current_row = n;
            this.table.current_column = n2;
        }
        cellAreaRenderer.repaintCell(n, n2);
        if (serializable != null) {
            ((JCTraverseCellEvent)serializable).type = 2;
            this.table.fireJCTraverseCellEvent((JCTraverseCellEvent)serializable);
        }
        return serializable == null || !((JCTraverseCellEvent)serializable).isCancelled();
    }

    protected boolean isValidCell(int n, int n2) {
        return n >= -1 && n < this.table.getNumRows() && n2 >= -1 && n2 < this.table.getNumColumns();
    }

    protected boolean setValues(int n, int n2, Rectangle rectangle) {
        CellArea cellArea = this.table.getCellAreaHandler().find(n, n2);
        return this.setValues(cellArea, n, n2, rectangle);
    }

    protected boolean setValues(CellArea cellArea, int n, int n2, Rectangle rectangle) {
        int n3;
        if (cellArea == null || this.editor == null) {
            return false;
        }
        if (this.component == null) {
            return true;
        }
        boolean bl = true;
        if (!bl) {
            return false;
        }
        int n4 = this.table.getEditHeightPolicy();
        int n5 = this.table.getEditWidthPolicy();
        int n6 = Math.max(rectangle.width, 10);
        int n7 = Math.max(rectangle.height, 10);
        int n8 = this.table.getCellBorderWidth() > 0 ? 1 : 0;
        int n9 = this.table.cellAreaHandler.determineThinSides(n, n2);
        boolean bl2 = (n9 & 0x10) > 0;
        boolean bl3 = (n9 & 0x20) > 0;
        switch (n5) {
            case 1: {
                if (this.component.getMinimumSize().width <= n6) break;
                n6 = this.component.getMinimumSize().width + (bl2 ? 2 * n8 : 1 * n8);
                break;
            }
            case 2: {
                if (this.component.getPreferredSize().width <= n6) break;
                n6 = this.component.getPreferredSize().width + (bl2 ? 2 * n8 : 1 * n8);
            }
        }
        switch (n4) {
            case 1: {
                if (this.component.getMinimumSize().height <= n7) break;
                n7 = this.component.getMinimumSize().height;
                break;
            }
            case 2: {
                if (this.component.getPreferredSize().height <= n7) break;
                n7 = this.component.getPreferredSize().height;
            }
        }
        if (cellArea.isHorizontalScrollable()) {
            rectangle.x += this.table.cellAreaHandler.cellOrigin.x;
        }
        if (cellArea.isVerticalScrollable()) {
            rectangle.y += this.table.cellAreaHandler.cellOrigin.y;
        }
        if (n6 + (n3 = rectangle.x - cellArea.getX()) > cellArea.getWidth()) {
            n6 = cellArea.getWidth() - n3;
        }
        this.component.setBounds(n3 + n8, rectangle.y + n8 - cellArea.getY(), n6 - (bl2 ? 2 * n8 : 1 * n8), n7 - (bl3 ? 2 * n8 : 1 * n8));
        return true;
    }

    public void checkAndReparentEditor() {
        CellArea cellArea;
        if (this.component != null && (cellArea = this.table.getCellAreaHandler().find(this.edit_row, this.edit_column)) != this.component.getParent()) {
            cellArea.add(this.component, 0);
        }
    }

    public void setWidth(int n) {
        Rectangle rectangle = this.table.getCellAreaHandler().getBounds(this.edit_row, this.edit_column);
        rectangle.width = n;
        this.setValues(this.edit_row, this.edit_column, rectangle);
    }

    public void setHeight(int n) {
        Rectangle rectangle = this.table.getCellAreaHandler().getBounds(this.edit_row, this.edit_column);
        rectangle.height = n;
        this.setValues(this.edit_row, this.edit_column, rectangle);
    }

    public void repositionEditor() {
        if (this.editor == null || this.component == null) {
            return;
        }
        Rectangle rectangle = this.table.getCellAreaHandler().getBounds(this.edit_row, this.edit_column);
        this.setValues(this.edit_row, this.edit_column, rectangle);
    }

    public void move(int n, int n2) {
        if (this.component == null) {
            return;
        }
        CellArea cellArea = this.table.getCellAreaHandler().find(this.edit_row, this.edit_column);
        if (cellArea != null) {
            if (n == 0) {
                if (cellArea.getType() == 3) {
                    return;
                }
                if (cellArea.getType() == 4 && this.edit_column < this.table.getFrozenColumns()) {
                    return;
                }
            } else if (n == 1) {
                if (cellArea.getType() == 1) {
                    return;
                }
                if (cellArea.getType() == 4 && this.edit_row < this.table.getFrozenRows()) {
                    return;
                }
            }
        }
        switch (n) {
            case 1: {
                int n3 = this.component.getLocation().x;
                int n4 = this.component.getLocation().y - n2;
                this.component.setLocation(n3, n4);
                break;
            }
            case 0: {
                int n5 = this.component.getLocation().x - n2;
                int n6 = this.component.getLocation().y;
                this.component.setLocation(n5, n6);
            }
        }
    }

    protected void signalError() {
        if (this.component == null || !this.component.isVisible()) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Toolkit.getDefaultToolkit().beep();
    }

    protected boolean cancel() {
        return this.cancel(true);
    }

    public boolean cancel(boolean bl) {
        if (this.editor == null) {
            return true;
        }
        if (this.table.editCellListeners != null) {
            JCEditCellEvent jCEditCellEvent = new JCEditCellEvent(this.table, 3, this.edit_row, this.edit_column);
            this.table.fireJCEditCellEvent(jCEditCellEvent);
        }
        this.editor.cancelCellEditing();
        this.editor.removeCellEditorListener(this);
        if (bl) {
            this.removeEditor();
        }
        return true;
    }

    protected boolean commit() {
        return this.commit(true);
    }

    public boolean commit(boolean bl) {
        return this.commit(bl, true);
    }

    protected boolean commit(boolean bl, boolean bl2) {
        if (this.editor == null) {
            return true;
        }
        if (bl2) {
            boolean bl3 = this.editor.isModified();
            if (!this.editor.stopCellEditing()) {
                this.signalError();
                return false;
            }
            if (!bl3) {
                if (bl) {
                    this.removeEditor();
                    if (this.table.editCellListeners != null) {
                        JCEditCellEvent jCEditCellEvent = new JCEditCellEvent(this.table, 3, this.edit_row, this.edit_column);
                        this.table.fireJCEditCellEvent(jCEditCellEvent);
                    }
                }
                return true;
            }
        }
        Object object = this.editor.getCellEditorValue();
        if (this.table.getDataView().setTableDataItem(object, this.edit_row, this.edit_column)) {
            if (bl) {
                this.removeEditor();
                if (this.table.editCellListeners != null) {
                    JCEditCellEvent jCEditCellEvent = new JCEditCellEvent(this.table, 3, this.edit_row, this.edit_column);
                    this.table.fireJCEditCellEvent(jCEditCellEvent);
                }
            }
            return true;
        }
        this.signalError();
        this.setFocusOnEditor(this.component);
        return false;
    }

    protected void commitAndTraverse(int n) {
        if (this.commit()) {
            this.table.getFocusManager().requestFocus();
            this.table.keyHandler.traverse(n);
        }
    }

    protected void removeEditor() {
        if (this.component != null) {
            this.component.setVisible(false);
        }
        this.setCellEditor(null);
        this.table.getFocusManager().requestFocus();
    }

    public void editingStopped(JCCellEditorEvent jCCellEditorEvent) {
        if (jCCellEditorEvent.getEvent() != null && jCCellEditorEvent.getEvent() instanceof KeyEvent) {
            ((KeyEvent)jCCellEditorEvent.getEvent()).consume();
        }
        if (this.editor != null && this.table.getCurrentRow() == this.edit_row && this.table.getCurrentColumn() == this.edit_column && this.commit()) {
            this.table.getFocusManager().requestFocus();
        }
    }

    public void editingCanceled(JCCellEditorEvent jCCellEditorEvent) {
        if (this.editor != null && this.table.getCurrentRow() == this.edit_row && this.table.getCurrentColumn() == this.edit_column) {
            this.cancel(true);
            this.table.getFocusManager().requestFocus();
        }
    }

    public Component getFocusableChild(Component component) {
        if (component != null && !this.table.getFocusManager().isFocusTraversable(component)) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (this.table.getFocusManager().isFocusTraversable(componentArray[n])) {
                    component = componentArray[n];
                    break;
                }
                ++n;
            }
        }
        return component;
    }

    public void setFocusOnEditor() {
        if (this.component != null) {
            this.setFocusOnEditor(this.component);
        }
    }

    protected void setFocusOnEditor(Component component) {
        if (component == null) {
            return;
        }
        FocusModel focusModel = this.table.getFocusManager();
        if (focusModel.isFocusTraversable(component)) {
            focusModel.requestFocus(component);
        } else {
            Component component2 = this.getFocusableChild(component);
            if (component2 != component) {
                focusModel.requestFocus(component2);
            }
        }
    }

    public abstract void focusGained(FocusEvent var1);

    public abstract void focusLost(FocusEvent var1);
}

