/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.cell.JCCellInfo;
import com.klg.jclass.cell.JCCellRenderer;
import com.klg.jclass.cell.JCComponentCellRenderer;
import com.klg.jclass.cell.JCLightCellRenderer;
import com.klg.jclass.table.CellArea;
import com.klg.jclass.table.CellAreaHandler;
import com.klg.jclass.table.CellBorderModel;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCPaintEvent;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.TableCellInfoModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class CellAreaRenderer
implements Serializable {
    protected JCTable table;
    protected CellAreaHandler cellAreaHandler;
    protected Color borderColor;
    protected Color borderShadowColor;
    protected Color borderHighlightColor;
    protected transient BasicStroke dashedStroke = null;

    public CellAreaRenderer(CellAreaHandler cellAreaHandler) {
        this.cellAreaHandler = cellAreaHandler;
        this.table = cellAreaHandler.getTable();
    }

    public void paintComponent(Graphics graphics) {
        Component component;
        this.drawFrameBorder(graphics);
        Rectangle rectangle = graphics.getClipBounds();
        int n = 0;
        while (n < this.cellAreaHandler.areas.size()) {
            component = (CellArea)this.cellAreaHandler.areas.elementAt(n);
            if (component.isVisible() && ((CellArea)component).intersects(rectangle)) {
                this.paintArea(graphics, (CellArea)component);
            }
            ++n;
        }
        if (this.table.getEditWidthPolicy() == 2 && (component = this.table.getEditingComponent()) != null) {
            component.repaint();
        }
    }

    protected void paintArea(Graphics graphics, CellArea cellArea) {
        if (!cellArea.isVisible()) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = cellArea.getBounds();
        if (rectangle2.width <= 0 || rectangle2.height <= 0) {
            return;
        }
        graphics.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        Rectangle rectangle3 = graphics.getClipBounds();
        int n = cellArea.getEndRow();
        int n2 = cellArea.getEndColumn();
        int n3 = this.cellAreaHandler.getRow(rectangle3.x + 1, rectangle3.y + 1);
        int n4 = this.cellAreaHandler.getColumn(rectangle3.x + 1, rectangle3.y + 1);
        int n5 = this.cellAreaHandler.getRow(rectangle3.x + rectangle3.width - 1, rectangle3.y + rectangle3.height - 1);
        int n6 = this.cellAreaHandler.getColumn(rectangle3.x + rectangle3.width - 1, rectangle3.y + rectangle3.height - 1);
        if (n3 == -999 || n4 == -999) {
            graphics.setClip(rectangle);
            return;
        }
        if (n5 == -999 || n5 == Integer.MAX_VALUE) {
            n5 = n;
        }
        if (n6 == -999 || n6 == Integer.MAX_VALUE) {
            n6 = n2;
        }
        if (cellArea.getType() == 0) {
            graphics.translate(this.cellAreaHandler.cellOrigin.x, this.cellAreaHandler.cellOrigin.y);
        } else if (cellArea.getType() == 3 || cellArea.getType() == 6) {
            graphics.translate(0, this.cellAreaHandler.cellOrigin.y);
        } else if (cellArea.getType() == 1 || cellArea.getType() == 2) {
            graphics.translate(this.cellAreaHandler.cellOrigin.x, 0);
        }
        this.paintRange(graphics, n3, n4, n5, n6);
        if (this.cellAreaHandler.DRAGGING) {
            if (this.cellAreaHandler.drag_row != -999 && this.cellAreaHandler.drag_row != -1 && (this.cellAreaHandler.drag_row < n3 || this.cellAreaHandler.drag_row > n5)) {
                this.paintRange(graphics, this.cellAreaHandler.drag_row, n4, this.cellAreaHandler.drag_row, n6);
            } else if (this.cellAreaHandler.drag_column != -999 && this.cellAreaHandler.drag_column != -1 && (this.cellAreaHandler.drag_column < n4 || this.cellAreaHandler.drag_column > n6)) {
                this.paintRange(graphics, n3, this.cellAreaHandler.drag_column, n5, this.cellAreaHandler.drag_column);
            }
        }
        if (cellArea.getType() == 0) {
            graphics.translate(-this.cellAreaHandler.cellOrigin.x, -this.cellAreaHandler.cellOrigin.y);
        } else if (cellArea.getType() == 3 || cellArea.getType() == 6) {
            graphics.translate(0, -this.cellAreaHandler.cellOrigin.y);
        } else if (cellArea.getType() == 1 || cellArea.getType() == 2) {
            graphics.translate(-this.cellAreaHandler.cellOrigin.x, 0);
        }
        graphics.setClip(rectangle);
    }

    protected void paintRange(Graphics graphics, int n, int n2, int n3, int n4) {
        if (graphics == null) {
            return;
        }
        if (this.table.paintListeners != null) {
            this.table.fireJCPaintEvent(new JCPaintEvent(this.table, 0, n, n2, n3, n4));
        }
        Rectangle rectangle = new Rectangle();
        int n5 = n;
        while (n5 <= n3) {
            int n6 = n2;
            while (n6 <= n4) {
                this.paintCell(graphics, n5, n6, false, rectangle);
                ++n6;
            }
            ++n5;
        }
        if (this.table.paintListeners != null) {
            this.table.fireJCPaintEvent(new JCPaintEvent(this.table, 1, n, n2, n3, n4));
        }
    }

    protected void paintCell(Graphics graphics, int n, int n2) {
        this.paintCell(graphics, n, n2, true, new Rectangle());
    }

    protected void paintCell(Graphics graphics, int n, int n2, boolean bl) {
        this.paintCell(graphics, n, n2, bl, new Rectangle());
    }

    protected void paintCell(Graphics graphics, int n, int n2, boolean bl, Rectangle rectangle) {
        Component component;
        Serializable serializable;
        Serializable serializable2;
        if (this.table.isRowHidden(n) || this.table.isColumnHidden(n2)) {
            return;
        }
        Rectangle rectangle2 = graphics.getClipBounds();
        if ((rectangle = this.cellAreaHandler.getBounds(n, n2, rectangle)) == null) {
            return;
        }
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        JCCellRange jCCellRange = null;
        if (this.table.spanHandler != null && (jCCellRange = this.table.spanHandler.getSpannedRange(n, n2)) != null && !this.table.spanHandler.isControllingCell(jCCellRange, n, n2)) {
            Rectangle rectangle3 = this.table.getCellLayout().getBounds(jCCellRange.start_row, jCCellRange.start_column);
            CellArea cellArea = this.cellAreaHandler.find(jCCellRange.start_row, jCCellRange.start_column);
            if (cellArea != null) {
                rectangle3.x += cellArea.getX() - cellArea.getStandardOffsetX();
                rectangle3.y += cellArea.getY() - cellArea.getStandardOffsetY();
                if (rectangle3.x < rectangle2.x || rectangle3.y < rectangle2.y) {
                    this.paintCell(graphics, jCCellRange.start_row, jCCellRange.start_column);
                }
            }
            return;
        }
        Object object = this.table.getDataView().getObject(n, n2);
        if (this.table.cellDisplayListeners != null) {
            serializable2 = new JCCellDisplayEvent(this.table, n, n2, object);
            this.table.fireJCCellDisplayEvent((JCCellDisplayEvent)serializable2);
            object = ((JCCellDisplayEvent)serializable2).getDisplayData();
        }
        if (bl) {
            this.table.fireJCPaintEvent(new JCPaintEvent(this.table, 0, n, n2, n, n2));
        }
        serializable2 = this.cellAreaHandler.getTableCellInfo();
        serializable2.initialize(this.table, object, n, n2);
        JCCellRenderer jCCellRenderer = this.table.getDataView().getCellRenderer(n, n2, object);
        boolean bl2 = this.table.isSelected(n, n2);
        int n7 = this.table.getFocusIndicator();
        int n8 = 0;
        n8 = jCCellRange == null ? this.cellAreaHandler.determineThinSides(n, n2) : this.cellAreaHandler.determineThinSides(jCCellRange.end_row, jCCellRange.end_column);
        if (this.table.isCurrentCell(n, n2) && n7 == 1 && this.table.getFocusColor() != null) {
            graphics.setColor(this.table.getFocusColor());
        } else if (bl2) {
            graphics.setColor(serializable2.getSelectedBackground());
        } else {
            graphics.setColor(serializable2.getBackground());
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        CellBorderModel cellBorderModel = serializable2.getCellBorder();
        if (cellBorderModel != null) {
            int n9 = serializable2.getCellStyle().getCellBorderColorMode();
            serializable = serializable2.getCellStyle().getCellBorderColor();
            if (serializable == null && n9 == 0 || n9 == 1) {
                serializable = bl2 ? serializable2.getSelectedBackground() : serializable2.getBackground();
            } else if (n9 == 2) {
                serializable = bl2 ? serializable2.getSelectedForeground() : serializable2.getForeground();
            }
            if (serializable != this.borderColor) {
                if (((Color)serializable).equals(Color.white)) {
                    this.borderHighlightColor = TableCellInfoModel.WHITE_BRIGHTER;
                    this.borderShadowColor = TableCellInfoModel.WHITE_DARKER;
                } else if (((Color)serializable).equals(Color.black)) {
                    this.borderHighlightColor = TableCellInfoModel.BLACK_BRIGHTER;
                    this.borderShadowColor = TableCellInfoModel.BLACK_DARKER;
                } else {
                    this.borderHighlightColor = ((Color)serializable).brighter();
                    this.borderShadowColor = ((Color)serializable).darker();
                }
                this.borderColor = serializable;
            }
            cellBorderModel.drawBackground(graphics, this.table.getCellBorderWidth(), serializable2.getCellBorderSides() | n8, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.borderHighlightColor, this.borderShadowColor, this.borderColor);
        }
        if ((component = this.table.getComponent(n, n2)) != null) {
            serializable = this.table.getCellAreaHandler().find(n, n2);
            if (serializable != component.getParent()) {
                ((Container)serializable).add(component);
            }
            if (!component.isVisible()) {
                component.setVisible(true);
            }
            Rectangle rectangle4 = new Rectangle();
            int n10 = this.cellAreaHandler.DRAGGING && this.cellAreaHandler.drag_rows != null ? this.cellAreaHandler.drag_rows[((CellArea)serializable).getStartRow()] : ((CellArea)serializable).getStartRow();
            int n11 = this.cellAreaHandler.DRAGGING && this.cellAreaHandler.drag_columns != null ? this.cellAreaHandler.drag_columns[((CellArea)serializable).getStartColumn()] : ((CellArea)serializable).getStartColumn();
            rectangle4 = this.cellAreaHandler.getBounds(n10, n11, rectangle4);
            int n12 = rectangle.x;
            int n13 = rectangle.y;
            if (((CellArea)serializable).isHorizontalScrollable()) {
                n12 -= ((CellArea)serializable).getStandardOffsetX() - this.cellAreaHandler.cellOrigin.x;
                rectangle4.x -= ((CellArea)serializable).getStandardOffsetX();
            }
            if (((CellArea)serializable).isVerticalScrollable()) {
                n13 -= ((CellArea)serializable).getStandardOffsetY() - this.cellAreaHandler.cellOrigin.y;
                rectangle4.y -= ((CellArea)serializable).getStandardOffsetY();
            }
            int n14 = rectangle4.x;
            int n15 = rectangle4.y;
            int n16 = this.table.getComponentBorderWidth();
            component.setBounds(n12 + n16 - n14, n13 + n16 - n15, rectangle.width - 2 * n16, rectangle.height - 2 * n16);
            component.validate();
            this.forcePaintComponent(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            serializable = serializable2.getDrawingArea();
            rectangle.x += ((Rectangle)serializable).x;
            rectangle.y += ((Rectangle)serializable).y;
            rectangle.width = ((Rectangle)serializable).width;
            rectangle.height = ((Rectangle)serializable).height;
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (jCCellRenderer instanceof JCLightCellRenderer) {
                graphics.translate(rectangle.x, rectangle.y);
                try {
                    ((JCLightCellRenderer)jCCellRenderer).draw(graphics, (JCCellInfo)serializable2, object, bl2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                graphics.translate(-rectangle.x, -rectangle.y);
            } else if (jCCellRenderer instanceof JCComponentCellRenderer) {
                JCComponentCellRenderer jCComponentCellRenderer = (JCComponentCellRenderer)jCCellRenderer;
                Component component2 = jCComponentCellRenderer.getRendererComponent((JCCellInfo)serializable2, object, bl2);
                try {
                    this.table.cellRendererPane.paintComponent(graphics, component2, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl) {
                this.table.fireJCPaintEvent(new JCPaintEvent(this.table, 1, n, n2, n, n2));
            }
            graphics.setClip(rectangle2);
        }
        if ((n8 & 0x10) == 0) {
            ++n5;
        }
        if ((n8 & 0x20) == 0) {
            ++n6;
        }
        if (this.table.isCurrentCell(n, n2)) {
            if (n7 == 2) {
                this.drawTable3FocusRectangle(graphics, n3, n4, n5, n6);
            } else if (n7 == 3) {
                this.drawThinFocusRectangle(graphics, n3, n4, n5, n6);
            } else if (n7 == 4) {
                this.drawDashedFocusRectangle(graphics, n3, n4, n5, n6);
            }
        }
    }

    protected void forcePaintComponent(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void drawFrameBorder(Graphics graphics) {
        Color color = this.table.getBackground();
        CellBorderModel cellBorderModel = this.table.getFrameBorder();
        if (cellBorderModel == null) {
            return;
        }
        int n = this.table.getFrameBorderWidth();
        int n2 = 2 * n;
        if (this.cellAreaHandler.rowLabelRect != null) {
            cellBorderModel.drawBackground(graphics, n, 15, this.cellAreaHandler.rowLabelRect.x - n, this.cellAreaHandler.rowLabelRect.y - n, this.cellAreaHandler.rowLabelRect.width + n2, this.cellAreaHandler.rowLabelRect.height + n2, color.brighter(), color.darker(), color);
        }
        if (this.cellAreaHandler.columnLabelRect != null) {
            cellBorderModel.drawBackground(graphics, n, 15, this.cellAreaHandler.columnLabelRect.x - n, this.cellAreaHandler.columnLabelRect.y - n, this.cellAreaHandler.columnLabelRect.width + n2, this.cellAreaHandler.columnLabelRect.height + n2, color.brighter(), color.darker(), color);
        }
        if (this.cellAreaHandler.cellRect != null) {
            cellBorderModel.drawBackground(graphics, n, 15, this.cellAreaHandler.cellRect.x - n, this.cellAreaHandler.cellRect.y - n, this.cellAreaHandler.cellRect.width + n2, this.cellAreaHandler.cellRect.height + n2, color.brighter(), color.darker(), color);
        }
    }

    public void drawTable3FocusRectangle(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = this.table.getFocusColor();
        if (color == null) {
            color = this.cellAreaHandler.getTableCellInfo().getForeground().darker();
        }
        graphics.setColor(color);
        graphics.drawRect(n + 1, n2 + 1, n3 - 3, n4 - 3);
        graphics.drawRect(n + 2, n2 + 2, n3 - 5, n4 - 5);
    }

    public void drawThinFocusRectangle(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = this.table.getFocusColor();
        if (color == null) {
            color = this.cellAreaHandler.getTableCellInfo().getForeground().darker();
        }
        graphics.setColor(color);
        graphics.drawRect(n + 1, n2 + 1, n3 - 3, n4 - 3);
    }

    public void drawDashedFocusRectangle(Graphics graphics, int n, int n2, int n3, int n4) {
        Object object;
        Color color = this.table.getFocusColor();
        if (color == null) {
            color = this.cellAreaHandler.getTableCellInfo().getForeground().darker();
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(color);
        Stroke stroke = graphics2D.getStroke();
        if (this.dashedStroke == null) {
            object = new float[]{1.0f, 3.0f};
            this.dashedStroke = new BasicStroke(1.0f, 0, 0, 1.0f, (float[])object, 0.0f);
        }
        graphics2D.setStroke(this.dashedStroke);
        object = new Rectangle2D.Float(n + 1, n2 + 1, n3 - 3, n4 - 3);
        graphics2D.draw((Shape)object);
        graphics2D.setStroke(stroke);
    }

    public void drawSelectionBorder(Graphics graphics) {
    }

    public void repaintRange(JCCellRange jCCellRange) {
        this.repaintRange(jCCellRange.start_row, jCCellRange.start_column, jCCellRange.end_row, jCCellRange.end_column);
    }

    public void repaintRange(int n, int n2, int n3, int n4) {
        Serializable serializable;
        if (n3 == Integer.MAX_VALUE) {
            n3 = this.table.getNumRows() - 1;
        }
        if (n4 == Integer.MAX_VALUE) {
            n4 = this.table.getNumColumns() - 1;
        }
        if (this.table.spanHandler != null && this.table.resize_interactive) {
            serializable = this.table.spanHandler.getCompleteRange(n, n2, n3, n4);
            n = serializable.start_row;
            n2 = serializable.start_column;
            n3 = serializable.end_row;
            n4 = serializable.end_column;
        }
        int n5 = 0;
        while (n5 < this.cellAreaHandler.areas.size()) {
            CellArea cellArea = (CellArea)this.cellAreaHandler.areas.elementAt(n5);
            if (n <= cellArea.end_row && n3 >= cellArea.start_row && n2 <= cellArea.end_column && n4 >= cellArea.start_column) {
                int n6 = Math.max(cellArea.start_row, n);
                int n7 = Math.max(cellArea.start_column, n2);
                int n8 = Math.min(cellArea.end_row, n3);
                int n9 = Math.min(cellArea.end_column, n4);
                serializable = this.cellAreaHandler.getBounds(n6, n7);
                if (serializable == null) {
                    serializable = new Rectangle(0, 0, 0, 0);
                }
                Rectangle rectangle = this.cellAreaHandler.getBounds(n8, n9);
                int n10 = Math.min(((Rectangle)serializable).x, rectangle.x);
                int n11 = Math.min(((Rectangle)serializable).y, rectangle.y);
                int n12 = Math.max(((Rectangle)serializable).x + ((Rectangle)serializable).width, rectangle.x + rectangle.width) - n10;
                int n13 = Math.max(((Rectangle)serializable).y + ((Rectangle)serializable).height, rectangle.y + rectangle.height) - n11;
                if (cellArea.isHorizontalScrollable()) {
                    n10 += this.cellAreaHandler.cellOrigin.x;
                }
                if (cellArea.isVerticalScrollable()) {
                    n11 += this.cellAreaHandler.cellOrigin.y;
                }
                this.table.repaint(n10, n11, n12, n13);
            }
            ++n5;
        }
    }

    public void repaintCell(int n, int n2) {
        this.repaintCell(n, n2, false);
    }

    public void repaintCell(int n, int n2, boolean bl) {
        Serializable serializable;
        if (this.table.spanHandler != null && (serializable = this.table.spanHandler.getSpannedRange(n, n2)) != null) {
            this.repaintRange((JCCellRange)serializable);
            return;
        }
        serializable = this.cellAreaHandler.getBounds(n, n2);
        CellArea cellArea = this.cellAreaHandler.find(n, n2);
        if (cellArea == null) {
            return;
        }
        if (cellArea.isHorizontalScrollable()) {
            serializable.x += this.cellAreaHandler.cellOrigin.x;
        }
        if (cellArea.isVerticalScrollable()) {
            serializable.y += this.cellAreaHandler.cellOrigin.y;
        }
        if (bl && this.table.store_image_enabled && this.table.store_image != null) {
            Graphics graphics = this.table.store_image.getGraphics();
            int n3 = 0;
            int n4 = 0;
            if (cellArea.getType() == 0) {
                n3 = this.table.cellAreaHandler.cellOrigin.x;
                n4 = this.table.cellAreaHandler.cellOrigin.y;
            } else if (cellArea.getType() == 3 || cellArea.getType() == 6) {
                n4 = this.table.cellAreaHandler.cellOrigin.y;
            } else if (cellArea.getType() == 1 || cellArea.getType() == 2) {
                n3 = this.table.cellAreaHandler.cellOrigin.x;
            }
            graphics.translate(n3, n4);
            this.paintCell(graphics, n, n2, false);
            graphics.translate(-n3, -n4);
        }
        this.table.repaint(serializable.x, serializable.y, serializable.width, serializable.height);
    }
}

