/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.CellArea;
import com.klg.jclass.table.CellAreaHandler;
import com.klg.jclass.table.EditTraverseHandler;
import com.klg.jclass.table.JCScrollEvent;
import com.klg.jclass.table.JCTable;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JScrollBar;

public class AdjustmentHandler
implements AdjustmentListener,
Serializable {
    protected JCTable table;
    protected boolean isTracking = false;
    protected JLabel trackLabel = new JLabel();
    private int vertLastRow = -1;
    private int vertLastValue = -1;
    private int vertLastRealValue = -1;
    private int horLastColumn = -1;
    private int horLastValue = -1;
    private int horLastRealValue = -1;

    public AdjustmentHandler(JCTable jCTable) {
        this.table = jCTable;
        this.trackLabel.setOpaque(true);
        this.trackLabel.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (!this.table.isRepaintEnabled()) {
            this.table.setRecalcRequired(true);
            return;
        }
        Adjustable adjustable = adjustmentEvent.getAdjustable();
        CellAreaHandler cellAreaHandler = this.table.getCellAreaHandler();
        EditTraverseHandler editTraverseHandler = this.table.getEditTraverseHandler();
        int n = adjustmentEvent.getValue();
        JCScrollEvent jCScrollEvent = null;
        int n2 = this.table.getJumpScroll();
        if (adjustable.getOrientation() == 1) {
            Rectangle rectangle;
            int n3;
            int n4;
            int n5;
            Serializable serializable;
            int n6 = cellAreaHandler.getCellOrigin().y;
            int n7 = -cellAreaHandler.getCellOrigin().y;
            if (n == n7 && !this.isTracking) {
                return;
            }
            boolean bl = false;
            if ((n2 == 2 || n2 == 3) && n != this.vertLastValue) {
                serializable = this;
                synchronized (serializable) {
                    n5 = cellAreaHandler.getCellArea().getStandardOffsetY();
                    n4 = this.table.getCellLayout().getRow(0, n + n5);
                    if (n4 == this.vertLastRow) {
                        n4 += n > this.vertLastValue ? 1 : -1;
                    }
                    if (adjustable instanceof JScrollBar && ((JScrollBar)adjustable).getValueIsAdjusting() && (n > this.vertLastRealValue && n4 < this.vertLastRow || n < this.vertLastRealValue && n4 > this.vertLastRow)) {
                        n4 = this.vertLastRow;
                    }
                    this.vertLastRealValue = n;
                    n = this.table.getCellLayout().getRowPosition(n4) - n5;
                    if (n > (n3 = adjustable.getMaximum() - adjustable.getVisibleAmount())) {
                        n = n3;
                    }
                    this.vertLastRow = n4;
                    this.vertLastValue = n;
                    if (n != this.vertLastRealValue) {
                        bl = true;
                    }
                }
            }
            if (this.table.scrollListeners != null && n != n7) {
                jCScrollEvent = new JCScrollEvent(this, 1, adjustable, adjustable.getOrientation(), n, adjustmentEvent);
                this.table.fireJCScrollEvent(jCScrollEvent);
                if (jCScrollEvent.getValue() != n) {
                    adjustable.setValue(jCScrollEvent.value);
                    return;
                }
            }
            cellAreaHandler.cellOrigin.y = -n;
            if (bl) {
                adjustable.setValue(n);
            }
            if (((JScrollBar)(serializable = (JScrollBar)adjustmentEvent.getSource())).getValueIsAdjusting()) {
                if (this.table.getVertSBTrack() != 0) {
                    if (this.isTracking) {
                        n5 = this.table.getVisibleCells().start_row;
                        String string = "";
                        if (this.table.getVertSBTrack() == 1) {
                            string = Integer.toString(n5 + 1);
                        } else {
                            n3 = this.table.getVertSBTrackColumn();
                            Object object = this.table.getDataView().getObject(n5, n3);
                            string = object == null || object.toString() == null ? "" : object.toString();
                        }
                        if (!this.trackLabel.isVisible()) {
                            this.trackLabel.setVisible(true);
                        }
                        this.trackLabel.setText(string);
                    } else {
                        CellArea cellArea = this.getRightCellArea();
                        cellArea.add((Component)this.trackLabel, 0);
                        this.table.getFocusManager().requestFocus(this.trackLabel);
                        n4 = 50;
                        n3 = 20;
                        Dimension dimension = this.table.getTrackSize();
                        if (dimension != null) {
                            n4 = dimension.width;
                            n3 = dimension.height;
                        }
                        this.trackLabel.setBounds(cellArea.getWidth() - n4, (cellArea.getHeight() - n3) / 2, n4, n3);
                        this.trackLabel.setHorizontalAlignment(4);
                        if (this.table.getTrackBackground() != null) {
                            this.trackLabel.setBackground(this.table.getTrackBackground());
                        }
                        if (this.table.getTrackForeground() != null) {
                            this.trackLabel.setForeground(this.table.getTrackForeground());
                        }
                        this.trackLabel.setText("");
                        this.isTracking = true;
                    }
                    jCScrollEvent = new JCScrollEvent(this, 2, adjustable, adjustable.getOrientation(), n, adjustmentEvent);
                    this.table.fireJCScrollEvent(jCScrollEvent);
                    return;
                }
            } else if (this.isTracking) {
                this.isTracking = false;
                this.trackLabel.setVisible(false);
                editTraverseHandler.setFocusOnEditor();
                JCScrollEvent jCScrollEvent2 = null;
                jCScrollEvent2 = new JCScrollEvent(this, 2, adjustable, adjustable.getOrientation(), n, adjustmentEvent);
                this.table.fireJCScrollEvent(jCScrollEvent2);
                this.table.layoutAreas();
            }
            if (editTraverseHandler.getCellEditor() != null) {
                editTraverseHandler.move(1, n6 + n);
            }
            if (!this.table.mouseHandler.isResizing() && (rectangle = this.table.cellAreaHandler.cellRect) != null) {
                this.table.repaint(0, rectangle.y, this.table.getSize().width, rectangle.height);
            }
        } else {
            Rectangle rectangle;
            int n8;
            int n9;
            int n10;
            Serializable serializable;
            int n11 = cellAreaHandler.getCellOrigin().x;
            int n12 = -cellAreaHandler.getCellOrigin().x;
            if (n == n12 && !this.isTracking) {
                return;
            }
            boolean bl = false;
            if ((n2 == 1 || n2 == 3) && n != this.horLastValue) {
                serializable = this;
                synchronized (serializable) {
                    n10 = cellAreaHandler.getCellArea().getStandardOffsetX();
                    n9 = this.table.getCellLayout().getColumn(n + n10, 0);
                    if (n9 == this.horLastColumn) {
                        n9 += n > this.horLastValue ? 1 : -1;
                    }
                    if (adjustable instanceof JScrollBar && ((JScrollBar)adjustable).getValueIsAdjusting() && (n > this.horLastRealValue && n9 < this.horLastColumn || n < this.horLastRealValue && n9 > this.horLastColumn)) {
                        n9 = this.horLastColumn;
                    }
                    this.horLastRealValue = n;
                    n = this.table.getCellLayout().getColumnPosition(n9) - n10;
                    if (n > (n8 = adjustable.getMaximum() - adjustable.getVisibleAmount())) {
                        n = n8;
                    }
                    this.horLastColumn = n9;
                    this.horLastValue = n;
                    if (n != this.horLastRealValue) {
                        bl = true;
                    }
                }
            }
            if (this.table.scrollListeners != null && n != n12) {
                jCScrollEvent = new JCScrollEvent(this, 1, adjustable, adjustable.getOrientation(), n, adjustmentEvent);
                this.table.fireJCScrollEvent(jCScrollEvent);
                if (jCScrollEvent.getValue() != n) {
                    adjustable.setValue(jCScrollEvent.value);
                    return;
                }
            }
            cellAreaHandler.cellOrigin.x = -n;
            if (bl) {
                adjustable.setValue(n);
            }
            if (((JScrollBar)(serializable = (JScrollBar)adjustmentEvent.getSource())).getValueIsAdjusting()) {
                if (this.table.getHorizSBTrack() != 0) {
                    if (this.isTracking) {
                        n10 = this.table.getVisibleCells().start_column;
                        String string = "";
                        if (this.table.getHorizSBTrack() == 1) {
                            string = Integer.toString(n10 + 1);
                        } else {
                            n8 = this.table.getHorizSBTrackRow();
                            n8 = n8 >= -1 ? n8 : -1;
                            Object object = this.table.getDataView().getObject(n8, n10);
                            string = object == null || object.toString() == null ? "" : object.toString();
                        }
                        if (!this.trackLabel.isVisible()) {
                            this.trackLabel.setVisible(true);
                        }
                        this.trackLabel.setText(string);
                    } else {
                        CellArea cellArea = this.getBottomCellArea();
                        cellArea.add((Component)this.trackLabel, 0);
                        this.table.getFocusManager().requestFocus(this.trackLabel);
                        n9 = 50;
                        n8 = 20;
                        Dimension dimension = this.table.getTrackSize();
                        if (dimension != null) {
                            n9 = dimension.width;
                            n8 = dimension.height;
                        }
                        this.trackLabel.setBounds((cellArea.getWidth() - n9) / 2, cellArea.getHeight() - n8, n9, n8);
                        this.trackLabel.setHorizontalAlignment(0);
                        if (this.table.getTrackBackground() != null) {
                            this.trackLabel.setBackground(this.table.getTrackBackground());
                        }
                        if (this.table.getTrackForeground() != null) {
                            this.trackLabel.setForeground(this.table.getTrackForeground());
                        }
                        this.trackLabel.setText("");
                        this.isTracking = true;
                    }
                    jCScrollEvent = new JCScrollEvent(this, 2, adjustable, adjustable.getOrientation(), n, adjustmentEvent);
                    this.table.fireJCScrollEvent(jCScrollEvent);
                    return;
                }
            } else if (this.isTracking) {
                this.isTracking = false;
                this.trackLabel.setVisible(false);
                editTraverseHandler.setFocusOnEditor();
                JCScrollEvent jCScrollEvent3 = null;
                jCScrollEvent3 = new JCScrollEvent(this, 2, adjustable, adjustable.getOrientation(), n, adjustmentEvent);
                this.table.fireJCScrollEvent(jCScrollEvent3);
                this.table.layoutAreas();
            }
            if (editTraverseHandler.getCellEditor() != null) {
                editTraverseHandler.move(0, n11 + n);
            }
            if (!this.table.mouseHandler.isResizing() && (rectangle = this.table.cellAreaHandler.cellRect) != null) {
                this.table.repaint(rectangle.x, 0, rectangle.width, this.table.getSize().height);
            }
        }
        if (this.table.scrollListeners != null && jCScrollEvent != null) {
            jCScrollEvent = new JCScrollEvent(this, 2, adjustable, adjustable.getOrientation(), n, adjustmentEvent);
            this.table.fireJCScrollEvent(jCScrollEvent);
        }
    }

    protected void adjustOrigin() {
        Point point = this.table.getCellAreaHandler().getCellOrigin();
        JScrollBar jScrollBar = this.table.getHorizSB();
        if (jScrollBar != null && jScrollBar.isVisible() && jScrollBar.getValue() != -point.x) {
            point.x = -jScrollBar.getValue();
        }
        jScrollBar = null;
        JScrollBar jScrollBar2 = this.table.getVertSB();
        if (jScrollBar2 != null & jScrollBar2.isVisible() && jScrollBar2.getValue() != -point.y) {
            point.y = -jScrollBar2.getValue();
        }
        jScrollBar2 = null;
    }

    protected CellArea getBottomCellArea() {
        if (this.table.isColumnLabelDisplay() && this.table.getColumnLabelPlacement() == 3) {
            return this.table.getCellAreaHandler().findByType(2);
        }
        if (this.table.getFrozenRows() > 0 && this.table.getFrozenRowPlacement() == 3) {
            return this.table.getCellAreaHandler().findByType(1);
        }
        return this.table.getCellAreaHandler().findByType(0);
    }

    protected CellArea getRightCellArea() {
        if (this.table.isRowLabelDisplay() && this.table.getRowLabelPlacement() == 4) {
            return this.table.getCellAreaHandler().findByType(6);
        }
        if (this.table.getFrozenColumns() > 0 && this.table.getFrozenColumnPlacement() == 4) {
            return this.table.getCellAreaHandler().findByType(3);
        }
        return this.table.getCellAreaHandler().findByType(0);
    }

    public boolean isTracking() {
        return this.isTracking;
    }

    public void dispose() {
        this.table = null;
        this.trackLabel = null;
    }
}

