/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.plaf;

import com.klg.jclass.swing.JCPopupCalendar;
import com.klg.jclass.swing.JCPopupCalendarEditor;
import com.klg.jclass.util.swing.JCPopupEvent;
import com.klg.jclass.util.swing.JCPopupListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboPopup;

public class CalendarPopup
extends BasicComboPopup
implements Serializable {
    protected JCPopupCalendarEditor popup = null;
    protected JCPopupCalendar popupCalendar;
    protected PopupListener popupListener = new PopupListener();
    protected Date originalDate = null;

    public CalendarPopup(JComboBox jComboBox, JCPopupCalendarEditor jCPopupCalendarEditor) {
        super(jComboBox);
        this.popupCalendar = (JCPopupCalendar)jComboBox;
        this.setPopupCalendarEditor(jCPopupCalendarEditor);
    }

    public void setPopupCalendarEditor(JCPopupCalendarEditor jCPopupCalendarEditor) {
        if (jCPopupCalendarEditor == null) {
            return;
        }
        if (this.popup != null) {
            this.popup.removePopupListener(this.popupListener);
            this.remove(this.popup.getEditorComponent());
        }
        this.popup = jCPopupCalendarEditor;
        this.popup.addPopupListener(this.popupListener);
        JComponent jComponent = this.popup.getEditorComponent();
        this.add(jComponent);
        this.setFocusableOnTree(jComponent, false);
    }

    protected void setFocusableOnTree(Component component, boolean bl) {
        if (component == null) {
            return;
        }
        component.setFocusable(false);
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this.setFocusableOnTree(componentArray[n], bl);
                ++n;
            }
        }
    }

    protected void configurePopup() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        this.setRequestFocusEnabled(false);
    }

    public void show() {
        if (this.popup == null || this.popup.getEditorComponent() == null) {
            return;
        }
        this.originalDate = this.popupCalendar.getValue();
        if (this.originalDate != null) {
            this.popup.setValue(this.originalDate);
        }
        JComponent jComponent = this.popup.getEditorComponent();
        Rectangle rectangle = this.computePopupBounds(0, this.popupCalendar.getBounds().height, jComponent.getWidth(), jComponent.getHeight());
        this.setLightWeightPopupEnabled(this.popupCalendar.isLightWeightPopupEnabled());
        this.show(this.popupCalendar, rectangle.x, rectangle.y);
    }

    public Date getOriginalDate() {
        return this.originalDate;
    }

    protected Rectangle computePopupBounds(int n, int n2, int n3, int n4) {
        Insets insets = this.getInsets();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        Point point = new Point(0, 0);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        SwingUtilities.convertPointFromScreen(point, this.comboBox);
        rectangle.x = point.x;
        rectangle.y = point.y;
        rectangle.width = dimension.width;
        rectangle.height = dimension.height;
        if (this.isRectangleContainingRectangle(rectangle, rectangle2)) {
            return rectangle2;
        }
        if (!this.isRectangleContainingRectangleFitRight(rectangle, rectangle2)) {
            rectangle2.x += rectangle.x + rectangle.width - (rectangle2.width + insets.left + insets.right);
        }
        if (!this.isRectangleContainingRectangleFitLeft(rectangle, rectangle2)) {
            rectangle2.x = rectangle.x;
        }
        if (!this.isRectangleContainingRectangleFitDown(rectangle, rectangle2)) {
            rectangle2.y = -(rectangle2.height + insets.top + insets.bottom);
        }
        return rectangle2;
    }

    public final boolean isRectangleContainingRectangle(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle2.x >= rectangle.x && rectangle2.x + rectangle2.width <= rectangle.x + rectangle.width && rectangle2.y >= rectangle.y && rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height;
    }

    public final boolean isRectangleContainingRectangleFitLeft(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle.x < 0;
    }

    public final boolean isRectangleContainingRectangleFitRight(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle2.x + rectangle2.width < rectangle.x + rectangle.width;
    }

    public final boolean isRectangleContainingRectangleFitDown(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle2.y >= rectangle.y && rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height;
    }

    public void hide() {
        super.hide();
        if (!this.popupListener.inCommit && this.popup != null) {
            this.popup.firePopupEvent();
        }
    }

    class PopupListener
    implements JCPopupListener,
    Serializable {
        boolean inCommit = false;

        PopupListener() {
        }

        public void commit(JCPopupEvent jCPopupEvent) {
            this.inCommit = true;
            CalendarPopup.this.hide();
            this.inCommit = false;
        }
    }
}

