/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.gauge.GaugeUtil;
import com.klg.jclass.swing.gauge.JCAbstractScale;
import com.klg.jclass.swing.gauge.JCAbstractTick;
import com.klg.jclass.swing.gauge.JCGauge;
import com.klg.jclass.swing.gauge.JCLinearScale;
import com.klg.jclass.swing.gauge.JCTickStyle;
import com.klg.jclass.swing.gauge.LinearConstraint;
import com.klg.jclass.swing.gauge.LinearLayout;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class JCLinearTick
extends JCAbstractTick {
    public JCLinearTick(JCLinearScale jCLinearScale) {
        super(jCLinearScale, jCLinearScale.getMin(), jCLinearScale.getMax());
        this.setLayout(new LinearLayout());
    }

    public JCLinearTick(JCLinearScale jCLinearScale, boolean bl, double d, double d2, double d3, boolean bl2, int n, double d4, boolean bl3, boolean bl4, double d5, double d6, double d7, Color color, JCTickStyle jCTickStyle, Font font, Color color2) {
        super(jCLinearScale, bl, d, d2, d3, bl2, n, d4, bl3, bl4, d5, d6, d7, color, jCTickStyle, font, color2);
        this.setLayout(new LinearLayout());
    }

    protected JCLinearScale getLinearScale() {
        return (JCLinearScale)this.getScale();
    }

    public Dimension getPreferredSize() {
        return this.getLinearScale().getPreferredSize();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.redrawLabels();
    }

    public void calcLinearTicks(Graphics graphics) {
        JCLinearScale jCLinearScale = this.getLinearScale();
        JCLinearScale.Orientation orientation = jCLinearScale.getOrientation();
        Rectangle rectangle = jCLinearScale.getScaleSize();
        int n = orientation == JCLinearScale.Orientation.HORIZONTAL ? rectangle.width : rectangle.height;
        this.calcTicks(graphics, n);
    }

    public void redrawLabels() {
        JCLinearScale jCLinearScale = this.getLinearScale();
        JCLinearScale.Orientation orientation = jCLinearScale.getOrientation();
        JCAbstractScale.Direction direction = jCLinearScale.getDirection();
        if (this.drawLabels) {
            Graphics graphics;
            this.removeAll();
            double d = jCLinearScale.getMin();
            double d2 = jCLinearScale.getMax();
            if (this.automatic && (graphics = this.getGraphics()) != null) {
                this.calcLinearTicks(graphics);
            }
            boolean bl = direction.equals(JCAbstractScale.Direction.BACKWARD) ^ orientation == JCLinearScale.Orientation.VERTICAL;
            double d3 = this.startValue;
            while (d3 <= this.stopValue && d3 <= d2 && this.incrementValue > 0.0) {
                if (d3 < d) {
                    d3 += this.incrementValue;
                    continue;
                }
                double d4 = bl ? d2 - d3 + d : d3;
                double d5 = 0.0;
                if (d < d2) {
                    d5 = 100.0 * ((d4 - d) / Math.abs(d2 - d));
                }
                JComponent jComponent = null;
                LinearConstraint linearConstraint = new LinearConstraint((JCGauge)jCLinearScale.getLinearGauge(), this.getLabelExtent(), d5);
                if (this.labelGenerator != null) {
                    jComponent = this.labelGenerator.makeLabel(this, d3, linearConstraint);
                } else {
                    String string = JCNumberUtil.format(d3, this.precision);
                    jComponent = new JLabel(string);
                    jComponent.setFont(this.getFont());
                    jComponent.setForeground(this.fontColor);
                }
                jComponent.setSize(jComponent.getPreferredSize());
                this.add((Component)jComponent, linearConstraint);
                d3 += this.incrementValue;
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        double d;
        double d2;
        JCLinearScale jCLinearScale = this.getLinearScale();
        JCLinearScale.Orientation orientation = jCLinearScale.getOrientation();
        JCAbstractScale.Direction direction = jCLinearScale.getDirection();
        Rectangle rectangle = jCLinearScale.getScaleSize();
        super.paintComponent(graphics);
        if (this.automatic) {
            this.calcLinearTicks(graphics);
        }
        double d3 = jCLinearScale.getMin();
        double d4 = jCLinearScale.getMax();
        if (!this.isVisible() || d3 >= d4 || this.innerExtent >= this.outerExtent || this.startValue > this.stopValue || this.incrementValue <= 0.0 || this.tickWidth <= 0.0) {
            return;
        }
        boolean bl = direction.equals(JCAbstractScale.Direction.BACKWARD) ^ orientation == JCLinearScale.Orientation.VERTICAL;
        if (orientation == JCLinearScale.Orientation.VERTICAL) {
            d2 = this.innerExtent * (double)rectangle.width;
            d = this.outerExtent * (double)rectangle.width;
        } else {
            d2 = this.innerExtent * (double)rectangle.height;
            d = this.outerExtent * (double)rectangle.height;
        }
        double d5 = this.startValue;
        while (d5 <= this.stopValue && d5 <= d4) {
            if (d5 < d3) {
                d5 += this.incrementValue;
                continue;
            }
            if (this.drawTicks) {
                if (this.tickStyle == JCTickStyle.LINE) {
                    int n;
                    int n2;
                    int n3;
                    int n4;
                    double d6 = bl ? d4 - d5 + d3 : d5;
                    int n5 = orientation == JCLinearScale.Orientation.VERTICAL ? GaugeUtil.valueToPosition(d6, d3, d4, rectangle.y, rectangle.y + rectangle.height) : GaugeUtil.valueToPosition(d6, d3, d4, rectangle.x, rectangle.x + rectangle.width);
                    if (orientation == JCLinearScale.Orientation.VERTICAL) {
                        n4 = rectangle.x + (int)d2;
                        n3 = n5;
                        n2 = rectangle.x + (int)d;
                        n = n5;
                    } else {
                        n4 = n5;
                        n3 = rectangle.y + (int)d2;
                        n2 = n5;
                        n = rectangle.y + (int)d;
                    }
                    Graphics graphics2 = graphics.create();
                    graphics2.setColor(this.tickColor);
                    graphics2.drawLine(n4, n3, n2, n);
                    graphics2.dispose();
                } else if (this.tickStyle == JCTickStyle.CIRCLE) {
                    GaugeUtil.drawCircleForLinearScale(graphics, jCLinearScale, this.tickColor, d5, this.innerExtent, this.outerExtent);
                } else {
                    GaugeUtil.drawLinearPolygon(graphics, jCLinearScale, this.tickColor, this.innerExtent, this.outerExtent, this.tickWidth, d5, this.reversed, true, this.tickStyle);
                }
            }
            d5 += this.incrementValue;
        }
    }

    public void redraw(boolean bl) {
        if (this.getLinearScale().getGauge().getRepaintEnabled()) {
            if (bl) {
                this.redrawLabels();
            }
            this.revalidate();
            this.repaint();
        }
    }
}

