/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.gauge.GaugeUtil;
import com.klg.jclass.swing.gauge.JCAbstractRange;
import com.klg.jclass.swing.gauge.JCAbstractScale;
import com.klg.jclass.swing.gauge.JCLinearScale;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JLabel;

public class JCLinearRange
extends JCAbstractRange {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    protected Image foregroundImage;
    protected Image backgroundImage;
    protected double foregroundCoverage = 0.0;
    protected int maskOrientation = 0;

    public JCLinearRange(Color color, JCLinearScale jCLinearScale, double d, double d2, double d3, double d4) {
        super(color, jCLinearScale, d, d2, d3, d4);
    }

    protected JCLinearScale getLinearScale() {
        return (JCLinearScale)this.getScale();
    }

    public Dimension getPreferredSize() {
        return this.getLinearScale().getPreferredSize();
    }

    public Rectangle getLinearRangeSize(JCLinearScale jCLinearScale, Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        int n4;
        JCLinearScale.Orientation orientation = jCLinearScale.getOrientation();
        JCAbstractScale.Direction direction = jCLinearScale.getDirection();
        double d = jCLinearScale.getMin();
        double d2 = jCLinearScale.getMax();
        double d3 = GaugeUtil.clamp(this.startValue, d, d2);
        double d4 = GaugeUtil.clamp(this.stopValue, d, d2);
        if (direction.equals(JCAbstractScale.Direction.BACKWARD) ^ orientation == JCLinearScale.Orientation.VERTICAL) {
            d4 = d2 - d4 + d;
            d3 = d2 - d3 + d;
        }
        if (this.backgroundImage != null || this.foregroundImage != null) {
            if (this.innerExtent > 1.0) {
                this.innerExtent = 1.0;
            }
            if (this.outerExtent > 1.0) {
                this.outerExtent = 1.0;
            }
        }
        if (orientation == JCLinearScale.Orientation.VERTICAL) {
            n4 = GaugeUtil.valueToPosition(d3, d, d2, rectangle.y, rectangle.y + rectangle.height);
            int n5 = GaugeUtil.valueToPosition(d4, d, d2, rectangle.y, rectangle.y + rectangle.height);
            n3 = n5 - n4;
            n2 = rectangle.x + (int)((double)rectangle.width * this.innerExtent);
            int n6 = rectangle.x + (int)((double)rectangle.width * this.outerExtent);
            n = n6 - n2;
            if (direction.equals(JCAbstractScale.Direction.FORWARD)) {
                n4 = n5;
                n3 = -n3;
            }
        } else {
            n2 = GaugeUtil.valueToPosition(d3, d, d2, rectangle.x, rectangle.x + rectangle.width);
            int n7 = GaugeUtil.valueToPosition(d4, d, d2, rectangle.x, rectangle.x + rectangle.width);
            n = n7 - n2;
            n4 = rectangle.y + (int)((double)rectangle.height * this.innerExtent);
            int n8 = rectangle.y + (int)((double)rectangle.height * this.outerExtent);
            n3 = n8 - n4;
            if (direction.equals(JCAbstractScale.Direction.BACKWARD)) {
                n2 = n7;
                n = -n;
            }
        }
        return new Rectangle(n2, n4, n, n3);
    }

    public void paintComponent(Graphics graphics) {
        JCLinearScale jCLinearScale = this.getLinearScale();
        double d = jCLinearScale.getMin();
        double d2 = jCLinearScale.getMax();
        double d3 = GaugeUtil.clamp(this.startValue, d, d2);
        double d4 = GaugeUtil.clamp(this.stopValue, d, d2);
        if (!this.isVisible() || d >= d2 || this.innerExtent >= this.outerExtent || d3 >= d4) {
            return;
        }
        Rectangle rectangle = this.getLinearRangeSize(jCLinearScale, jCLinearScale.getScaleSize());
        Graphics graphics2 = graphics.create();
        if (this.backgroundImage != null || this.foregroundImage != null) {
            this.drawImage(graphics2, rectangle);
        } else {
            graphics2.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics2.dispose();
    }

    public void redraw() {
        if (super.getScale().getGauge().getRepaintEnabled()) {
            this.repaint();
        }
    }

    public void setImage(Image image) {
        this.image = image;
        this.backgroundImage = image;
        this.foregroundImage = null;
        this.redraw();
    }

    public void setForegroundImage(Image image) {
        this.foregroundImage = image;
        this.redraw();
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
        this.image = image;
        this.redraw();
    }

    public Image getImage() {
        return this.backgroundImage;
    }

    public Image getForegroundImage() {
        return this.foregroundImage;
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setForegroundCoverage(double d) {
        this.foregroundCoverage = d;
        if (this.foregroundCoverage < 0.0) {
            this.foregroundCoverage = 0.0;
        }
        if (this.foregroundCoverage > 1.0) {
            this.foregroundCoverage = 1.0;
        }
        if (this.foregroundImage != null && this.backgroundImage != null) {
            this.redraw();
        }
    }

    public double getForegroundCoverage() {
        return this.foregroundCoverage;
    }

    public void setMaskOrientation(int n) {
        if (n != 0 && n != 1) {
            return;
        }
        this.maskOrientation = n;
        if (this.foregroundImage != null && this.backgroundImage != null) {
            this.redraw();
        }
    }

    public int getMaskOrientation() {
        return this.maskOrientation;
    }

    protected void drawImage(Graphics graphics, Rectangle rectangle) {
        JLabel jLabel = new JLabel();
        if (this.backgroundImage != null && this.foregroundImage != null) {
            if (this.scaleImage) {
                graphics.drawImage(this.backgroundImage, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.getForeground(), jLabel);
                Rectangle rectangle2 = (Rectangle)graphics.getClip();
                Rectangle rectangle3 = null;
                switch (this.maskOrientation) {
                    case 0: {
                        rectangle3 = new Rectangle(rectangle.x, rectangle.y, (int)((double)rectangle.width * this.foregroundCoverage), rectangle.height);
                        break;
                    }
                    case 1: {
                        rectangle3 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, (int)((double)rectangle.height * this.foregroundCoverage));
                    }
                }
                graphics.setClip(rectangle3);
                graphics.drawImage(this.foregroundImage, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.getForeground(), jLabel);
                graphics.setClip(rectangle2);
            } else {
                graphics.drawImage(this.foregroundImage, rectangle.x, rectangle.y, this.getForeground(), jLabel);
            }
            return;
        }
        if (this.backgroundImage != null) {
            this.image = this.backgroundImage;
        } else if (this.foregroundImage != null) {
            this.image = this.foregroundImage;
        }
        if (this.scaleImage) {
            graphics.drawImage(this.image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.getForeground(), jLabel);
        } else {
            graphics.drawImage(this.image, rectangle.x, rectangle.y, this.getForeground(), jLabel);
        }
    }
}

