/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.gauge.GaugeUtil;
import com.klg.jclass.swing.gauge.JCAbstractScale;
import com.klg.jclass.swing.gauge.JCAbstractTick;
import com.klg.jclass.swing.gauge.JCCircularScale;
import com.klg.jclass.swing.gauge.JCTickStyle;
import com.klg.jclass.swing.gauge.RadialConstraint;
import com.klg.jclass.swing.gauge.RadialLayout;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class JCCircularTick
extends JCAbstractTick
implements Serializable {
    static final long serialVersionUID = -5247737898082678005L;

    public JCCircularTick(JCCircularScale jCCircularScale) {
        super(jCCircularScale, jCCircularScale.getMin(), jCCircularScale.getMax());
        this.setLayout(new RadialLayout());
    }

    public JCCircularTick(JCCircularScale jCCircularScale, boolean bl, double d, double d2, double d3, boolean bl2, int n, double d4, boolean bl3, boolean bl4, double d5, double d6, double d7, Color color, JCTickStyle jCTickStyle, Font font, Color color2) {
        super(jCCircularScale, bl, d, d2, d3, bl2, n, d4, bl3, bl4, d5, d6, d7, color, jCTickStyle, font, color2);
        this.setLayout(new RadialLayout());
    }

    public JCCircularScale getCircularScale() {
        return (JCCircularScale)this.getScale();
    }

    public Dimension getPreferredSize() {
        return this.getCircularScale().getPreferredSize();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.redrawLabels();
    }

    public void calcCircularTicks(Graphics graphics) {
        JCCircularScale jCCircularScale = this.getCircularScale();
        double d = GaugeUtil.normalizeAngle(jCCircularScale.getStartAngle());
        double d2 = GaugeUtil.normalizeAngle(jCCircularScale.getStopAngle());
        double d3 = jCCircularScale.getRadius();
        if (d >= d2) {
            d2 += 360.0;
        }
        double d4 = d2 == d ? 360.0 : Math.abs(d2 - d);
        int n = (int)(GaugeUtil.toRadians(d4) * d3);
        this.calcTicks(graphics, n);
    }

    public void redrawLabels() {
        JCCircularScale jCCircularScale = this.getCircularScale();
        JCAbstractScale.Direction direction = jCCircularScale.getDirection();
        if (this.drawLabels) {
            Graphics graphics;
            boolean bl;
            this.removeAll();
            double d = jCCircularScale.getMin();
            double d2 = jCCircularScale.getMax();
            double d3 = GaugeUtil.normalizeAngle(jCCircularScale.getStartAngle());
            double d4 = GaugeUtil.normalizeAngle(jCCircularScale.getStopAngle());
            if (d3 >= d4) {
                d4 += 360.0;
            }
            boolean bl2 = bl = d3 == d4;
            if (this.automatic && (graphics = this.getGraphics()) != null) {
                this.calcCircularTicks(graphics);
            }
            double d5 = Math.max(0.0, this.labelExtent);
            double d6 = this.startValue;
            while (d6 <= this.stopValue && d6 <= d2 && this.incrementValue != 0.0) {
                if (d6 < d) {
                    d6 += this.incrementValue;
                    continue;
                }
                if (bl && this.automatic && (d6 == this.stopValue || 1.0 + Math.abs(this.stopValue - d6) == 1.0)) break;
                double d7 = d6;
                if (direction.equals(JCAbstractScale.Direction.BACKWARD)) {
                    d7 = d2 - d6 + d;
                }
                double d8 = GaugeUtil.valueToAngle(d7, d, d2, 0.0, GaugeUtil.arcAngle(d3, d4));
                JComponent jComponent = null;
                RadialConstraint radialConstraint = new RadialConstraint(jCCircularScale.getCircularGauge(), d5, d8);
                if (this.labelGenerator != null) {
                    jComponent = this.labelGenerator.makeLabel(this, d6, radialConstraint);
                } else {
                    String string = JCNumberUtil.format(d6, this.precision);
                    jComponent = new JLabel(string);
                    jComponent.setFont(this.getFont());
                    jComponent.setForeground(this.fontColor);
                }
                jComponent.setSize(jComponent.getPreferredSize());
                this.add((Component)jComponent, radialConstraint);
                d6 += this.incrementValue;
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        boolean bl = false;
        JCCircularScale jCCircularScale = this.getCircularScale();
        JCAbstractScale.Direction direction = jCCircularScale.getDirection();
        Rectangle rectangle = jCCircularScale.getCircularGauge().getArcBounds();
        super.paintComponent(graphics);
        if (this.automatic) {
            this.calcCircularTicks(graphics);
        }
        double d = jCCircularScale.getMin();
        double d2 = jCCircularScale.getMax();
        double d3 = Math.max(0.0, this.innerExtent);
        double d4 = Math.max(0.0, this.outerExtent);
        if (!this.isVisible() || d >= d2 || d3 >= d4 || this.startValue > this.stopValue || this.incrementValue <= 0.0 || this.tickWidth <= 0.0) {
            return;
        }
        double d5 = jCCircularScale.getRadius();
        double d6 = (double)rectangle.x + d5;
        double d7 = (double)rectangle.y + d5;
        double d8 = GaugeUtil.normalizeAngle(jCCircularScale.getStartAngle());
        double d9 = GaugeUtil.normalizeAngle(jCCircularScale.getStopAngle());
        double d10 = d3 * d5;
        double d11 = d4 * d5;
        double d12 = this.startValue;
        while (d12 <= this.stopValue && d12 <= d2) {
            if (d12 < d) {
                d12 += this.incrementValue;
                continue;
            }
            if (bl && this.automatic && (d12 == this.stopValue || 1.0 + Math.abs(this.stopValue - d12) == 1.0)) break;
            if (this.drawTicks) {
                if (this.tickStyle == JCTickStyle.LINE) {
                    double d13 = d12;
                    if (direction.equals(JCAbstractScale.Direction.BACKWARD)) {
                        d13 = d2 - d12 + d;
                    }
                    double d14 = GaugeUtil.valueToAngle(d13, d, d2, d8, d9);
                    double d15 = GaugeUtil.toRadians(d14);
                    double d16 = Math.cos(d15);
                    double d17 = Math.sin(d15);
                    Graphics graphics2 = graphics.create();
                    graphics2.setColor(this.tickColor);
                    int n = (int)d6 + (int)(d10 * d16);
                    int n2 = (int)d7 - (int)(d10 * d17);
                    int n3 = (int)d6 + (int)(d11 * d16);
                    int n4 = (int)d7 - (int)(d11 * d17);
                    graphics2.drawLine(n, n2, n3, n4);
                    graphics2.dispose();
                } else if (this.tickStyle == JCTickStyle.CIRCLE) {
                    GaugeUtil.drawCircleForCircularScale(graphics, jCCircularScale, this.tickColor, d12, d3, d4);
                } else {
                    GaugeUtil.drawCircularPolygon(graphics, jCCircularScale, this.tickColor, d3, d4, this.tickWidth, d12, this.reversed, true, this.tickStyle);
                }
            }
            d12 += this.incrementValue;
        }
    }

    public void redraw(boolean bl) {
        if (this.getCircularScale().getGauge().getRepaintEnabled()) {
            if (bl) {
                this.redrawLabels();
            }
            this.revalidate();
            this.repaint();
        }
    }
}

