/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.gauge.GaugeUtil;
import com.klg.jclass.swing.gauge.JCAbstractRange;
import com.klg.jclass.swing.gauge.JCAbstractScale;
import com.klg.jclass.swing.gauge.JCCircularScale;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import javax.swing.JLabel;

public class JCCircularRange
extends JCAbstractRange
implements Serializable {
    static final long serialVersionUID = -3498488049576531605L;
    protected int innerArcStartCompensator = 0;
    protected int innerArcStopCompensator = 0;

    public JCCircularRange(Color color, JCCircularScale jCCircularScale, double d, double d2, double d3, double d4) {
        super(color, jCCircularScale, d, d2, d3, d4);
    }

    public JCCircularScale getCircularScale() {
        return (JCCircularScale)this.getScale();
    }

    public Dimension getPreferredSize() {
        return this.getCircularScale().getPreferredSize();
    }

    public int getInnerArcStartCompensator() {
        return this.innerArcStartCompensator;
    }

    public void setInnerArcStartCompensator(int n) {
        this.innerArcStartCompensator = n;
        this.redraw();
    }

    public int getInnerArcStopCompensator() {
        return this.innerArcStopCompensator;
    }

    public void setInnerArcStopCompensator(int n) {
        this.innerArcStopCompensator = n;
        this.redraw();
    }

    public void paintComponent(Graphics graphics) {
        double d;
        JCCircularScale jCCircularScale = this.getCircularScale();
        double d2 = jCCircularScale.getMin();
        double d3 = jCCircularScale.getMax();
        double d4 = jCCircularScale.getRadius();
        double d5 = GaugeUtil.normalizeAngle(jCCircularScale.getStartAngle());
        double d6 = GaugeUtil.normalizeAngle(jCCircularScale.getStopAngle());
        double d7 = GaugeUtil.clamp(this.startValue, d2, d3);
        double d8 = GaugeUtil.clamp(this.stopValue, d2, d3);
        if (!this.isVisible() || d2 >= d3 || this.innerExtent >= this.outerExtent || d7 >= d8) {
            return;
        }
        if (jCCircularScale.getDirection().equals(JCAbstractScale.Direction.BACKWARD)) {
            d = d7;
            d7 = d8;
            d8 = d;
            d8 = d3 - d8 + d2;
            d7 = d3 - d7 + d2;
        }
        d = GaugeUtil.valueToAngle(d7, d2, d3, d5, d6);
        double d9 = GaugeUtil.valueToAngle(d8, d2, d3, d5, d6);
        double d10 = this.innerExtent * d4;
        double d11 = this.outerExtent * d4;
        if (d >= d9) {
            d9 += 360.0;
        }
        double d12 = d9 - d;
        Graphics graphics2 = graphics.create();
        Rectangle rectangle = jCCircularScale.getCircularGauge().getArcBounds();
        double d13 = (double)rectangle.x + d4;
        double d14 = (double)rectangle.y + d4;
        int n = (int)(d13 - d11);
        int n2 = (int)(d14 - d11);
        int n3 = (int)(2.0 * d11);
        int n4 = (int)(2.0 * d11);
        int n5 = (int)(d13 - d10);
        int n6 = (int)(d14 - d10);
        int n7 = (int)(2.0 * d10);
        Graphics2D graphics2D = (Graphics2D)graphics2;
        if (this.image != null) {
            if (this.scaleImage) {
                Shape shape = graphics2D.getClip();
                Polygon polygon = this.getCircularRangeShape(d, d9, d4, d10, d11);
                graphics2D.setClip(polygon);
                this.drawImage(graphics2D, this.image, rectangle);
                graphics2D.setClip(shape);
            } else {
                this.drawImage(graphics2D, this.image, rectangle);
            }
        } else {
            int n8 = Math.abs(n2 - n6);
            graphics2D.setStroke(new BasicStroke(n8));
            GeneralPath generalPath = this.traceArcPath(d13 * 2.0 - d13, d14, n3 / 2, n4 / 2, -d, -d12);
            generalPath.lineTo((int)(d13 * 2.0 - d13), (int)d14);
            generalPath.closePath();
            graphics2D.clip(generalPath);
            graphics2D.draw(new Arc2D.Double(n + (n5 - n) / 2, n2 + (n6 - n2) / 2, n4 - (n4 - n7) / 2, n4 - (n4 - n7) / 2, d, d9 - d, 0));
        }
        graphics2.dispose();
    }

    public void redraw() {
        if (this.getCircularScale().getGauge().getRepaintEnabled()) {
            this.repaint();
        }
    }

    private GeneralPath traceArcPath(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        double d9;
        GeneralPath generalPath = new GeneralPath();
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = d6 < 0.0 ? (d5 + d6) / 180.0 * Math.PI : d5 / 180.0 * Math.PI;
        d10 = d + d3 * Math.cos(d18);
        d14 = d2 + d4 * Math.sin(d18);
        generalPath.moveTo((float)d10, (float)d14);
        if (Math.abs(d6) < 0.001) {
            d18 = (d5 + d6) / 180.0 * Math.PI;
            d10 = d + d3 * Math.cos(d18);
            d14 = d2 + d4 * Math.sin(d18);
        }
        if (d6 < 0.0) {
            d5 += d6;
            d6 = -d6;
        }
        double d19 = 0.5522848 * d3;
        double d20 = 0.5522848 * d4;
        d18 = d5 / 180.0 * Math.PI;
        d10 = d + d3 * Math.cos(d18);
        d14 = d2 + d4 * Math.sin(d18);
        double d21 = (int)d5 / 90 * 90;
        if (Math.abs(d21 - d5) > 0.001) {
            if (d5 > 0.0) {
                d21 += 90.0;
            }
            if ((d9 = d5 + d6) > d21) {
                d9 = d21;
            }
            d18 = d9 / 180.0 * Math.PI;
            d13 = d + d3 * Math.cos(d18);
            d17 = d2 + d4 * Math.sin(d18);
            d8 = d9 - d5;
            d7 = this.computeControlPointFactor(d8);
            d11 = d10 - d7 * (d14 - d2);
            d15 = d14 + d7 * (d10 - d);
            d12 = d13 + d7 * (d17 - d2);
            d16 = d17 - d7 * (d13 - d);
            generalPath.curveTo((float)d11, (float)d15, (float)d12, (float)d16, (float)d13, (float)d17);
            d10 = d13;
            d14 = d17;
        }
        d9 = d5 + d6;
        while (d21 + 90.0 <= d9) {
            int n = (int)d21 % 360;
            if (n == 0) {
                d11 = 0.0;
                d15 = d20;
                d12 = d19;
                d16 = 0.0;
            } else if (n == 90 || n == -270) {
                d11 = -d19;
                d15 = 0.0;
                d12 = 0.0;
                d16 = d20;
            } else if (n == 180 || n == -180) {
                d11 = 0.0;
                d15 = -d20;
                d12 = -d19;
                d16 = 0.0;
            } else if (n == 270 || n == -90) {
                d11 = d19;
                d15 = 0.0;
                d12 = 0.0;
                d16 = -d20;
            }
            d18 = (d21 += 90.0) / 180.0 * Math.PI;
            d13 = d + d3 * Math.cos(d18);
            d17 = d2 + d4 * Math.sin(d18);
            generalPath.curveTo((float)(d11 += d10), (float)(d15 += d14), (float)(d12 += d13), (float)(d16 += d17), (float)d13, (float)d17);
            d10 = d13;
            d14 = d17;
        }
        if (d21 < d9 && Math.abs(d21 - d9) > 0.001) {
            d18 = d9 / 180.0 * Math.PI;
            d13 = d + d3 * Math.cos(d18);
            d17 = d2 + d4 * Math.sin(d18);
            d8 = d9 - d21;
            d7 = this.computeControlPointFactor(d8);
            d11 = d10 - d7 * (d14 - d2);
            d15 = d14 + d7 * (d10 - d);
            d12 = d13 + d7 * (d17 - d2);
            d16 = d17 - d7 * (d13 - d);
            generalPath.curveTo((float)d11, (float)d15, (float)d12, (float)d16, (float)d13, (float)d17);
            d10 = d13;
            d14 = d17;
        }
        return generalPath;
    }

    private double computeControlPointFactor(double d) {
        double d2 = d / 2.0 / 180.0 * Math.PI;
        double d3 = 1.3333333333333333 * (1.0 - Math.cos(d2)) / Math.sin(d2);
        return d3;
    }

    protected Polygon getCircularRangeShape(double d, double d2, double d3, double d4, double d5) {
        int n;
        int n2;
        Polygon polygon = new Polygon();
        double d6 = 2.0;
        double d7 = d;
        while (d7 < d2) {
            polygon.addPoint((int)d4, (int)d7);
            d7 += d6;
        }
        polygon.addPoint((int)d4, (int)d2);
        Polygon polygon2 = new Polygon();
        d7 = d2;
        while (d7 > d) {
            polygon2.addPoint((int)d5, (int)d7);
            d7 -= d6;
        }
        polygon2.addPoint((int)d5, (int)d);
        JCCircularScale jCCircularScale = this.getCircularScale();
        Rectangle rectangle = jCCircularScale.getCircularGauge().getArcBounds();
        double d8 = (double)rectangle.x + d3;
        double d9 = (double)rectangle.y + d3;
        Polygon polygon3 = new Polygon();
        int n3 = 0;
        while (n3 < polygon.npoints) {
            double d10 = GaugeUtil.toRadians(polygon.ypoints[n3]);
            n2 = (int)(d8 + (double)polygon.xpoints[n3] * Math.cos(d10));
            n = (int)(d9 - (double)polygon.xpoints[n3] * Math.sin(d10));
            polygon3.addPoint(n2, n);
            ++n3;
        }
        int n4 = 0;
        while (n4 < polygon2.npoints) {
            double d11 = GaugeUtil.toRadians(polygon2.ypoints[n4]);
            n2 = (int)(d8 + (double)polygon2.xpoints[n4] * Math.cos(d11));
            n = (int)(d9 - (double)polygon2.xpoints[n4] * Math.sin(d11));
            polygon3.addPoint(n2, n);
            ++n4;
        }
        return polygon3;
    }

    protected void drawImage(Graphics graphics, Image image, Rectangle rectangle) {
        JLabel jLabel = new JLabel();
        if (super.getScaleImage()) {
            graphics.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.getForeground(), jLabel);
        } else {
            graphics.drawImage(image, rectangle.x, rectangle.y, this.getForeground(), jLabel);
        }
    }
}

