/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.gauge.GaugeUtil;
import com.klg.jclass.swing.gauge.JCAbstractNeedle;
import com.klg.jclass.swing.gauge.JCCenter;
import com.klg.jclass.swing.gauge.JCCircularNeedle;
import com.klg.jclass.swing.gauge.JCCircularScale;
import com.klg.jclass.swing.gauge.JCCircularTick;
import com.klg.jclass.swing.gauge.JCGauge;
import com.klg.jclass.swing.gauge.JCGaugePickEvent;
import com.klg.jclass.swing.gauge.RadialConstraint;
import com.klg.jclass.util.ServerRenderable;
import com.klg.jclass.util.ServerRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class JCCircularGauge
extends JCGauge
implements Serializable,
ServerRenderable {
    static final long serialVersionUID = -5471322510947631802L;
    protected GaugeType gaugeType = GaugeType.FULL_CIRCLE;
    protected JCCenter center;
    protected Vector labels = new Vector();
    private Graphics prevSetGraphics = null;

    public JCCircularGauge() {
        JCCircularScale jCCircularScale = new JCCircularScale(this);
        this.setScale(jCCircularScale, false);
        JCCenter jCCenter = new JCCenter(jCCircularScale);
        this.setCenter(jCCenter);
        JCCircularNeedle jCCircularNeedle = new JCCircularNeedle(jCCircularScale);
        this.addNeedle(jCCircularNeedle);
        JCCircularTick jCCircularTick = new JCCircularTick(jCCircularScale);
        this.addTick(jCCircularTick);
        this.gaugeArea.add(jCCircularScale);
        this.setPreferredSize(new Dimension(75, 75));
    }

    public JCCircularGauge(boolean bl) {
        if (bl) {
            JCCircularScale jCCircularScale = new JCCircularScale(this);
            this.setScale(jCCircularScale);
        }
    }

    public JCCircularGauge(GaugeType gaugeType) {
        this.gaugeType = gaugeType;
    }

    public void paintComponent(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (this.image != null) {
            this.drawImage(graphics, this.image, this.getBounds(), this.getBackground());
        }
        this.gaugeArea.doLayout();
        super.paintComponent(graphics);
    }

    public JCCircularScale getCircularScale() {
        return (JCCircularScale)this.getScale();
    }

    public void setScale(JCCircularScale jCCircularScale, boolean bl) {
        if (this.scale != null) {
            this.gaugeArea.remove((Component)((Object)this.scale));
        }
        this.scale = jCCircularScale;
        if (bl) {
            this.gaugeArea.add(jCCircularScale);
        }
        this.setIndicatorScales(jCCircularScale);
        this.setNeedleScales(jCCircularScale);
    }

    public void setScale(JCCircularScale jCCircularScale) {
        this.setScale(jCCircularScale, true);
    }

    public void addLabel(JComponent jComponent, RadialConstraint radialConstraint) {
        this.labels.addElement(jComponent);
        this.getGaugeArea().add(jComponent, radialConstraint, 0);
    }

    public void addLabel(JComponent jComponent, RadialConstraint radialConstraint, int n) {
        this.labels.addElement(jComponent);
        this.getGaugeArea().add(jComponent, radialConstraint, n);
    }

    public void removeLabel(JComponent jComponent) {
        if (this.labels.contains(jComponent)) {
            this.labels.removeElement(jComponent);
            this.getGaugeArea().remove(jComponent);
        }
    }

    public JCCenter getCenter() {
        return this.center;
    }

    public void setCenter(JCCenter jCCenter, int n) {
        if (this.center != null) {
            this.gaugeArea.remove(this.center);
        }
        this.center = jCCenter;
        if (jCCenter != null) {
            this.getGaugeArea().add(jCCenter, new RadialConstraint(this, 0.0, 0.0), n);
        }
    }

    public void setCenter(JCCenter jCCenter) {
        this.setCenter(jCCenter, 0);
    }

    public GaugeType getGaugeType() {
        return this.gaugeType;
    }

    public void setGaugeType(GaugeType gaugeType) {
        JCCircularScale jCCircularScale;
        this.gaugeType = gaugeType;
        if (this.gaugeArea != null) {
            this.gaugeArea.doLayout();
        }
        if ((jCCircularScale = this.getCircularScale()) != null) {
            if (gaugeType == GaugeType.FULL_CIRCLE) {
                jCCircularScale.setStartAngle(0.0);
                jCCircularScale.setStopAngle(360.0);
            } else if (gaugeType == GaugeType.TOP_HALF_CIRCLE) {
                jCCircularScale.setStartAngle(0.0);
                jCCircularScale.setStopAngle(180.0);
            } else if (gaugeType == GaugeType.BOTTOM_HALF_CIRCLE) {
                jCCircularScale.setStartAngle(180.0);
                jCCircularScale.setStopAngle(360.0);
            } else if (gaugeType == GaugeType.LEFT_HALF_CIRCLE) {
                jCCircularScale.setStartAngle(90.0);
                jCCircularScale.setStopAngle(270.0);
            } else if (gaugeType == GaugeType.RIGHT_HALF_CIRCLE) {
                jCCircularScale.setStartAngle(270.0);
                jCCircularScale.setStopAngle(90.0);
            } else if (gaugeType == GaugeType.LOWER_LEFT_QUARTER_CIRCLE) {
                jCCircularScale.setStartAngle(180.0);
                jCCircularScale.setStopAngle(270.0);
            } else if (gaugeType == GaugeType.LOWER_RIGHT_QUARTER_CIRCLE) {
                jCCircularScale.setStartAngle(270.0);
                jCCircularScale.setStopAngle(360.0);
            } else if (gaugeType == GaugeType.UPPER_RIGHT_QUARTER_CIRCLE) {
                jCCircularScale.setStartAngle(0.0);
                jCCircularScale.setStopAngle(90.0);
            } else if (gaugeType == GaugeType.UPPER_LEFT_QUARTER_CIRCLE) {
                jCCircularScale.setStartAngle(90.0);
                jCCircularScale.setStopAngle(180.0);
            }
            jCCircularScale.doLayout();
            int n = 0;
            while (n < jCCircularScale.getTicks().size()) {
                JCCircularTick jCCircularTick = (JCCircularTick)jCCircularScale.getTicks().elementAt(n);
                jCCircularTick.doLayout();
                ++n;
            }
        }
        this.redraw();
    }

    public Rectangle getArcBounds() {
        Rectangle rectangle = null;
        JCCircularScale jCCircularScale = this.getCircularScale();
        int n = (int)jCCircularScale.getRadius();
        int n2 = (int)(jCCircularScale.getRadius() * 2.0);
        Insets insets = jCCircularScale.getScaleInsets();
        int n3 = insets.left;
        int n4 = insets.top;
        int n5 = this.gaugeArea.getBounds().width;
        int n6 = this.gaugeArea.getBounds().height;
        Rectangle rectangle2 = new Rectangle(n3, n4, n5 -= insets.left + insets.right, n6 -= insets.top + insets.bottom);
        if (this.gaugeType.equals(GaugeType.FULL_CIRCLE)) {
            rectangle = new Rectangle(n3 + (rectangle2.width - n2) / 2, n4 + (rectangle2.height - n2) / 2, n2, n2);
        } else if (this.gaugeType.equals(GaugeType.TOP_HALF_CIRCLE)) {
            rectangle = new Rectangle(n3 + (rectangle2.width - n2) / 2, n4, n2, n2);
        } else if (this.gaugeType.equals(GaugeType.BOTTOM_HALF_CIRCLE)) {
            rectangle = new Rectangle(n3 + (rectangle2.width - n2) / 2, -(n - n4), n2, n2);
        } else if (this.gaugeType.equals(GaugeType.LEFT_HALF_CIRCLE)) {
            rectangle = new Rectangle(n3, n4 + (rectangle2.height - n2) / 2, n2, n2);
        } else if (this.gaugeType.equals(GaugeType.RIGHT_HALF_CIRCLE)) {
            rectangle = new Rectangle(-(n - n3), n4 + (rectangle2.height - n2) / 2, n2, n2);
        } else if (this.gaugeType.equals(GaugeType.LOWER_LEFT_QUARTER_CIRCLE)) {
            rectangle = new Rectangle(n3, -(n - n4), n2, n2);
        } else if (this.gaugeType.equals(GaugeType.LOWER_RIGHT_QUARTER_CIRCLE)) {
            rectangle = new Rectangle(-(n - n3), -(n - n4), n2, n2);
        } else if (this.gaugeType.equals(GaugeType.UPPER_RIGHT_QUARTER_CIRCLE)) {
            rectangle = new Rectangle(-(n - n3), n4, n2, n2);
        } else if (this.gaugeType.equals(GaugeType.UPPER_LEFT_QUARTER_CIRCLE)) {
            rectangle = new Rectangle(n3, n4, n2, n2);
        }
        return rectangle;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        JCCircularNeedle jCCircularNeedle;
        super.mouseClicked(mouseEvent);
        JCGaugePickEvent jCGaugePickEvent = this.pick(mouseEvent.getPoint());
        if (jCGaugePickEvent != null && (jCCircularNeedle = this.getClosestNeedle(jCGaugePickEvent, JCAbstractNeedle.InteractionType.CLICK)) != null) {
            jCCircularNeedle.setValue(jCGaugePickEvent.getValue());
            this.redraw();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        JCGaugePickEvent jCGaugePickEvent = this.pick(mouseEvent.getPoint());
        if (jCGaugePickEvent != null) {
            if (this.draggedNeedle == null) {
                this.draggedNeedle = this.getClosestNeedle(jCGaugePickEvent, JCAbstractNeedle.InteractionType.DRAG);
            }
            if (this.draggedNeedle != null) {
                this.draggedNeedle.setValue(jCGaugePickEvent.getValue());
                this.redraw();
            }
        }
    }

    public JCCircularNeedle getClosestNeedle(JCGaugePickEvent jCGaugePickEvent, JCAbstractNeedle.InteractionType interactionType) {
        JCCircularNeedle jCCircularNeedle = null;
        double d = this.valueToAngle(jCGaugePickEvent.getValue());
        Enumeration enumeration = this.needles.elements();
        while (enumeration.hasMoreElements()) {
            JCCircularNeedle jCCircularNeedle2 = (JCCircularNeedle)enumeration.nextElement();
            JCAbstractNeedle.InteractionType interactionType2 = jCCircularNeedle2.getInteractionType();
            if (interactionType2 != JCAbstractNeedle.InteractionType.CLICK_DRAG && interactionType2 != interactionType) continue;
            if (jCCircularNeedle == null) {
                jCCircularNeedle = jCCircularNeedle2;
                continue;
            }
            double d2 = this.valueToAngle(jCCircularNeedle2.getValue());
            double d3 = this.valueToAngle(jCCircularNeedle.getValue());
            double d4 = GaugeUtil.distanceBetweenAngles(d, d2);
            double d5 = GaugeUtil.distanceBetweenAngles(d, d3);
            if (!(d5 > d4)) continue;
            jCCircularNeedle = jCCircularNeedle2;
        }
        return jCCircularNeedle;
    }

    protected double valueToAngle(double d) {
        JCCircularScale jCCircularScale = this.getCircularScale();
        return GaugeUtil.valueToAngle(d, jCCircularScale.getMin(), jCCircularScale.getMax(), jCCircularScale.getStartAngle(), jCCircularScale.getStopAngle());
    }

    public void redraw() {
        if (this.getRepaintEnabled()) {
            this.repaint();
        }
    }

    protected void drawImage(Graphics graphics, Image image, Rectangle rectangle, Color color) {
        JLabel jLabel = new JLabel();
        if (super.getScaleImage()) {
            graphics.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, color, jLabel);
        } else {
            graphics.drawImage(image, rectangle.x, rectangle.y, color, jLabel);
        }
    }

    public Graphics getGraphics() {
        if (this.prevSetGraphics == null) {
            return super.getGraphics();
        }
        return this.prevSetGraphics;
    }

    public void setGraphics(Graphics graphics) {
        this.prevSetGraphics = graphics;
        this.getLegend().setGraphics(graphics);
    }

    public Image serverSnapshot() {
        return ServerRenderer.snapshot(this);
    }

    public void serverPaint(Graphics graphics) {
        ServerRenderer.paintContainer(graphics, this);
    }

    public static class GaugeType
    implements Serializable {
        public static final GaugeType FULL_CIRCLE = new GaugeType(0, 360);
        public static final GaugeType TOP_HALF_CIRCLE = new GaugeType(0, 180);
        public static final GaugeType BOTTOM_HALF_CIRCLE = new GaugeType(180, 180);
        public static final GaugeType LEFT_HALF_CIRCLE = new GaugeType(90, 180);
        public static final GaugeType RIGHT_HALF_CIRCLE = new GaugeType(270, 180);
        public static final GaugeType UPPER_RIGHT_QUARTER_CIRCLE = new GaugeType(0, 90);
        public static final GaugeType LOWER_RIGHT_QUARTER_CIRCLE = new GaugeType(270, 90);
        public static final GaugeType UPPER_LEFT_QUARTER_CIRCLE = new GaugeType(90, 90);
        public static final GaugeType LOWER_LEFT_QUARTER_CIRCLE = new GaugeType(180, 90);
        int startAngle;
        int sweepAngle;

        private GaugeType(int n, int n2) {
            this.startAngle = n;
            this.sweepAngle = n2;
        }

        public int getStartAngle() {
            return this.startAngle;
        }

        public int getSweepAngle() {
            return this.sweepAngle;
        }

        public boolean equals(GaugeType gaugeType) {
            return this.startAngle == gaugeType.startAngle && this.sweepAngle == gaugeType.sweepAngle;
        }
    }
}

