/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.gauge.GaugeUtil;
import com.klg.jclass.swing.gauge.JCAbstractIndicator;
import com.klg.jclass.swing.gauge.JCIndicatorStyle;
import com.klg.jclass.swing.gauge.JCNeedle;
import com.klg.jclass.swing.gauge.JCScale;
import com.klg.jclass.util.JCListenerList;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class JCAbstractNeedle
extends JCAbstractIndicator
implements JCNeedle {
    static final long serialVersionUID = 3489006543322509139L;
    protected JCListenerList changeListeners = null;
    protected ChangeEvent changeEvent = new ChangeEvent(this);
    protected boolean sendEvents = true;
    protected InteractionType interactionType = InteractionType.NONE;

    public JCAbstractNeedle(JCScale jCScale) {
        super(jCScale);
        this.value = jCScale.getMin();
        this.indicatorStyle = JCIndicatorStyle.ARROW;
    }

    public JCAbstractNeedle(Color color, double d, JCScale jCScale, boolean bl, double d2, double d3, JCIndicatorStyle jCIndicatorStyle, double d4) {
        super(color, d, jCScale, bl, d2, d3, jCIndicatorStyle, d4);
    }

    public JCAbstractNeedle(Color color, double d, JCScale jCScale, InteractionType interactionType, boolean bl, double d2, JCIndicatorStyle jCIndicatorStyle, double d3) {
        super(color, d, jCScale, bl, 0.0, d2, jCIndicatorStyle, d3);
        this.interactionType = interactionType;
    }

    public Dimension getPreferredSize() {
        return this.scale.getGauge().getGaugeArea().getPreferredSize();
    }

    public abstract void paint(Graphics var1);

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners = JCListenerList.add(this.changeListeners, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners = JCListenerList.remove(this.changeListeners, changeListener);
    }

    public void sendChangeEvent(ChangeEvent changeEvent) {
        Enumeration enumeration = JCListenerList.elements(this.changeListeners);
        while (enumeration.hasMoreElements()) {
            ((ChangeListener)enumeration.nextElement()).stateChanged(changeEvent);
        }
    }

    public void setValue(double d) {
        if (this.value != (d = GaugeUtil.clamp(d, this.scale.getMin(), this.scale.getMax()))) {
            this.value = d;
            if (this.sendEvents) {
                this.sendChangeEvent(this.changeEvent);
            }
            this.redraw();
        }
    }

    public double getLength() {
        return this.outer_extent;
    }

    public void setLength(double d) {
        this.setOuterExtent(d);
    }

    public JCIndicatorStyle getNeedleStyle() {
        return this.indicatorStyle;
    }

    public void setNeedleStyle(JCIndicatorStyle jCIndicatorStyle) {
        this.indicatorStyle = jCIndicatorStyle;
        this.redraw();
    }

    public double getNeedleWidth() {
        return this.getIndicatorWidth();
    }

    public void setNeedleWidth(double d) {
        this.setIndicatorWidth(d);
    }

    public InteractionType getInteractionType() {
        return this.interactionType;
    }

    public void setInteractionType(InteractionType interactionType) {
        this.interactionType = interactionType;
    }

    public boolean getSendEvents() {
        return this.sendEvents;
    }

    public void setSendEvents(boolean bl) {
        this.sendEvents = bl;
    }

    public static class InteractionType
    implements Serializable {
        public static final InteractionType NONE = new InteractionType();
        public static final InteractionType DRAG = new InteractionType();
        public static final InteractionType CLICK = new InteractionType();
        public static final InteractionType CLICK_DRAG = new InteractionType();

        private InteractionType() {
        }
    }
}

