/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing;

import com.klg.jclass.swing.DateTimeChooser;
import com.klg.jclass.swing.DateTimePopup;
import com.klg.jclass.swing.JCPopupCalendarEditor;
import com.klg.jclass.swing.plaf.CalendarPopup;
import com.klg.jclass.swing.plaf.CalendarPopupUI;
import com.klg.jclass.swing.plaf.MetalCalendarPopupUI;
import com.klg.jclass.swing.plaf.MotifCalendarPopupUI;
import com.klg.jclass.swing.plaf.WindowsCalendarPopupUI;
import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.calendar.CalendarContainer;
import com.klg.jclass.util.calendar.DateTimeEditor;
import com.klg.jclass.util.swing.JCCheckBoxList;
import com.klg.jclass.util.swing.JCExitFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.JTextComponent;

public class JCPopupCalendar
extends JComboBox
implements KeyListener,
PropertyChangeListener,
DocumentListener,
FocusListener {
    public static final int DATE_TIME = 1;
    public static final int DATE = 2;
    protected int calendarType = 1;
    protected JCPopupCalendarEditor popupEditor = null;
    protected boolean showPopupOnUpDownArrow = true;
    protected DefaultComboBoxModel model = null;
    private Bounds minimum = new Bounds();
    private Bounds maximum = new Bounds();
    private boolean editorChanged = false;
    private Border editorUIBorder;
    static /* synthetic */ Class class$java$util$Date;

    public JCPopupCalendar() {
        this(1, new Date(), Locale.getDefault());
    }

    public JCPopupCalendar(int n) {
        this(n, new Date(), Locale.getDefault());
    }

    public JCPopupCalendar(Date date) {
        this(1, date, Locale.getDefault());
    }

    public JCPopupCalendar(int n, Date date) {
        this(n, date, Locale.getDefault());
    }

    public JCPopupCalendar(Date date, Locale locale) {
        this(1, date, locale);
    }

    public JCPopupCalendar(int n, Date date, Locale locale) {
        if (JCEnvironment.getJavaVersion() < 140) {
            throw new IllegalStateException("JCPopupCalendar is incompatible with JDKs prior to 1.4.0");
        }
        this.setCalendarType(n);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.setLocale(locale);
        Calendar calendar = Calendar.getInstance(this.getLocale());
        if (date == null) {
            date = new Date();
        }
        calendar.setTime(date);
        this.setPopupEditor(new DateTimePopup(this, 2, n == 1, false, this.getLocale(), calendar));
        this.model = new DefaultComboBoxModel<Object>(new Object[]{date});
        this.setModel(this.model);
        this.setEditor(new DateEditor(this, this.getCalendarType(), date, this.getLocale()));
        this.setRenderer(new DateRenderer(this, this.getCalendarType(), date, this.getLocale()));
        this.addKeyListener(this);
    }

    protected ComboBoxUI inferLookAndFeelUI() {
        CalendarPopupUI calendarPopupUI;
        Component component;
        Object object = null;
        String string = UIManager.getLookAndFeel().getID();
        object = string.equals("Windows") ? new WindowsCalendarPopupUI(null) : (string.equals("Motif") ? new MotifCalendarPopupUI(null) : new MetalCalendarPopupUI(null));
        if (object instanceof CalendarPopupUI && (component = (calendarPopupUI = (CalendarPopupUI)object).getEditor().getEditorComponent()) instanceof JComponent) {
            this.editorUIBorder = ((JComponent)component).getBorder();
        }
        return object;
    }

    public void setPopupEditor(JCPopupCalendarEditor jCPopupCalendarEditor) {
        if (this.popupEditor != jCPopupCalendarEditor) {
            this.popupEditor = jCPopupCalendarEditor;
            if (this.popupEditor != null) {
                this.popupEditor.setLocale(this.getLocale());
                this.popupEditor.setMinimumDate(this.minimum.getValue());
                this.popupEditor.setMaximumDate(this.maximum.getValue());
            }
            if (JCEnvironment.isWindows()) {
                ((WindowsCalendarPopupUI)((Object)this.ui)).setPopupCalendarEditor(jCPopupCalendarEditor);
            } else if (JCEnvironment.isMotif()) {
                ((MotifCalendarPopupUI)this.ui).setPopupCalendarEditor(jCPopupCalendarEditor);
            } else {
                ((MetalCalendarPopupUI)this.ui).setPopupCalendarEditor(jCPopupCalendarEditor);
            }
        }
    }

    public JCPopupCalendarEditor getPopupEditor() {
        return this.popupEditor;
    }

    public void setValue(Date date) {
        this.setValue(date, true);
    }

    protected void setValue(Date date, boolean bl) {
        if (date == null) {
            date = new Date();
        }
        this.updateComboBoxModel(date);
        this.updateComboBoxEditor(date);
        this.updateComboBoxRenderer();
        if (bl && this.popupEditor != null) {
            this.popupEditor.setValue(date);
        }
    }

    public Date getValue() {
        Date date = (Date)this.model.getElementAt(0);
        return (Date)date.clone();
    }

    public Date getMinimumDate() {
        Calendar calendar = this.minimum.getValue();
        Date date = null;
        if (calendar != null) {
            date = calendar.getTime();
        }
        return date;
    }

    public void setMinimumDate(Date date) {
        Calendar calendar = null;
        if (date != null) {
            calendar = Calendar.getInstance();
            calendar.setTime(date);
        }
        this.minimum.setValue(calendar);
        if (this.popupEditor != null) {
            this.popupEditor.setMinimumDate(calendar);
        }
    }

    public Date getMaximumDate() {
        Calendar calendar = this.maximum.getValue();
        Date date = null;
        if (calendar != null) {
            date = calendar.getTime();
        }
        return date;
    }

    public void setMaximumDate(Date date) {
        Calendar calendar = null;
        if (date != null) {
            calendar = Calendar.getInstance();
            calendar.setTime(date);
        }
        this.maximum.setValue(calendar);
        if (this.popupEditor != null) {
            this.popupEditor.setMaximumDate(calendar);
        }
    }

    public int getCalendarType() {
        return this.calendarType;
    }

    public void setCalendarType(int n) {
        Object object;
        ComboBoxEditor comboBoxEditor;
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("Bad calendar type.  Must be one of JCPopupCalendar.DATE_TIME or JCPopupCalendar.DATE");
        }
        if (this.calendarType == n) {
            return;
        }
        this.calendarType = n;
        if (this.popupEditor != null) {
            this.popupEditor.setShowTimeComponent(n == 1);
        }
        if ((comboBoxEditor = this.getEditor()) instanceof DateEditor) {
            object = (DateEditor)comboBoxEditor;
            ((DateEditor)object).setCalendarType(n);
        }
        if ((object = this.getRenderer()) instanceof DateRenderer) {
            DateRenderer dateRenderer = (DateRenderer)object;
            dateRenderer.setCalendarType(n);
        }
    }

    public boolean getShowPopupOnUpDownArrow() {
        return this.showPopupOnUpDownArrow;
    }

    public void setShowPopupOnUpDownArrow(boolean bl) {
        this.showPopupOnUpDownArrow = bl;
    }

    public boolean getHidePopupOnDayTableClick() {
        if (this.popupEditor != null) {
            return this.popupEditor.getHidePopupOnDayTableClick();
        }
        return false;
    }

    public void setHidePopupOnDayTableClick(boolean bl) {
        if (this.popupEditor != null) {
            this.popupEditor.setHidePopupOnDayTableClick(bl);
        }
    }

    public boolean getShowApplyButton() {
        if (this.popupEditor != null) {
            return this.popupEditor.getShowApplyButton();
        }
        return false;
    }

    public void setShowApplyButton(boolean bl) {
        if (this.popupEditor != null) {
            this.popupEditor.setShowApplyButton(bl);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        CalendarPopup calendarPopup;
        Date date;
        ComboBoxUI comboBoxUI;
        this.editorChanged = false;
        int n = keyEvent.getKeyCode();
        Component component = this.getEditor().getEditorComponent();
        if (component != null && keyEvent.getSource() == component && (n == 38 || n == 40)) {
            this.editorChanged = true;
            if (this.showPopupOnUpDownArrow && !this.isPopupVisible()) {
                this.showPopup();
            }
        }
        if (n == 27 && this.isPopupVisible() && (comboBoxUI = this.getUI()) instanceof CalendarPopupUI && (date = (calendarPopup = ((CalendarPopupUI)((Object)comboBoxUI)).getPopup()).getOriginalDate()) != null) {
            this.setValue(date);
            this.hidePopup();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Date date;
        if ("value".equals(propertyChangeEvent.getPropertyName()) && (date = this.extractCurrentEditorValue()) != null) {
            this.updatePopupEditor(date);
            this.updateComboBoxModel(date);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        Date date = (Date)this.model.getElementAt(0);
        this.updateComboBoxEditor(date);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        Date date;
        if (this.editorChanged && (date = this.extractCurrentEditorValue()) != null) {
            this.updatePopupEditor(date);
            this.updateComboBoxModel(date);
        }
        this.editorChanged = false;
    }

    public void removeUpdate(DocumentEvent documentEvent) {
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    protected Date extractCurrentEditorValue() {
        Component component;
        ComboBoxEditor comboBoxEditor = this.getEditor();
        Date date = null;
        if (comboBoxEditor != null && (component = comboBoxEditor.getEditorComponent()) instanceof JFormattedTextField) {
            JFormattedTextField jFormattedTextField = (JFormattedTextField)component;
            DateFormatter dateFormatter = (DateFormatter)jFormattedTextField.getFormatter();
            Object object = null;
            try {
                object = dateFormatter.stringToValue(jFormattedTextField.getText());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (object instanceof Date) {
                date = (Date)object;
            }
        }
        return date;
    }

    protected void updateComboBoxEditor(Date date) {
        if (!this.isEditable()) {
            return;
        }
        ComboBoxEditor comboBoxEditor = this.getEditor();
        if (comboBoxEditor != null && date != null) {
            comboBoxEditor.setItem(date);
        }
    }

    protected void updateComboBoxRenderer() {
        if (this.isEditable()) {
            return;
        }
        this.repaint();
    }

    protected void updateComboBoxModel(Date date) {
        if (this.model != null && date != null) {
            Date date2 = (Date)this.model.getElementAt(0);
            date2.setTime(date.getTime());
        }
    }

    protected void updatePopupEditor(Date date) {
        if (this.popupEditor != null && date != null) {
            this.popupEditor.setValue(date);
        }
    }

    public void setUI(ComboBoxUI comboBoxUI) {
        super.setUI(this.inferLookAndFeelUI());
    }

    public void updateUI() {
        this.setUI(null);
        if (this.popupEditor != null) {
            Serializable serializable;
            Font font = null;
            int n = 2;
            JComponent jComponent = this.popupEditor.getEditorComponent();
            if (jComponent instanceof DateTimeChooser) {
                serializable = (DateTimeChooser)jComponent;
                font = ((CalendarContainer)serializable).getUserFont();
                n = ((DateTimeEditor)serializable).getChooserType();
            }
            serializable = Calendar.getInstance(this.getLocale());
            ((Calendar)serializable).setTime(this.getValue());
            DateTimePopup dateTimePopup = new DateTimePopup(this, n, this.calendarType == 1, this.getShowApplyButton(), this.getLocale(), (Calendar)serializable);
            JCListenerList jCListenerList = null;
            if (this.popupEditor instanceof DateTimePopup) {
                DateTimePopup dateTimePopup2 = (DateTimePopup)this.popupEditor;
                jCListenerList = dateTimePopup2.popupListeners;
                dateTimePopup2.popupListeners = null;
            }
            dateTimePopup.popupListeners = jCListenerList;
            if (font != null) {
                dateTimePopup.setFont(font);
            }
            this.setPopupEditor(dateTimePopup);
        }
    }

    public void setLocale(Locale locale) {
        Object object;
        ComboBoxEditor comboBoxEditor;
        super.setLocale(locale);
        if (this.popupEditor != null) {
            this.popupEditor.setLocale(locale);
        }
        if ((comboBoxEditor = this.getEditor()) instanceof DateEditor) {
            object = (DateEditor)comboBoxEditor;
            ((DateEditor)object).setLocale(locale);
        }
        if ((object = this.getRenderer()) instanceof DateRenderer) {
            DateRenderer dateRenderer = (DateRenderer)object;
            dateRenderer.setLocale(locale);
        }
    }

    public void setEditor(ComboBoxEditor comboBoxEditor) {
        Component component;
        Object object;
        ComboBoxEditor comboBoxEditor2 = this.getEditor();
        if (comboBoxEditor2 != null) {
            object = comboBoxEditor2.getEditorComponent();
            ((Component)object).removeKeyListener(this);
            ((Component)object).removePropertyChangeListener(this);
            ((Component)object).removeFocusListener(this);
            if (object instanceof JTextField) {
                component = (JTextField)object;
                ((JTextComponent)component).getDocument().removeDocumentListener(this);
            }
        }
        super.setEditor(comboBoxEditor);
        object = this.getEditor();
        if (object != null) {
            component = object.getEditorComponent();
            component.addKeyListener(this);
            component.addPropertyChangeListener(this);
            component.addFocusListener(this);
            if (component instanceof JTextField) {
                JTextField jTextField = (JTextField)component;
                jTextField.getDocument().addDocumentListener(this);
            }
        }
    }

    public static DateFormat getDefaultDateFormat(int n, Locale locale) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("Bad calendar type.  Must be one of JCPopupCalendar.DATE_TIME or JCPopupCalendar.DATE");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        DateFormat dateFormat = null;
        dateFormat = n == 2 ? DateFormat.getDateInstance(2, locale) : DateFormat.getDateTimeInstance(2, 2, locale);
        return dateFormat;
    }

    public static void main(String[] stringArray) {
        Object object;
        if (stringArray.length > 0) {
            if (stringArray[0].equals("windows")) {
                try {
                    object = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
                    UIManager.setLookAndFeel((String)object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (stringArray[0].equals("motif")) {
                try {
                    object = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
                    UIManager.setLookAndFeel((String)object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        object = new JCExitFrame("JCPopupCalendar");
        Locale locale = new Locale("fr", "FR");
        final JCPopupCalendar jCPopupCalendar = new JCPopupCalendar(1, new Date(), locale);
        jCPopupCalendar.setEditable(true);
        Component component = jCPopupCalendar.getEditor().getEditorComponent();
        ((JTextField)component).setColumns(20);
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(1);
        calendar.set(1, n - 2);
        jCPopupCalendar.setMinimumDate(calendar.getTime());
        Calendar calendar2 = Calendar.getInstance();
        calendar2.set(1, n + 2);
        jCPopupCalendar.setMaximumDate(calendar2.getTime());
        Object[] objectArray = new String[]{"English (US)", "French", "Spanish", "Russian"};
        final Locale[] localeArray = new Locale[]{new Locale("en", "US"), new Locale("fr", "FR"), new Locale("es", "ES"), new Locale("ru", "RU")};
        final JCCheckBoxList jCCheckBoxList = new JCCheckBoxList(objectArray);
        jCCheckBoxList.setSelectedIndex(1);
        jCCheckBoxList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                jCPopupCalendar.setLocale(localeArray[jCCheckBoxList.getSelectedIndex()]);
            }
        });
        JButton jButton = new JButton("Switch types");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jCPopupCalendar.setCalendarType(3 - jCPopupCalendar.getCalendarType());
            }
        });
        Container container = ((JFrame)object).getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jCPopupCalendar, "North");
        container.add((Component)jCCheckBoxList, "Center");
        container.add((Component)jButton, "South");
        ((Window)object).pack();
        ((Window)object).show();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class Bounds
    implements Comparable,
    Serializable {
        protected Calendar value = null;

        public Bounds() {
        }

        public Bounds(Calendar calendar) {
            this.value = calendar;
        }

        public Calendar getValue() {
            return this.value;
        }

        public void setValue(Calendar calendar) {
            this.value = calendar;
        }

        public int compareTo(Object object) {
            Date date = (Date)object;
            if (this.value == null || date == null) {
                return 0;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int n = 1;
            if (this.value.before(calendar)) {
                n = -1;
            }
            return n;
        }
    }

    public class DateRenderer
    extends DefaultListCellRenderer {
        protected JCPopupCalendar popupCalendar;
        protected int calendarType = 1;
        protected DateFormat format;

        public DateRenderer(JCPopupCalendar jCPopupCalendar2, int n, Date date) {
            this(jCPopupCalendar2, n, date, null);
        }

        public DateRenderer(JCPopupCalendar jCPopupCalendar2, int n, Date date, Locale locale) {
            this.popupCalendar = jCPopupCalendar2;
            this.calendarType = n;
            if (date == null) {
                date = new Date();
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            this.setLocale(locale);
        }

        public JCPopupCalendar getPopupCalendar() {
            return this.popupCalendar;
        }

        public int getCalendarType() {
            return this.calendarType;
        }

        public void setCalendarType(int n) {
            if (n != 1 && n != 2) {
                throw new IllegalArgumentException("Bad calendar type.  Must be one of JCPopupCalendar.DATE_TIME or JCPopupCalendar.DATE");
            }
            if (this.calendarType == n) {
                return;
            }
            this.calendarType = n;
            this.setFormat(JCPopupCalendar.getDefaultDateFormat(n, this.getLocale()));
        }

        public void setLocale(Locale locale) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            super.setLocale(locale);
            if (this.popupCalendar != null) {
                this.setFormat(JCPopupCalendar.getDefaultDateFormat(this.calendarType, this.getLocale()));
            }
        }

        public DateFormat getFormat() {
            return this.format;
        }

        public void setFormat(DateFormat dateFormat) {
            if (dateFormat == null) {
                throw new IllegalArgumentException("Format cannot be null");
            }
            this.format = dateFormat;
            Date date = (Date)this.popupCalendar.getModel().getElementAt(0);
            this.setText(this.format.format(date));
            if (this.popupCalendar.isShowing()) {
                this.popupCalendar.repaint();
            }
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = null;
            if (object instanceof Date) {
                string = this.format.format((Date)object);
            } else if (!(object instanceof Icon)) {
                string = object == null ? "" : object.toString();
            }
            Object object2 = string == null ? object : string;
            return super.getListCellRendererComponent((JList<?>)jList, object2, n, bl, bl2);
        }
    }

    public class DateEditor
    implements ComboBoxEditor,
    Serializable {
        protected JCPopupCalendar popupCalendar;
        protected JFormattedTextField editor;
        protected int calendarType = 1;

        public DateEditor(JCPopupCalendar jCPopupCalendar2, int n, Date date) {
            this(jCPopupCalendar2, n, date, null);
        }

        public DateEditor(JCPopupCalendar jCPopupCalendar2, int n, Date date, Locale locale) {
            this.popupCalendar = jCPopupCalendar2;
            this.calendarType = n;
            this.editor = new JFormattedTextField();
            if (date == null) {
                date = new Date();
            }
            this.editor.setValue(date);
            if (locale == null) {
                locale = Locale.getDefault();
            }
            this.setLocale(locale);
            this.editor.setFocusLostBehavior(1);
            this.editor.setBorder(JCPopupCalendar.this.editorUIBorder);
        }

        public JCPopupCalendar getPopupCalendar() {
            return this.popupCalendar;
        }

        public int getCalendarType() {
            return this.calendarType;
        }

        public void setCalendarType(int n) {
            if (n != 1 && n != 2) {
                throw new IllegalArgumentException("Bad calendar type.  Must be one of JCPopupCalendar.DATE_TIME or JCPopupCalendar.DATE");
            }
            if (this.calendarType == n) {
                return;
            }
            this.calendarType = n;
            this.setFormat(JCPopupCalendar.getDefaultDateFormat(n, this.editor.getLocale()));
        }

        public void setLocale(Locale locale) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            this.editor.setLocale(locale);
            if (this.popupCalendar != null) {
                this.setFormat(JCPopupCalendar.getDefaultDateFormat(this.calendarType, this.editor.getLocale()));
            }
        }

        public void setFormat(DateFormat dateFormat) {
            DateFormatter dateFormatter = new DateFormatter(dateFormat);
            dateFormatter.setValueClass(class$java$util$Date == null ? (class$java$util$Date = JCPopupCalendar.class$("java.util.Date")) : class$java$util$Date);
            dateFormatter.setMinimum(JCPopupCalendar.this.minimum);
            dateFormatter.setMaximum(JCPopupCalendar.this.maximum);
            DefaultFormatterFactory defaultFormatterFactory = new DefaultFormatterFactory(dateFormatter);
            this.editor.setFormatterFactory(defaultFormatterFactory);
        }

        public Component getEditorComponent() {
            return this.editor;
        }

        public void setItem(Object object) {
            if (object == null) {
                this.editor.setValue(new Date());
            } else if (object instanceof Date) {
                this.editor.setValue(object);
            } else {
                throw new IllegalArgumentException("Object must be of type Date");
            }
        }

        public Object getItem() {
            return this.editor.getValue();
        }

        public void selectAll() {
            this.editor.selectAll();
            this.editor.requestFocus();
        }

        public void addActionListener(ActionListener actionListener) {
            this.editor.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.editor.removeActionListener(actionListener);
        }
    }
}

