/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.ttf;

import com.klg.jclass.page.resources.LocaleBundle;
import com.klg.jclass.page.ttf.FontFileReader;
import com.klg.jclass.page.ttf.Glyphs;
import com.klg.jclass.page.ttf.TTFCmapEntry;
import com.klg.jclass.page.ttf.TTFDirTabEntry;
import com.klg.jclass.page.ttf.TTFFontNames;
import com.klg.jclass.page.ttf.TTFMtxEntry;
import com.klg.jclass.page.ttf.UnicodeMapping;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class TTFFile {
    public static final int UNPARSED = 0;
    public static final int PARSE_OK = 1;
    public static final int PARSE_WARNING = 2;
    public static final int PARSE_FATAL = 3;
    static final byte NTABS = 24;
    static final int NMACGLYPHS = 258;
    static final int MAX_CHAR_CODE = 255;
    static final int ENC_BUF_SIZE = 1024;
    static String encoding = "WinAnsiEncoding";
    short firstChar = 0;
    boolean is_embeddable = true;
    boolean hasSerifs = true;
    Hashtable dirTabs;
    Hashtable kerningTab;
    Hashtable ansiKerningTab;
    Vector cmaps;
    Vector unicodeMapping;
    Hashtable unicodeToGlyphTable;
    Hashtable compositeGlyphs;
    double version;
    int upem;
    int nhmtx;
    int post_format;
    int loca_format;
    long lastLoca = 0L;
    int nglyphs;
    int nmglyphs;
    TTFMtxEntry[] mtx_tab;
    int[] mtx_encoded = null;
    String fontName = "";
    String fullName = "";
    String notice = "";
    String familyName = "";
    String subFamilyName = "";
    double italicAngle = 0.0;
    long isFixedPitch = 0L;
    int fontBBox1 = 0;
    int fontBBox2 = 0;
    int fontBBox3 = 0;
    int fontBBox4 = 0;
    int capHeight = 0;
    int underlinePosition = 0;
    int underlineThickness = 0;
    int xHeight = 0;
    int ascender = 0;
    int descender = 0;
    short lastChar = 0;
    int[] ansiWidth;
    Hashtable ansiIndex;
    long dirTabOffset = 0L;
    byte[] panose = null;
    int ibmFamilyClass = 0;
    int ibmFamilySubclass = 0;
    int status = 0;
    StringBuffer statusMessage = null;
    String fontFileName = null;

    void seek_tab(FontFileReader fontFileReader, String string, long l) throws IOException {
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get(string);
        if (tTFDirTabEntry == null) {
            System.err.println("Warning: TTF: Dirtab " + string + " not found.");
            return;
        }
        fontFileReader.seek_set(tTFDirTabEntry.offset + l);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        if (n > this.status) {
            this.status = n;
        }
    }

    public void addToStatusMessage(String string) {
        if (string == null) {
            return;
        }
        if (this.statusMessage == null) {
            this.statusMessage = new StringBuffer();
        }
        boolean bl = false;
        if (this.statusMessage.length() == 0) {
            bl = true;
        }
        if (!bl) {
            this.statusMessage.append('\n');
        }
        this.statusMessage.append(string);
    }

    public String getStatusMessage() {
        if (this.statusMessage == null) {
            return "";
        }
        return this.statusMessage.toString();
    }

    public void setFontFileName(String string) {
        this.fontFileName = string;
    }

    protected void addNoUnicodeStatusMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LocaleBundle.string("No Unicode CMap"));
        String string = "xxx";
        int n = stringBuffer.toString().indexOf(string);
        if (n >= 0) {
            stringBuffer.replace(n, n + string.length(), this.fullName);
        }
        this.addToStatusMessage(stringBuffer.toString());
        if (this.fontFileName != null) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("    (");
            stringBuffer.append(this.fontFileName);
            stringBuffer.append(")");
            this.addToStatusMessage(stringBuffer.toString());
        }
    }

    protected void addInvalidFileStatusMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LocaleBundle.string("Invalid TTF"));
        this.addToStatusMessage(stringBuffer.toString());
        if (this.fontFileName != null) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("    (");
            stringBuffer.append(this.fontFileName);
            stringBuffer.append(")");
            this.addToStatusMessage(stringBuffer.toString());
        }
    }

    public int get_ttf_funit(int n) {
        int n2;
        if (n < 0) {
            long l = n % this.upem;
            long l2 = 1000L * l;
            long l3 = l / l2;
            n2 = -(-1000 * n / this.upem - (int)l3);
        } else {
            n2 = n / this.upem * 1000 + n % this.upem * 1000 / this.upem;
        }
        return n2;
    }

    private boolean readCMAP(FontFileReader fontFileReader) throws IOException {
        int n;
        int n2;
        this.unicodeMapping = new Vector();
        this.unicodeToGlyphTable = new Hashtable();
        int n3 = 0;
        this.seek_tab(fontFileReader, "cmap", 2L);
        int n4 = fontFileReader.readTTFUShort();
        long l = 0L;
        int n5 = 0;
        while (n5 < n4) {
            n2 = fontFileReader.readTTFUShort();
            n = fontFileReader.readTTFUShort();
            long l2 = fontFileReader.readTTFULong();
            if (n2 == 3 && n == 1) {
                l = l2;
            }
            ++n5;
        }
        if (l <= 0L) {
            this.addNoUnicodeStatusMessage();
            this.setStatus(2);
            return false;
        }
        this.seek_tab(fontFileReader, "cmap", l);
        n2 = fontFileReader.readTTFUShort();
        n = fontFileReader.readTTFUShort();
        if (n2 == 4) {
            fontFileReader.skip(2L);
            int n6 = fontFileReader.readTTFUShort();
            int n7 = fontFileReader.readTTFUShort();
            int n8 = fontFileReader.readTTFUShort();
            int n9 = fontFileReader.readTTFUShort();
            int[] nArray = new int[n6 / 2];
            int[] nArray2 = new int[n6 / 2];
            int[] nArray3 = new int[n6 / 2];
            int[] nArray4 = new int[n6 / 2];
            int n10 = 0;
            while (n10 < n6 / 2) {
                nArray[n10] = fontFileReader.readTTFUShort();
                ++n10;
            }
            fontFileReader.skip(2L);
            int n11 = 0;
            while (n11 < n6 / 2) {
                nArray2[n11] = fontFileReader.readTTFUShort();
                ++n11;
            }
            int n12 = 0;
            while (n12 < n6 / 2) {
                nArray3[n12] = fontFileReader.readTTFShort();
                ++n12;
            }
            int n13 = fontFileReader.getCurrentPos();
            int n14 = 0;
            while (n14 < n6 / 2) {
                nArray4[n14] = fontFileReader.readTTFUShort();
                ++n14;
            }
            int n15 = fontFileReader.getCurrentPos();
            int n16 = 0;
            while (n16 < nArray2.length && nArray2[n16] != 65535) {
                int n17 = nArray2[n16];
                while (n17 <= nArray[n16]) {
                    if (n17 < 256 && n17 > this.lastChar) {
                        this.lastChar = (short)n17;
                    }
                    if (n3 < this.mtx_tab.length) {
                        Object object;
                        Object object2;
                        int n18;
                        if (nArray4[n16] != 0) {
                            int n19 = n15 + (nArray4[n16] / 2 + (n17 - nArray2[n16]) + n16 - n6 / 2) * 2;
                            fontFileReader.seek_set(n19);
                            n18 = fontFileReader.readTTFUShort() + nArray3[n16] & 0xFFFF;
                            this.unicodeMapping.addElement(new UnicodeMapping(n18, n17));
                            this.unicodeToGlyphTable.put(new Integer(n17), new Integer(n18));
                            this.mtx_tab[n18].unicodeIndex.addElement(new Integer(n17));
                            object2 = (Vector)this.ansiIndex.get(new Integer(n17));
                            if (object2 != null) {
                                object = ((Vector)object2).elements();
                                while (object.hasMoreElements()) {
                                    Integer n20 = (Integer)object.nextElement();
                                    this.ansiWidth[n20.intValue()] = this.mtx_tab[n18].wx;
                                }
                            }
                        } else {
                            n18 = n17 + nArray3[n16] & 0xFFFF;
                            if (n18 < this.mtx_tab.length) {
                                this.mtx_tab[n18].unicodeIndex.addElement(new Integer(n17));
                            } else {
                                System.err.println("Glyph " + n18 + " out of range: " + this.mtx_tab.length);
                            }
                            this.unicodeMapping.addElement(new UnicodeMapping(n18, n17));
                            this.unicodeToGlyphTable.put(new Integer(n17), new Integer(n18));
                            Vector vector = (Vector)this.ansiIndex.get(new Integer(n17));
                            if (vector != null) {
                                object2 = vector.elements();
                                while (object2.hasMoreElements()) {
                                    object = (Integer)object2.nextElement();
                                    this.ansiWidth[((Integer)object).intValue()] = this.mtx_tab[n18].wx;
                                }
                            }
                        }
                        if (n18 < this.mtx_tab.length && this.mtx_tab[n18].unicodeIndex.size() < 2) {
                            ++n3;
                        }
                    }
                    ++n17;
                }
                ++n16;
            }
        }
        return true;
    }

    private boolean isUnicode(FontFileReader fontFileReader) throws IOException {
        boolean bl = false;
        this.seek_tab(fontFileReader, "cmap", 2L);
        int n = fontFileReader.readTTFUShort();
        long l = 0L;
        int n2 = 0;
        while (n2 < n) {
            int n3 = fontFileReader.readTTFUShort();
            int n4 = fontFileReader.readTTFUShort();
            long l2 = fontFileReader.readTTFULong();
            if (n3 == 3 && n4 == 1) {
                l = l2;
            }
            ++n2;
        }
        return l > 0L;
    }

    private void print_max_min() {
        int n = 255;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.mtx_tab.length) {
            if (this.mtx_tab[n3].index < n) {
                n = this.mtx_tab[n3].index;
            }
            if (this.mtx_tab[n3].index > n2) {
                n2 = this.mtx_tab[n3].index;
            }
            ++n3;
        }
        System.err.println("Min: " + n);
        System.err.println("Max: " + n2);
    }

    public void readFont(FontFileReader fontFileReader) throws IOException {
        this.readFont(fontFileReader, null);
    }

    private void initAnsiWidths() {
        this.ansiWidth = new int[256];
        int n = 0;
        while (n < 256) {
            this.ansiWidth[n] = this.mtx_tab[0].wx;
            ++n;
        }
        this.ansiIndex = new Hashtable();
        int n2 = 32;
        while (n2 < Glyphs.winAnsiEncoding.length) {
            Integer n3 = new Integer(n2);
            Integer n4 = new Integer(Glyphs.winAnsiEncoding[n2]);
            Vector<Integer> vector = (Vector<Integer>)this.ansiIndex.get(n4);
            if (vector == null) {
                vector = new Vector<Integer>();
                this.ansiIndex.put(n4, vector);
            }
            vector.addElement(n3);
            ++n2;
        }
    }

    public void readFont(FontFileReader fontFileReader, String string) throws IOException {
        this.setStatus(1);
        if (!this.checkTTC(fontFileReader, string, false)) {
            throw new IOException("Failed to read font");
        }
        if (!this.readDirTabs(fontFileReader)) {
            this.addInvalidFileStatusMessage();
            this.setStatus(3);
            return;
        }
        this.readName(fontFileReader);
        if (!this.isUnicode(fontFileReader)) {
            this.addNoUnicodeStatusMessage();
            this.setStatus(3);
            return;
        }
        this.readFontHeader(fontFileReader);
        this.getNumGlyphs(fontFileReader);
        this.readHorizontalHeader(fontFileReader);
        this.readHorizontalMetrics(fontFileReader);
        this.initAnsiWidths();
        this.readPostscript(fontFileReader);
        this.readOS2(fontFileReader);
        this.readIndexToLocation(fontFileReader);
        this.readGlyf(fontFileReader);
        this.readPCLT(fontFileReader);
        if (!this.readCMAP(fontFileReader)) {
            this.setStatus(3);
            return;
        }
        this.createCMaps();
        this.readKerning(fontFileReader);
    }

    public void writeReducedFont(OutputStream outputStream, FontFileReader fontFileReader, SortedSet sortedSet, SortedSet sortedSet2) throws IOException {
        int n;
        int n2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Iterator iterator;
        TreeSet<Object> treeSet = null;
        if (sortedSet2 != null) {
            treeSet = new TreeSet(sortedSet2);
            iterator = sortedSet2.iterator();
            while (iterator.hasNext()) {
                object4 = (Integer)iterator.next();
                object3 = (List)this.compositeGlyphs.get(object4);
                if (object3 == null) continue;
                int n3 = 0;
                while (n3 < object3.size()) {
                    treeSet.add(object3.get(n3));
                    ++n3;
                }
            }
        } else {
            treeSet = new TreeSet<Object>();
        }
        if (sortedSet != null) {
            iterator = sortedSet.iterator();
            while (iterator.hasNext()) {
                object4 = (Integer)iterator.next();
                if ((Integer)object4 == 128) {
                    object4 = new Integer(8364);
                }
                if ((object3 = (Integer)this.unicodeToGlyphTable.get(object4)) == null) continue;
                treeSet.add(object3);
                List list = (List)this.compositeGlyphs.get(object3);
                if (list == null) continue;
                int n4 = 0;
                while (n4 < list.size()) {
                    treeSet.add(list.get(n4));
                    ++n4;
                }
            }
        }
        fontFileReader.seek_set(this.dirTabOffset);
        int n5 = this.dirTabs.size();
        object4 = new ByteArrayOutputStream();
        object3 = new ByteArrayOutputStream();
        this.reduceGLYF(fontFileReader, (ByteArrayOutputStream)object4, (ByteArrayOutputStream)object3, treeSet);
        byte[] byArray = ((ByteArrayOutputStream)object3).toByteArray();
        byte[] byArray2 = ((ByteArrayOutputStream)object4).toByteArray();
        fontFileReader.seek_set(this.dirTabOffset);
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        if (this.dirTabs.get("EBLC") != null && this.dirTabs.get("EBDT") != null) {
            TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("EBLC");
            TTFDirTabEntry tTFDirTabEntry2 = (TTFDirTabEntry)this.dirTabs.get("EBDT");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            this.reduceEBLC(fontFileReader, byteArrayOutputStream, byteArrayOutputStream2, treeSet);
            byArray3 = byteArrayOutputStream.toByteArray();
            byArray4 = byteArrayOutputStream2.toByteArray();
            if (byArray3.length == 0) {
                --n5;
                byArray3 = null;
            }
            if (byArray4.length == 0) {
                --n5;
                byArray4 = null;
            }
        }
        if (this.dirTabs.get("vhea") != null) {
            --n5;
        }
        if (this.dirTabs.get("vmtx") != null) {
            --n5;
        }
        if (this.dirTabs.get("DSIG") != null) {
            --n5;
        }
        boolean bl = false;
        if ((sortedSet == null || sortedSet.size() == 0) && this.dirTabs.get("cmap") != null) {
            --n5;
            bl = true;
        }
        fontFileReader.seek_set(this.dirTabOffset);
        long l = 12 + n5 * 16;
        long l2 = 0L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(fontFileReader.readBytes(4));
        byteArrayOutputStream.write(this.shortToBytes(n5));
        byteArrayOutputStream.write(fontFileReader.readBytes(6));
        TreeMap treeMap = new TreeMap(this.dirTabs);
        Set set = treeMap.keySet();
        Iterator iterator2 = set.iterator();
        while (iterator2.hasNext()) {
            String string = (String)iterator2.next();
            object2 = (TTFDirTabEntry)this.dirTabs.get(string);
            object = null;
            if (string.equals("glyf")) {
                object = byArray2;
            } else if (string.equals("loca")) {
                object = byArray;
            } else if (string.equals("EBLC")) {
                if (byArray3 == null) continue;
                object = byArray3;
            } else if (string.equals("EBDT")) {
                if (byArray4 == null) continue;
                object = byArray4;
            } else {
                if (string.equals("vhea") || string.equals("vmtx") || string.equals("DSIG") || bl && string.equals("cmap")) continue;
                object = fontFileReader.getBytes((int)((TTFDirTabEntry)object2).offset, (int)((TTFDirTabEntry)object2).length);
            }
            if (string.equals("head")) {
                object[8] = 0;
                object[9] = 0;
                object[10] = 0;
                object[11] = 0;
            }
            byteArrayOutputStream.write(((TTFDirTabEntry)object2).tag);
            long l3 = this.calcCheckSum((byte[])object);
            byteArrayOutputStream.write(this.longToBytes(l3));
            byteArrayOutputStream.write(this.longToBytes(l));
            byteArrayOutputStream.write(this.longToBytes(((byte[])object).length));
            l += (long)((byte[])object).length;
            n2 = ((byte[])object).length % 4;
            if (n2 > 0) {
                n = 4 - n2;
                l += (long)n;
            }
            if ((l2 += l3) < 0x100000000L) continue;
            l2 -= 0x100000000L;
        }
        if ((l2 += this.calcCheckSum(byteArrayOutputStream.toByteArray())) >= 0x100000000L) {
            l2 -= 0x100000000L;
        }
        int n6 = 0;
        iterator2 = set.iterator();
        while (iterator2.hasNext()) {
            object2 = (String)iterator2.next();
            object = (TTFDirTabEntry)this.dirTabs.get(object2);
            byte[] byArray5 = null;
            if (((String)object2).equals("glyf")) {
                byArray5 = byArray2;
            } else if (((String)object2).equals("loca")) {
                byArray5 = byArray;
            } else if (((String)object2).equals("EBLC")) {
                if (byArray3 == null) continue;
                byArray5 = byArray3;
            } else if (((String)object2).equals("EBDT")) {
                if (byArray4 == null) continue;
                byArray5 = byArray4;
            } else {
                if (((String)object2).equals("vhea") || ((String)object2).equals("vmtx") || ((String)object2).equals("DSIG") || bl && ((String)object2).equals("cmap")) continue;
                byArray5 = fontFileReader.getBytes((int)object.offset, (int)object.length);
            }
            if (((String)object2).equals("head")) {
                n6 = byteArrayOutputStream.size();
                byArray5[8] = 0;
                byArray5[9] = 0;
                byArray5[10] = 0;
                byArray5[11] = 0;
            }
            byteArrayOutputStream.write(byArray5);
            int n7 = byArray5.length % 4;
            if (n7 <= 0) continue;
            n2 = 4 - n7;
            n = 0;
            while (n < n2) {
                byteArrayOutputStream.write(0);
                ++n;
            }
        }
        long l4 = 2981146554L - l2;
        if (l4 < 0L) {
            l4 += 0x100000000L;
        }
        byte[] byArray6 = this.longToBytes(l4);
        byte[] byArray7 = byteArrayOutputStream.toByteArray();
        byArray7[n6 + 8] = byArray6[0];
        byArray7[n6 + 9] = byArray6[1];
        byArray7[n6 + 10] = byArray6[2];
        byArray7[n6 + 11] = byArray6[3];
        outputStream.write(byArray7);
    }

    protected byte[] longToBytes(long l) {
        byte[] byArray = new byte[4];
        int n = 3;
        while (n >= 0) {
            byArray[n] = (byte)(l & 0xFFL);
            l >>= 8;
            --n;
        }
        return byArray;
    }

    protected byte[] shortToBytes(int n) {
        byte[] byArray = new byte[2];
        int n2 = 1;
        while (n2 >= 0) {
            byArray[n2] = (byte)(n & 0xFF);
            n >>= 8;
            --n2;
        }
        return byArray;
    }

    protected long bytesToLong(byte[] byArray) throws IOException {
        long l = byArray[0];
        l = (l << 8) + (long)byArray[1];
        l = (l << 8) + (long)byArray[2];
        l = (l << 8) + (long)byArray[3];
        return l;
    }

    protected int bytesToShort(byte[] byArray) throws IOException {
        int n = byArray[0];
        n = (n << 8) + byArray[1];
        return n;
    }

    public long calcCheckSum(byte[] byArray) {
        long l = 0L;
        long l2 = (byArray.length + 3) / 4;
        int n = 0;
        while (l2-- > 0L) {
            long l3 = 0L;
            int n2 = 0;
            while (n2 < 4) {
                if (n + n2 < byArray.length) {
                    byte by;
                    if (n2 != 0) {
                        l3 <<= 8;
                    }
                    l3 = (by = byArray[n + n2]) < 0 ? (l3 += (long)(by + 256)) : (l3 += (long)by);
                } else {
                    l3 <<= 8;
                }
                ++n2;
            }
            if ((l += l3) >= 0x100000000L) {
                l -= 0x100000000L;
            }
            n += 4;
        }
        return l;
    }

    public List readFontNames(FontFileReader fontFileReader) throws IOException {
        this.setStatus(1);
        Vector<String> vector = new Vector<String>();
        if (this.checkTTCForFontNames(fontFileReader, vector, false, false)) {
            return vector;
        }
        if (!this.readDirTabs(fontFileReader)) {
            this.addInvalidFileStatusMessage();
            this.setStatus(3);
            return vector;
        }
        this.readName(fontFileReader);
        if (this.isUnicode(fontFileReader)) {
            vector.add(this.fontName);
        } else {
            this.addNoUnicodeStatusMessage();
            this.setStatus(2);
        }
        return vector;
    }

    public List readAllFontNames(FontFileReader fontFileReader) throws IOException {
        this.setStatus(1);
        Vector<TTFFontNames> vector = new Vector<TTFFontNames>();
        if (this.checkTTCForFontNames(fontFileReader, vector, false, true)) {
            return vector;
        }
        if (!this.readDirTabs(fontFileReader)) {
            this.addInvalidFileStatusMessage();
            this.setStatus(3);
            return vector;
        }
        this.readName(fontFileReader);
        if (this.isUnicode(fontFileReader)) {
            TTFFontNames tTFFontNames = new TTFFontNames();
            tTFFontNames.fontName = this.fontName;
            tTFFontNames.fullName = this.fullName;
            tTFFontNames.familyName = this.familyName;
            tTFFontNames.subFamilyName = this.subFamilyName;
            vector.add(tTFFontNames);
        } else {
            this.addNoUnicodeStatusMessage();
            this.setStatus(2);
        }
        return vector;
    }

    private void createCMaps() {
        UnicodeMapping unicodeMapping;
        this.cmaps = new Vector();
        TTFCmapEntry tTFCmapEntry = new TTFCmapEntry();
        Enumeration enumeration = this.unicodeMapping.elements();
        UnicodeMapping unicodeMapping2 = unicodeMapping = (UnicodeMapping)enumeration.nextElement();
        tTFCmapEntry.unicodeStart = unicodeMapping.uIdx;
        tTFCmapEntry.glyphStartIndex = unicodeMapping.gIdx;
        while (enumeration.hasMoreElements()) {
            unicodeMapping = (UnicodeMapping)enumeration.nextElement();
            if (unicodeMapping2.uIdx + 1 != unicodeMapping.uIdx || unicodeMapping2.gIdx + 1 != unicodeMapping.gIdx) {
                tTFCmapEntry.unicodeEnd = unicodeMapping2.uIdx;
                this.cmaps.addElement(tTFCmapEntry);
                tTFCmapEntry = new TTFCmapEntry();
                tTFCmapEntry.unicodeStart = unicodeMapping.uIdx;
                tTFCmapEntry.glyphStartIndex = unicodeMapping.gIdx;
            }
            unicodeMapping2 = unicodeMapping;
        }
        tTFCmapEntry.unicodeEnd = unicodeMapping.uIdx;
        this.cmaps.addElement(tTFCmapEntry);
    }

    public void printStuff() {
        System.err.println("Font name: " + this.fontName);
        System.err.println("Full name: " + this.fullName);
        System.err.println("Family name: " + this.familyName);
        System.err.println("Subfamily name: " + this.subFamilyName);
        System.err.println("Notice:    " + this.notice);
        System.err.println("xHeight:   " + this.get_ttf_funit(this.xHeight));
        System.err.println("capheight: " + this.get_ttf_funit(this.capHeight));
        System.err.println("ItalicAngle: " + this.italicAngle);
        System.err.println();
        System.err.println("Ascender:    " + this.get_ttf_funit(this.ascender));
        System.err.println("Descender:   " + this.get_ttf_funit(this.descender));
        System.err.println("FontBBox:    [" + this.get_ttf_funit(this.fontBBox1) + " " + this.get_ttf_funit(this.fontBBox2) + " " + this.get_ttf_funit(this.fontBBox3) + " " + this.get_ttf_funit(this.fontBBox4) + "]");
    }

    public static void main(String[] stringArray) {
        try {
            TTFFile tTFFile = new TTFFile();
            FontFileReader fontFileReader = new FontFileReader(stringArray[0]);
            String string = null;
            if (stringArray.length >= 2) {
                string = stringArray[1];
            }
            tTFFile.readFont(fontFileReader, string);
            tTFFile.printStuff();
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
    }

    public String getWindowsName() {
        return new String(this.familyName + "," + this.subFamilyName);
    }

    public String getPostscriptName() {
        if ("Regular".equals(this.subFamilyName) || "Roman".equals(this.subFamilyName)) {
            return this.familyName;
        }
        return this.familyName + "," + this.subFamilyName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getCharSetName() {
        return encoding;
    }

    public int getCapHeight() {
        return this.get_ttf_funit(this.capHeight);
    }

    public int getXHeight() {
        return this.get_ttf_funit(this.xHeight);
    }

    public boolean isSerif() {
        return this.hasSerifs;
    }

    public int getFlags() {
        int n = 32;
        if (this.italicAngle != 0.0) {
            n |= 0x40;
        }
        if (this.isFixedPitch != 0L) {
            n |= 2;
        }
        if (this.hasSerifs) {
            n |= 1;
        }
        return n;
    }

    public String getStemV() {
        return "0";
    }

    public String getItalicAngle() {
        String string = Double.toString(this.italicAngle);
        return string;
    }

    public double getItalicAngleValue() {
        return this.italicAngle;
    }

    public int[] getFontBBox() {
        int[] nArray = new int[]{this.get_ttf_funit(this.fontBBox1), this.get_ttf_funit(this.fontBBox2), this.get_ttf_funit(this.fontBBox3), this.get_ttf_funit(this.fontBBox4)};
        return nArray;
    }

    public int getLowerCaseAscent() {
        return this.get_ttf_funit(this.ascender);
    }

    public int getLowerCaseDescent() {
        return this.get_ttf_funit(this.descender);
    }

    public short getLastChar() {
        return this.lastChar;
    }

    public short getFirstChar() {
        return this.firstChar;
    }

    public int[] getWidths() {
        int[] nArray = new int[this.mtx_tab.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.get_ttf_funit(this.mtx_tab[n].wx);
            ++n;
        }
        return nArray;
    }

    public int getCharWidth(int n) {
        return this.get_ttf_funit(this.ansiWidth[n]);
    }

    public Hashtable getKerning() {
        return this.kerningTab;
    }

    public Hashtable getAnsiKerning() {
        return this.ansiKerningTab;
    }

    public boolean isEmbeddable() {
        return this.is_embeddable;
    }

    public TTFMtxEntry getGlyphMetricsByUnicode(int n) {
        int n2 = this.unicodeToGlyphCode(n);
        if (n2 == -1) {
            return null;
        }
        return this.mtx_tab[n2];
    }

    public TTFMtxEntry getGlyphMetricsByGlyphCode(int n) {
        if (n < this.mtx_tab.length) {
            return this.mtx_tab[n];
        }
        return null;
    }

    public List glyphCodeToUnicodes(int n) {
        return this.mtx_tab[n].unicodeIndex;
    }

    public int unicodeToGlyphCode(int n) {
        Integer n2 = (Integer)this.unicodeToGlyphTable.get(new Integer(n));
        if (n2 == null) {
            return -1;
        }
        return n2;
    }

    public int getGlyphWidthByUnicode(int n) {
        int n2 = this.unicodeToGlyphCode(n);
        if (n2 == -1) {
            return 0;
        }
        return this.getGlyphWidthByGlyphCode(n2);
    }

    public int getGlyphWidthByGlyphCode(int n) {
        return this.get_ttf_funit(this.mtx_tab[n].getWx());
    }

    public byte[] getPanose() {
        return this.panose;
    }

    public int getIBMFamilyClass() {
        return this.ibmFamilyClass;
    }

    public int getIBMFamilySubclass() {
        return this.ibmFamilySubclass;
    }

    protected boolean readDirTabs(FontFileReader fontFileReader) throws IOException {
        long l = fontFileReader.readTTFULong();
        if (l != 1953658213L && l != 65536L) {
            return false;
        }
        int n = fontFileReader.readTTFUShort();
        fontFileReader.skip(6L);
        this.dirTabs = new Hashtable();
        TTFDirTabEntry[] tTFDirTabEntryArray = new TTFDirTabEntry[n];
        int n2 = 0;
        while (n2 < n) {
            tTFDirTabEntryArray[n2] = new TTFDirTabEntry();
            String string = tTFDirTabEntryArray[n2].read(fontFileReader);
            this.dirTabs.put(string, tTFDirTabEntryArray[n2]);
            ++n2;
        }
        return true;
    }

    protected void readFontHeader(FontFileReader fontFileReader) throws IOException {
        this.seek_tab(fontFileReader, "head", 0L);
        this.version = fontFileReader.readTTFFixedDecimal();
        fontFileReader.skip(4L);
        fontFileReader.skip(4L);
        fontFileReader.skip(6L);
        this.upem = fontFileReader.readTTFUShort();
        fontFileReader.skip(16L);
        this.fontBBox1 = fontFileReader.readTTFShort();
        this.fontBBox2 = fontFileReader.readTTFShort();
        this.fontBBox3 = fontFileReader.readTTFShort();
        this.fontBBox4 = fontFileReader.readTTFShort();
        fontFileReader.skip(6L);
        this.loca_format = fontFileReader.readTTFShort();
    }

    protected void getNumGlyphs(FontFileReader fontFileReader) throws IOException {
        this.seek_tab(fontFileReader, "maxp", 4L);
        this.nglyphs = fontFileReader.readTTFUShort();
    }

    protected void readHorizontalHeader(FontFileReader fontFileReader) throws IOException {
        this.seek_tab(fontFileReader, "hhea", 4L);
        this.ascender = fontFileReader.readTTFShort();
        this.descender = fontFileReader.readTTFShort();
        fontFileReader.skip(26L);
        this.nhmtx = fontFileReader.readTTFUShort();
    }

    protected void readHorizontalMetrics(FontFileReader fontFileReader) throws IOException {
        this.seek_tab(fontFileReader, "hmtx", 0L);
        int n = this.nglyphs > this.nhmtx ? this.nglyphs : this.nhmtx;
        this.mtx_tab = new TTFMtxEntry[n];
        int n2 = 0;
        while (n2 < n) {
            this.mtx_tab[n2] = new TTFMtxEntry();
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.nhmtx) {
            this.mtx_tab[n3].wx = fontFileReader.readTTFUShort();
            this.mtx_tab[n3].lsb = fontFileReader.readTTFShort();
            ++n3;
        }
        if (this.nhmtx < n) {
            int n4 = this.mtx_tab[this.nhmtx - 1].wx;
            int n5 = this.nhmtx;
            while (n5 < n) {
                this.mtx_tab[n5].wx = n4;
                this.mtx_tab[n5].lsb = fontFileReader.readTTFShort();
                ++n5;
            }
        }
    }

    private final void readPostscript(FontFileReader fontFileReader) throws IOException {
        this.seek_tab(fontFileReader, "post", 0L);
        this.post_format = fontFileReader.readTTFLong();
        this.italicAngle = fontFileReader.readTTFFixedDecimal();
        this.underlinePosition = fontFileReader.readTTFShort();
        this.underlineThickness = fontFileReader.readTTFShort();
        this.isFixedPitch = fontFileReader.readTTFULong();
        fontFileReader.skip(16L);
        switch (this.post_format) {
            case 65536: {
                int n = 0;
                while (n < Glyphs.mac_glyph_names.length && n < this.mtx_tab.length) {
                    this.mtx_tab[n].name = Glyphs.mac_glyph_names[n];
                    ++n;
                }
                break;
            }
            case 131072: {
                int n = 0;
                int n2 = fontFileReader.readTTFUShort();
                int n3 = 0;
                while (n3 < n2) {
                    this.mtx_tab[n3].index = fontFileReader.readTTFUShort();
                    if (this.mtx_tab[n3].index > 257) {
                        ++n;
                    }
                    ++n3;
                }
                String[] stringArray = new String[n];
                n3 = 0;
                while (n3 < stringArray.length) {
                    stringArray[n3] = fontFileReader.readTTFString(fontFileReader.readTTFUByte());
                    ++n3;
                }
                n3 = 0;
                while (n3 < n2) {
                    if (this.mtx_tab[n3].index < 258) {
                        this.mtx_tab[n3].name = Glyphs.mac_glyph_names[this.mtx_tab[n3].index];
                    } else {
                        int n4 = this.mtx_tab[n3].index - 258;
                        this.mtx_tab[n3].name = stringArray[n4];
                    }
                    ++n3;
                }
                break;
            }
            case 196608: {
                break;
            }
            default: {
                System.err.println("Unknown Postscript format : " + this.post_format);
            }
        }
    }

    private final void readOS2(FontFileReader fontFileReader) throws IOException {
        if (this.dirTabs.get("OS/2") != null) {
            this.seek_tab(fontFileReader, "OS/2", 8L);
            int n = fontFileReader.readTTFUShort();
            this.is_embeddable = n != 2;
            fontFileReader.readBytes(20);
            int n2 = fontFileReader.readTTFUShort();
            this.ibmFamilyClass = n2 >> 8;
            this.ibmFamilySubclass = n2 & 0xF;
            this.panose = fontFileReader.readBytes(10);
        } else {
            this.is_embeddable = true;
        }
    }

    protected final void readIndexToLocation(FontFileReader fontFileReader) throws IOException {
        this.seek_tab(fontFileReader, "loca", 0L);
        int n = 0;
        while (n < this.nglyphs) {
            this.mtx_tab[n].offset = this.loca_format == 1 ? fontFileReader.readTTFULong() : (long)(fontFileReader.readTTFUShort() << 1);
            ++n;
        }
        this.lastLoca = this.loca_format == 1 ? fontFileReader.readTTFULong() : (long)(fontFileReader.readTTFUShort() << 1);
    }

    private final void readGlyf(FontFileReader fontFileReader) throws IOException {
        this.compositeGlyphs = new Hashtable();
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("glyf");
        int n = 0;
        while (n < this.nglyphs) {
            long l = 0L;
            l = n < this.nglyphs - 1 ? this.mtx_tab[n + 1].offset - this.mtx_tab[n].offset : this.lastLoca - this.mtx_tab[n].offset;
            if (l > 0L) {
                fontFileReader.seek_set(tTFDirTabEntry.offset + this.mtx_tab[n].offset);
                short s = fontFileReader.readTTFShort();
                this.mtx_tab[n].bbox[0] = fontFileReader.readTTFShort();
                this.mtx_tab[n].bbox[1] = fontFileReader.readTTFShort();
                this.mtx_tab[n].bbox[2] = fontFileReader.readTTFShort();
                this.mtx_tab[n].bbox[3] = fontFileReader.readTTFShort();
                if (s == -1) {
                    Vector<Integer> vector = new Vector<Integer>();
                    Integer n2 = null;
                    int n3 = 0;
                    boolean bl = true;
                    while (bl) {
                        n3 = fontFileReader.readTTFUShort();
                        n2 = new Integer(fontFileReader.readTTFUShort());
                        vector.addElement(n2);
                        if ((n3 & 1) > 0) {
                            fontFileReader.skip(4L);
                        } else {
                            fontFileReader.skip(2L);
                        }
                        if ((n3 & 8) > 0) {
                            fontFileReader.skip(2L);
                        } else if ((n3 & 0x40) > 0) {
                            fontFileReader.skip(4L);
                        } else if ((n3 & 0x80) > 0) {
                            fontFileReader.skip(8L);
                        }
                        bl = (n3 & 0x20) > 0;
                    }
                    this.compositeGlyphs.put(new Integer(n), vector);
                }
            } else {
                this.mtx_tab[n].bbox[0] = this.mtx_tab[0].bbox[0];
                this.mtx_tab[n].bbox[1] = this.mtx_tab[0].bbox[1];
                this.mtx_tab[n].bbox[2] = this.mtx_tab[0].bbox[2];
                this.mtx_tab[n].bbox[3] = this.mtx_tab[0].bbox[3];
            }
            ++n;
        }
    }

    private final void readName(FontFileReader fontFileReader) throws IOException {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        this.seek_tab(fontFileReader, "name", 2L);
        int n4 = fontFileReader.getCurrentPos();
        int n5 = fontFileReader.readTTFUShort();
        int n6 = fontFileReader.readTTFUShort() + n4 - 2;
        n4 += 4;
        while (n5-- > 0) {
            fontFileReader.seek_set(n4);
            n = fontFileReader.readTTFUShort();
            n2 = fontFileReader.readTTFUShort();
            n3 = fontFileReader.readTTFUShort();
            int n7 = fontFileReader.readTTFUShort();
            int n8 = fontFileReader.readTTFUShort();
            if ((n == 1 && n2 == 0 || n == 3 && n2 == 1) && (n7 == 1 || n7 == 2 || n7 == 0 || n7 == 4 || n7 == 6)) {
                fontFileReader.seek_set(n6 + fontFileReader.readTTFUShort());
                String string = n == 3 ? fontFileReader.readTTFString(n8, "UTF-16BE") : fontFileReader.readTTFString(n8);
                switch (n7) {
                    case 0: {
                        this.notice = string;
                        break;
                    }
                    case 1: {
                        this.familyName = string;
                        break;
                    }
                    case 2: {
                        this.subFamilyName = string;
                        break;
                    }
                    case 4: {
                        this.fullName = string;
                        break;
                    }
                    case 6: {
                        this.fontName = string;
                    }
                }
                if (!this.notice.equals("") && !this.fullName.equals("") && !this.fontName.equals("") && !this.familyName.equals("") && !this.subFamilyName.equals("")) break;
            }
            n4 += 12;
        }
    }

    private final void readPCLT(FontFileReader fontFileReader) throws IOException {
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("PCLT");
        if (tTFDirTabEntry != null) {
            fontFileReader.seek_set(tTFDirTabEntry.offset + 4L + 4L + 2L);
            this.xHeight = fontFileReader.readTTFUShort();
            fontFileReader.skip(4L);
            this.capHeight = fontFileReader.readTTFUShort();
            fontFileReader.skip(34L);
            int n = fontFileReader.readTTFUByte();
            n >>= 6;
            this.hasSerifs = (n &= 3) != 1;
        } else {
            int n = 0;
            while (n < this.mtx_tab.length) {
                if ("H".equals(this.mtx_tab[n].name)) {
                    this.capHeight = this.mtx_tab[n].bbox[3] - this.mtx_tab[n].bbox[1];
                }
                ++n;
            }
        }
    }

    protected final void reduceGLYF(FontFileReader fontFileReader, ByteArrayOutputStream byteArrayOutputStream, ByteArrayOutputStream byteArrayOutputStream2, SortedSet sortedSet) throws IOException {
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("glyf");
        int n = 0;
        int n2 = 0;
        while (n2 < this.nglyphs) {
            long l;
            long l2;
            if (this.loca_format == 1) {
                byteArrayOutputStream2.write(this.longToBytes(n));
            } else {
                byteArrayOutputStream2.write(this.shortToBytes(n >> 1));
            }
            if ((n2 == 0 || sortedSet.contains(new Integer(n2))) && (l2 = (l = n2 + 1 < this.nglyphs ? this.mtx_tab[n2 + 1].offset : this.lastLoca) - this.mtx_tab[n2].offset) > 0L) {
                fontFileReader.seek_set(tTFDirTabEntry.offset + this.mtx_tab[n2].offset);
                byteArrayOutputStream.write(fontFileReader.readBytes((int)l2));
                n = (int)((long)n + l2);
            }
            ++n2;
        }
        if (this.loca_format == 1) {
            byteArrayOutputStream2.write(this.longToBytes(n));
        } else {
            byteArrayOutputStream2.write(this.shortToBytes(n >> 1));
        }
    }

    protected final void reduceEBLC(FontFileReader fontFileReader, ByteArrayOutputStream byteArrayOutputStream, ByteArrayOutputStream byteArrayOutputStream2, SortedSet sortedSet) throws IOException {
        Object object;
        long l = 4L;
        int n = 48;
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("EBLC");
        TTFDirTabEntry tTFDirTabEntry2 = (TTFDirTabEntry)this.dirTabs.get("EBDT");
        fontFileReader.seek_set(tTFDirTabEntry2.offset);
        byteArrayOutputStream2.write(fontFileReader.readBytes(4));
        fontFileReader.seek_set(tTFDirTabEntry.offset);
        byteArrayOutputStream.write(fontFileReader.readBytes(4));
        int n2 = (int)fontFileReader.readTTFULong();
        long[] lArray = new long[n2];
        long[] lArray2 = new long[n2];
        long[] lArray3 = new long[n2];
        Vector<Integer> vector = new Vector<Integer>();
        int n3 = 0;
        while (n3 < n2) {
            lArray[n3] = fontFileReader.readTTFULong();
            lArray2[n3] = fontFileReader.readTTFULong();
            lArray3[n3] = fontFileReader.readTTFULong();
            fontFileReader.skip(28L);
            int n4 = fontFileReader.readTTFUShort();
            int n5 = fontFileReader.readTTFUShort();
            object = sortedSet.subSet(new Integer(n4), new Integer(n5 + 1));
            if (object.size() > 0) {
                vector.add(new Integer(n3));
            }
            fontFileReader.skip(1L);
            fontFileReader.skip(1L);
            fontFileReader.skip(1L);
            fontFileReader.skip(1L);
            ++n3;
        }
        if (vector.size() == 0) {
            byteArrayOutputStream.reset();
            byteArrayOutputStream2.reset();
            return;
        }
        byteArrayOutputStream.write(this.longToBytes(vector.size()));
        long l2 = 8 + vector.size() * 48;
        object = new ByteArrayOutputStream();
        int n6 = 0;
        while (n6 < vector.size()) {
            int n7;
            int n8 = (Integer)vector.get(n6);
            long l3 = tTFDirTabEntry.offset + lArray[n8];
            fontFileReader.seek_set(l3);
            Vector<Integer> vector2 = new Vector<Integer>();
            int[] nArray = new int[(int)lArray3[n8]];
            int[] nArray2 = new int[(int)lArray3[n8]];
            long[] lArray4 = new long[(int)lArray3[n8]];
            int n9 = 0;
            while ((long)n9 < lArray3[n8]) {
                nArray[n9] = fontFileReader.readTTFUShort();
                nArray2[n9] = fontFileReader.readTTFUShort();
                lArray4[n9] = fontFileReader.readTTFULong();
                SortedSet<Integer> sortedSet2 = sortedSet.subSet(new Integer(nArray[n9]), new Integer(nArray2[n9]));
                if (sortedSet2.size() != 0) {
                    vector2.add(new Integer(n9));
                }
                ++n9;
            }
            long l4 = vector2.size() * 8;
            ByteArrayOutputStream[] byteArrayOutputStreamArray = new ByteArrayOutputStream[vector2.size()];
            int n10 = 0;
            while (n10 < vector2.size()) {
                int n11;
                n7 = (Integer)vector2.get(n10);
                ((OutputStream)object).write(this.shortToBytes(nArray[n7]));
                ((OutputStream)object).write(this.shortToBytes(nArray2[n7]));
                ((OutputStream)object).write(this.longToBytes(l4));
                fontFileReader.seek_set(l3 + lArray4[n7]);
                int n12 = fontFileReader.readTTFUShort();
                int n13 = fontFileReader.readTTFUShort();
                long l5 = fontFileReader.readTTFULong();
                byteArrayOutputStreamArray[n10] = new ByteArrayOutputStream();
                byteArrayOutputStreamArray[n10].write(this.shortToBytes(n12));
                byteArrayOutputStreamArray[n10].write(this.shortToBytes(n13));
                byteArrayOutputStreamArray[n10].write(this.longToBytes(l));
                if (n12 == 1) {
                    long l6 = fontFileReader.readTTFULong();
                    int n14 = 1;
                    while (n14 < nArray2[n7] - nArray[n7] + 1 + 1) {
                        long l7 = fontFileReader.readTTFULong();
                        long l8 = l7 - l6;
                        byte[] byArray = fontFileReader.getBytes((int)(tTFDirTabEntry2.offset + l5 + l6), (int)l8);
                        byteArrayOutputStreamArray[n10].write(this.longToBytes((int)l));
                        byteArrayOutputStream2.write(byArray);
                        l += (long)byArray.length;
                        l6 = l7;
                        ++n14;
                    }
                    byteArrayOutputStreamArray[n10].write(this.longToBytes((int)l));
                } else if (n12 == 2) {
                    long l9 = fontFileReader.readTTFULong();
                    byteArrayOutputStreamArray[n10].write(this.longToBytes(l9));
                    byteArrayOutputStreamArray[n10].write(fontFileReader.readBytes(8));
                    byte[] byArray = fontFileReader.getBytes((int)(tTFDirTabEntry2.offset + l5), (int)l9);
                    byteArrayOutputStream2.write(byArray);
                    l += (long)byArray.length;
                } else if (n12 == 3) {
                    int n15 = fontFileReader.readTTFUShort();
                    int n16 = 0;
                    int n17 = 1;
                    while (n17 < nArray2[n7] - nArray[n7] + 1 + 1) {
                        int n18 = fontFileReader.readTTFUShort();
                        n11 = n18 - n15;
                        n16 += n11;
                        byte[] byArray = fontFileReader.getBytes((int)(tTFDirTabEntry2.offset + l5 + (long)n15), n11);
                        byteArrayOutputStreamArray[n10].write(this.shortToBytes((int)l));
                        byteArrayOutputStream2.write(byArray);
                        l += (long)byArray.length;
                        n15 = n18;
                        ++n17;
                    }
                    byteArrayOutputStreamArray[n10].write(this.shortToBytes((int)l));
                    while (fontFileReader.getCurrentPos() % 4 != 0) {
                        fontFileReader.skip(1L);
                        byteArrayOutputStreamArray[n10].write(0);
                    }
                } else if (n12 == 4) {
                    long l10 = fontFileReader.readTTFULong();
                    byteArrayOutputStreamArray[n10].write(this.longToBytes(l10));
                    int n19 = fontFileReader.readTTFUShort();
                    int n20 = fontFileReader.readTTFUShort();
                    n11 = 1;
                    while ((long)n11 < l10 + 1L) {
                        int n21 = fontFileReader.readTTFUShort();
                        int n22 = fontFileReader.readTTFUShort();
                        int n23 = n22 - n20;
                        byte[] byArray = fontFileReader.getBytes((int)(tTFDirTabEntry2.offset + (long)n20), n23);
                        byteArrayOutputStreamArray[n10].write(this.shortToBytes(n19));
                        byteArrayOutputStreamArray[n10].write(this.shortToBytes((int)l));
                        byteArrayOutputStream2.write(byArray);
                        l += (long)byArray.length;
                        n19 = n21;
                        n20 = n22;
                        ++n11;
                    }
                    byteArrayOutputStreamArray[n10].write(this.shortToBytes(n19));
                    byteArrayOutputStreamArray[n10].write(this.shortToBytes((int)l));
                } else if (n12 == 5) {
                    long l11 = fontFileReader.readTTFULong();
                    byteArrayOutputStreamArray[n10].write(this.longToBytes(l11));
                    byteArrayOutputStreamArray[n10].write(fontFileReader.readBytes(8));
                    long l12 = fontFileReader.readTTFULong();
                    byteArrayOutputStreamArray[n10].write(this.longToBytes(l12));
                    n11 = 0;
                    while ((long)n11 < l12) {
                        int n24 = fontFileReader.readTTFUShort();
                        byteArrayOutputStreamArray[n10].write(this.shortToBytes(n24));
                        ++n11;
                    }
                    while (fontFileReader.getCurrentPos() % 4 != 0) {
                        fontFileReader.skip(1L);
                        byteArrayOutputStreamArray[n10].write(0);
                    }
                    byte[] byArray = fontFileReader.getBytes((int)(tTFDirTabEntry2.offset + l5), (int)l11);
                    byteArrayOutputStream2.write(byArray);
                    l += (long)byArray.length;
                }
                l4 += (long)byteArrayOutputStreamArray[n10].size();
                ++n10;
            }
            n7 = 0;
            while (n7 < vector2.size()) {
                ((OutputStream)object).write(byteArrayOutputStreamArray[n7].toByteArray());
                ++n7;
            }
            long l13 = tTFDirTabEntry.offset + 8L + (long)(n8 * n);
            fontFileReader.seek_set(l13);
            byteArrayOutputStream.write(this.longToBytes(l2));
            byteArrayOutputStream.write(this.longToBytes(((ByteArrayOutputStream)object).size()));
            byteArrayOutputStream.write(this.longToBytes(vector2.size()));
            byteArrayOutputStream.write(this.longToBytes(0L));
            fontFileReader.skip(16L);
            byteArrayOutputStream.write(fontFileReader.readBytes(12));
            byteArrayOutputStream.write(fontFileReader.readBytes(12));
            byteArrayOutputStream.write(fontFileReader.readBytes(2));
            byteArrayOutputStream.write(fontFileReader.readBytes(2));
            byteArrayOutputStream.write(fontFileReader.readBytes(4));
            l2 = 8 + vector.size() * 48 + ((ByteArrayOutputStream)object).size();
            ++n6;
        }
        byteArrayOutputStream.write(((ByteArrayOutputStream)object).toByteArray());
    }

    private final void readKerning(FontFileReader fontFileReader) throws IOException {
        this.kerningTab = new Hashtable();
        this.ansiKerningTab = new Hashtable();
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("kern");
        if (tTFDirTabEntry != null) {
            Hashtable hashtable;
            Object object;
            this.seek_tab(fontFileReader, "kern", 2L);
            int n = fontFileReader.readTTFUShort();
            while (n > 0) {
                fontFileReader.skip(4L);
                int n2 = fontFileReader.readTTFUShort();
                if ((n2 & 1) == 0 || (n2 & 2) != 0 || (n2 & 4) != 0) {
                    System.err.println("Warning: TTF: only Kern format 1 is supported.  This is format " + (n2 & 3));
                    return;
                }
                if (n2 >> 8 != 0) {
                    System.err.println("Warning: TTF: Ignoring this kerning table.");
                } else {
                    n2 = fontFileReader.readTTFUShort();
                    fontFileReader.skip(6L);
                    while (n2-- > 0) {
                        int n3 = fontFileReader.readTTFUShort();
                        int n4 = fontFileReader.readTTFUShort();
                        short s = fontFileReader.readTTFShort();
                        if (s == 0) continue;
                        object = new Integer(n3);
                        hashtable = (Hashtable)this.kerningTab.get(object);
                        if (hashtable == null) {
                            hashtable = new Hashtable();
                        }
                        hashtable.put(new Integer(n4), new Integer(this.get_ttf_funit(s)));
                        this.kerningTab.put(object, hashtable);
                    }
                }
                --n;
            }
            Enumeration enumeration = this.kerningTab.keys();
            while (enumeration.hasMoreElements()) {
                Integer[] integerArray;
                Integer n5;
                Integer n6 = (Integer)enumeration.nextElement();
                Hashtable<Integer, Integer> hashtable2 = new Hashtable<Integer, Integer>();
                Hashtable hashtable3 = (Hashtable)this.kerningTab.get(n6);
                object = hashtable3.keys();
                while (object.hasMoreElements()) {
                    hashtable = (Integer)object.nextElement();
                    n5 = (Integer)hashtable3.get(hashtable);
                    integerArray = this.mtx_tab[((Integer)((Object)hashtable)).intValue()].unicodeIndex.elements();
                    while (integerArray.hasMoreElements()) {
                        Integer n7 = (Integer)integerArray.nextElement();
                        Integer[] integerArray2 = this.unicodeToWinAnsi(n7);
                        int n8 = 0;
                        while (n8 < integerArray2.length) {
                            hashtable2.put(integerArray2[n8], n5);
                            ++n8;
                        }
                    }
                }
                if (hashtable2.size() <= 0) continue;
                hashtable = this.mtx_tab[n6.intValue()].unicodeIndex.elements();
                while (hashtable.hasMoreElements()) {
                    n5 = (Integer)hashtable.nextElement();
                    integerArray = this.unicodeToWinAnsi(n5);
                    int n9 = 0;
                    while (n9 < integerArray.length) {
                        this.ansiKerningTab.put(integerArray[n9], hashtable2);
                        ++n9;
                    }
                }
            }
        }
    }

    public Vector getCMaps() {
        return this.cmaps;
    }

    protected final boolean checkTTC(FontFileReader fontFileReader, String string, boolean bl) throws IOException {
        String string2 = fontFileReader.readTTFString(4);
        if ("ttcf".equals(string2)) {
            fontFileReader.skip(4L);
            int n = (int)fontFileReader.readTTFULong();
            long[] lArray = new long[n];
            int n2 = 0;
            while (n2 < n) {
                lArray[n2] = fontFileReader.readTTFULong();
                ++n2;
            }
            if (bl) {
                System.err.println("This is a TrueType collection file with" + n + " fonts");
                System.err.println("Containing the following fonts: ");
            }
            boolean bl2 = false;
            this.dirTabOffset = 0L;
            int n3 = 0;
            while (n3 < n) {
                fontFileReader.seek_set(lArray[n3]);
                if (!this.readDirTabs(fontFileReader)) {
                    this.addInvalidFileStatusMessage();
                    this.setStatus(2);
                }
                this.readName(fontFileReader);
                if (this.fontName.equals(string)) {
                    if (bl) {
                        System.err.println("* " + this.fullName);
                    }
                    if (this.isUnicode(fontFileReader)) {
                        bl2 = true;
                        this.dirTabOffset = lArray[n3];
                    } else {
                        this.addNoUnicodeStatusMessage();
                        this.setStatus(2);
                    }
                } else if (bl) {
                    System.err.println(this.fullName);
                }
                this.notice = "";
                this.fullName = "";
                this.familyName = "";
                this.fontName = "";
                this.subFamilyName = "";
                ++n3;
            }
            fontFileReader.seek_set(this.dirTabOffset);
            return bl2;
        }
        fontFileReader.seek_set(0L);
        return true;
    }

    protected final boolean checkTTCForFontNames(FontFileReader fontFileReader, List list, boolean bl, boolean bl2) throws IOException {
        String string = fontFileReader.readTTFString(4);
        if ("ttcf".equals(string)) {
            fontFileReader.skip(4L);
            int n = (int)fontFileReader.readTTFULong();
            long[] lArray = new long[n];
            int n2 = 0;
            while (n2 < n) {
                lArray[n2] = fontFileReader.readTTFULong();
                ++n2;
            }
            if (bl) {
                System.err.println("This is a TrueType collection file with" + n + " fonts");
                System.err.println("Containing the following fonts: ");
            }
            boolean bl3 = false;
            int n3 = 0;
            while (n3 < n) {
                fontFileReader.seek_set(lArray[n3]);
                if (!this.readDirTabs(fontFileReader)) {
                    this.addInvalidFileStatusMessage();
                    this.setStatus(2);
                }
                this.readName(fontFileReader);
                if (bl) {
                    System.err.println(this.fullName);
                }
                if (this.isUnicode(fontFileReader)) {
                    if (bl2) {
                        TTFFontNames tTFFontNames = new TTFFontNames();
                        tTFFontNames.fontName = this.fontName;
                        tTFFontNames.fullName = this.fullName;
                        tTFFontNames.familyName = this.familyName;
                        tTFFontNames.subFamilyName = this.subFamilyName;
                        list.add(tTFFontNames);
                    } else {
                        list.add(this.fontName);
                    }
                } else {
                    this.addNoUnicodeStatusMessage();
                    this.setStatus(2);
                }
                this.notice = "";
                this.fullName = "";
                this.familyName = "";
                this.fontName = "";
                this.subFamilyName = "";
                ++n3;
            }
            fontFileReader.seek_set(0L);
            return true;
        }
        fontFileReader.seek_set(0L);
        return false;
    }

    public String getFontName() {
        return this.fontName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getNotice() {
        return this.notice;
    }

    public boolean isFixedPitch() {
        return this.isFixedPitch != 0L;
    }

    public double getVersion() {
        return this.version;
    }

    public int getUnderlinePosition() {
        return this.get_ttf_funit(this.underlinePosition);
    }

    public int getUnderlineThickness() {
        return this.get_ttf_funit(this.underlineThickness);
    }

    private Integer[] unicodeToWinAnsi(int n) {
        Vector<Integer> vector = new Vector<Integer>();
        int n2 = 32;
        while (n2 < Glyphs.winAnsiEncoding.length) {
            if (n == Glyphs.winAnsiEncoding[n2]) {
                vector.addElement(new Integer(n2));
            }
            ++n2;
        }
        Object[] objectArray = new Integer[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }
}

