/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.render;

import com.klg.jclass.page.FontMetricsBase;
import com.klg.jclass.page.JCTextStyle;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.Markup;
import com.klg.jclass.page.render.Render;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;

public class SymbolRender
extends Render
implements Cloneable {
    protected int symbolType;
    protected JCTextStyle style;
    protected int alignment;
    protected JCUnit.Measure leaderStart;
    protected JCUnit.Measure leaderEnd;
    protected int leaderFill;
    public static final int TAB_SYMBOL = 1;
    public static final int NEWLINE_SYMBOL = 2;
    public static final int NEWPARAGRAPH_SYMBOL = 3;

    public SymbolRender() {
        this.symbolType = 0;
        this.style = null;
    }

    public SymbolRender(int n, JCTextStyle jCTextStyle) {
        this.symbolType = n;
        this.style = jCTextStyle;
    }

    public JCTextStyle getStyle() {
        return this.style;
    }

    public void setStyle(JCTextStyle jCTextStyle) {
        this.style = jCTextStyle;
    }

    public int getType() {
        return this.symbolType;
    }

    public void setType(int n) {
        if (n <= 0 || n > 2) {
            throw new IllegalArgumentException("Unrecognised symbol type");
        }
        this.symbolType = n;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public JCUnit.Measure getLeaderStart() {
        return this.leaderStart;
    }

    public void setLeaderStart(JCUnit.Measure measure) {
        this.leaderStart = measure;
    }

    public JCUnit.Measure getLeaderEnd() {
        return this.leaderEnd;
    }

    public void setLeaderEnd(JCUnit.Measure measure) {
        this.leaderEnd = measure;
    }

    public int getLeaderFill() {
        return this.leaderFill;
    }

    public void setLeaderFill(int n) {
        this.leaderFill = n;
    }

    public boolean isAtomic() {
        return true;
    }

    public void draw(Graphics2D graphics2D) {
        if (this.symbolType == 1 && this.leaderFill != 1) {
            String string;
            String string2;
            String string3;
            JCUnit.Measure measure = (JCUnit.Measure)this.leaderEnd.clone();
            measure.subtract(this.leaderStart);
            double d = measure.getAs(JCUnit.POINTS);
            if (this.leaderFill == 2) {
                string3 = "  ";
                string2 = "   ";
                string = " ";
            } else if (this.leaderFill == 3) {
                string3 = ". .";
                string2 = ". . .";
                string = " .";
            } else {
                return;
            }
            Font font = this.style.getFont();
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, string3, graphics2D);
            Rectangle2D rectangle2D2 = FontMetricsBase.getStringBounds(fontMetrics, string2, graphics2D);
            double d2 = rectangle2D.getWidth();
            double d3 = rectangle2D2.getWidth() - d2;
            if (d < d2) {
                return;
            }
            int n = (int)((d - d2) / d3);
            StringBuffer stringBuffer = new StringBuffer(string3);
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(string);
                ++n2;
            }
            String string4 = new String(stringBuffer);
            rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, string4, graphics2D);
            double d4 = rectangle2D.getWidth();
            float f = (float)this.leaderStart.getAs(JCUnit.POINTS);
            f = (float)((double)f + (double)((float)(d - d4)) / 2.0);
            float f2 = (float)JCUnit.getAsPoints(this.origin.units, this.origin.y);
            AttributedString attributedString = new AttributedString(string4);
            int n3 = string4.length();
            attributedString.addAttribute(TextAttribute.SIZE, new Float(this.style.getPointSize()), 0, n3);
            if (this.leaderFill == 2) {
                attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, 0, n3);
            }
            graphics2D.setColor(this.style.getColor());
            graphics2D.drawString(attributedString.getIterator(), f, f2);
        } else if (this.symbolType == 2 && graphics2D instanceof Markup) {
            ((Markup)((Object)graphics2D)).newLine();
        } else if (this.symbolType == 3 && graphics2D instanceof Markup) {
            ((Markup)((Object)graphics2D)).newParagraph();
        }
    }

    public Object clone() {
        SymbolRender symbolRender = (SymbolRender)super.clone();
        if (this.leaderStart != null) {
            symbolRender.leaderStart = (JCUnit.Measure)this.leaderStart.clone();
        }
        if (this.leaderEnd != null) {
            symbolRender.leaderEnd = (JCUnit.Measure)this.leaderEnd.clone();
        }
        return symbolRender;
    }
}

