/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.awt;

import com.klg.jclass.page.JCDocument;
import com.klg.jclass.page.JCPage;
import com.klg.jclass.page.JCPrinter;
import com.klg.jclass.util.JCEnvironment;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.List;
import java.util.Stack;

public class JCAWTPrinter
extends JCPrinter {
    protected PrinterThread printerThread;
    protected Thread thread;
    protected PrinterJob printerJob;
    protected boolean actuallyPrinting;
    protected JCDocument document;
    protected boolean showDialog = true;
    protected Stack clipStack = new Stack();
    protected PageFormat pageFormat = new PageFormat();
    protected boolean abort = false;
    protected int firstToPrint = -1;
    protected int lastToPrint = -1;
    protected PrinterException threadException = null;
    protected JCPage firstPage = null;
    protected boolean updatePageFormat = false;

    public JCAWTPrinter() throws PrinterJobCancelledException, PrinterException {
        this(true);
    }

    public JCAWTPrinter(boolean bl) throws PrinterJobCancelledException, PrinterException {
        this.showDialog = bl;
        Paper paper = new Paper();
        paper.setImageableArea(0.0, 0.0, 612.0, 792.0);
        this.pageFormat.setPaper(paper);
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (graphics2D == null) {
            if (this.threadException != null) {
                throw this.threadException;
            }
            throw new PrinterJobCancelledException();
        }
    }

    public JCAWTPrinter(List list) throws PrinterJobCancelledException, PrinterException {
        this(list, true);
    }

    public JCAWTPrinter(List list, boolean bl) throws PrinterJobCancelledException, PrinterException {
        this(null, null, list, bl);
    }

    public JCAWTPrinter(PageFormat pageFormat) throws PrinterJobCancelledException, PrinterException {
        this(pageFormat, true);
    }

    public JCAWTPrinter(PageFormat pageFormat, boolean bl) throws PrinterJobCancelledException, PrinterException {
        this(null, pageFormat, null, bl);
    }

    public JCAWTPrinter(PageFormat pageFormat, List list) throws PrinterJobCancelledException, PrinterException {
        this(pageFormat, list, true);
    }

    public JCAWTPrinter(PageFormat pageFormat, List list, boolean bl) throws PrinterJobCancelledException, PrinterException {
        this(null, pageFormat, list, bl);
    }

    public JCAWTPrinter(PrinterJob printerJob, PageFormat pageFormat) throws PrinterJobCancelledException, PrinterException {
        this(printerJob, pageFormat, true);
    }

    public JCAWTPrinter(PrinterJob printerJob, PageFormat pageFormat, boolean bl) throws PrinterJobCancelledException, PrinterException {
        this(printerJob, pageFormat, null, bl);
    }

    public JCAWTPrinter(PrinterJob printerJob, PageFormat pageFormat, List list) throws PrinterJobCancelledException, PrinterException {
        this(printerJob, pageFormat, list, true);
    }

    public JCAWTPrinter(PrinterJob printerJob, PageFormat pageFormat, List list, boolean bl) throws PrinterJobCancelledException, PrinterException {
        Object object;
        this.showDialog = bl;
        if (printerJob != null) {
            this.printerJob = printerJob;
        }
        if (pageFormat != null) {
            this.pageFormat = pageFormat;
        }
        if (list != null) {
            this.updatePageFormat = true;
            if (list.size() > 0) {
                this.firstPage = object = (JCPage)list.get(0);
            }
        }
        if ((object = (Graphics2D)this.getGraphics()) == null) {
            if (this.threadException != null) {
                throw this.threadException;
            }
            throw new PrinterJobCancelledException();
        }
    }

    public void setup() {
    }

    public boolean isImageScalable() {
        return false;
    }

    public void registerDocument(JCDocument jCDocument) {
        this.document = jCDocument;
    }

    public void registerFirstLast(int n, int n2) {
        this.firstToPrint = n;
        this.lastToPrint = n2;
    }

    public synchronized void openDocument(Rectangle2D rectangle2D) {
        if (this.printerThread == null) {
            this.getGraphics();
        }
        if (!this.actuallyPrinting) {
            this.actuallyPrinting = true;
            this.printerThread.wakeUp();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void openDocument(Rectangle2D rectangle2D, boolean bl) {
        super.openDocument(rectangle2D);
    }

    protected synchronized void wakeUpMainThread() {
        this.notifyAll();
    }

    protected synchronized void clearThread() {
        this.printerThread = null;
        this.graphics = null;
    }

    public void print(JCDocument jCDocument) {
        this.document = jCDocument;
        this.actuallyPrinting = true;
        this.printerThread.wakeUp();
    }

    public synchronized void closeDocument(Rectangle2D rectangle2D) {
    }

    public void closeDocument(Rectangle2D rectangle2D, boolean bl) {
        super.closeDocument(rectangle2D);
    }

    public void beginPage(Rectangle2D rectangle2D, int n) {
    }

    public void endPage(Rectangle2D rectangle2D) {
    }

    protected void initPrinterJob() {
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        this.printerThread = new PrinterThread(this.printerJob);
        if (this.updatePageFormat && this.firstPage != null) {
            this.updatePageFormat(this.firstPage);
            this.firstPage = null;
        }
        this.printerJob.setPrintable(this.printerThread, this.pageFormat);
    }

    protected void updatePageFormat(JCPage jCPage) {
        Paper paper = this.pageFormat.getPaper();
        if (paper == null) {
            paper = new Paper();
        }
        this.setOrientation(jCPage.getOrientation());
        Rectangle2D rectangle2D = jCPage.getPageSize();
        if (this.isLandscape(rectangle2D.getWidth(), rectangle2D.getHeight())) {
            this.pageFormat.setOrientation(0);
            paper.setImageableArea(rectangle2D.getY(), rectangle2D.getX(), rectangle2D.getHeight(), rectangle2D.getWidth());
            paper.setSize(rectangle2D.getHeight(), rectangle2D.getWidth());
        } else {
            this.pageFormat.setOrientation(1);
            paper.setImageableArea(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            paper.setSize(rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        this.pageFormat.setPaper(paper);
    }

    public Graphics getGraphics() {
        if (this.graphics == null) {
            this.initPrinterJob();
            if (this.showDialog && !this.printerJob.printDialog()) {
                return null;
            }
            this.thread = new Thread((Runnable)this.printerThread, "PageLayout print thread");
            this.thread.start();
            while (this.graphics == null && !this.abort) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
        return this.graphics;
    }

    protected void printPage(JCDocument jCDocument, int n) {
        super.beginPage(null, n);
        JCPage jCPage = (JCPage)jCDocument.getPages().get(n);
        jCPage.draw((Graphics2D)this.getGraphics());
        super.endPage(null);
    }

    protected void setGraphics(Graphics2D graphics2D) {
        this.graphics = graphics2D;
        if (JCEnvironment.getJavaVersion() < 130) {
            this.graphics.translate(-13, -13);
        }
    }

    public void setShowDialog(boolean bl) {
    }

    public boolean getShowDialog() {
        return this.showDialog;
    }

    public void cancel() {
        this.abort = true;
        if (this.printerJob != null) {
            this.printerJob.cancel();
            if (this.printerThread != null) {
                this.printerThread.wakeUp();
            }
        }
    }

    public void cancelFromPrinterThread(PrinterException printerException) {
        this.abort = true;
        this.threadException = printerException;
        if (this.printerJob != null) {
            this.printerJob.cancel();
        }
    }

    public static class PrinterJobCancelledException
    extends Exception {
        public PrinterJobCancelledException() {
            super("User elected not to print");
        }
    }

    protected class PrinterThread
    implements Runnable,
    Printable {
        protected PrinterJob pj;
        protected int copies;
        protected int first;
        protected int last;
        protected int pageCount;
        protected boolean collate;
        protected boolean reverse;
        protected int currentPage;
        protected int lastPageIndex = -1;
        protected int pageIncr = 1;
        protected int numPages;
        protected boolean firstPass = true;

        public PrinterThread(PrinterJob printerJob) {
            this.pj = printerJob;
        }

        public void run() {
            try {
                this.firstPass = true;
                this.pj.print();
                JCAWTPrinter.this.clearThread();
                JCAWTPrinter.this.wakeUpMainThread();
            }
            catch (PrinterException printerException) {
                JCAWTPrinter.this.clearThread();
                JCAWTPrinter.this.cancelFromPrinterThread(printerException);
            }
        }

        public synchronized int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            int n2 = 0;
            if (JCEnvironment.isWorking("PrintingUse2ndCall") == 1 && this.firstPass) {
                this.firstPass = false;
                this.lastPageIndex = n;
                return n2;
            }
            JCAWTPrinter.this.setGraphics((Graphics2D)graphics);
            try {
                if (!JCAWTPrinter.this.actuallyPrinting) {
                    this.wait();
                    if (JCAWTPrinter.this.abort) {
                        return 1;
                    }
                    JCAWTPrinter.this.openDocument(null, true);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.reverse) {
                this.currentPage = this.copies == 1 ? this.first + n : (this.collate ? this.first + n % this.pageCount : this.first + n / this.copies);
                this.pageIncr = 1;
            } else {
                this.currentPage = this.copies == 1 ? this.first - n : (this.collate ? this.first - n % this.pageCount : this.first - n / this.copies);
                this.pageIncr = -1;
            }
            if (n < this.numPages) {
                boolean bl;
                JCAWTPrinter.this.printPage(JCAWTPrinter.this.document, this.currentPage);
                boolean bl2 = bl = JCAWTPrinter.this.updatePageFormat && n + 1 < this.numPages;
                if (bl && JCEnvironment.isWorking("PrintingUse2ndCall") == 1 && this.lastPageIndex != n) {
                    bl = false;
                }
                if (bl) {
                    JCPage jCPage = (JCPage)JCAWTPrinter.this.document.getPages().get(this.currentPage + this.pageIncr);
                    JCAWTPrinter.this.updatePageFormat(jCPage);
                }
            } else {
                n2 = 1;
                JCAWTPrinter.this.actuallyPrinting = false;
                JCAWTPrinter.this.closeDocument(null, true);
            }
            this.lastPageIndex = n;
            return n2;
        }

        public synchronized void wakeUp() {
            this.copies = JCAWTPrinter.this.getNumCopies();
            if (this.copies <= 0) {
                this.copies = 1;
            }
            this.collate = JCAWTPrinter.this.getCollate();
            this.reverse = JCAWTPrinter.this.getReverseOrder();
            this.first = JCAWTPrinter.this.firstToPrint;
            this.last = JCAWTPrinter.this.lastToPrint;
            this.pageCount = JCAWTPrinter.this.document.getPages().size();
            if (!this.reverse) {
                if (this.first < 0) {
                    this.first = 0;
                }
                if (this.last == -1 || this.last >= this.pageCount) {
                    this.last = this.pageCount - 1;
                }
                if (this.first > this.last) {
                    this.first = this.last;
                }
                this.pageCount = this.last - this.first + 1;
                this.numPages = this.pageCount * this.copies;
            } else {
                if (this.last < 0) {
                    this.last = 0;
                }
                if (this.first == -1 || this.first >= this.pageCount) {
                    this.first = this.pageCount - 1;
                }
                if (this.last > this.first) {
                    this.last = this.first;
                }
                this.pageCount = this.first - this.last + 1;
                this.numPages = this.pageCount * this.copies;
            }
            this.currentPage = -1;
            this.notifyAll();
        }
    }
}

