/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.adobe.postscript;

import com.klg.jclass.page.FontParser;
import com.klg.jclass.page.Graphics2DBase;
import com.klg.jclass.page.JCPrinter;
import com.klg.jclass.page.adobe.postscript.FontPS;
import com.klg.jclass.page.adobe.postscript.Graphics2DPS;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.io.OutputStream;
import java.util.Date;

public class JCPostScriptPrinter
extends JCPrinter {
    public static final int ENCODING_ISO_LATIN_1 = 0;
    public static final int ENCODING_ISO_LATIN_1_EURO = 1;
    static String std_PS_headers = "%!PS-Adobe-3.0\n%%PageOrder: Ascend\n%%DocumentData: Clean7Bit\n%%Pages: (atend)\n%%BoundingBox: (atend)\n%%Creator: PageLayout 6.x";
    static String std_PS_prologue_begin = "%%EndComments\n%%BeginProlog\n%\n% This document produced by PageLayout 6.x\n%\n% PageLayout is a trademark of Quest Software Inc.\n% Copyright (c) 2003 by Quest Software Inc.\n% All rights reserved.\n%\n%%BeginResource: procset KlgPfglobals\n\t/PFLevel1\n\t\t/languagelevel where {\n\t\t\tpop languagelevel\n\t\t} {\n\t\t\t1\n\t\t} ifelse\n\t\t2 lt def\n\t/PFBeginPage {\n\t\t/pgsave save def\n\t\tKlgPfDict begin\n\t} def\n\t/PFEndPage {\n\t\tend\n\t\tpgsave restore\n\t\tshowpage\n\t} def\n\t/PfOutputError {\n\t\tdup = flush\n\t\tshowpage\n\t\t/Helvetica findfont 12 scalefont setfont\n\t\t72 200 moveto show\n\t\tshowpage\n\t\tquit\n\t} def\n\t/PFEpsfError {\n\t\t(Command X must not be called from an EPS file)\n\t\t(X) search pop dup length index 4 putinterval\n\t\tdup length index 3 putinterval\n\t\t4 1 roll pop pop pop\n\t\tPFOutputError\n\t} def\n\t/PFBeginEpsf {\n\t\tend\n\t\t/Epsfsave save def\n\t\t/dict_count countdictstack def\n\t\t/op_count count 1 sub def\n\t\tuserdict begin\n\t\t/showpage {} def\n\t\t/banddevice {(banddevice) PFEpsfError} def\n\t\t/clear {(clear) PFEpsfError} def\n\t\t/cleardictstack {(cleardictstack) PFEpsfError} def\n\t\t/copypage {(copypage) PFEpsfError} def\n\t\t/erasepage {(erasepage) PFEpsfError} def\n\t\t/exitserver {(exitserver) PFEpsfError} def\n\t\t/framedevice {(framedevice) PFEpsfError} def\n\t\t/grestoreall {(grestoreall) PFEpsfError} def\n\t\t/initclip {(initclip) PFEpsfError} def\n\t\t/initgraphics {(initgraphics) PFEpsfError} def\n\t\t/initmatrix {(initmatrix) PFEpsfError} def\n\t\t/quit {(quit) PFEpsfError} def\n\t\t/renderbands {(renderbands) PFEpsfError} def\n\t\t/setglobal {(setglobal) PFEpsfError} def\n\t\t/setpagedevice {(setpagedevice) PFEpsfError} def\n\t\t/setshared {(setshared) PFEpsfError} def\n\t\t/startjob {(startjob) PFEpsfError} def\n\t\t/lettertray {(lettertray) PFEpsfError} def\n\t\t/letter {(letter) PFEpsfError} def\n\t\t/lettersmall {(lettersmall) PFEpsfError} def\n\t\t/11x17tray {(11x17tray) PFEpsfError} def\n\t\t/11x17 {(11x17) PFEpsfError} def\n\t\t/ledgertray {(ledgertray) PFEpsfError} def\n\t\t/ledger {(ledger) PFEpsfError} def\n\t\t/legaltray {(legaltray) PFEpsfError} def\n\t\t/legal {(legal) PFEpsfError} def\n\t\t/statementtray {(statementtray) PFEpsfError} def\n\t\t/statement {(statement) PFEpsfError} def\n\t\t/executivetray {(executivetray) PFEpsfError} def\n\t\t/executive {(executive) PFEpsfError} def\n\t\t/a3tray {(a3tray) PFEpsfError} def\n\t\t/a3 {(a3) PFEpsfError} def\n\t\t/a4tray {(a4tray) PFEpsfError} def\n\t\t/a4 {(a4) PFEpsfError} def\n\t\t/a4small {(a4small) PFEpsfError} def\n\t\t/b4tray {(b4tray) PFEpsfError} def\n\t\t/b4 {(b4) PFEpsfError} def\n\t\t/b5tray {(b5tray) PFEpsfError} def\n\t\t/b5 {(b5) PFEpsfError} def\n\t\t0 setgray\n\t\t0 setlinecap\n\t\t1 setlinewidth\n\t\t0 setlinejoin\n\t\t10 setmiterlimit\n\t\t[ ] 0 setdash\n\t\tnewpath\n\t\tPFLevel1 not {\n\t\t\tfalse setoverprint false setstrokeadjust\n\t\t} if\n\t} bind def\n\t/PFEndEpsf {\n\t\tcount op_count sub { pop } repeat\n\t\tcountdictstack dict_count sub { end } repeat\n\t\tEpsfsave restore\n\t\tKlgPfDict begin\n\t} bind def\n%%EndResource\n%%BeginResource: procset KlgPfDict\n\t/KlgPfDict 100 dict dup begin\n\t\t/bd {\n\t\t\tbind def\n\t\t} bind def\n\t\t/dla {\n\t\t\tnewpath 4 2 roll moveto lineto stroke\n\t\t} bd\n\t\t/st {\n\t\t\tmoveto show\n\t\t} bd\n\t\t/PFrect {\n\t\t\tnewpath\n\t\t\t4 2 roll moveto\n\t\t\t1 index 0 rlineto\n\t\t\t0 exch rlineto\n\t\t\tneg 0 rlineto\n\t\t\tclosepath\n\t\t} bd\n\t\t/rc {\n\t\t\tPFLevel1 {\n\t\t\t\tPFrect\n\t\t\t\tclip\n\t\t\t\tnewpath\n\t\t\t} {\n\t\t\t\trectclip\n\t\t\t} ifelse\n\t\t} bd\n\t\t/rf {\n\t\t\tPFLevel1 {\n\t\t\t\tgsave\n\t\t\t\tPFrect\n\t\t\t\tfill\n\t\t\t\tgrestore\n\t\t\t} {\n\t\t\t\trectfill\n\t\t\t} ifelse\n\t\t} bd\n\t\t/rs {\n\t\t\tPFLevel1 {\n\t\t\t\tgsave\n\t\t\t\tPFrect\n\t\t\t\tstroke\n\t\t\t\tgrestore\n\t\t\t} {\n\t\t\t\trectstroke\n\t\t\t} ifelse\n\t\t} bd\n\t\t/sf {\n\t\t\tPFLevel1 {\n\t\t\t\texch findfont exch scalefont setfont\n\t\t\t} {\n\t\t\t\tselectfont\n\t\t\t} ifelse\n\t\t} bd\n\t\t/iso {\t\t% iso-fontname fontname |- -\n\t\t\tfindfont\n\t\t\tdup length dict begin\n\t\t\t\t{1 index /FID ne {def} {pop pop} ifelse} forall";
    static String std_PS_prologue_encoding_isolatin = "\t\t\t\t/Encoding ISOLatin1Encoding def";
    static String std_PS_prologue_encoding_euro = "                /Encoding [\n                  /.notdef /.notdef /.notdef /.notdef /.notdef\n                  /.notdef /.notdef /.notdef /.notdef /.notdef\n                  /.notdef /.notdef /.notdef /.notdef /.notdef\n                  /.notdef /.notdef /.notdef /.notdef /.notdef\n                  /.notdef /.notdef /.notdef /.notdef /.notdef\n                  /.notdef /.notdef /.notdef /.notdef /.notdef\n                  /.notdef /.notdef /space /exclam /quotedbl\n                  /numbersign /dollar /percent /ampersand\n                  /quoteright /parenleft /parenright /asterisk\n                  /plus /comma /minus /period /slash /zero\n                  /one /two /three /four /five /six /seven\n                  /eight /nine /colon /semicolon /less /equal\n                  /greater /question /at /A /B /C /D /E /F /G\n                  /H /I /J /K /L /M /N /O /P /Q /R /S /T /U /V\n                  /W /X /Y /Z /bracketleft /backslash\n                  /bracketright /asciicircum /underscore\n                  /quoteleft /a /b /c /d /e /f /g /h /i /j /k\n                  /l /m /n /o /p /q /r /s /t /u /v /w /x /y /z\n                  /braceleft /bar /braceright /asciitilde\n                  /.notdef /Euro /.notdef /.notdef /.notdef\n                  /.notdef /.notdef /.notdef /.notdef /.notdef\n                  /.notdef /.notdef /.notdef /.notdef /.notdef\n                  /.notdef /.notdef /dotlessi /grave /acute\n                  /circumflex /tilde /macron /breve /dotaccent\n                  /dieresis /.notdef /ring /cedilla /.notdef\n                  /hungarumlaut /ogonek /caron /space\n                  /exclamdown /cent /sterling /currency /yen\n                  /brokenbar /section /dieresis /copyright\n                  /ordfeminine /guillemotleft /logicalnot\n                  /hyphen /registered /macron /degree\n                  /plusminus /twosuperior /threesuperior\n                  /acute /mu /paragraph /periodcentered\n                  /cedilla /onesuperior /ordmasculine\n                  /guillemotright /onequarter /onehalf\n                  /threequarters /questiondown /Agrave\n                  /Aacute /Acircumflex /Atilde /Adieresis\n                  /Aring /AE /Ccedilla /Egrave /Eacute\n                  /Ecircumflex /Edieresis /Igrave /Iacute\n                  /Icircumflex /Idieresis /Eth /Ntilde\n                  /Ograve /Oacute /Ocircumflex /Otilde\n                  /Odieresis /multiply /Oslash /Ugrave\n                  /Uacute /Ucircumflex /Udieresis /Yacute\n                  /Thorn /germandbls /agrave /aacute\n                  /acircumflex /atilde /adieresis /aring\n                  /ae /ccedilla /egrave /eacute /ecircumflex\n                  /edieresis /igrave /iacute /icircumflex\n                  /idieresis /eth /ntilde /ograve /oacute\n                  /ocircumflex /otilde /odieresis /divide\n                  /oslash /ugrave /uacute /ucircumflex\n                  /udieresis /yacute /thorn /ydieresis\n                ] def";
    static String std_PS_prologue_after_encoding = "\t\t\t\tcurrentdict\n\t\t\tend\n\t\t\tdefinefont pop\n\t\t} bd\n\tend def\n%%EndResource";
    static String std_PS_prologue_end = "%%EndProlog";
    protected int characterEncoding = 0;

    public JCPostScriptPrinter(OutputStream outputStream) {
        this.setOutputStream(outputStream);
        FontPS.getAllFonts();
    }

    public JCPostScriptPrinter(OutputStream outputStream, FontParser fontParser, String string, String string2, String string3) {
        this.os = outputStream;
        FontPS.getAllFonts(fontParser, string, string2, string3);
    }

    public void setup() {
    }

    public boolean isImageScalable() {
        return true;
    }

    public void setCharacterEncoding(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("PostScript Character Encoding must be one of ENCODING_ISO_LATIN_1 or ENCODING_ISO_LATIN_1_EURO");
        }
        this.characterEncoding = n;
    }

    public int getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void openDocument(Rectangle2D rectangle2D) {
        super.openDocument(rectangle2D);
        this.output(std_PS_headers);
        this.output("%%CreationDate: " + new Date().toString());
        this.output(std_PS_prologue_begin);
        if (this.characterEncoding == 1) {
            this.output(std_PS_prologue_encoding_euro);
        } else {
            this.output(std_PS_prologue_encoding_isolatin);
        }
        this.output(std_PS_prologue_after_encoding);
        this.output(std_PS_prologue_end);
    }

    public void closeDocument(Rectangle2D rectangle2D) {
        this.output("%%Trailer");
        this.output("%%Pages: " + this.pageCount);
        this.output("%%EOF");
        ((Graphics2DPS)this.graphics).setFinishedOutput(true);
        super.closeDocument(rectangle2D);
        this.graphics.dispose();
    }

    public void beginPage(Rectangle2D rectangle2D, int n) {
        super.beginPage(rectangle2D, n);
        ((Graphics2DPS)this.getGraphics()).flushLoadedFonts();
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        this.output("%%Page: " + n + " " + ++this.pageCount);
        this.output("%%BeginPageSetup");
        this.output("PFBeginPage");
        this.output("%%EndPageSetup");
        if (this.isLandscape(d3, d4)) {
            this.output("90 rotate");
            d2 = -d2;
        } else {
            d2 = d4 + d2;
        }
        this.output(d + " " + d2 + " translate");
        this.output("0.0 0.0 " + d3 + " " + -d4 + " rc");
    }

    public void endPage(Rectangle2D rectangle2D) {
        this.output("%%PageTrailer");
        this.output("PFEndPage");
        super.endPage(rectangle2D);
    }

    public Graphics getGraphics() {
        if (this.graphics == null) {
            this.graphics = new Graphics2DPS(this.os, this);
            ((Graphics2DBase)this.graphics).setFrameRoot();
        }
        return this.graphics;
    }
}

