/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.adobe.pdf;

import com.klg.jclass.page.EPSImage;
import com.klg.jclass.page.FontLibrary;
import com.klg.jclass.page.Graphics2DBase;
import com.klg.jclass.page.adobe.pdf.AcroFontEntry;
import com.klg.jclass.page.adobe.pdf.Ascii85OutputStream;
import com.klg.jclass.page.adobe.pdf.JCPDFPrinter;
import com.klg.jclass.page.adobe.postscript.CharMetricPS;
import com.klg.jclass.page.adobe.postscript.FontMetricsPS;
import com.klg.jclass.page.adobe.postscript.FontPS;
import com.klg.jclass.page.adobe.postscript.PairKern;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Set;
import java.util.zip.DeflaterOutputStream;

public class Graphics2DPDF
extends Graphics2DBase {
    protected JCPDFPrinter printer;
    protected AffineTransform pdfTransform = new AffineTransform();
    protected static final char[] hd = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected Color currentLineColor = null;
    protected boolean lineColorChanged = true;
    protected Color currentFillColor = null;
    protected boolean fillColorChanged = true;
    protected Paint currentPaint = null;
    protected static Hashtable convertedFonts = new Hashtable();
    protected int patternIndex = 0;

    public Graphics2DPDF(OutputStream outputStream, JCPDFPrinter jCPDFPrinter) {
        super(outputStream);
        this.printer = jCPDFPrinter;
    }

    public void drawString(String string, float f, float f2) {
        if (string == null || string.equals("")) {
            return;
        }
        this.updateContext();
        f2 = -f2;
        CharMetricPS charMetricPS = null;
        this.outputCurrentPaint("rg");
        this.initializeOutString(f, f2);
        this.printer.streamInfo.textPresent = true;
        this.output("BT");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(f);
        stringBuffer.append(" ");
        stringBuffer.append(f2);
        stringBuffer.append(" Td");
        this.output(stringBuffer.toString());
        FontPS fontPS = (FontPS)this.getFont();
        String string2 = this.getFont().getName();
        AcroFontEntry acroFontEntry = this.printer.getFontEntry(string2);
        boolean bl = false;
        if (acroFontEntry.usingTTF) {
            bl = acroFontEntry.expectedCharacterRange == 0;
        }
        Set set = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = -1;
        int n2 = 0;
        while (n2 < string.length()) {
            Object object;
            int n3;
            int n4 = string.charAt(n2);
            if (n4 == 8364 && (acroFontEntry.expectedCharacterRange == 1 || acroFontEntry.expectedCharacterRange == 0)) {
                n3 = 128;
            } else if (n4 > 255 && acroFontEntry.expectedCharacterRange == 1) {
                System.err.println("Warning: expecting single-byte character, found multi-byte character 0x" + Integer.toHexString(n4));
                n3 = n4 = 32;
            } else {
                n3 = n4;
            }
            boolean bl5 = bl3 = n3 > 255;
            if (acroFontEntry.usingTTF && (bl && bl3 || !bl && acroFontEntry.usingUnicode) && (n = fontPS.ttfParser.unicodeToGlyphCode(n4)) < 0) {
                n = 0;
            }
            CharMetricPS charMetricPS2 = fontPS.getCharMetric((char)n4);
            if (charMetricPS != null) {
                object = null;
                object = acroFontEntry.usingTTF ? charMetricPS.getKernByUnicode(charMetricPS2.getCode()) : charMetricPS.getKernByName(charMetricPS2.getName());
                boolean bl6 = false;
                if (object != null && ((PairKern)object).xAmount != 0) {
                    this.endTextSegment(bl2);
                    if (bl) {
                        bl6 = bl4 != bl3;
                    }
                    this.addKerning(((PairKern)object).xAmount, bl2, !bl6);
                }
                if (bl && bl4 != bl3) {
                    this.printOutString(bl2, !bl6);
                    this.out.text.delete(0, this.out.text.length());
                }
            }
            if (charMetricPS == null || bl && bl4 != bl3) {
                if (bl) {
                    bl2 = bl3;
                    if (bl3) {
                        acroFontEntry.usingUnicode = true;
                    } else {
                        acroFontEntry.usingAnsi = true;
                    }
                    this.loadFont(string2, bl3);
                    set = bl3 ? acroFontEntry.unicodeCharactersUsed : acroFontEntry.ansiCharactersUsed;
                } else {
                    bl2 = acroFontEntry.usingUnicode;
                    this.loadFont(string2, acroFontEntry.usingUnicode);
                    set = acroFontEntry.usingUnicode ? acroFontEntry.unicodeCharactersUsed : acroFontEntry.ansiCharactersUsed;
                }
            }
            if (bl2 && acroFontEntry.usingTTF) {
                object = new Integer(n);
                if (!set.contains(object)) {
                    set.add(object);
                    Integer n5 = new Integer(charMetricPS2.getWx());
                    Integer n6 = (Integer)acroFontEntry.unicodeWidths.get(n5);
                    if (n6 == null) {
                        acroFontEntry.unicodeWidths.put(n5, new Integer(1));
                    } else {
                        acroFontEntry.unicodeWidths.put(n5, new Integer(n6 + 1));
                    }
                }
                this.appendToOutString(n, charMetricPS2.getWx(), fontPS, bl2);
            } else {
                set.add(new Integer(n3));
                this.appendToOutString(n3, charMetricPS2.getWx(), fontPS, bl2);
            }
            charMetricPS = charMetricPS2;
            bl4 = bl3;
            ++n2;
        }
        this.printOutString(bl2, true);
        this.output("ET");
        if (this.underline) {
            double d = FontMetricsPS.asPoints(fontPS.getUnderlineThickness(), fontPS.getSize());
            this.setStroke(new BasicStroke((float)d));
            f2 = (float)((double)(-f2) - FontMetricsPS.asPoints(fontPS.getUnderlinePosition(), fontPS.getSize()));
            this.drawLinePW(f, f2, this.out.x, f2);
        }
    }

    public void translate(int n, int n2) {
        this.translate((double)n, (double)n2);
    }

    public void translate(double d, double d2) {
        this.transform.translate(d, d2);
        this.pdfTransform.translate(d, d2);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(-d, -d2);
        this.clip = affineTransform.createTransformedShape(this.clip);
        if (this.isContextCurrent()) {
            this.output("1 0 0 1 " + this.truncateDecimalDigits(d) + " " + this.truncateDecimalDigits(-d2) + " cm");
        }
    }

    public void scale(double d, double d2) {
        this.transform.scale(d, d2);
        this.pdfTransform.scale(d, d2);
        AffineTransform affineTransform = AffineTransform.getScaleInstance(1.0 / d, 1.0 / d2);
        this.clip = affineTransform.createTransformedShape(this.clip);
        if (this.isContextCurrent()) {
            this.output(this.truncateDecimalDigits(d) + " 0 0 " + this.truncateDecimalDigits(d2) + " 0 0 cm");
        }
    }

    public void rotate(double d) {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(-d);
        this.clip = affineTransform.createTransformedShape(this.clip);
        this.transform.rotate(d);
        d = Math.PI * 2 - d;
        this.pdfTransform.rotate(d);
        if (this.isContextCurrent()) {
            this.output(this.truncateDecimalDigits(Math.cos(d)) + " " + this.truncateDecimalDigits(Math.sin(d)) + " " + this.truncateDecimalDigits(-1.0 * Math.sin(d)) + " " + this.truncateDecimalDigits(Math.cos(d)) + " " + " 0 0 cm");
        }
    }

    public void rotate(double d, double d2, double d3) {
        this.translate(d2, d3);
        this.rotate(d);
        this.translate(-d2, -d3);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.clipRect((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void clipRect(double d, double d2, double d3, double d4) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        if (this.clipSet) {
            Shape shape = null;
            if (this.clip instanceof Rectangle2D) {
                shape = new Rectangle2D.Double();
                Rectangle2D.intersect((Rectangle2D)this.clip, double_, shape);
            } else {
                Area area = new Area(this.clip);
                area.intersect(new Area(double_));
                shape = new GeneralPath();
                ((GeneralPath)shape).append(area, false);
            }
            this.clip = shape;
        } else {
            this.clip = double_;
            this.clipSet = true;
        }
        if (this.isContextCurrent()) {
            this.outputClip();
        }
    }

    public void setPaint(Paint paint) {
        this.currentPaint = paint;
        if (paint == null || paint instanceof Color) {
            this.setColor((Color)paint);
        } else if (paint instanceof GradientPaint) {
            this.setColor(((GradientPaint)paint).getColor1());
        }
    }

    public Paint getPaint() {
        return this.currentPaint != null ? this.currentPaint : this.getColor();
    }

    public void setColor(Color color) {
        super.setColor(color);
        this.currentPaint = color;
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.updateContext();
        this.outputCurrentPaint("RG");
        this.setLineStroke();
        this.output(nArray[0] + " " + -nArray2[0] + " m");
        int n2 = 1;
        while (n2 < n) {
            this.output(nArray[n2] + " " + -nArray2[n2] + " l");
            ++n2;
        }
        this.output("S");
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.printPolygon(nArray, nArray2, n, "S");
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.printPolygon(nArray, nArray2, n, "f");
    }

    public void setFont(Font font) {
        Object object;
        this.updateContext();
        if (!(font instanceof FontPS)) {
            if (convertedFonts.containsKey(font)) {
                font = (FontPS)convertedFonts.get(font);
            } else {
                object = font;
                try {
                    font = FontPS.getNativeFont((Font)object);
                }
                catch (NullPointerException nullPointerException) {
                    this.addFont((Font)object);
                    font = FontPS.getNativeFont((Font)object);
                }
                convertedFonts.put(object, font);
            }
        }
        if (this.currentFont != null && this.currentFont.equals(font) && this.currentFont.getStyle() == font.getStyle() && this.currentFont.getSize() == font.getSize()) {
            return;
        }
        this.currentFont = font;
        this.fontChanged = true;
        object = font.getName();
        Object v = this.printer.fontList.get(object);
        if (v == null) {
            this.printer.addFontToList((FontPS)font);
        }
        this.printer.getFontAbbreviation((String)object);
    }

    public FontMetrics getFontMetrics(Font font) {
        if (!(font instanceof FontPS)) {
            if (convertedFonts.containsKey(font)) {
                font = (FontPS)convertedFonts.get(font);
            } else {
                if (!this.printer.fontList.containsKey(font.getName())) {
                    this.setFont(font);
                }
                Font font2 = font;
                font = FontPS.getNativeFont(font2);
                convertedFonts.put(font2, font);
            }
        }
        return new FontMetricsPS((FontPS)font);
    }

    public void addFont(Font font) {
        if (FontLibrary.availableFonts[0].containsKey(font.getName())) {
            FontPS.loadFont(font.getName());
        }
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (image == null) {
            return false;
        }
        this.updateContext();
        if (image instanceof EPSImage) {
            Color color2 = this.getColor();
            this.setColor(Color.lightGray);
            this.fillRect(n, n2, n3, n4);
            this.setColor(color2);
            return true;
        }
        return this.drawJavaImage(image, n, n2, n3, n4, color, imageObserver, true, false, null);
    }

    public Graphics create() {
        Graphics graphics = super.create();
        if (graphics instanceof Graphics2DPDF) {
            Graphics2DPDF graphics2DPDF = (Graphics2DPDF)graphics;
            graphics2DPDF.pdfTransform = this.isFrameGraphics ? new AffineTransform() : new AffineTransform(this.pdfTransform);
        }
        return graphics;
    }

    public void setTransform(AffineTransform affineTransform) {
        super.setTransform(affineTransform);
        this.pdfTransform = new AffineTransform(affineTransform);
    }

    public Graphics newGraphics() {
        return new Graphics2DPDF(this.getOutputStream(), this.printer);
    }

    public void startContext() {
        if (this.printer.isDocOpen()) {
            this.output("q");
            double[] dArray = new double[6];
            this.pdfTransform.getMatrix(dArray);
            this.output("" + this.truncateDecimalDigits(dArray[0]) + " " + this.truncateDecimalDigits(dArray[1]) + " " + this.truncateDecimalDigits(dArray[2]) + " " + this.truncateDecimalDigits(dArray[3]) + " " + this.truncateDecimalDigits(dArray[4]) + " " + this.truncateDecimalDigits(-1.0 * dArray[5]) + " cm");
            this.outputClip();
            this.lineColorChanged = true;
            this.fillColorChanged = true;
            this.strokeChanged = true;
        }
    }

    public void outputClip() {
        if (this.clip == null) {
            return;
        }
        if (this.clip instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)this.clip;
            this.output(this.truncateDecimalDigits(rectangle2D.getX()) + " " + this.truncateDecimalDigits(-rectangle2D.getY()) + " " + this.truncateDecimalDigits(rectangle2D.getWidth()) + " " + this.truncateDecimalDigits(-rectangle2D.getHeight()) + " re W n");
        } else if (this.clip instanceof GeneralPath) {
            PathIterator pathIterator = this.clip.getPathIterator(null);
            double[] dArray = new double[6];
            int n = 0;
            while (!pathIterator.isDone()) {
                n = pathIterator.currentSegment(dArray);
                switch (n) {
                    case 0: {
                        this.output(this.truncateDecimalDigits(dArray[0]) + " " + this.truncateDecimalDigits(-dArray[1]) + " m");
                        break;
                    }
                    case 1: {
                        this.output(this.truncateDecimalDigits(dArray[0]) + " " + this.truncateDecimalDigits(-dArray[1]) + " l");
                        break;
                    }
                    case 4: {
                        this.output("h");
                        break;
                    }
                }
                pathIterator.next();
            }
            this.output("W n");
        } else {
            Rectangle2D rectangle2D = this.clip.getBounds2D();
            this.output(this.truncateDecimalDigits(rectangle2D.getX()) + " " + this.truncateDecimalDigits(-rectangle2D.getY()) + " " + this.truncateDecimalDigits(rectangle2D.getWidth()) + " " + this.truncateDecimalDigits(-rectangle2D.getHeight()) + " re W n");
        }
    }

    public void endContext() {
        this.output("Q");
        this.lineColorChanged = true;
        this.fillColorChanged = true;
    }

    public void fillShape(Shape shape) {
        PathIterator pathIterator = shape.getPathIterator(new AffineTransform());
        String string = "f";
        this.updateContext();
        this.outputCurrentPaint("rg");
        this.windingRule = ((GeneralPath)shape).getWindingRule();
        string = this.windingRule == 1 ? "f*" : "f";
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        boolean bl = true;
        while (!pathIterator.isDone()) {
            float[] fArray = new float[6];
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    this.output(this.truncateDecimalDigits(fArray[0]) + " " + this.truncateDecimalDigits(-fArray[1]) + " m");
                    f3 = fArray[0];
                    f4 = fArray[1];
                    f = fArray[0];
                    f2 = fArray[1];
                    bl = false;
                    break;
                }
                case 1: {
                    this.output(this.truncateDecimalDigits(fArray[0]) + " " + this.truncateDecimalDigits(-fArray[1]) + " l");
                    f3 = fArray[0];
                    f4 = fArray[1];
                    break;
                }
                case 3: {
                    this.output(this.truncateDecimalDigits(fArray[0]) + " " + this.truncateDecimalDigits(-fArray[1]) + " " + this.truncateDecimalDigits(fArray[2]) + " " + this.truncateDecimalDigits(-fArray[3]) + " " + this.truncateDecimalDigits(fArray[4]) + " " + this.truncateDecimalDigits(-fArray[5]) + " c");
                    f3 = fArray[4];
                    f4 = fArray[5];
                    break;
                }
                case 2: {
                    this.output(this.truncateDecimalDigits(this.cvtQuadraticCPToFirstCubicCP(fArray[0], f3)) + " " + this.truncateDecimalDigits(-this.cvtQuadraticCPToFirstCubicCP(fArray[1], f4)) + " " + this.truncateDecimalDigits(this.cvtQuadraticCPToSecondCubicCP(fArray[0], fArray[2])) + " " + this.truncateDecimalDigits(-this.cvtQuadraticCPToSecondCubicCP(fArray[1], fArray[3])) + " " + this.truncateDecimalDigits(fArray[2]) + " " + this.truncateDecimalDigits(-fArray[3]) + " c");
                    f3 = fArray[2];
                    f4 = fArray[3];
                    break;
                }
                case 4: {
                    f3 = f;
                    f4 = f2;
                    this.output("h");
                    bl = true;
                    break;
                }
            }
            pathIterator.next();
        }
        if (!bl) {
            this.output("h " + string);
        } else {
            this.output(string);
        }
    }

    private float cvtQuadraticCPToFirstCubicCP(float f, float f2) {
        return 2.0f * (f - f2) / 3.0f + f2;
    }

    private float cvtQuadraticCPToSecondCubicCP(float f, float f2) {
        return (f2 - f) / 3.0f + f;
    }

    public void drawArcPW(double d, double d2, double d3, double d4, double d5, double d6, int n) {
        this.updateContext();
        this.setLineStroke();
        this.outputCurrentPaint("RG");
        double d7 = d3 / 2.0;
        double d8 = d4 / 2.0;
        d2 = -(d2 + d8);
        double d9 = d6 < 0.0 ? (d5 + d6) / 180.0 * Math.PI : d5 / 180.0 * Math.PI;
        double d10 = (d += d7) + d7 * Math.cos(d9);
        double d11 = d2 + d8 * Math.sin(d9);
        this.output(this.truncateDecimalDigits(d10) + " " + this.truncateDecimalDigits(d11) + " m");
        this.traceArcPath(d, d2, d7, d8, d5, d6);
        this.output("S");
    }

    public void fillArcPW(double d, double d2, double d3, double d4, double d5, double d6, int n) {
        this.updateContext();
        this.outputCurrentPaint("rg");
        double d7 = d3 / 2.0;
        double d8 = d4 / 2.0;
        d2 = -(d2 + d8);
        double d9 = d6 < 0.0 ? (d5 + d6) / 180.0 * Math.PI : d5 / 180.0 * Math.PI;
        double d10 = (d += d7) + d7 * Math.cos(d9);
        double d11 = d2 + d8 * Math.sin(d9);
        this.output(this.truncateDecimalDigits(d) + " " + this.truncateDecimalDigits(d2) + " m " + this.truncateDecimalDigits(d10) + " " + this.truncateDecimalDigits(d11) + " l");
        this.traceArcPath(d, d2, d7, d8, d5, d6);
        this.output("h f");
    }

    public void setClipPW(double d, double d2, double d3, double d4) {
        boolean bl = this.isContextCurrent();
        if (bl) {
            this.endContext();
        }
        if (this.parent != null && ((Graphics2DPDF)this.parent).clipSet) {
            Cloneable cloneable;
            Cloneable cloneable2;
            Shape shape = null;
            Shape shape2 = null;
            Shape shape3 = this.parent.getClip();
            try {
                if (((Graphics2DBase)this.parent).isFrameRoot()) {
                    cloneable2 = this.pdfTransform.createInverse();
                } else {
                    cloneable = (AffineTransform)((Graphics2D)this.parent).getTransform().clone();
                    if (((AffineTransform)cloneable).isIdentity()) {
                        cloneable2 = this.pdfTransform.createInverse();
                    } else {
                        cloneable2 = ((AffineTransform)cloneable).createInverse();
                        ((AffineTransform)cloneable2).concatenate(this.pdfTransform);
                        cloneable2 = ((AffineTransform)cloneable2).createInverse();
                    }
                }
                shape2 = ((AffineTransform)cloneable2).createTransformedShape(shape3);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                shape2 = shape3;
            }
            cloneable2 = new Rectangle2D.Double(d, d2, d3, d4);
            if (shape2 instanceof Rectangle2D) {
                shape = new Rectangle2D.Double();
                Rectangle2D.intersect((Rectangle2D)shape2, (Rectangle2D)cloneable2, shape);
            } else {
                cloneable = new Area(shape2);
                ((Area)cloneable).intersect(new Area((Shape)((Object)cloneable2)));
                shape = new GeneralPath();
                ((GeneralPath)shape).append((Shape)((Object)cloneable), false);
            }
            this.clip = shape;
        } else {
            this.clip = new Rectangle2D.Double(d, d2, d3, d4);
        }
        this.clipSet = true;
        if (bl) {
            this.startContext();
        }
    }

    public void fillRectPW(double d, double d2, double d3, double d4) {
        this.printRect(d, d2, d3, d4, "f");
    }

    public void drawRectPW(double d, double d2, double d3, double d4) {
        this.printRect(d, d2, d3, d4, "S");
    }

    public void drawLinePW(double d, double d2, double d3, double d4) {
        this.updateContext();
        this.outputCurrentPaint("RG");
        this.setLineStroke();
        this.output(this.truncateDecimalDigits(d) + " " + this.truncateDecimalDigits(-d2) + " m " + this.truncateDecimalDigits(d3) + " " + this.truncateDecimalDigits(-d4) + " l S");
    }

    public void drawRoundRectPW(double d, double d2, double d3, double d4, double d5, double d6) {
        this.drawRRect(d, d2, d3, d4, d5, d6, "S");
    }

    public void fillRoundRectPW(double d, double d2, double d3, double d4, double d5, double d6) {
        this.drawRRect(d, d2, d3, d4, d5, d6, "f");
    }

    protected void appendToOutString(int n, double d, FontPS fontPS, boolean bl) {
        String string = "\\()";
        char c = '\\';
        if (bl) {
            int n2 = n >> 8;
            if (n2 <= 15) {
                this.out.text.append("0");
            }
            this.out.text.append(Integer.toHexString(n2));
            n2 = n & 0xFF;
            if (n2 <= 15) {
                this.out.text.append("0");
            }
            this.out.text.append(Integer.toHexString(n2));
        } else if (n < 32 || n > 126) {
            if (n <= 255) {
                this.out.text.append(this.octal3((char)(n & 0xFF)));
            } else if (n == 8364) {
                this.out.text.append(this.octal3('\u0080'));
            } else {
                System.err.println("Warning: expecting single-byte character, found multi-byte character 0x" + Integer.toHexString(n));
                this.out.text.append(' ');
            }
        } else {
            if (string.indexOf((char)n) != -1) {
                this.out.text.append(c);
            }
            this.out.text.append((char)n);
        }
        this.out.width += FontMetricsPS.asPoints(d, this.getFont().getSize());
    }

    protected void printOutString(boolean bl, boolean bl2) {
        int n = this.out.text.length() + 7;
        StringBuffer stringBuffer = new StringBuffer(n);
        if (bl) {
            stringBuffer.append("[<");
            stringBuffer.append(this.out.text.toString());
            if (bl2) {
                stringBuffer.append(">");
            }
        } else {
            stringBuffer.append("[(");
            stringBuffer.append(this.out.text.toString());
            if (bl2) {
                stringBuffer.append(")");
            }
        }
        stringBuffer.append("]TJ");
        this.output(stringBuffer.toString());
        this.out.x += this.out.width;
        this.out.width = 0.0;
    }

    protected void endTextSegment(boolean bl) {
        if (bl) {
            this.out.text.append(">");
        } else {
            this.out.text.append(")");
        }
    }

    protected void addKerning(int n, boolean bl, boolean bl2) {
        this.out.text.append(-n);
        if (bl2) {
            if (bl) {
                this.out.text.append("<");
            } else {
                this.out.text.append("(");
            }
        }
    }

    protected void outputColor(String string, Color color) {
        if (color == null) {
            return;
        }
        if (string.equals("RG")) {
            if (color.equals(this.currentLineColor) && !this.lineColorChanged) {
                return;
            }
            this.currentLineColor = color;
            this.lineColorChanged = false;
        } else {
            if (color.equals(this.currentFillColor) && !this.fillColorChanged) {
                return;
            }
            this.currentFillColor = color;
            this.fillColorChanged = false;
        }
        double d = (double)color.getRed() / 255.0;
        double d2 = (double)color.getGreen() / 255.0;
        double d3 = (double)color.getBlue() / 255.0;
        this.output(this.truncateDecimalDigits(d) + " " + this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(d3) + " " + string);
        this.colorChanged = false;
    }

    protected void outputTexture(TexturePaint texturePaint) {
        String string = "/P" + this.patternIndex;
        ++this.patternIndex;
        this.output("/Pattern cs " + string + " scn");
        this.printer.addPattern(string, texturePaint.getImage());
        this.outputPatternObjectDictionaries(texturePaint.getImage());
        this.fillColorChanged = true;
    }

    protected void outputCurrentPaint(String string) {
        Paint paint = this.getPaint();
        if (string.equals("RG") || paint == null) {
            this.outputColor(string, this.getColor());
        } else if (paint instanceof Color) {
            this.outputColor(string, (Color)paint);
        } else if (paint instanceof TexturePaint) {
            this.outputTexture((TexturePaint)paint);
        }
    }

    protected void outputCurrentColor(String string) {
        this.outputColor(string, this.getColor());
    }

    protected void printPolygon(int[] nArray, int[] nArray2, int n, String string) {
        this.updateContext();
        String string2 = string.equals("S") ? "RG" : "rg";
        this.outputCurrentPaint(string2);
        this.output(nArray[0] + " " + -nArray2[0] + " m");
        int n2 = 1;
        while (n2 < n) {
            int n3 = nArray[n2];
            int n4 = -nArray2[n2];
            this.output(n3 + " " + n4 + " l");
            ++n2;
        }
        if (string.equals("f") && this.getWindingRule() == 1) {
            string = "f*";
        }
        this.output("h " + string);
    }

    protected void drawRRect(double d, double d2, double d3, double d4, double d5, double d6, String string) {
        this.updateContext();
        d2 = -d2;
        String string2 = string.equals("S") ? "RG" : "rg";
        this.outputCurrentPaint(string2);
        this.setLineStroke();
        double d7 = d5 * 0.448;
        double d8 = d6 * 0.448;
        this.output(this.truncateDecimalDigits(d + d5) + " " + this.truncateDecimalDigits(d2) + " m");
        this.output(this.truncateDecimalDigits(d + d7) + " " + this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(d) + " " + this.truncateDecimalDigits(d2 - d8) + " " + this.truncateDecimalDigits(d) + " " + this.truncateDecimalDigits(d2 - d6) + " c");
        if (d4 > d6 * 2.0) {
            this.output(this.truncateDecimalDigits(d) + " " + this.truncateDecimalDigits(d2 - d4 + d6) + " l");
        }
        this.output(this.truncateDecimalDigits(d) + " " + this.truncateDecimalDigits(d2 - d4 + d8) + " " + this.truncateDecimalDigits(d + d7) + " " + this.truncateDecimalDigits(d2 - d4) + " " + this.truncateDecimalDigits(d + d5) + " " + this.truncateDecimalDigits(d2 - d4) + " c");
        if (d3 > d5 * 2.0) {
            this.output(this.truncateDecimalDigits(d + d3 - d5) + " " + this.truncateDecimalDigits(d2 - d4) + " l");
        }
        this.output(this.truncateDecimalDigits(d + d3 - d7) + " " + this.truncateDecimalDigits(d2 - d4) + " " + this.truncateDecimalDigits(d + d3) + " " + this.truncateDecimalDigits(d2 - d4 + d8) + " " + this.truncateDecimalDigits(d + d3) + " " + this.truncateDecimalDigits(d2 - d4 + d6) + " c");
        if (d4 > d6 * 2.0) {
            this.output(this.truncateDecimalDigits(d + d3) + " " + this.truncateDecimalDigits(d2 - d6) + " l");
        }
        this.output(this.truncateDecimalDigits(d + d3) + " " + this.truncateDecimalDigits(d2 - d8) + " " + this.truncateDecimalDigits(d + d3 - d7) + " " + this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(d + d3 - d5) + " " + this.truncateDecimalDigits(d2) + " c h");
        this.output(string);
    }

    protected void setLineStroke() {
        if (this.strokeChanged) {
            float f = ((BasicStroke)this.currentStroke).getLineWidth();
            this.output(this.truncateDecimalDigits(f) + " w");
            float[] fArray = ((BasicStroke)this.currentStroke).getDashArray();
            float f2 = ((BasicStroke)this.currentStroke).getDashPhase();
            if (fArray != null) {
                this.output("[ ");
                int n = 0;
                while (n < fArray.length) {
                    this.output(this.truncateDecimalDigits(fArray[n]) + " ");
                    ++n;
                }
                this.output("] ");
                this.output(String.valueOf(f2).toString());
                this.output(" d");
                this.dashMode = true;
            } else if (this.dashMode) {
                this.output("[] 0 d");
                this.dashMode = false;
            }
        }
        this.strokeChanged = false;
    }

    protected void loadFont(String string, boolean bl) {
        String string2 = this.printer.getFontAbbreviation(string);
        if (string2 == null) {
            throw new IllegalArgumentException("Font not found " + string);
        }
        this.printer.streamInfo.fontList.put(bl ? string + "-Unicode" : string, string);
        this.output("/" + string2 + (bl ? "U" : "") + " " + this.getFont().getSize() + " Tf");
    }

    public void traceArcPath(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        double d9;
        double d10;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = 0.0;
        if (d6 < 0.0) {
            d5 += d6;
            d6 = -d6;
        }
        if (Math.abs(d6) < 0.001) {
            double d19 = (d5 + d6) / 180.0 * Math.PI;
            d11 = d + d3 * Math.cos(d19);
            d15 = d2 + d4 * Math.sin(d19);
            this.output(this.truncateDecimalDigits(d11) + " " + this.truncateDecimalDigits(-d15) + " l");
            return;
        }
        if (d3 <= 0.0) {
            double d20 = (d5 + d6) / 180.0 * Math.PI;
            d15 = d2 + d4 * Math.sin(d20);
            this.output(this.truncateDecimalDigits(d) + " " + this.truncateDecimalDigits(-d15) + " l");
            return;
        }
        if (d4 <= 0.0) {
            double d21 = (d5 + d6) / 180.0 * Math.PI;
            d11 = d + d3 * Math.cos(d21);
            this.output(this.truncateDecimalDigits(d11) + " " + this.truncateDecimalDigits(-d2) + " l");
            return;
        }
        double d22 = 0.5522848 * d3;
        double d23 = 0.5522848 * d4;
        double d24 = d10 = d3 / d4;
        double d25 = 1.0 / d24;
        double d26 = d5 / 180.0 * Math.PI;
        d11 = d + d3 * Math.cos(d26);
        d15 = d2 + d4 * Math.sin(d26);
        double d27 = (int)d5 / 90 * 90;
        if (Math.abs(d27 - d5) > 0.001) {
            if (d5 > 0.0) {
                d27 += 90.0;
            }
            if ((d9 = d5 + d6) > d27) {
                d9 = d27;
            }
            d26 = d9 / 180.0 * Math.PI;
            d14 = d + d3 * Math.cos(d26);
            d18 = d2 + d4 * Math.sin(d26);
            d8 = d9 - d5;
            d7 = this.computeControlPointFactor(d8);
            d12 = d11 - d7 * d24 * (d15 - d2);
            d16 = d15 + d7 * d25 * (d11 - d);
            d13 = d14 + d7 * d24 * (d18 - d2);
            d17 = d18 - d7 * d25 * (d14 - d);
            this.drawSegment(d12, d16, d13, d17, d14, d18);
            d11 = d14;
            d15 = d18;
        }
        d9 = d5 + d6;
        while (d27 + 90.0 <= d9) {
            int n = (int)d27 % 360;
            if (n == 0) {
                d12 = 0.0;
                d16 = d23;
                d13 = d22;
                d17 = 0.0;
            } else if (n == 90 || n == -270) {
                d12 = -d22;
                d16 = 0.0;
                d13 = 0.0;
                d17 = d23;
            } else if (n == 180 || n == -180) {
                d12 = 0.0;
                d16 = -d23;
                d13 = -d22;
                d17 = 0.0;
            } else if (n == 270 || n == -90) {
                d12 = d22;
                d16 = 0.0;
                d13 = 0.0;
                d17 = -d23;
            }
            d26 = (d27 += 90.0) / 180.0 * Math.PI;
            d14 = d + d3 * Math.cos(d26);
            d18 = d2 + d4 * Math.sin(d26);
            this.drawSegment(d12 += d11, d16 += d15, d13 += d14, d17 += d18, d14, d18);
            d11 = d14;
            d15 = d18;
        }
        if (d27 < d9 && Math.abs(d27 - d9) > 0.001) {
            d26 = d9 / 180.0 * Math.PI;
            d14 = d + d3 * Math.cos(d26);
            d18 = d2 + d4 * Math.sin(d26);
            d8 = d9 - d27;
            d7 = this.computeControlPointFactor(d8);
            d12 = d11 - d7 * d24 * (d15 - d2);
            d16 = d15 + d7 * d25 * (d11 - d);
            d13 = d14 + d7 * d24 * (d18 - d2);
            d17 = d18 - d7 * d25 * (d14 - d);
            this.drawSegment(d12, d16, d13, d17, d14, d18);
            d11 = d14;
            d15 = d18;
        }
    }

    protected double computeControlPointFactor(double d) {
        double d2 = d / 2.0 / 180.0 * Math.PI;
        double d3 = 1.3333333333333333 * (1.0 - Math.cos(d2)) / Math.sin(d2);
        return d3;
    }

    protected void drawSegment(double d, double d2, double d3, double d4, double d5, double d6) {
        this.output(this.truncateDecimalDigits(d) + " " + this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(d3) + " " + this.truncateDecimalDigits(d4) + " " + this.truncateDecimalDigits(d5) + " " + this.truncateDecimalDigits(d6) + " c");
    }

    protected void printRect(double d, double d2, double d3, double d4, String string) {
        this.updateContext();
        d2 = -d2;
        String string2 = string.equals("S") ? "RG" : "rg";
        this.outputCurrentPaint(string2);
        this.setLineStroke();
        this.output(this.truncateDecimalDigits(d) + " " + this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(d3) + " " + this.truncateDecimalDigits(-d4) + " re " + string);
    }

    protected void output(String string) {
        this.printer.output(string);
    }

    protected void outputPatternObjectDictionaries(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = bufferedImage.getSubimage(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        Int intVal = new Int();
        this.drawJavaImage(bufferedImage2, 0, 0, 0, 0, null, null, false, true, intVal);
        this.drawJavaImage(bufferedImage, 0, 0, 0, 0, null, null, false, false, intVal);
    }

    protected boolean drawJavaImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver, boolean bl, boolean bl2, Int intVal) {
        int n5;
        long l = 0L;
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        n2 = -n2 - n4;
        int n8 = -1;
        boolean bl3 = false;
        if (this.printer.imageCache.containsKey(image)) {
            n8 = (Integer)this.printer.imageCache.get(image);
            bl3 = true;
        } else {
            n8 = this.printer.imageNumber;
        }
        if (bl3) {
            if (bl) {
                this.outputImageDraw(n8, n, n2, n3, n4);
            }
            this.printer.streamInfo.imagePresent = true;
            Integer n9 = new Integer(n8);
            if (!this.printer.streamInfo.imageList.contains(n9)) {
                this.printer.streamInfo.imageList.add(n9);
                this.printer.streamInfo.xObjectList.add(this.printer.docImageList.get(n8));
            }
            return true;
        }
        int[] nArray = new int[n6 * n7];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n6, n7, nArray, 0, n6);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return false;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return false;
        }
        if (bl) {
            this.outputImageDraw(n8, n, n2, n3, n4);
        }
        Integer n10 = new Integer(n8);
        this.printer.imageCache.put(image, n10);
        int n11 = ++this.printer.objectNumber;
        Integer n12 = new Integer(n11);
        this.printer.streamInfo.imageList.add(n10);
        this.printer.docImageList.add(n12);
        this.printer.streamInfo.xObjectList.add(n12);
        if (bl2 && intVal != null) {
            intVal.value = n11;
        }
        this.printer.switchToNewStream();
        this.printer.storeObjectReference(n11, this.printer.getCurrentOffset());
        this.printer.streamInfo.imagePresent = true;
        this.output(n11 + " 0 obj\n<<");
        this.output("/Type /XObject\n/Subtype /Image");
        this.output("/Name /Im" + this.printer.imageNumber++);
        this.output("/Width " + n6 + "\n/Height " + n7);
        this.output("/BitsPerComponent 8");
        String string = bl2 ? "/DeviceGray" : "/DeviceRGB";
        this.output("/ColorSpace " + string);
        this.output("/Filter [ /ASCII85Decode /FlateDecode ]");
        this.output("/Length " + (n11 + 1) + " 0 R");
        if (!bl2 && intVal != null) {
            this.output("/SMask " + intVal.value + " 0 R");
        }
        this.output("/Resources " + (n11 + 2) + " 0 R\n>>");
        this.output("stream");
        l = this.printer.getCurrentOffset();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(new Ascii85OutputStream(byteArrayOutputStream));
        int n13 = 0;
        int n14 = bl2 ? n6 : n6 * 3;
        byte[] byArray = new byte[n14];
        int n15 = pixelGrabber.getHeight();
        int n16 = pixelGrabber.getWidth();
        int n17 = 0;
        while (n17 < n15) {
            n13 = 0;
            int n18 = 0;
            while (n18 < n16) {
                int n19 = nArray[n17 * n16 + n18];
                if (bl2) {
                    n5 = n19 >> 24 & 0xFF;
                    byArray[n13++] = n5 == 0 ? 0 : -1;
                } else {
                    byArray[n13++] = (byte)((n19 & 0xFF0000) >> 16);
                    byArray[n13++] = (byte)((n19 & 0xFF00) >> 8);
                    byArray[n13++] = (byte)(n19 & 0xFF);
                }
                ++n18;
            }
            try {
                deflaterOutputStream.write(byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n17;
        }
        try {
            deflaterOutputStream.finish();
            deflaterOutputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int n20 = byteArrayOutputStream.size();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        n13 = 0;
        while (n13 + 72 < n20) {
            this.printer.output(byArray2, n13, 72);
            n13 += 72;
            this.printer.output((byte)10);
        }
        this.printer.output(byArray2, n13, n20 - n13);
        this.printer.output((byte)10);
        n5 = (int)(this.printer.getCurrentOffset() - l - 1L);
        this.output("endstream\nendobj");
        this.printer.storeObjectReference(++this.printer.objectNumber, this.printer.getCurrentOffset());
        this.output(this.printer.objectNumber + " 0 obj\n" + n5 + " \nendobj");
        this.printer.storeObjectReference(++this.printer.objectNumber, this.printer.getCurrentOffset());
        this.output(this.printer.objectNumber + " 0 obj\n<<");
        this.printer.writeResourcesDictionary();
        this.output(">>\nendobj");
        this.printer.switchBackToOldStream();
        return true;
    }

    protected void outputImageDraw(int n, double d, double d2, double d3, double d4) {
        this.output("q");
        this.output(d3 + " 0 0 " + d4 + " " + d + " " + d2 + " cm");
        this.output("0 0 1 1 re W n");
        this.output("/Im" + n + " Do");
        this.output("Q");
    }

    protected String octal3(char c) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(Integer.toOctalString(c));
        int n2 = n = stringBuffer.length();
        while (n2 < 3) {
            stringBuffer.insert(0, 0);
            ++n2;
        }
        stringBuffer.insert(0, '\\');
        return stringBuffer.toString();
    }

    protected class Int {
        int value = -1;

        protected Int() {
        }
    }
}

