/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.adobe.pdf;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Ascii85OutputStream
extends FilterOutputStream {
    private byte[] buffer = new byte[4];
    private byte[] tuple = new byte[5];
    private int bufCount = 0;
    private static String EOD = "~>";
    protected static final char[] hd = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static char[] char_b = new char[2];
    private static char[] char_l = new char[16];

    public Ascii85OutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    public void flush() throws IOException {
        if (this.bufCount > 0) {
            this.encode(this.buffer, 0, this.bufCount);
        }
        this.out.write(EOD.getBytes());
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (n2 + this.bufCount >= 4) {
            if (this.bufCount > 0) {
                while (this.bufCount < 4) {
                    this.buffer[this.bufCount++] = byArray[n + n3];
                    ++n3;
                }
                this.encode(this.buffer, 0);
                this.bufCount = 0;
            }
            while (n3 + 3 < n2) {
                this.encode(byArray, n + n3);
                n3 += 4;
            }
        }
        int n4 = n3;
        while (n4 < n2) {
            this.buffer[this.bufCount++] = byArray[n + n4];
            ++n4;
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(int n) throws IOException {
        this.buffer[this.bufCount++] = (byte)n;
        if (this.bufCount == 4) {
            this.encode(this.buffer, 0);
            this.bufCount = 0;
        }
    }

    private static String hexVal(byte by) {
        Ascii85OutputStream.char_b[0] = hd[(by & 0xF0) >> 4];
        Ascii85OutputStream.char_b[1] = hd[by & 0xF];
        return new String(char_b);
    }

    private static String hexVal(long l) {
        Ascii85OutputStream.char_l[0] = hd[(int)(l >> 60 & 0xFL)];
        Ascii85OutputStream.char_l[1] = hd[(int)((l & 0xF00000000000000L) >> 56)];
        Ascii85OutputStream.char_l[2] = hd[(int)((l & 0xF0000000000000L) >> 52)];
        Ascii85OutputStream.char_l[3] = hd[(int)((l & 0xF000000000000L) >> 48)];
        Ascii85OutputStream.char_l[4] = hd[(int)((l & 0xF00000000000L) >> 44)];
        Ascii85OutputStream.char_l[5] = hd[(int)((l & 0xF0000000000L) >> 40)];
        Ascii85OutputStream.char_l[6] = hd[(int)((l & 0xF000000000L) >> 36)];
        Ascii85OutputStream.char_l[7] = hd[(int)((l & 0xF00000000L) >> 32)];
        Ascii85OutputStream.char_l[8] = hd[(int)((l & 0xF0000000L) >> 28)];
        Ascii85OutputStream.char_l[9] = hd[(int)((l & 0xF000000L) >> 24)];
        Ascii85OutputStream.char_l[10] = hd[(int)((l & 0xF00000L) >> 20)];
        Ascii85OutputStream.char_l[11] = hd[(int)((l & 0xF0000L) >> 16)];
        Ascii85OutputStream.char_l[12] = hd[(int)((l & 0xF000L) >> 12)];
        Ascii85OutputStream.char_l[13] = hd[(int)((l & 0xF00L) >> 8)];
        Ascii85OutputStream.char_l[14] = hd[(int)((l & 0xF0L) >> 4)];
        Ascii85OutputStream.char_l[15] = hd[(int)(l & 0xFL)];
        return new String(char_l);
    }

    private void encode(byte[] byArray, int n) throws IOException {
        long l = ((long)byArray[n] & 0xFFL) << 24 | (long)((byArray[n + 1] & 0xFF) << 16) | (long)((byArray[n + 2] & 0xFF) << 8) | (long)(byArray[n + 3] & 0xFF);
        if (l == 0L) {
            this.out.write(122);
        } else {
            this.tuple = this.getTuple(l, this.tuple);
            this.out.write(this.tuple);
        }
    }

    private void encode(byte[] byArray, int n, int n2) throws IOException {
        long l = 0L;
        int n3 = 0;
        while (n3 < n2) {
            l = l << 8 | (long)(byArray[n + n3] & 0xFF);
            ++n3;
        }
        int n4 = n2;
        while (n4 < 4) {
            l <<= 8;
            ++n4;
        }
        this.tuple = this.getTuple(l, this.tuple);
        this.out.write(this.tuple, 0, n2 + 1);
    }

    private byte[] getTuple(long l, byte[] byArray) {
        byArray[4] = (byte)(l % 85L + 33L);
        byArray[3] = (byte)((l /= 85L) % 85L + 33L);
        byArray[2] = (byte)((l /= 85L) % 85L + 33L);
        byArray[1] = (byte)((l /= 85L) % 85L + 33L);
        byArray[0] = (byte)((l /= 85L) + 33L);
        return byArray;
    }
}

