/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page;

import com.klg.jclass.page.EPSImage;
import com.klg.jclass.page.EndOfFrameException;
import com.klg.jclass.page.FontBase;
import com.klg.jclass.page.Graphics2DBase;
import com.klg.jclass.page.JCDocument;
import com.klg.jclass.page.JCDrawStyle;
import com.klg.jclass.page.JCFlow;
import com.klg.jclass.page.JCFlowInfo;
import com.klg.jclass.page.JCPage;
import com.klg.jclass.page.JCPageTable;
import com.klg.jclass.page.JCTab;
import com.klg.jclass.page.JCTextStyle;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.Markup;
import com.klg.jclass.page.PageArea;
import com.klg.jclass.page.TextMacro;
import com.klg.jclass.page.render.ArcRender;
import com.klg.jclass.page.render.BoxRender;
import com.klg.jclass.page.render.Embedable;
import com.klg.jclass.page.render.Floatable;
import com.klg.jclass.page.render.HRuleMarker;
import com.klg.jclass.page.render.ImageMarker;
import com.klg.jclass.page.render.ImageRender;
import com.klg.jclass.page.render.LineRender;
import com.klg.jclass.page.render.MacroRender;
import com.klg.jclass.page.render.Render;
import com.klg.jclass.page.render.RoundRectRender;
import com.klg.jclass.page.render.Splitable;
import com.klg.jclass.page.render.StringRender;
import com.klg.jclass.page.render.SymbolRender;
import com.klg.jclass.page.render.TableMarker;
import com.klg.jclass.util.ServerRenderable;
import com.klg.jclass.util.swing.JCSwingUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class JCFrame
extends PageArea
implements Cloneable,
Floatable {
    protected static JCUnit.Measure FLEXIBLE_SIZE = new JCUnit.Measure(JCUnit.INTERNAL, 10000.0);
    protected JCDrawStyle border;
    protected int columnCount = 1;
    protected JCUnit.Measure columnSpace = new JCUnit.Measure(JCUnit.INTERNAL, 0.25);
    protected JCUnit.Measure columnWidth;
    protected JCUnit.Margins margin = new JCUnit.Margins();
    protected List renderList;
    protected JCUnit.Margins clipMask;
    protected JCUnit.Measure yExtent;
    protected JCFlowInfo info;
    protected int floatAlignment;
    protected JCPage page;
    public static final String HEADER = "header";
    public static final String FOOTER = "footer";

    public JCFrame() {
        this.border = JCDrawStyle.stringToStyle("default blank");
        this.columnWidth = new JCUnit.Measure();
        this.info = new JCFlowInfo();
        this.renderList = new Vector();
        this.yExtent = new JCUnit.Measure();
        this.clipMask = null;
    }

    public JCFrame(JCDocument jCDocument) {
        super(jCDocument);
        this.border = JCDrawStyle.stringToStyle("default blank");
        this.columnWidth = new JCUnit.Measure();
        this.info = new JCFlowInfo();
        this.renderList = new Vector();
        this.yExtent = new JCUnit.Measure();
        this.clipMask = null;
    }

    public JCFrame(String string) {
        super(string);
        this.border = JCDrawStyle.stringToStyle("default blank");
        this.columnWidth = new JCUnit.Measure();
        this.info = new JCFlowInfo();
        this.renderList = new Vector();
        this.yExtent = new JCUnit.Measure();
        this.clipMask = null;
    }

    public JCFrame(String string, JCDocument jCDocument) {
        super(string, jCDocument);
        this.border = JCDrawStyle.stringToStyle("default blank");
        this.columnWidth = new JCUnit.Measure();
        this.info = new JCFlowInfo();
        this.renderList = new Vector();
        this.yExtent = new JCUnit.Measure();
        this.clipMask = null;
    }

    public JCFrame(String string, JCUnit.Point point, JCUnit.Dimension dimension) {
        super(string, point, dimension);
        this.border = JCDrawStyle.stringToStyle("default blank");
        this.columnWidth = new JCUnit.Measure();
        this.computeColumnWidth();
        this.info = new JCFlowInfo();
        this.renderList = new Vector();
        this.yExtent = new JCUnit.Measure();
        this.clipMask = null;
    }

    public JCFrame(String string, JCDocument jCDocument, JCUnit.Point point, JCUnit.Dimension dimension) {
        super(string, jCDocument, point, dimension);
        this.border = JCDrawStyle.stringToStyle("default blank");
        this.columnWidth = new JCUnit.Measure();
        this.computeColumnWidth();
        this.info = new JCFlowInfo();
        this.renderList = new Vector();
        this.yExtent = new JCUnit.Measure();
        this.clipMask = null;
    }

    public int getAlignment() {
        return this.floatAlignment;
    }

    public void setAlignment(int n) {
        if (n <= 0 || n > 5) {
            throw new IllegalArgumentException("Unrecognised horizontal alignment");
        }
        this.floatAlignment = n;
    }

    public JCDrawStyle getBorder() {
        return this.border;
    }

    public void setBorder(JCDrawStyle jCDrawStyle) {
        if (jCDrawStyle == null) {
            throw new IllegalArgumentException("border style must be non-null");
        }
        this.border = jCDrawStyle = jCDrawStyle.getImmutable();
    }

    public JCUnit.Margins getClipMask() {
        return this.clipMask;
    }

    public void setClipMask(JCUnit.Margins margins) {
        JCUnit.Measure measure;
        JCUnit.Margins margins2 = (JCUnit.Margins)margins.clone();
        JCUnit.Measure measure2 = margins2.getLeft();
        JCUnit.Measure measure3 = margins2.getRight();
        measure3.add(measure2);
        if (measure2.isNegative()) {
            margins2.setLeft(new JCUnit.Measure());
            measure2 = margins2.getLeft();
        }
        if (measure3.greaterThan(measure = this.size.getWidth())) {
            measure.subtract(measure2);
            margins2.setRight(measure);
        } else {
            margins2.setRight(measure3);
        }
        measure2 = margins2.getTop();
        measure3 = margins2.getBottom();
        measure3.add(measure2);
        if (measure2.isNegative()) {
            margins2.setTop(new JCUnit.Measure());
            measure2 = margins2.getTop();
        }
        if (measure3.greaterThan(measure = this.size.getHeight())) {
            measure.subtract(measure2);
            margins2.setBottom(measure);
        } else {
            margins2.setBottom(measure3);
        }
        this.clipMask = margins2;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Number of columns must be >= 1");
        }
        if (this.columnCount != n) {
            this.columnCount = n;
            this.computeColumnWidth();
        }
    }

    public JCUnit.Measure getColumnWidth() {
        return this.columnWidth;
    }

    public JCUnit.Measure getColumnSpace() {
        return this.columnSpace;
    }

    public void setColumnSpace(JCUnit.Measure measure) {
        if (measure.isNegative()) {
            throw new IllegalArgumentException("Column spacing must be >= 0");
        }
        if (this.columnSpace.internal() != measure.internal()) {
            this.columnSpace = measure;
            this.computeColumnWidth();
        }
    }

    public JCUnit.Margins getMargins() {
        return (JCUnit.Margins)this.margin.clone();
    }

    public void setMargins(JCUnit.Margins margins) {
        if (margins.top < 0.0 || margins.bottom < 0.0 || margins.left < 0.0 || margins.right < 0.0) {
            throw new IllegalArgumentException("Margin width must be >= 0");
        }
        JCUnit.Measure measure = this.size.getWidth();
        measure.subtract(margins.getLeft());
        measure.subtract(margins.getRight());
        if (measure.isNegative()) {
            throw new IllegalArgumentException("Margins can't be wider than the frame");
        }
        JCUnit.Measure measure2 = this.size.getHeight();
        measure2.subtract(margins.getTop());
        measure2.subtract(margins.getBottom());
        if (measure2.isNegative()) {
            throw new IllegalArgumentException("Margins can't be taller than the frame");
        }
        boolean bl = !this.margin.getLeft().equals(margins.getLeft()) || !this.margin.getRight().equals(margins.getRight());
        this.margin = (JCUnit.Margins)margins.clone();
        if (bl) {
            this.computeColumnWidth();
        }
    }

    public void setPage(JCPage jCPage) {
        this.page = jCPage;
        int n = this.frameList.size();
        int n2 = 0;
        while (n2 < n) {
            JCFrame jCFrame = (JCFrame)this.frameList.get(n2);
            jCFrame.setPage(jCPage);
            ++n2;
        }
    }

    public void setSize(JCUnit.Dimension dimension) {
        if (dimension.width < 0.0 || dimension.height < 0.0) {
            throw new IllegalArgumentException("Dimensions must be non-negative");
        }
        this.size = (JCUnit.Dimension)dimension.clone();
        this.computeColumnWidth();
        if (this.clipMask != null) {
            JCUnit.Measure measure = this.clipMask.getLeft();
            JCUnit.Measure measure2 = this.clipMask.getRight();
            if (measure.isNegative()) {
                measure2.add(measure);
                this.clipMask.setLeft(new JCUnit.Measure());
            }
            if (measure2.greaterThan(dimension.getWidth())) {
                this.clipMask.setRight(dimension.getWidth());
            }
            measure = this.clipMask.getTop();
            measure2 = this.clipMask.getBottom();
            if (measure.isNegative()) {
                measure2.add(measure);
                this.clipMask.setTop(new JCUnit.Measure());
            }
            if (measure2.greaterThan(dimension.getWidth())) {
                this.clipMask.setBottom(dimension.getWidth());
            }
        }
    }

    public JCFlowInfo getInfo() {
        return this.info;
    }

    public void print(JCTextStyle jCTextStyle, String string) throws EndOfFrameException {
        this.info.currentTextStyle = jCTextStyle = jCTextStyle.getImmutable();
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        StringRender stringRender = new StringRender(graphics2D, string, jCTextStyle);
        this.flowPrint(graphics2D, stringRender, false);
    }

    public void print(JCTextStyle jCTextStyle, TextMacro textMacro) throws EndOfFrameException {
        this.info.currentTextStyle = jCTextStyle = jCTextStyle.getImmutable();
        textMacro.evaluate(null, this.page);
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        MacroRender macroRender = new MacroRender(graphics2D, textMacro, jCTextStyle);
        this.flowPrint(graphics2D, macroRender, false);
    }

    public void print(JCTextStyle jCTextStyle, MacroRender macroRender) throws EndOfFrameException {
        this.info.currentTextStyle = jCTextStyle = jCTextStyle.getImmutable();
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        this.flowPrint(graphics2D, macroRender, false);
    }

    public void print(JCTextStyle jCTextStyle, String string, JCUnit.Point point) {
        this.info.currentTextStyle = jCTextStyle = jCTextStyle.getImmutable();
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        StringRender stringRender = new StringRender(graphics2D, string, jCTextStyle);
        stringRender.setLocation(point);
        this.renderList.add(stringRender);
    }

    protected void printWithNewlines(JCTextStyle jCTextStyle, String string) throws EndOfFrameException {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            this.print(jCTextStyle, stringTokenizer.nextToken());
            this.newLine(jCTextStyle);
        }
    }

    public void print(JCPageTable jCPageTable) throws EndOfFrameException {
        this.renderList.add(new TableMarker(jCPageTable, this.info.currentTextStyle));
        this.print(jCPageTable, 0, 0);
    }

    public void print(JCPageTable jCPageTable, int n, int n2) throws EndOfFrameException {
        int n3 = jCPageTable.getRowCount() - 1;
        int n4 = jCPageTable.getColumnCount() - 1;
        this.print(jCPageTable, n, n2, n3, n4);
    }

    public void print(JCPageTable jCPageTable, int n, int n2, int n3, int n4) throws EndOfFrameException {
        JCUnit.Measure measure;
        if (!this.isInfoInitialised()) {
            this.initialiseInfo();
        }
        this.renderList.add(new TableMarker(jCPageTable, this.info.currentTextStyle, n, n2));
        jCPageTable.completeLayout();
        if (n3 == -1) {
            JCPageTable jCPageTable2;
            int n5;
            if (jCPageTable.hasHeaders() && (n5 = (jCPageTable2 = jCPageTable.getHeaders()).getRowCount() - 1) != -1) {
                this.print(jCPageTable2, 0, n2);
            }
            return;
        }
        JCUnit.Measure measure2 = jCPageTable.getColumnRangeWidth(n2, n4);
        JCUnit.Measure measure3 = jCPageTable.getRowRangeHeight(n, n3);
        if (jCPageTable.hasHeaders()) {
            JCPageTable jCPageTable3 = jCPageTable.getHeaders();
            int n6 = jCPageTable3.getRowCount() - 1;
            measure = jCPageTable3.getRowRangeHeight(0, n6);
        } else {
            measure = new JCUnit.Measure();
        }
        if (this.info.currentTextStyle == null) {
            this.info.currentTextStyle = JCTextStyle.DEFAULT_TEXT;
        }
        if (this.info.currentLine.size() != 0) {
            this.doLineBreak(this.info.currentTextStyle, false);
        }
        JCUnit.Measure measure4 = this.size.getHeight();
        JCUnit.Measure measure5 = (JCUnit.Measure)measure4.clone();
        measure5.subtract(this.info.insertion.getY());
        measure5.subtract(this.margin.getBottom());
        int n7 = n2;
        int n8 = n4;
        JCUnit.Measure measure6 = (JCUnit.Measure)measure2.clone();
        int n9 = jCPageTable.getOverflowMode();
        if (this.columnWidth.lessThan(measure2) && n9 != 1) {
            n8 = jCPageTable.getColumnSet(n7, this.columnWidth, measure6);
        }
        int n10 = n;
        JCUnit.Measure measure7 = (JCUnit.Measure)measure3.clone();
        JCUnit.Measure measure8 = (JCUnit.Measure)measure3.clone();
        JCUnit.Measure measure9 = (JCUnit.Measure)measure5.clone();
        measure9.subtract(measure);
        while (measure7.distance > 0.0) {
            int n11 = jCPageTable.getRowSet(n10, measure9, measure8);
            JCUnit.Measure measure10 = this.margin.getTop();
            measure10.add(this.getFirstLineOffset(this.info.currentTextStyle));
            if (measure8.greaterThan(measure9) && (n10 + 1 < n11 || this.info.insertion.getY().greaterThan(measure10))) {
                try {
                    this.newColumn(this.info.currentTextStyle, false);
                }
                catch (EndOfFrameException endOfFrameException) {
                    if (n10 == n) {
                        endOfFrameException.setTableFlow(jCPageTable, n10, n7);
                    } else {
                        endOfFrameException.setTableFlow(jCPageTable, n10, n7, n8);
                    }
                    throw endOfFrameException;
                }
                measure5 = (JCUnit.Measure)measure4.clone();
                measure5.subtract(this.info.insertion.getY());
                measure5.subtract(this.margin.getBottom());
                measure9 = (JCUnit.Measure)measure5.clone();
                measure9.subtract(measure);
                continue;
            }
            jCPageTable.drawTablePart(this, n10, n7, n11, n8, measure, measure8, measure6);
            JCUnit.Measure measure11 = this.info.insertion.getY();
            measure11.add(measure8);
            measure11.add(measure);
            measure11.add(this.getFirstLineOffset(this.info.currentTextStyle));
            this.info.insertion.setY(measure11);
            n10 = n11 + 1;
            if (n10 <= n3) {
                measure7 = jCPageTable.getRowRangeHeight(n10, n3);
                try {
                    this.newColumn(this.info.currentTextStyle, false);
                }
                catch (EndOfFrameException endOfFrameException) {
                    if (n10 == n) {
                        endOfFrameException.setTableFlow(jCPageTable, n10, n7);
                    } else {
                        endOfFrameException.setTableFlow(jCPageTable, n10, n7, n8);
                    }
                    throw endOfFrameException;
                }
                measure5 = (JCUnit.Measure)measure4.clone();
                measure5.subtract(this.info.insertion.getY());
                measure5.subtract(this.margin.getBottom());
            } else if (n8 < n4 && n9 == 2) {
                n7 = n8 + 1;
                n8 = jCPageTable.getColumnSet(n7, this.columnWidth, measure6);
                n10 = n;
                measure7 = measure3;
                measure5 = (JCUnit.Measure)measure4.clone();
                measure5.subtract(this.info.insertion.getY());
                measure5.subtract(this.margin.getBottom());
            } else if (n8 < n4 && n9 == 4) {
                n7 = n8 + 1;
                n8 = jCPageTable.getColumnSet(n7, this.columnWidth, measure6);
                n10 = n;
                measure7 = measure3;
                try {
                    this.newColumn(this.info.currentTextStyle, false);
                }
                catch (EndOfFrameException endOfFrameException) {
                    if (n10 == n) {
                        endOfFrameException.setTableFlow(jCPageTable, n10, n7);
                    } else {
                        endOfFrameException.setTableFlow(jCPageTable, n10, n7, n8);
                    }
                    throw endOfFrameException;
                }
                measure5 = (JCUnit.Measure)measure4.clone();
                measure5.subtract(this.info.insertion.getY());
                measure5.subtract(this.margin.getBottom());
            } else {
                measure7.distance = 0.0;
            }
            measure9 = (JCUnit.Measure)measure5.clone();
            measure9.subtract(measure);
        }
    }

    public void tab(JCTextStyle jCTextStyle) {
        JCTab jCTab = null;
        JCUnit.Measure measure = null;
        this.info.currentTextStyle = jCTextStyle = jCTextStyle.getImmutable();
        if (!this.isInfoInitialised()) {
            this.initialiseInfo();
        }
        if (this.info.currentLine.size() == 0 && this.info.firstLine) {
            this.computeLineBounds(jCTextStyle, this.info.firstLine);
            this.info.insertion.setX(this.info.lineBegin);
        }
        JCUnit.Measure measure2 = this.info.insertion.getX();
        Iterator iterator = jCTextStyle.getTabs().iterator();
        while (iterator.hasNext()) {
            JCTab jCTab2 = (JCTab)iterator.next();
            measure = (JCUnit.Measure)jCTab2.getPosition().clone();
            measure.add(this.info.leftOfColumn);
            if (!measure.greaterThan(measure2)) continue;
            jCTab = jCTab2;
            break;
        }
        if (jCTab == null || measure.greaterThan(this.info.lineEnd)) {
            SymbolRender symbolRender = new SymbolRender(1, jCTextStyle);
            symbolRender.setLeaderFill(1);
            this.info.currentLine.add(symbolRender);
            JCUnit.Measure measure3 = this.info.insertion.getY();
            measure3.add(this.info.ascender);
            JCUnit.Point point = (JCUnit.Point)this.info.insertion.clone();
            point.setY(measure3);
            symbolRender.setLocation(point);
            this.doLineBreak(jCTextStyle, false);
            return;
        }
        this.info.insertion.setX(measure);
        this.info.currentTab = jCTab;
        this.info.tabUsed = true;
        this.info.tabIndex = this.info.currentLine.size() + 1;
        SymbolRender symbolRender = new SymbolRender(1, jCTextStyle);
        JCUnit.Measure measure4 = this.info.insertion.getY();
        measure4.add(this.info.ascender);
        JCUnit.Point point = (JCUnit.Point)this.info.insertion.clone();
        point.setY(measure4);
        symbolRender.setLocation(point);
        symbolRender.setLeaderStart(measure2);
        symbolRender.setLeaderEnd(this.info.insertion.getX());
        symbolRender.setLeaderFill(jCTab.getTabFill());
        symbolRender.setAlignment(jCTab.getTabAlignment());
        this.info.currentLine.add(symbolRender);
        this.info.tabSymbol = symbolRender;
    }

    public JCTab nextTab(JCTextStyle jCTextStyle) {
        JCTab jCTab = null;
        jCTextStyle = jCTextStyle.getImmutable();
        if (!this.isInfoInitialised()) {
            this.initialiseInfo();
        }
        JCUnit.Measure measure = this.info.insertion.getX();
        Iterator iterator = jCTextStyle.getTabs().iterator();
        while (iterator.hasNext()) {
            JCTab jCTab2 = (JCTab)iterator.next();
            JCUnit.Measure measure2 = jCTab2.getPosition();
            measure2.add(this.info.leftOfColumn);
            if (!measure2.greaterThan(measure)) continue;
            jCTab = jCTab2;
            break;
        }
        return jCTab;
    }

    public void floatImage(Image image) {
        ImageIcon imageIcon = new ImageIcon(image);
        JCUnit.Dimension dimension = new JCUnit.Dimension(JCUnit.POINTS, imageIcon.getIconWidth(), imageIcon.getIconHeight());
        ImageRender imageRender = new ImageRender(image, dimension, 4);
        this.renderList.add(new ImageMarker(imageRender));
        this.addFloat(imageRender);
    }

    public void floatImage(Image image, int n) {
        ImageIcon imageIcon = new ImageIcon(image);
        JCUnit.Dimension dimension = new JCUnit.Dimension(JCUnit.POINTS, imageIcon.getIconWidth(), imageIcon.getIconHeight());
        ImageRender imageRender = new ImageRender(image, dimension, n);
        this.renderList.add(new ImageMarker(imageRender));
        this.addFloat(imageRender);
    }

    public void floatImage(Image image, JCUnit.Dimension dimension) {
        ImageRender imageRender = new ImageRender(image, dimension, 4);
        this.renderList.add(new ImageMarker(imageRender));
        this.addFloat(imageRender);
    }

    public void floatImage(Image image, int n, JCUnit.Dimension dimension) {
        ImageRender imageRender = new ImageRender(image, dimension, n);
        this.renderList.add(new ImageMarker(imageRender));
        this.addFloat(imageRender);
    }

    public void floatIcon(Icon icon) {
        JCUnit.Dimension dimension = new JCUnit.Dimension(JCUnit.POINTS, icon.getIconWidth(), icon.getIconHeight());
        ImageRender imageRender = new ImageRender(icon, dimension, 4);
        this.renderList.add(new ImageMarker(imageRender));
        this.addFloat(imageRender);
    }

    public void floatIcon(Icon icon, int n) {
        JCUnit.Dimension dimension = new JCUnit.Dimension(JCUnit.POINTS, icon.getIconWidth(), icon.getIconHeight());
        ImageRender imageRender = new ImageRender(icon, dimension, n);
        this.renderList.add(new ImageMarker(imageRender));
        this.addFloat(imageRender);
    }

    public void floatIcon(Icon icon, JCUnit.Dimension dimension) {
        ImageRender imageRender = new ImageRender(icon, dimension, 4);
        this.renderList.add(new ImageMarker(imageRender));
        this.addFloat(imageRender);
    }

    public void floatIcon(Icon icon, int n, JCUnit.Dimension dimension) {
        ImageRender imageRender = new ImageRender(icon, dimension, n);
        this.renderList.add(new ImageMarker(imageRender));
        this.addFloat(imageRender);
    }

    public void floatComponent(Component component) {
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        JCUnit.Dimension dimension = this.sizeComponent(component, graphics2D, 0, 0);
        ImageRender imageRender = new ImageRender(component, dimension, 4);
        this.renderList.add(new ImageMarker(imageRender));
        this.addFloat(imageRender);
    }

    public void floatComponent(Component component, int n) {
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        JCUnit.Dimension dimension = this.sizeComponent(component, graphics2D, 0, 0);
        ImageRender imageRender = new ImageRender(component, dimension, n);
        this.renderList.add(new ImageMarker(imageRender));
        this.addFloat(imageRender);
    }

    public void floatComponent(Component component, JCUnit.Dimension dimension) {
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        this.sizeComponent(component, graphics2D, (int)JCUnit.getAsPoints(dimension.units, dimension.width), (int)JCUnit.getAsPoints(dimension.units, dimension.height));
        ImageRender imageRender = new ImageRender(component, dimension, 4);
        this.renderList.add(new ImageMarker(imageRender));
        this.addFloat(imageRender);
    }

    public void floatComponent(Component component, int n, JCUnit.Dimension dimension) {
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        this.sizeComponent(component, graphics2D, (int)JCUnit.getAsPoints(dimension.units, dimension.width), (int)JCUnit.getAsPoints(dimension.units, dimension.height));
        ImageRender imageRender = new ImageRender(component, dimension, n);
        this.renderList.add(new ImageMarker(imageRender));
        this.addFloat(imageRender);
    }

    public void floatEPS(EPSImage ePSImage) {
        JCUnit.Dimension dimension = ePSImage.getSize();
        double d = JCUnit.getAsPoints(dimension.units, dimension.width);
        double d2 = JCUnit.getAsPoints(dimension.units, dimension.height);
        dimension = new JCUnit.Dimension(JCUnit.POINTS, d, d2);
        ImageRender imageRender = new ImageRender(ePSImage, dimension, 4);
        this.renderList.add(new ImageMarker(imageRender));
        this.addFloat(imageRender);
    }

    public void floatEPS(EPSImage ePSImage, int n) {
        JCUnit.Dimension dimension = ePSImage.getSize();
        double d = JCUnit.getAsPoints(dimension.units, dimension.width);
        double d2 = JCUnit.getAsPoints(dimension.units, dimension.height);
        dimension = new JCUnit.Dimension(JCUnit.POINTS, d, d2);
        ImageRender imageRender = new ImageRender(ePSImage, dimension, n);
        this.renderList.add(new ImageMarker(imageRender));
        this.addFloat(imageRender);
    }

    public void floatEPS(EPSImage ePSImage, JCUnit.Dimension dimension) {
        ImageRender imageRender = new ImageRender(ePSImage, dimension, 4);
        this.renderList.add(new ImageMarker(imageRender));
        this.addFloat(imageRender);
    }

    public void floatEPS(EPSImage ePSImage, int n, JCUnit.Dimension dimension) {
        ImageRender imageRender = new ImageRender(ePSImage, dimension, n);
        this.renderList.add(new ImageMarker(imageRender));
        this.addFloat(imageRender);
    }

    protected void addFloat(ImageRender imageRender) {
        this.info.floatList.add(imageRender);
        if (this.info.currentLine == null || this.info.currentLine.size() == 0) {
            this.pasteFloats();
        }
    }

    public void embedImage(JCTextStyle jCTextStyle, Image image) throws EndOfFrameException {
        this.info.currentTextStyle = jCTextStyle;
        ImageIcon imageIcon = new ImageIcon(image);
        JCUnit.Dimension dimension = new JCUnit.Dimension(JCUnit.POINTS, imageIcon.getIconWidth(), imageIcon.getIconHeight());
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        ImageRender imageRender = new ImageRender((Object)image, dimension);
        this.renderList.add(new ImageMarker(imageRender, true));
        this.flowPrint(graphics2D, imageRender, false);
    }

    public void embedImage(JCTextStyle jCTextStyle, Image image, int n) throws EndOfFrameException {
        this.info.currentTextStyle = jCTextStyle;
        ImageIcon imageIcon = new ImageIcon(image);
        JCUnit.Dimension dimension = new JCUnit.Dimension(JCUnit.POINTS, imageIcon.getIconWidth(), imageIcon.getIconHeight());
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        ImageRender imageRender = new ImageRender((Object)image, dimension);
        imageRender.setVerticalAlignment(n);
        this.renderList.add(new ImageMarker(imageRender, true));
        this.flowPrint(graphics2D, imageRender, false);
    }

    public void embedImage(JCTextStyle jCTextStyle, Image image, JCUnit.Dimension dimension) throws EndOfFrameException {
        this.info.currentTextStyle = jCTextStyle;
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        ImageRender imageRender = new ImageRender((Object)image, dimension);
        imageRender.setScaleImage(!this.document.getPrinter().isImageScalable());
        this.renderList.add(new ImageMarker(imageRender, true));
        this.flowPrint(graphics2D, imageRender, false);
    }

    public void embedImage(JCTextStyle jCTextStyle, Image image, int n, JCUnit.Dimension dimension) throws EndOfFrameException {
        this.info.currentTextStyle = jCTextStyle;
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        ImageRender imageRender = new ImageRender((Object)image, dimension);
        imageRender.setScaleImage(!this.document.getPrinter().isImageScalable());
        imageRender.setVerticalAlignment(n);
        this.renderList.add(new ImageMarker(imageRender, true));
        this.flowPrint(graphics2D, imageRender, false);
    }

    public void embedIcon(JCTextStyle jCTextStyle, Icon icon) throws EndOfFrameException {
        this.info.currentTextStyle = jCTextStyle;
        JCUnit.Dimension dimension = new JCUnit.Dimension(JCUnit.POINTS, icon.getIconWidth(), icon.getIconHeight());
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        ImageRender imageRender = new ImageRender((Object)icon, dimension);
        this.renderList.add(new ImageMarker(imageRender, true));
        this.flowPrint(graphics2D, imageRender, false);
    }

    public void embedIcon(JCTextStyle jCTextStyle, Icon icon, int n) throws EndOfFrameException {
        this.info.currentTextStyle = jCTextStyle;
        JCUnit.Dimension dimension = new JCUnit.Dimension(JCUnit.POINTS, icon.getIconWidth(), icon.getIconHeight());
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        ImageRender imageRender = new ImageRender((Object)icon, dimension);
        imageRender.setVerticalAlignment(n);
        this.renderList.add(new ImageMarker(imageRender, true));
        this.flowPrint(graphics2D, imageRender, false);
    }

    public void embedIcon(JCTextStyle jCTextStyle, Icon icon, JCUnit.Dimension dimension) throws EndOfFrameException {
        this.info.currentTextStyle = jCTextStyle;
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        ImageRender imageRender = new ImageRender((Object)icon, dimension);
        imageRender.setScaleImage(!this.document.getPrinter().isImageScalable());
        this.renderList.add(new ImageMarker(imageRender, true));
        this.flowPrint(graphics2D, imageRender, false);
    }

    public void embedIcon(JCTextStyle jCTextStyle, Icon icon, int n, JCUnit.Dimension dimension) throws EndOfFrameException {
        this.info.currentTextStyle = jCTextStyle;
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        ImageRender imageRender = new ImageRender((Object)icon, dimension);
        imageRender.setScaleImage(!this.document.getPrinter().isImageScalable());
        imageRender.setVerticalAlignment(n);
        this.renderList.add(new ImageMarker(imageRender, true));
        this.flowPrint(graphics2D, imageRender, false);
    }

    public void embedComponent(JCTextStyle jCTextStyle, Component component) throws EndOfFrameException {
        this.info.currentTextStyle = jCTextStyle;
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        JCUnit.Dimension dimension = this.sizeComponent(component, graphics2D, 0, 0);
        ImageRender imageRender = new ImageRender((Object)component, dimension);
        this.renderList.add(new ImageMarker(imageRender, true));
        this.flowPrint(graphics2D, imageRender, false);
    }

    public void embedComponent(JCTextStyle jCTextStyle, Component component, int n) throws EndOfFrameException {
        this.info.currentTextStyle = jCTextStyle;
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        JCUnit.Dimension dimension = this.sizeComponent(component, graphics2D, 0, 0);
        ImageRender imageRender = new ImageRender((Object)component, dimension);
        imageRender.setVerticalAlignment(n);
        this.renderList.add(new ImageMarker(imageRender, true));
        this.flowPrint(graphics2D, imageRender, false);
    }

    public void embedComponent(JCTextStyle jCTextStyle, Component component, JCUnit.Dimension dimension) throws EndOfFrameException {
        this.info.currentTextStyle = jCTextStyle;
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        this.sizeComponent(component, graphics2D, (int)JCUnit.getAsPoints(dimension.units, dimension.width), (int)JCUnit.getAsPoints(dimension.units, dimension.height));
        ImageRender imageRender = new ImageRender((Object)component, dimension);
        this.renderList.add(new ImageMarker(imageRender, true));
        this.flowPrint(graphics2D, imageRender, false);
    }

    public void embedComponent(JCTextStyle jCTextStyle, Component component, int n, JCUnit.Dimension dimension) throws EndOfFrameException {
        this.info.currentTextStyle = jCTextStyle;
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        this.sizeComponent(component, graphics2D, (int)JCUnit.getAsPoints(dimension.units, dimension.width), (int)JCUnit.getAsPoints(dimension.units, dimension.height));
        ImageRender imageRender = new ImageRender((Object)component, dimension);
        imageRender.setVerticalAlignment(n);
        this.renderList.add(new ImageMarker(imageRender, true));
        this.flowPrint(graphics2D, imageRender, false);
    }

    protected JCUnit.Dimension sizeComponent(Component component, Graphics graphics, int n, int n2) {
        int n3 = component.getWidth();
        int n4 = component.getHeight();
        if (n3 == 0 || n4 == 0) {
            Object object;
            if (!component.isShowing() && component instanceof ServerRenderable) {
                object = (ServerRenderable)((Object)component);
                object.setGraphics(graphics);
            }
            object = component instanceof JComponent ? JCSwingUtilities.getPreferredSizeFromGraphics((JComponent)component, graphics, false) : component.getPreferredSize();
            n3 = n == 0 ? ((Dimension)object).width : n;
            n4 = n2 == 0 ? ((Dimension)object).height : n2;
            component.setSize(n3, n4);
        }
        return new JCUnit.Dimension(JCUnit.POINTS, n3, n4);
    }

    public void embedEPS(JCTextStyle jCTextStyle, EPSImage ePSImage) throws EndOfFrameException {
        this.info.currentTextStyle = jCTextStyle;
        JCUnit.Dimension dimension = ePSImage.getSize();
        double d = JCUnit.getAsPoints(dimension.units, dimension.width);
        double d2 = JCUnit.getAsPoints(dimension.units, dimension.height);
        dimension = new JCUnit.Dimension(JCUnit.POINTS, d, d2);
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        ImageRender imageRender = new ImageRender((Object)ePSImage, dimension);
        this.renderList.add(new ImageMarker(imageRender, true));
        this.flowPrint(graphics2D, imageRender, false);
    }

    public void embedEPS(JCTextStyle jCTextStyle, EPSImage ePSImage, int n) throws EndOfFrameException {
        this.info.currentTextStyle = jCTextStyle;
        JCUnit.Dimension dimension = ePSImage.getSize();
        double d = JCUnit.getAsPoints(dimension.units, dimension.width);
        double d2 = JCUnit.getAsPoints(dimension.units, dimension.height);
        dimension = new JCUnit.Dimension(JCUnit.POINTS, d, d2);
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        ImageRender imageRender = new ImageRender((Object)ePSImage, dimension);
        imageRender.setVerticalAlignment(n);
        this.renderList.add(new ImageMarker(imageRender, true));
        this.flowPrint(graphics2D, imageRender, false);
    }

    public void embedEPS(JCTextStyle jCTextStyle, EPSImage ePSImage, JCUnit.Dimension dimension) throws EndOfFrameException {
        this.info.currentTextStyle = jCTextStyle;
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        ImageRender imageRender = new ImageRender((Object)ePSImage, dimension);
        this.renderList.add(new ImageMarker(imageRender, true));
        this.flowPrint(graphics2D, imageRender, false);
    }

    public void embedEPS(JCTextStyle jCTextStyle, EPSImage ePSImage, int n, JCUnit.Dimension dimension) throws EndOfFrameException {
        this.info.currentTextStyle = jCTextStyle;
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        ImageRender imageRender = new ImageRender((Object)ePSImage, dimension);
        imageRender.setVerticalAlignment(n);
        this.renderList.add(new ImageMarker(imageRender, true));
        this.flowPrint(graphics2D, imageRender, false);
    }

    public void pasteImage(Image image, JCUnit.Point point) {
        ImageIcon imageIcon = new ImageIcon(image);
        JCUnit.Dimension dimension = new JCUnit.Dimension(JCUnit.POINTS, imageIcon.getIconWidth(), imageIcon.getIconHeight());
        ImageRender imageRender = new ImageRender(image, dimension, 4);
        imageRender.setLocation(point);
        this.renderList.add(imageRender);
    }

    public void pasteImage(Image image, JCUnit.Dimension dimension, JCUnit.Point point) {
        ImageRender imageRender = new ImageRender(image, dimension, 4);
        imageRender.setLocation(point);
        this.renderList.add(imageRender);
    }

    public void pasteIcon(Icon icon, JCUnit.Point point) {
        JCUnit.Dimension dimension = new JCUnit.Dimension(JCUnit.POINTS, icon.getIconWidth(), icon.getIconHeight());
        ImageRender imageRender = new ImageRender(icon, dimension, 4);
        imageRender.setLocation(point);
        this.renderList.add(imageRender);
    }

    public void pasteIcon(Icon icon, JCUnit.Dimension dimension, JCUnit.Point point) {
        ImageRender imageRender = new ImageRender(icon, dimension, 4);
        imageRender.setLocation(point);
        this.renderList.add(imageRender);
    }

    public void pasteComponent(Component component, JCUnit.Point point) {
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        this.sizeComponent(component, graphics2D, 0, 0);
        JCUnit.Dimension dimension = new JCUnit.Dimension(JCUnit.POINTS, component.getWidth(), component.getHeight());
        ImageRender imageRender = new ImageRender(component, dimension, 4);
        imageRender.setLocation(point);
        this.renderList.add(imageRender);
    }

    public void pasteComponent(Component component, JCUnit.Dimension dimension, JCUnit.Point point) {
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        this.sizeComponent(component, graphics2D, (int)JCUnit.getAsPoints(dimension.units, dimension.width), (int)JCUnit.getAsPoints(dimension.units, dimension.height));
        ImageRender imageRender = new ImageRender(component, dimension, 4);
        imageRender.setLocation(point);
        this.renderList.add(imageRender);
    }

    public void pasteEPS(EPSImage ePSImage, JCUnit.Point point) {
        JCUnit.Dimension dimension = ePSImage.getSize();
        double d = JCUnit.getAsPoints(dimension.units, dimension.width);
        double d2 = JCUnit.getAsPoints(dimension.units, dimension.height);
        dimension = new JCUnit.Dimension(JCUnit.POINTS, d, d2);
        ImageRender imageRender = new ImageRender(ePSImage, dimension, 4);
        imageRender.setLocation(point);
        this.renderList.add(imageRender);
    }

    public void pasteEPS(EPSImage ePSImage, JCUnit.Dimension dimension, JCUnit.Point point) {
        ImageRender imageRender = new ImageRender(ePSImage, dimension, 4);
        imageRender.setLocation(point);
        this.renderList.add(imageRender);
    }

    public void hRule(JCTextStyle jCTextStyle, JCDrawStyle jCDrawStyle, double d) throws EndOfFrameException {
        jCTextStyle = jCTextStyle.getImmutable();
        jCDrawStyle = jCDrawStyle.getImmutable();
        JCUnit.Measure measure = (JCUnit.Measure)this.info.rightOfColumn.clone();
        measure.subtract(this.info.leftOfColumn);
        measure.multiply(d / 100.0);
        this.hRule(jCTextStyle, jCDrawStyle, measure);
    }

    public void hRule(JCTextStyle jCTextStyle, JCDrawStyle jCDrawStyle, JCUnit.Measure measure) throws EndOfFrameException {
        JCUnit.Measure measure2;
        JCUnit.Measure measure3;
        this.renderList.add(new HRuleMarker(jCTextStyle, jCDrawStyle, measure));
        jCTextStyle = jCTextStyle.getImmutable();
        jCDrawStyle = jCDrawStyle.getImmutable();
        if (!this.isInfoInitialised()) {
            this.initialiseInfo();
        }
        if (this.info.currentLine.size() != 0) {
            this.doLineBreak(jCTextStyle, false);
        }
        switch (jCTextStyle.getAlignment()) {
            case 3: {
                measure3 = (JCUnit.Measure)this.info.rightOfColumn.clone();
                measure2 = (JCUnit.Measure)this.info.rightOfColumn.clone();
                measure2.subtract(measure);
                if (!measure2.lessThan(this.info.leftOfColumn)) break;
                measure2 = (JCUnit.Measure)this.info.leftOfColumn.clone();
                break;
            }
            case 4: 
            case 5: {
                measure2 = (JCUnit.Measure)this.info.leftOfColumn.clone();
                measure2.add(this.info.rightOfColumn);
                measure2.subtract(measure);
                measure2.divide(2.0);
                measure3 = (JCUnit.Measure)measure2.clone();
                measure3.add(measure);
                if (measure2.lessThan(this.info.leftOfColumn)) {
                    measure2 = (JCUnit.Measure)this.info.leftOfColumn.clone();
                }
                if (!measure3.greaterThan(this.info.rightOfColumn)) break;
                measure3 = (JCUnit.Measure)this.info.rightOfColumn.clone();
                break;
            }
            case 1: 
            case 2: {
                measure2 = (JCUnit.Measure)this.info.leftOfColumn.clone();
                measure3 = (JCUnit.Measure)measure2.clone();
                measure3.add(measure);
                if (!measure3.greaterThan(this.info.rightOfColumn)) break;
                measure3 = (JCUnit.Measure)this.info.rightOfColumn.clone();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid text alignment");
            }
        }
        JCUnit.Measure measure4 = this.info.insertion.getY();
        JCUnit.Measure measure5 = jCDrawStyle.getDrawnWidth();
        JCUnit.Measure measure6 = (JCUnit.Measure)measure5.clone();
        measure6.multiply(2.0);
        measure6.add(measure4);
        JCUnit.Measure measure7 = this.size.getHeight();
        measure7.subtract(this.margin.getBottom());
        if (measure6.greaterThan(measure7)) {
            this.newColumn(jCTextStyle, false);
            measure4 = this.info.insertion.getY();
        }
        measure5.multiply(1.5);
        measure4.add(measure5);
        JCUnit.Point point = new JCUnit.Point(measure2.units, measure2.distance, 0.0);
        point.setY(measure4);
        JCUnit.Point point2 = new JCUnit.Point(measure3.units, measure3.distance, 0.0);
        point2.setY(measure4);
        this.drawLine(jCDrawStyle, point, point2);
        JCUnit.Measure measure8 = new JCUnit.Measure(JCUnit.POINTS, 2.0);
        if (measure5.lessThan(measure8)) {
            measure4.add(measure8);
        } else {
            measure4.add(measure5);
        }
        this.info.insertion.setY(measure4);
    }

    public void newLine(JCTextStyle jCTextStyle) {
        SymbolRender symbolRender = new SymbolRender(2, jCTextStyle);
        symbolRender.setLocation(this.info.insertion);
        this.info.currentLine.add(symbolRender);
        this.doLineBreak(jCTextStyle, false);
    }

    public void newParagraph(JCTextStyle jCTextStyle) {
        SymbolRender symbolRender = new SymbolRender(3, jCTextStyle);
        symbolRender.setLocation(this.info.insertion);
        this.info.currentLine.add(symbolRender);
        this.doLineBreak(jCTextStyle, true);
    }

    protected void newLine(JCTextStyle jCTextStyle, boolean bl) {
        if (bl) {
            this.newParagraph(jCTextStyle);
        } else {
            this.newLine(jCTextStyle);
        }
    }

    protected void doLineBreak(JCTextStyle jCTextStyle, boolean bl) {
        this.doLineBreak(jCTextStyle, bl, false);
    }

    protected void doLineBreak(JCTextStyle jCTextStyle, boolean bl, boolean bl2) {
        JCUnit.Measure measure;
        JCUnit.Measure measure2;
        Render render;
        int n;
        if (!this.isInfoInitialised()) {
            this.initialiseInfo();
        }
        jCTextStyle = jCTextStyle.getImmutable();
        int n2 = jCTextStyle.getAlignment();
        if (this.info.tabUsed) {
            n2 = 1;
        }
        if ((n = this.info.currentLine.size()) > 0 && (n2 == 4 || n2 == 3 || n2 == 5) && (render = (Render)this.info.currentLine.get(n - 1)) instanceof StringRender) {
            ((StringRender)render).trimTrailingWhitespace();
            measure2 = render.getLocation().getX();
            measure2.add(render.getSize().getWidth());
            this.info.insertion.setX(measure2);
        }
        JCUnit.Measure measure3 = (JCUnit.Measure)this.info.rightOfColumn.clone();
        measure3.subtract(this.info.insertion.getX());
        measure3.subtract(jCTextStyle.getRightIndent());
        if (measure3.isZero() || measure3.isNegative()) {
            n2 = 1;
        }
        if (bl && n2 == 5) {
            n2 = 1;
        }
        switch (n2) {
            case 3: 
            case 4: {
                JCUnit.Point point;
                if (n2 == 4) {
                    measure3.divide(2.0);
                }
                int n3 = 0;
                while (n3 < n) {
                    render = (Render)this.info.currentLine.get(n3);
                    point = render.getLocation();
                    measure2 = point.getX();
                    measure2.add(measure3);
                    point.setX(measure2);
                    ++n3;
                }
                break;
            }
            case 5: {
                JCUnit.Point point;
                int n4 = 0;
                int n3 = n - 1;
                while (n3 >= 0) {
                    render = (Render)this.info.currentLine.get(n3);
                    if (render instanceof StringRender) {
                        List list = ((StringRender)render).splitIntoWords();
                        n4 += list.size();
                        int n5 = 0;
                        while (n5 < list.size()) {
                            this.info.currentLine.insertElementAt(list.get(n5), n3 + 1);
                            ++n5;
                        }
                        this.info.currentLine.remove(n3);
                    } else if (!(render instanceof SymbolRender)) {
                        ++n4;
                    }
                    --n3;
                }
                n = this.info.currentLine.size();
                if (n4 == 0) break;
                if (n4 == 1) {
                    measure3.divide(2.0);
                    n3 = 0;
                    while (n3 < n) {
                        render = (Render)this.info.currentLine.get(n3);
                        if (!(render instanceof SymbolRender)) {
                            point = render.getLocation();
                            measure2 = point.getX();
                            measure2.add(measure3);
                            point.setX(measure2);
                        }
                        ++n3;
                    }
                } else {
                    measure3.divide(n4 - 1);
                    JCUnit.Measure measure4 = (JCUnit.Measure)measure3.clone();
                    boolean bl3 = true;
                    n3 = 0;
                    while (n3 < n) {
                        render = (Render)this.info.currentLine.get(n3);
                        if (!(render instanceof SymbolRender)) {
                            if (bl3) {
                                bl3 = false;
                            } else {
                                point = render.getLocation();
                                measure2 = point.getX();
                                measure2.add(measure4);
                                point.setX(measure2);
                                measure4.add(measure3);
                            }
                        }
                        ++n3;
                    }
                }
                break;
            }
        }
        Iterator iterator = this.info.currentLine.iterator();
        while (iterator.hasNext()) {
            Render render2 = (Render)iterator.next();
            this.renderList.add(render2);
        }
        this.info.currentLine.removeAllElements();
        this.computeLineBounds(jCTextStyle, bl);
        this.info.insertion.setX(this.info.lineBegin);
        if (!bl2 || this.info.floatList.size() > 0) {
            measure = new JCUnit.Measure(JCUnit.POINTS, jCTextStyle.getPointSize());
            if (bl) {
                measure.multiply(jCTextStyle.getParagraphSpacing() - 1.0);
            } else {
                measure.multiply(jCTextStyle.getLineSpacing() - 1.0);
            }
        } else {
            measure = new JCUnit.Measure(JCUnit.POINTS, 0.0);
        }
        if (this.info.lineSpacing.isZero()) {
            double d = jCTextStyle.getPointSize();
            measure.add(new JCUnit.Measure(JCUnit.POINTS, d));
            Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
            FontMetrics fontMetrics = graphics2D.getFontMetrics(jCTextStyle.getFont());
            d -= (double)(fontMetrics.getAscent() + fontMetrics.getDescent());
            if (d <= 0.0) {
                d = 1.0;
            }
            this.info.leading = new JCUnit.Measure(JCUnit.POINTS, d);
        } else {
            measure.add(this.info.lineSpacing);
        }
        if (!bl2 || this.info.floatList.size() > 0) {
            measure.add(this.info.leading);
        }
        measure.add(this.info.insertion.getY());
        this.info.insertion.setY(measure);
        this.info.lineSpacing = new JCUnit.Measure(JCUnit.POINTS);
        this.info.ascender = new JCUnit.Measure(JCUnit.POINTS);
        this.info.descender = new JCUnit.Measure(JCUnit.POINTS);
        this.info.leading = new JCUnit.Measure(JCUnit.POINTS);
        this.info.height = new JCUnit.Measure(JCUnit.POINTS);
        this.info.embedAscent = new JCUnit.Measure(JCUnit.POINTS);
        this.info.embedDescent = new JCUnit.Measure(JCUnit.POINTS);
        this.pasteFloats();
        this.info.currentTab = null;
        this.info.tabSymbol = null;
        this.info.tabIndex = -1;
        this.info.tabUsed = false;
    }

    private void computeLineBounds(JCTextStyle jCTextStyle, boolean bl) {
        this.info.lineBegin.assign(this.info.leftOfColumn);
        this.info.lineEnd.assign(this.info.rightOfColumn);
        this.info.lineEnd.subtract(jCTextStyle.getRightIndent());
        if (bl) {
            this.info.lineBegin.add(jCTextStyle.getParagraphIndent());
            this.info.firstLine = true;
        } else {
            this.info.lineBegin.add(jCTextStyle.getLeftIndent());
            this.info.firstLine = false;
        }
        if (!this.info.lineBegin.lessThan(this.info.lineEnd)) {
            this.info.lineBegin.assign(this.info.leftOfColumn);
            this.info.lineEnd.assign(this.info.rightOfColumn);
        }
    }

    public void newColumn(JCTextStyle jCTextStyle) throws EndOfFrameException {
        this.newColumn(jCTextStyle, true);
    }

    private void newColumn(JCTextStyle jCTextStyle, boolean bl) throws EndOfFrameException {
        Object object;
        JCUnit.Measure measure;
        JCUnit.Measure measure2;
        JCUnit.Point point;
        Render render;
        if (bl) {
            this.newLine(jCTextStyle);
        }
        JCUnit.Measure measure3 = this.info.insertion.getY();
        int n = this.info.currentLine.size();
        int n2 = 0;
        while (n2 < n) {
            render = (Render)this.info.currentLine.get(n2);
            point = render.getLocation();
            measure2 = point.getX();
            measure2.subtract(this.info.leftOfColumn);
            measure = point.getY();
            measure.subtract(measure3);
            point.setX(measure2);
            point.setY(measure);
            if (render instanceof SymbolRender && ((SymbolRender)(object = (SymbolRender)render)).getType() == 1) {
                ((SymbolRender)object).getLeaderStart().subtract(this.info.leftOfColumn);
                ((SymbolRender)object).getLeaderEnd().subtract(this.info.leftOfColumn);
            }
            ++n2;
        }
        if (this.info.currentColumn + 1 == this.columnCount) {
            object = new EndOfFrameException(this.info, "Frame end reached");
            this.info.currentLine.clear();
            throw object;
        }
        measure2 = this.info.insertion.getX();
        measure2.subtract(this.info.leftOfColumn);
        ++this.info.currentColumn;
        this.info.leftOfColumn.assign(this.columnWidth);
        this.info.leftOfColumn.add(this.columnSpace);
        this.info.leftOfColumn.multiply(this.info.currentColumn);
        this.info.leftOfColumn.add(this.margin.getLeft());
        this.info.rightOfColumn.assign(this.info.leftOfColumn);
        this.info.rightOfColumn.add(this.columnWidth);
        this.computeLineBounds(jCTextStyle, this.info.firstLine);
        this.info.insertion.setX(this.info.lineBegin);
        measure = this.getFirstLineOffset(jCTextStyle);
        measure.add(this.margin.getTop());
        measure2.add(this.info.leftOfColumn);
        this.info.insertion.setX(measure2);
        this.info.insertion.setY(measure);
        this.pasteFloats();
        measure3 = this.info.insertion.getY();
        n = this.info.currentLine.size();
        n2 = 0;
        while (n2 < n) {
            render = (Render)this.info.currentLine.get(n2);
            point = render.getLocation();
            measure2 = point.getX();
            measure2.add(this.info.leftOfColumn);
            measure = point.getY();
            measure.add(measure3);
            point.setX(measure2);
            point.setY(measure);
            if (render instanceof SymbolRender && ((SymbolRender)(object = (SymbolRender)render)).getType() == 1) {
                ((SymbolRender)object).getLeaderStart().add(this.info.leftOfColumn);
                ((SymbolRender)object).getLeaderEnd().add(this.info.leftOfColumn);
            }
            ++n2;
        }
    }

    public JCUnit.Measure getFirstLineOffset(JCTextStyle jCTextStyle) {
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(jCTextStyle.getFont());
        double d = jCTextStyle.getPointSize() - (double)fontMetrics.getAscent() - (double)fontMetrics.getDescent();
        if (d <= 0.0) {
            d = 1.0;
        }
        return new JCUnit.Measure(JCUnit.POINTS, d);
    }

    public JCUnit.Point getInsertionPoint() {
        return this.info.insertion;
    }

    public void setInsertionPoint(JCUnit.Point point) {
        if (point == null) {
            return;
        }
        if (!this.isInfoInitialised()) {
            this.initialiseInfo();
        }
        if (!point.getY().equals(this.info.insertion.getY()) && this.info.currentLine.size() > 0) {
            JCTextStyle jCTextStyle = this.info.currentTextStyle;
            if (jCTextStyle == null) {
                jCTextStyle = JCTextStyle.DEFAULT_TEXT;
            }
            this.doLineBreak(jCTextStyle, false);
        }
        this.info.insertion = (JCUnit.Point)point.clone();
        this.info.firstLine = false;
    }

    public JCUnit.Measure getCurrentAscender() {
        return this.info.ascender;
    }

    public JCUnit.Measure getCurrentDescender() {
        return this.info.descender;
    }

    public JCUnit.Measure getCurrentBaseline() {
        JCUnit.Measure measure = this.info.insertion.getY();
        measure.add(this.info.ascender);
        return measure;
    }

    public int getCurrentColumn() {
        return this.info.currentColumn;
    }

    public JCFlowInfo getFlowInfo() {
        return this.info;
    }

    public void addFloats(List list) {
        this.info.floatList.addAll(list);
    }

    public void setCurrentLine(List list) throws EndOfFrameException {
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        this.reflow(graphics2D, list);
        list.clear();
    }

    public void drawCircle(JCDrawStyle jCDrawStyle, JCUnit.Point point, JCUnit.Measure measure) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        if (measure.isNegative()) {
            throw new IllegalArgumentException("Radius must be positive");
        }
        ArcRender arcRender = new ArcRender(point, measure, 0.0, 360.0, jCDrawStyle);
        this.renderList.add(arcRender);
        JCUnit.Measure measure2 = jCDrawStyle.getDrawnWidth();
        measure2.divide(2.0);
        measure2.add(point.getY());
        measure2.add(measure);
        if (measure2.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure2);
        }
    }

    public void fillCircle(JCDrawStyle jCDrawStyle, JCUnit.Point point, JCUnit.Measure measure) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        if (measure.isNegative()) {
            throw new IllegalArgumentException("Radius must be positive");
        }
        ArcRender arcRender = new ArcRender(point, measure, 0.0, 360.0, jCDrawStyle);
        arcRender.setFilled(true);
        this.renderList.add(arcRender);
        JCUnit.Measure measure2 = jCDrawStyle.getDrawnWidth();
        measure2.divide(2.0);
        measure2.add(point.getY());
        measure2.add(measure);
        if (measure2.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure2);
        }
    }

    public void drawRectangle(JCDrawStyle jCDrawStyle, JCUnit.Point point, JCUnit.Dimension dimension) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        BoxRender boxRender = new BoxRender(point, dimension, jCDrawStyle);
        this.renderList.add(boxRender);
        JCUnit.Measure measure = jCDrawStyle.getDrawnWidth();
        measure.divide(2.0);
        measure.add(point.getY());
        measure.add(dimension.getHeight());
        if (measure.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure);
        }
    }

    public void drawRectangle(JCDrawStyle jCDrawStyle, JCUnit.Point point, JCUnit.Point point2) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        BoxRender boxRender = new BoxRender(point, point2, jCDrawStyle);
        this.renderList.add(boxRender);
        JCUnit.Measure measure = point.getY();
        JCUnit.Measure measure2 = point2.getY();
        JCUnit.Measure measure3 = jCDrawStyle.getDrawnWidth();
        measure3.divide(2.0);
        if (measure.greaterThan(measure2)) {
            measure3.add(measure);
        } else {
            measure3.add(measure2);
        }
        if (measure3.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure3);
        }
    }

    public void fillRectangle(JCDrawStyle jCDrawStyle, JCUnit.Point point, JCUnit.Dimension dimension) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        BoxRender boxRender = new BoxRender(point, dimension, jCDrawStyle);
        boxRender.setFilled(true);
        this.renderList.add(boxRender);
        JCUnit.Measure measure = jCDrawStyle.getDrawnWidth();
        measure.divide(2.0);
        measure.add(point.getY());
        measure.add(dimension.getHeight());
        if (measure.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure);
        }
    }

    public void fillRectangle(JCDrawStyle jCDrawStyle, JCUnit.Point point, JCUnit.Point point2) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        BoxRender boxRender = new BoxRender(point, point2, jCDrawStyle);
        boxRender.setFilled(true);
        this.renderList.add(boxRender);
        JCUnit.Measure measure = point.getY();
        JCUnit.Measure measure2 = point2.getY();
        JCUnit.Measure measure3 = jCDrawStyle.getDrawnWidth();
        measure3.divide(2.0);
        if (measure.greaterThan(measure2)) {
            measure3.add(measure);
        } else {
            measure3.add(measure2);
        }
        if (measure3.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure3);
        }
    }

    public void drawLine(JCDrawStyle jCDrawStyle, JCUnit.Point point, JCUnit.Point point2) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        LineRender lineRender = new LineRender(point, point2, jCDrawStyle);
        this.renderList.add(lineRender);
        JCUnit.Measure measure = point.getY();
        JCUnit.Measure measure2 = point2.getY();
        JCUnit.Measure measure3 = jCDrawStyle.getDrawnWidth();
        measure3.divide(2.0);
        if (measure.greaterThan(measure2)) {
            measure3.add(measure);
        } else {
            measure3.add(measure2);
        }
        if (measure3.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure3);
        }
    }

    public void drawLine(JCDrawStyle jCDrawStyle, List list) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        int n = list.size();
        JCUnit.Point[] pointArray = new JCUnit.Point[n];
        JCUnit.Measure measure = new JCUnit.Measure();
        int n2 = 0;
        while (n2 < n) {
            JCUnit.Point point;
            pointArray[n2] = point = (JCUnit.Point)list.get(n2);
            JCUnit.Measure measure2 = point.getY();
            if (measure2.greaterThan(measure)) {
                measure = measure2;
            }
            ++n2;
        }
        LineRender lineRender = new LineRender(pointArray, jCDrawStyle);
        this.renderList.add(lineRender);
        JCUnit.Measure measure3 = jCDrawStyle.getDrawnWidth();
        measure3.divide(2.0);
        measure.add(measure3);
        if (measure.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure);
        }
    }

    public void drawLine(JCDrawStyle jCDrawStyle, JCUnit.Point[] pointArray) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        int n = pointArray.length;
        JCUnit.Measure measure = new JCUnit.Measure();
        int n2 = 0;
        while (n2 < n) {
            JCUnit.Measure measure2 = pointArray[n2].getY();
            if (measure2.greaterThan(measure)) {
                measure = measure2;
            }
            ++n2;
        }
        LineRender lineRender = new LineRender(pointArray, jCDrawStyle);
        this.renderList.add(lineRender);
        JCUnit.Measure measure3 = jCDrawStyle.getDrawnWidth();
        measure3.divide(2.0);
        measure.add(measure3);
        if (measure.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure);
        }
    }

    public void drawPolygon(JCDrawStyle jCDrawStyle, List list) {
        JCUnit.Point point;
        int n = 0;
        boolean bl = false;
        JCUnit.Point point2 = null;
        jCDrawStyle = jCDrawStyle.getImmutable();
        int n2 = list.size();
        JCUnit.Point point3 = (JCUnit.Point)list.get(0);
        if (n2 > 1) {
            point2 = (JCUnit.Point)list.get(1);
        }
        if (!point3.equals(point = (JCUnit.Point)list.get(n2 - 1))) {
            bl = true;
            n = point2 != null ? 2 : 1;
        } else if (point2 != null) {
            n = 1;
        }
        JCUnit.Point[] pointArray = new JCUnit.Point[n2 + n];
        JCUnit.Measure measure = new JCUnit.Measure();
        int n3 = 0;
        while (n3 < n2) {
            JCUnit.Point point4;
            pointArray[n3] = point4 = (JCUnit.Point)list.get(n3);
            JCUnit.Measure measure2 = point4.getY();
            if (measure2.greaterThan(measure)) {
                measure = measure2;
            }
            ++n3;
        }
        if (bl) {
            pointArray[n2] = (JCUnit.Point)point3.clone();
            if (point2 != null) {
                pointArray[n2 + 1] = (JCUnit.Point)point2.clone();
            }
        } else if (point2 != null) {
            pointArray[n2] = (JCUnit.Point)point2.clone();
        }
        LineRender lineRender = new LineRender(pointArray, jCDrawStyle);
        this.renderList.add(lineRender);
        JCUnit.Measure measure3 = jCDrawStyle.getDrawnWidth();
        measure3.divide(2.0);
        measure.add(measure3);
        if (measure.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure);
        }
    }

    public void drawPolygon(JCDrawStyle jCDrawStyle, JCUnit.Point[] pointArray) {
        boolean bl = false;
        JCUnit.Point[] pointArray2 = null;
        jCDrawStyle = jCDrawStyle.getImmutable();
        int n = pointArray.length;
        JCUnit.Measure measure = new JCUnit.Measure();
        if (!pointArray[0].equals(pointArray[n - 1])) {
            bl = true;
            pointArray2 = new JCUnit.Point[++n];
            pointArray2[n - 1] = (JCUnit.Point)pointArray[0].clone();
        }
        int n2 = 0;
        while (n2 < n - 1) {
            JCUnit.Measure measure2;
            if (bl) {
                pointArray2[n2] = pointArray[n2];
            }
            if ((measure2 = pointArray[n2].getY()).greaterThan(measure)) {
                measure = measure2;
            }
            ++n2;
        }
        if (bl) {
            pointArray = pointArray2;
        }
        LineRender lineRender = new LineRender(pointArray, jCDrawStyle);
        this.renderList.add(lineRender);
        JCUnit.Measure measure3 = jCDrawStyle.getDrawnWidth();
        measure3.divide(2.0);
        measure.add(measure3);
        if (measure.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure);
        }
    }

    public void fillPolygon(JCDrawStyle jCDrawStyle, List list) {
        JCUnit.Point point;
        boolean bl = false;
        jCDrawStyle = jCDrawStyle.getImmutable();
        int n = list.size();
        JCUnit.Point point2 = (JCUnit.Point)list.get(0);
        if (!point2.equals(point = (JCUnit.Point)list.get(n - 1))) {
            ++n;
            bl = true;
        }
        JCUnit.Point[] pointArray = new JCUnit.Point[n];
        JCUnit.Measure measure = new JCUnit.Measure();
        int n2 = 0;
        while (n2 < n - 1) {
            JCUnit.Point point3;
            pointArray[n2] = point3 = (JCUnit.Point)list.get(n2);
            JCUnit.Measure measure2 = point3.getY();
            if (measure2.greaterThan(measure)) {
                measure = measure2;
            }
            ++n2;
        }
        if (bl) {
            pointArray[n - 1] = (JCUnit.Point)point2.clone();
        }
        LineRender lineRender = new LineRender(pointArray, jCDrawStyle);
        lineRender.setFilled(true);
        this.renderList.add(lineRender);
        JCUnit.Measure measure3 = jCDrawStyle.getDrawnWidth();
        measure3.divide(2.0);
        measure.add(measure3);
        if (measure.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure);
        }
    }

    public void fillPolygon(JCDrawStyle jCDrawStyle, JCUnit.Point[] pointArray) {
        boolean bl = false;
        JCUnit.Point[] pointArray2 = null;
        jCDrawStyle = jCDrawStyle.getImmutable();
        int n = pointArray.length;
        JCUnit.Measure measure = new JCUnit.Measure();
        if (!pointArray[0].equals(pointArray[n - 1])) {
            bl = true;
            pointArray2 = new JCUnit.Point[++n];
            pointArray2[n - 1] = (JCUnit.Point)pointArray[0].clone();
        }
        int n2 = 0;
        while (n2 < n - 1) {
            JCUnit.Measure measure2;
            if (bl) {
                pointArray2[n2] = pointArray[n2];
            }
            if ((measure2 = pointArray[n2].getY()).greaterThan(measure)) {
                measure = measure2;
            }
            ++n2;
        }
        if (bl) {
            pointArray = pointArray2;
        }
        LineRender lineRender = new LineRender(pointArray, jCDrawStyle);
        lineRender.setFilled(true);
        this.renderList.add(lineRender);
        JCUnit.Measure measure3 = jCDrawStyle.getDrawnWidth();
        measure3.divide(2.0);
        measure.add(measure3);
        if (measure.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure);
        }
    }

    public void drawRoundedRectangle(JCDrawStyle jCDrawStyle, JCUnit.Point point, JCUnit.Dimension dimension, JCUnit.Measure measure) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        if (measure.isNegative()) {
            throw new IllegalArgumentException("Radius must be positive");
        }
        RoundRectRender roundRectRender = new RoundRectRender(point, dimension, measure, jCDrawStyle);
        this.renderList.add(roundRectRender);
        JCUnit.Measure measure2 = jCDrawStyle.getDrawnWidth();
        measure2.divide(2.0);
        measure2.add(point.getY());
        measure2.add(dimension.getHeight());
        if (measure2.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure2);
        }
    }

    public void drawRoundedRectangle(JCDrawStyle jCDrawStyle, JCUnit.Point point, JCUnit.Point point2, JCUnit.Measure measure) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        if (measure.isNegative()) {
            throw new IllegalArgumentException("Radius must be positive");
        }
        RoundRectRender roundRectRender = new RoundRectRender(point, point2, measure, jCDrawStyle);
        this.renderList.add(roundRectRender);
        JCUnit.Measure measure2 = point.getY();
        JCUnit.Measure measure3 = point2.getY();
        JCUnit.Measure measure4 = jCDrawStyle.getDrawnWidth();
        measure4.divide(2.0);
        if (measure2.greaterThan(measure3)) {
            measure4.add(measure2);
        } else {
            measure4.add(measure3);
        }
        if (measure4.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure4);
        }
    }

    public void fillRoundedRectangle(JCDrawStyle jCDrawStyle, JCUnit.Point point, JCUnit.Dimension dimension, JCUnit.Measure measure) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        if (measure.isNegative()) {
            throw new IllegalArgumentException("Radius must be positive");
        }
        RoundRectRender roundRectRender = new RoundRectRender(point, dimension, measure, jCDrawStyle);
        roundRectRender.setFilled(true);
        this.renderList.add(roundRectRender);
        JCUnit.Measure measure2 = jCDrawStyle.getDrawnWidth();
        measure2.divide(2.0);
        measure2.add(point.getY());
        measure2.add(dimension.getHeight());
        if (measure2.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure2);
        }
    }

    public void fillRoundedRectangle(JCDrawStyle jCDrawStyle, JCUnit.Point point, JCUnit.Point point2, JCUnit.Measure measure) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        if (measure.isNegative()) {
            throw new IllegalArgumentException("Radius must be positive");
        }
        RoundRectRender roundRectRender = new RoundRectRender(point, point2, measure, jCDrawStyle);
        roundRectRender.setFilled(true);
        this.renderList.add(roundRectRender);
        JCUnit.Measure measure2 = point.getY();
        JCUnit.Measure measure3 = point2.getY();
        JCUnit.Measure measure4 = jCDrawStyle.getDrawnWidth();
        measure4.divide(2.0);
        if (measure2.greaterThan(measure3)) {
            measure4.add(measure2);
        } else {
            measure4.add(measure3);
        }
        if (measure4.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure4);
        }
    }

    public void complete() {
        if (this.info.currentLine.size() > 0) {
            JCTextStyle jCTextStyle = this.info.currentTextStyle;
            if (jCTextStyle == null) {
                jCTextStyle = JCTextStyle.DEFAULT_TEXT;
            }
            this.doLineBreak(jCTextStyle, false, true);
        }
        this.calcLayoutStatus();
        if (this.layoutStatus < 4) {
            this.updateLayoutStatus(this.document.getFlow(), this.page);
        } else {
            this.document.getFlow().fireFrameCompleted(this);
        }
    }

    public void calcLayoutStatus() {
        int n = 4;
        super.calcLayoutStatus();
        Iterator iterator = this.renderList.iterator();
        while (iterator.hasNext()) {
            Render render = (Render)iterator.next();
            int n2 = render.getLayoutStatus();
            if (!Render.isLayoutLower(n, n2)) continue;
            n = n2;
        }
        if (Render.isLayoutLower(this.layoutStatus, n)) {
            this.layoutStatus = n;
        }
    }

    public void updateLayoutStatus(JCFlow jCFlow, JCPage jCPage) {
        int n = 4;
        int n2 = -1;
        if (this.layoutStatus == 4) {
            return;
        }
        super.updateLayoutStatus(jCFlow, jCPage);
        int n3 = this.renderList.size();
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            Cloneable cloneable;
            Render render = (Render)this.renderList.get(n4);
            if (render instanceof MacroRender) {
                MacroRender macroRender = (MacroRender)render;
                if (macroRender.getStatus() != 4) {
                    cloneable = macroRender.getSize().getWidth();
                    macroRender.evaluateMacro(jCFlow, jCPage);
                    JCUnit.Measure measure = macroRender.getSize().getWidth();
                    if (!measure.equals(cloneable)) {
                        measure.subtract((JCUnit.Measure)cloneable);
                        this.macroAdjustLine(macroRender, measure, n2);
                    }
                }
            } else if (render instanceof SymbolRender) {
                cloneable = (SymbolRender)render;
                if (((SymbolRender)cloneable).getType() == 3 || ((SymbolRender)cloneable).getType() == 2) {
                    n2 = n4;
                }
                render.setLayoutStatus(4);
            } else {
                render.setLayoutStatus(4);
            }
            if (Render.isLayoutLower(n, n5 = render.getLayoutStatus())) {
                n = n5;
            }
            ++n4;
        }
        if (Render.isLayoutLower(this.layoutStatus, n)) {
            this.layoutStatus = n;
        }
    }

    private void macroAdjustLine(MacroRender macroRender, JCUnit.Measure measure, int n) {
        JCTextStyle jCTextStyle;
        SymbolRender symbolRender;
        Render render;
        int n2 = -1;
        int n3 = 0;
        int n4 = -1;
        int n5 = 2;
        int n6 = 1;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n7 = this.renderList.size();
        int n8 = n + 1;
        while (n8 < n7 && n2 == -1) {
            render = (Render)this.renderList.get(n8);
            if (render instanceof SymbolRender) {
                symbolRender = (SymbolRender)render;
                if (symbolRender.getType() == 3 || symbolRender.getType() == 2) {
                    n2 = n8;
                } else if (symbolRender.getType() == 1) {
                    bl2 = true;
                    if (bl) {
                        n6 = symbolRender.getAlignment();
                        n = n8;
                        bl3 = true;
                    } else {
                        n2 = n8;
                        bl4 = true;
                    }
                }
            } else {
                if (macroRender == render) {
                    bl = false;
                    n4 = n8;
                    if (n6 == 4) {
                        n6 = 2;
                        n2 = n8 + 1;
                    }
                } else if (n6 == 4 && n8 == n + 1) {
                    n6 = 1;
                    n = n8;
                    bl3 = false;
                }
                ++n3;
            }
            ++n8;
        }
        if (bl2) {
            n5 = n6 == 3 ? 4 : (n6 == 2 ? 3 : 2);
        } else if (n2 == -1) {
            n8 = n7 - 1;
            while (n8 > n) {
                render = (Render)this.renderList.get(n8);
                if (render instanceof StringRender || render instanceof MacroRender) {
                    jCTextStyle = render instanceof StringRender ? ((StringRender)render).getStyle() : ((MacroRender)render).getStyle();
                    n5 = jCTextStyle.getAlignment();
                    n8 = n;
                }
                --n8;
            }
            n2 = n7;
        } else {
            jCTextStyle = ((SymbolRender)this.renderList.get(n2)).getStyle();
            n5 = jCTextStyle.getAlignment();
        }
        if (n5 == 5 && n3 == 1) {
            n5 = 4;
        }
        bl = true;
        switch (n5) {
            case 2: {
                JCUnit.Measure measure2;
                n8 = n + 1;
                while (n8 < n2) {
                    render = (Render)this.renderList.get(n8);
                    if (bl) {
                        if (macroRender == render) {
                            bl = false;
                        }
                    } else {
                        JCUnit.Point point = render.getLocation();
                        measure2 = point.getX();
                        measure2.add(measure);
                        point.setX(measure2);
                    }
                    ++n8;
                }
                if (!bl4) break;
                symbolRender = (SymbolRender)this.renderList.get(n2);
                measure2 = symbolRender.getLeaderStart();
                measure2.add(measure);
                symbolRender.setLeaderStart(measure2);
                break;
            }
            case 3: {
                JCUnit.Measure measure3;
                n8 = n + 1;
                while (bl && n8 < n2) {
                    render = (Render)this.renderList.get(n8);
                    if (bl) {
                        JCUnit.Point point = render.getLocation();
                        measure3 = point.getX();
                        measure3.subtract(measure);
                        point.setX(measure3);
                        if (macroRender == render) {
                            bl = false;
                        }
                    }
                    ++n8;
                }
                if (!bl3) break;
                symbolRender = (SymbolRender)this.renderList.get(n);
                measure3 = symbolRender.getLeaderEnd();
                measure3.subtract(measure);
                symbolRender.setLeaderEnd(measure3);
                break;
            }
            case 4: {
                JCUnit.Measure measure4;
                measure.divide(2.0);
                n8 = n + 1;
                while (n8 < n2) {
                    JCUnit.Point point;
                    render = (Render)this.renderList.get(n8);
                    if (bl) {
                        point = render.getLocation();
                        measure4 = point.getX();
                        measure4.subtract(measure);
                        point.setX(measure4);
                        if (macroRender == render) {
                            bl = false;
                        }
                    } else {
                        point = render.getLocation();
                        measure4 = point.getX();
                        measure4.add(measure);
                        point.setX(measure4);
                    }
                    ++n8;
                }
                if (bl3) {
                    symbolRender = (SymbolRender)this.renderList.get(n);
                    measure4 = symbolRender.getLeaderEnd();
                    measure4.subtract(measure);
                    symbolRender.setLeaderEnd(measure4);
                }
                if (!bl4) break;
                symbolRender = (SymbolRender)this.renderList.get(n2);
                measure4 = symbolRender.getLeaderStart();
                measure4.add(measure);
                symbolRender.setLeaderStart(measure4);
                break;
            }
            case 5: {
                JCUnit.Measure measure5 = new JCUnit.Measure(JCUnit.POINTS);
                JCUnit.Measure measure6 = (JCUnit.Measure)measure.clone();
                measure6.divide(n3 - 1);
                n8 = n + 1;
                while (n8 < n2) {
                    render = (Render)this.renderList.get(n8);
                    JCUnit.Point point = render.getLocation();
                    JCUnit.Measure measure7 = point.getX();
                    measure7.subtract(measure5);
                    point.setX(measure7);
                    if (bl && macroRender == render) {
                        bl = false;
                        measure5.subtract(measure);
                    }
                    measure5.add(measure6);
                    ++n8;
                }
                break;
            }
        }
    }

    protected List getRenderList() {
        return this.renderList;
    }

    public Object clone() {
        JCFrame jCFrame;
        if (this.info.currentLine.size() > 0) {
            this.doLineBreak(this.info.currentTextStyle, false);
        }
        try {
            jCFrame = (JCFrame)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        jCFrame.info = new JCFlowInfo();
        jCFrame.frameList = new Vector();
        Iterator iterator = this.frameList.iterator();
        while (iterator.hasNext()) {
            JCFrame jCFrame2 = (JCFrame)iterator.next();
            jCFrame.frameList.add((JCFrame)jCFrame2.clone());
        }
        jCFrame.renderList = new Vector();
        Iterator iterator2 = this.renderList.iterator();
        while (iterator2.hasNext()) {
            Render render = (Render)iterator2.next();
            if (render instanceof StringRender) {
                // empty if block
            }
            jCFrame.renderList.add(render.clone());
        }
        return jCFrame;
    }

    public void draw(Graphics2D graphics2D) {
        if (graphics2D instanceof Graphics2DBase) {
            ((Graphics2DBase)graphics2D).setFrameRoot();
            ((Graphics2DBase)graphics2D).updateContext();
        }
        if (this.color != null) {
            JCDrawStyle jCDrawStyle = new JCDrawStyle();
            jCDrawStyle.setFillForegroundColor(this.color);
            jCDrawStyle.makeImmutable();
            if (this.background == null) {
                this.background = new BoxRender(new JCUnit.Point(), this.size, jCDrawStyle);
                ((BoxRender)this.background).setFilled(true);
            }
            this.background.draw(graphics2D);
        }
        if (this.border != null && this.border.getForegroundColor() != null) {
            double d = this.border.getDrawnWidth().getAs(JCUnit.POINTS);
            if (d <= 0.0) {
                d = 1.0;
            }
            double d2 = this.size.getWidth().getAs(JCUnit.POINTS);
            double d3 = this.size.getHeight().getAs(JCUnit.POINTS);
            double d4 = d / 2.0;
            double d5 = d2 / 2.0;
            double d6 = d3 / 2.0;
            double d7 = d >= d2 ? d2 : (d > d5 ? d2 - d4 : d2 - d);
            double d8 = d >= d3 ? d3 : (d > d6 ? d3 - d4 : d3 - d);
            JCUnit.Dimension dimension = new JCUnit.Dimension(JCUnit.POINTS, d7, d8);
            double d9 = d >= d2 ? 0.0 : (d > d5 ? Math.floor(d4) : d4);
            double d10 = d >= d3 ? 0.0 : (d > d6 ? Math.floor(d4) : d4);
            JCUnit.Point point = new JCUnit.Point(JCUnit.POINTS, d9, d10);
            BoxRender boxRender = new BoxRender(point, dimension, this.border);
            boxRender.draw(graphics2D);
        }
        int n = this.renderList.size();
        int n2 = 0;
        while (n2 < n) {
            Render render = (Render)this.renderList.get(n2);
            render.draw(graphics2D);
            ++n2;
        }
        if (graphics2D instanceof Markup) {
            return;
        }
        Iterator iterator = this.frameList.iterator();
        while (iterator.hasNext()) {
            JCFrame jCFrame = (JCFrame)iterator.next();
            double d = this.size.getWidth().getAs(JCUnit.POINTS);
            double d11 = this.size.getHeight().getAs(JCUnit.POINTS);
            JCUnit.Point point = jCFrame.getLocation();
            double d12 = point.getX().getAs(JCUnit.POINTS);
            double d13 = point.getY().getAs(JCUnit.POINTS);
            JCUnit.Dimension dimension = jCFrame.getSize();
            double d14 = dimension.getWidth().getAs(JCUnit.POINTS);
            double d15 = dimension.getHeight().getAs(JCUnit.POINTS);
            if (d12 > d || d12 + d14 < 0.0 || d13 > d11 || d13 + d15 < 0.0) continue;
            Rectangle2D.Double double_ = new Rectangle2D.Double(d12, d13, d14, d15);
            Rectangle2D.Double double_2 = new Rectangle2D.Double(0.0, 0.0, d, d11);
            Rectangle2D.Double double_3 = this.clipToFrame(double_2, double_);
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            if (graphics2D2 instanceof Graphics2DBase) {
                ((Graphics2DBase)graphics2D2).setFrameRoot();
            }
            graphics2D2.setClip(double_3);
            graphics2D2.translate(d12, d13);
            double_2.x -= d12;
            double_2.y -= d13;
            JCUnit.Margins margins = jCFrame.getClipMask();
            if (margins != null) {
                d12 = margins.getLeft().getAs(JCUnit.POINTS);
                d13 = margins.getTop().getAs(JCUnit.POINTS);
                d14 = margins.getRight().getAs(JCUnit.POINTS);
                d15 = margins.getBottom().getAs(JCUnit.POINTS);
                double_ = new Rectangle2D.Double(d12, d13, d14, d15);
                double_3 = this.clipToFrame(double_2, double_);
                graphics2D2.setClip(double_3);
            }
            jCFrame.draw(graphics2D2);
            graphics2D2.dispose();
        }
    }

    private Rectangle2D.Double clipToFrame(Rectangle2D.Double double_, Rectangle2D.Double double_2) {
        Rectangle2D.Double double_3 = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        if (double_2.x < double_.x) {
            double_3.x = double_.x;
            double_3.width = double_2.width + double_2.x - double_.x;
        } else {
            double_3.x = double_2.x;
            double_3.width = double_2.width;
        }
        if (double_2.y < double_.y) {
            double_3.y = double_.y;
            double_3.height = double_2.height + double_2.y - double_.y;
        } else {
            double_3.y = double_2.y;
            double_3.height = double_2.height;
        }
        if (double_3.x + double_3.width > double_.x + double_.width) {
            double_3.width = double_.x + double_.width - double_3.x;
        }
        if (double_3.y + double_3.height > double_.height) {
            double_3.height = double_.y + double_.height - double_3.y;
        }
        return double_3;
    }

    private void computeColumnWidth() {
        JCUnit.Measure measure = this.size.getWidth();
        measure.subtract(this.margin.getLeft());
        measure.subtract(this.margin.getRight());
        if (measure.isNegative()) {
            throw new IllegalArgumentException("Printable space would be < 0");
        }
        if (this.columnCount > 1) {
            JCUnit.Measure measure2 = (JCUnit.Measure)this.columnSpace.clone();
            measure2.multiply(this.columnCount - 1);
            measure.subtract(measure2);
            measure.divide(this.columnCount);
            if (measure.isNegative()) {
                throw new IllegalArgumentException("Column widths would be < 0");
            }
        }
        this.columnWidth.assign(measure);
    }

    /*
     * Unable to fully structure code
     */
    private void reflow(Graphics2D var1_1, List var2_2) throws EndOfFrameException {
        var4_3 = var2_2.size();
        var3_4 = 0;
        while (var3_4 < var4_3) {
            block11: {
                var5_5 = (Render)var2_2.get(var3_4);
                if (var5_5 instanceof SymbolRender) {
                    var6_6 = ((SymbolRender)var5_5).getType();
                    this.info.currentTextStyle = ((SymbolRender)var5_5).getStyle();
                    if (var6_6 == 1) {
                        this.tab(this.info.currentTextStyle);
                    } else if (var6_6 == 3 || var6_6 == 2) {
                        this.newLine(this.info.currentTextStyle);
                    }
                } else {
                    if (var5_5 instanceof StringRender) {
                        this.info.currentTextStyle = ((StringRender)var5_5).getStyle();
                    }
                    if (var5_5 instanceof MacroRender) {
                        ((MacroRender)var5_5).evaluateMacro(null, this.page);
                    }
                    try {
                        this.flowPrint(var1_1, var5_5, false);
                        break block11;
                    }
                    catch (EndOfFrameException var6_7) {
                        ++var3_4;
                        ** while (var3_4 < var4_3)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var6_7.currentLine.add(var2_2.get(var3_4++));
                        continue;
                    }
lbl28:
                    // 1 sources

                    throw var6_7;
                }
            }
            ++var3_4;
        }
    }

    private boolean isInfoInitialised() {
        return this.info.lineEnd.distance != -1.0;
    }

    protected void initialiseInfo() {
        this.initialiseInfo(true);
    }

    protected void initialiseInfo(boolean bl) {
        JCTextStyle jCTextStyle = this.info.currentTextStyle == null ? JCTextStyle.DEFAULT_TEXT : this.info.currentTextStyle;
        this.info.leftOfColumn.assign(this.margin.getLeft());
        this.info.rightOfColumn.assign(this.info.leftOfColumn);
        this.info.rightOfColumn.add(this.columnWidth);
        this.info.insertion = new JCUnit.Point(this.info.leftOfColumn.units);
        this.computeLineBounds(jCTextStyle, bl);
        this.info.insertion.setX(this.info.lineBegin);
        JCUnit.Measure measure = this.getFirstLineOffset(jCTextStyle);
        measure.add(this.margin.getTop());
        this.info.insertion.setY(measure);
    }

    private void flowPrint(Graphics2D graphics2D, Render render, boolean bl) throws EndOfFrameException {
        Cloneable cloneable;
        int n;
        JCUnit.Measure measure;
        JCTextStyle jCTextStyle;
        double d = 0.0;
        double d2 = 0.0;
        if (!this.isInfoInitialised()) {
            this.initialiseInfo();
        }
        JCUnit.Measure measure2 = render.getSize().getWidth();
        JCUnit.Measure measure3 = this.size.getHeight();
        measure3.subtract(this.margin.getBottom());
        if (render instanceof StringRender) {
            jCTextStyle = ((StringRender)render).getStyle();
            measure = ((StringRender)render).getTrimWidth(graphics2D);
        } else {
            jCTextStyle = this.info.currentTextStyle;
            if (jCTextStyle == null) {
                jCTextStyle = JCTextStyle.DEFAULT_TEXT;
            }
            measure = measure2;
        }
        if (this.info.currentLine.size() == 0 && this.info.firstLine) {
            this.computeLineBounds(jCTextStyle, this.info.firstLine);
            this.info.insertion.setX(this.info.lineBegin);
        }
        JCUnit.Measure measure4 = new JCUnit.Measure();
        if (this.info.currentTab != null) {
            n = this.info.currentTab.getTabAlignment();
            switch (n) {
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    measure4.assign(this.info.tabSymbol.getLeaderEnd());
                    measure4.subtract(this.info.tabSymbol.getLeaderStart());
                    if (!measure4.isZero()) break;
                    n = 1;
                    break;
                }
                case 4: {
                    measure4.assign(this.info.tabSymbol.getLeaderEnd());
                    measure4.subtract(this.info.tabSymbol.getLeaderStart());
                    if (render instanceof StringRender && ((StringRender)render).hasDecimal() && measure4.greaterThan((JCUnit.Measure)(cloneable = ((StringRender)render).getDecimalPosition()))) {
                        measure4 = cloneable;
                    }
                    bl = true;
                }
            }
        } else {
            n = 1;
        }
        JCUnit.Measure measure5 = (JCUnit.Measure)this.info.lineEnd.clone();
        measure5.subtract(this.info.insertion.getX());
        JCUnit.Measure measure6 = (JCUnit.Measure)measure5.clone();
        measure6.add(measure4);
        if (measure6.isZero() || measure6.isNegative()) {
            measure6.distance = 0.0;
        }
        if (!measure.greaterThan(measure6) || bl) {
            JCUnit.Measure measure7;
            JCUnit.Measure measure8;
            JCUnit.Point point;
            double d3;
            double d4;
            double d5;
            double d6;
            Object object;
            cloneable = new JCUnit.Measure(JCUnit.POINTS, jCTextStyle.getPointSize());
            if (this.info.lineSpacing.lessThan((JCUnit.Measure)cloneable) || this.info.currentLine.size() == 0) {
                this.info.lineSpacing = cloneable;
            }
            if (render instanceof StringRender || render instanceof MacroRender) {
                double d7;
                Object object2;
                Font font = jCTextStyle.getFont();
                object = graphics2D.getFontMetrics(font);
                String string = render instanceof MacroRender ? ((MacroRender)render).getText() : ((StringRender)render).getText();
                if (jCTextStyle.getBaselineOffset() == 1) {
                    d = ((FontMetrics)object).getAscent();
                    d2 = ((FontMetrics)object).getDescent();
                    if (jCTextStyle.getUnderlining() == 2) {
                        object2 = ((FontMetrics)object).getLineMetrics(string, graphics2D);
                        double d8 = ((LineMetrics)object2).getUnderlineOffset();
                        if ((d8 += (double)((LineMetrics)object2).getUnderlineThickness()) > d2) {
                            d2 = d8;
                        }
                    }
                    d7 = 0.0;
                } else {
                    Font font2 = FontBase.deriveFont(font, (float)((double)FontBase.getSize2D(font) * jCTextStyle.getSubscriptRatio()));
                    FontMetrics fontMetrics = graphics2D.getFontMetrics(font2);
                    font2 = fontMetrics.getFont();
                    FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                    object2 = FontBase.createGlyphVector(font2, fontRenderContext, "x");
                    GlyphVector glyphVector = FontBase.createGlyphVector(font2, fontRenderContext, string);
                    Rectangle2D rectangle2D = ((GlyphVector)object2).getLogicalBounds();
                    Rectangle2D rectangle2D2 = glyphVector.getLogicalBounds();
                    double d9 = -rectangle2D.getY();
                    double d10 = -rectangle2D2.getY();
                    double d11 = rectangle2D2.getHeight() + rectangle2D2.getY();
                    if (jCTextStyle.getBaselineOffset() == 3) {
                        d = d9 + d10;
                        d7 = d9;
                    } else {
                        d = fontMetrics.getAscent();
                        d7 = d9 - (double)fontMetrics.getAscent();
                    }
                    d2 = d11 - d7;
                    if ((double)((FontMetrics)object).getAscent() > this.info.ascender.getAs(JCUnit.POINTS)) {
                        this.info.ascender = new JCUnit.Measure(JCUnit.POINTS, ((FontMetrics)object).getAscent());
                    }
                    if ((double)((FontMetrics)object).getDescent() > this.info.descender.getAs(JCUnit.POINTS)) {
                        this.info.descender = new JCUnit.Measure(JCUnit.POINTS, ((FontMetrics)object).getDescent());
                    }
                }
                double d12 = ((FontMetrics)object).getLeading();
                d12 = jCTextStyle.getPointSize() - (double)((FontMetrics)object).getAscent() - (double)((FontMetrics)object).getDescent();
                JCUnit.Measure measure9 = new JCUnit.Measure(JCUnit.POINTS, d12);
                if (measure9.greaterThan(this.info.leading)) {
                    this.info.leading = measure9;
                }
                if (d + d2 + d12 > this.info.lineSpacing.getAs(JCUnit.POINTS) && jCTextStyle.getBaselineOffset() == 1) {
                    this.info.lineSpacing = new JCUnit.Measure(JCUnit.POINTS, d + d2 + d12);
                }
                d6 = this.info.descender.getAs(JCUnit.POINTS);
                d5 = this.info.embedDescent.getAs(JCUnit.POINTS);
                if (d2 > d6) {
                    this.info.descender = new JCUnit.Measure(JCUnit.POINTS, d2);
                } else {
                    d2 = d6 > d5 ? d6 : d5;
                }
                d4 = this.info.ascender.getAs(JCUnit.POINTS);
                d3 = this.info.embedAscent.getAs(JCUnit.POINTS);
                if (d > d4) {
                    this.info.ascender = new JCUnit.Measure(JCUnit.POINTS, d);
                    if (d > d3) {
                        this.pushLineDown(d - d4, d2 - d6, true);
                    }
                } else {
                    d = d4 > d3 ? d4 : d3;
                }
                if (d + d2 + d12 > this.info.height.getAs(JCUnit.POINTS)) {
                    this.info.height.assign(this.info.ascender);
                    this.info.height.add(this.info.descender);
                    this.info.height.add(new JCUnit.Measure(JCUnit.POINTS, d12));
                }
                point = render.getLocation();
                measure8 = new JCUnit.Measure(JCUnit.POINTS, d - d7);
                measure8.add(this.info.insertion.getY());
                point.setY(measure8);
            } else {
                d6 = render.getSize().getHeight().getAs(JCUnit.POINTS);
                int n2 = render instanceof Embedable ? ((Embedable)((Object)render)).getVerticalAlignment() : 3;
                d = this.computeAscent(d6, n2);
                d2 = d6 - d;
                if (!this.isVariable(n2)) {
                    d5 = this.info.descender.getAs(JCUnit.POINTS);
                    if (d2 > d5) {
                        this.info.descender = new JCUnit.Measure(JCUnit.POINTS, d2);
                    }
                    if (d > (d4 = this.info.ascender.getAs(JCUnit.POINTS))) {
                        this.info.ascender = new JCUnit.Measure(JCUnit.POINTS, d);
                        this.pushLineDown(d - d4, d2 - d5, true);
                    }
                    measure8 = new JCUnit.Measure(JCUnit.POINTS, -d);
                    if (this.info.ascender.greaterThan(this.info.embedAscent)) {
                        measure8.add(this.info.ascender);
                    } else {
                        measure8.add(this.info.embedAscent);
                    }
                } else {
                    d5 = this.info.embedAscent.getAs(JCUnit.POINTS);
                    d4 = this.info.embedDescent.getAs(JCUnit.POINTS);
                    if (d > d5) {
                        this.info.embedAscent = new JCUnit.Measure(JCUnit.POINTS, d);
                        if (this.info.embedAscent.greaterThan(this.info.ascender)) {
                            d3 = this.info.ascender.getAs(JCUnit.POINTS);
                            if (d3 > (d5 = this.info.ascender.getAs(JCUnit.POINTS))) {
                                d5 = d3;
                            }
                            this.pushLineDown(d - d5, 0.0, false);
                        }
                    }
                    if (d2 > d4) {
                        this.info.embedDescent = new JCUnit.Measure(JCUnit.POINTS, d2);
                    }
                    measure8 = new JCUnit.Measure(JCUnit.POINTS, -d);
                    if (this.info.ascender.greaterThan(this.info.embedAscent)) {
                        measure8.add(this.info.ascender);
                    } else {
                        measure8.add(this.info.embedAscent);
                    }
                }
                point = render.getLocation();
                measure8.add(this.info.insertion.getY());
                point.setY(measure8);
            }
            if (this.info.ascender.greaterThan(this.info.embedAscent)) {
                this.info.height.assign(this.info.ascender);
            } else {
                this.info.height.assign(this.info.embedAscent);
            }
            if (this.info.descender.greaterThan(this.info.embedDescent)) {
                this.info.height.add(this.info.descender);
            } else {
                this.info.height.add(this.info.embedDescent);
            }
            if (this.info.height.greaterThan(this.info.lineSpacing)) {
                this.info.lineSpacing.assign(this.info.height);
            }
            point = render.getLocation();
            if (n == 1) {
                measure7 = this.info.insertion.getX();
                point.setX(measure7);
                measure7.add(measure2);
            } else if (n == 3) {
                JCUnit.Measure measure10;
                JCUnit.Measure measure11 = (JCUnit.Measure)measure2.clone();
                measure11.divide(2.0);
                if (measure11.greaterThan(measure4)) {
                    measure10 = measure4;
                    measure11.multiply(2.0);
                    measure11.subtract(measure4);
                    this.info.currentTab = null;
                } else if (measure11.greaterThan(measure5)) {
                    measure10 = (JCUnit.Measure)measure2.clone();
                    measure10.subtract(measure5);
                    measure11 = measure5;
                } else {
                    measure10 = measure11;
                }
                int n3 = this.info.tabIndex;
                while (n3 < this.info.currentLine.size()) {
                    Render render2 = (Render)this.info.currentLine.get(n3);
                    JCUnit.Point point2 = render2.getLocation();
                    measure7 = point2.getX();
                    measure7.subtract(measure10);
                    point2.setX(measure7);
                    ++n3;
                }
                measure7 = this.info.tabSymbol.getLeaderEnd();
                measure7.subtract(measure10);
                this.info.tabSymbol.setLeaderEnd(measure7);
                measure7 = this.info.insertion.getX();
                measure7.subtract(measure10);
                point.setX(measure7);
                if (this.info.currentTab == null) {
                    this.info.tabIndex = -1;
                }
                measure7.add(measure2);
            } else if (n == 2) {
                JCUnit.Measure measure12;
                JCUnit.Measure measure13 = new JCUnit.Measure();
                if (measure2.greaterThan(measure4)) {
                    measure12 = measure4;
                    measure13.assign(measure2);
                    measure13.subtract(measure4);
                    this.info.currentTab = null;
                } else {
                    measure12 = measure2;
                }
                int n4 = this.info.tabIndex;
                while (n4 < this.info.currentLine.size()) {
                    Render render3 = (Render)this.info.currentLine.get(n4);
                    JCUnit.Point point3 = render3.getLocation();
                    measure7 = point3.getX();
                    measure7.subtract(measure12);
                    point3.setX(measure7);
                    ++n4;
                }
                measure7 = this.info.tabSymbol.getLeaderEnd();
                measure7.subtract(measure12);
                this.info.tabSymbol.setLeaderEnd(measure7);
                measure7 = this.info.insertion.getX();
                measure7.subtract(measure12);
                point.setX(measure7);
                if (this.info.currentTab == null) {
                    this.info.tabIndex = -1;
                }
                measure7.add(measure2);
            } else {
                boolean bl2 = false;
                if (render instanceof StringRender) {
                    bl2 = ((StringRender)render).hasDecimal();
                }
                JCUnit.Measure measure14 = new JCUnit.Measure();
                Object object3 = bl2 ? (((JCUnit.Measure)(object = ((StringRender)render).getDecimalPosition())).greaterThan(measure4) ? measure4 : object) : (measure2.greaterThan(measure4) ? measure4 : measure2);
                measure14.assign(measure2);
                measure14.subtract((JCUnit.Measure)object3);
                measure7 = this.info.tabSymbol.getLeaderEnd();
                measure7.subtract((JCUnit.Measure)object3);
                this.info.tabSymbol.setLeaderEnd(measure7);
                measure7 = this.info.insertion.getX();
                measure7.subtract((JCUnit.Measure)object3);
                point.setX(measure7);
                this.info.currentTab = null;
                this.info.tabIndex = -1;
                measure7.add(measure2);
            }
            this.info.currentLine.add(render);
            this.info.insertion.setX(measure7);
            measure8 = this.info.insertion.getY();
            measure8.add(this.info.height);
            if (measure8.greaterThan(measure3)) {
                this.newColumn(jCTextStyle, false);
            }
            if (measure7.greaterThan(this.info.lineEnd)) {
                this.doLineBreak(jCTextStyle, false);
            }
        } else if (render.isAtomic()) {
            if (this.info.insertion.getX().greaterThan(this.info.lineBegin)) {
                this.doLineBreak(jCTextStyle, false);
                this.flowPrint(graphics2D, render, false);
            } else {
                this.flowPrint(graphics2D, render, true);
            }
        } else {
            Object object;
            Render render4 = ((Splitable)((Object)render)).splitBefore(graphics2D, measure6);
            Render render5 = ((Splitable)((Object)render)).splitAfter(graphics2D, measure6);
            if (render4.getSize().width == 0.0) {
                object = (JCUnit.Measure)this.info.lineEnd.clone();
                ((JCUnit.Measure)object).subtract(this.info.lineBegin);
                cloneable = measure2.greaterThan((JCUnit.Measure)object) ? ((Splitable)((Object)render)).splitBefore(graphics2D, (JCUnit.Measure)object) : render;
                if (((Render)cloneable).getSize().width == 0.0 || this.info.currentLine.size() == 0) {
                    Render render6 = ((Splitable)((Object)render)).forceSplit(graphics2D, measure6);
                    if (render6.getSize().width <= measure6.getAs(JCUnit.POINTS) || this.info.currentLine.size() == 0) {
                        render4 = render6;
                        bl = true;
                        render5 = ((Splitable)((Object)render)).splitAfter(graphics2D, measure6);
                    }
                }
            }
            if (render4.getSize().width > 0.0) {
                try {
                    this.flowPrint(graphics2D, render4, bl);
                }
                catch (EndOfFrameException endOfFrameException) {
                    object = endOfFrameException.getCurrentLine();
                    int n5 = object.size() - 1;
                    Render render7 = (Render)object.get(n5);
                    ((StringRender)render7).unsplit(graphics2D, render5);
                    throw endOfFrameException;
                }
            }
            if (this.info.insertion.getX().greaterThan(this.info.lineBegin)) {
                this.doLineBreak(jCTextStyle, false);
            }
            if (render5.getSize().width > 0.0) {
                this.flowPrint(graphics2D, render5, false);
            }
        }
        if (this.info.currentTextStyle == null || render instanceof StringRender) {
            this.info.currentTextStyle = jCTextStyle;
        }
    }

    private void pushLineDown(double d, double d2, boolean bl) {
        double d3;
        double d4;
        double d5;
        int n;
        Render render;
        int n2;
        int n3 = this.info.currentLine.size();
        if (bl) {
            double d6 = 0.0;
            double d7 = 0.0;
            n2 = 0;
            while (n2 < n3) {
                render = (Render)this.info.currentLine.get(n2);
                if (render instanceof Embedable && this.isVariable(n = ((Embedable)((Object)render)).getVerticalAlignment())) {
                    d5 = render.getSize().getHeight().getAs(JCUnit.POINTS);
                    d4 = this.computeAscent(d5, n);
                    d3 = d5 - d4;
                    if (d4 > d6) {
                        d6 = d4;
                    }
                    if (d3 > d7) {
                        d7 = d3;
                    }
                }
                ++n2;
            }
            double d8 = this.info.embedAscent.getAs(JCUnit.POINTS);
            double d9 = d8 - d6;
            this.info.embedAscent = new JCUnit.Measure(JCUnit.POINTS, d6);
            this.info.embedDescent = new JCUnit.Measure(JCUnit.POINTS, d7);
            d -= d9;
        }
        n2 = 0;
        while (n2 < n3) {
            JCUnit.Point point;
            JCUnit.Measure measure;
            render = (Render)this.info.currentLine.get(n2);
            if (render instanceof Embedable && bl && this.isVariable(n = ((Embedable)((Object)render)).getVerticalAlignment())) {
                d5 = render.getSize().getHeight().getAs(JCUnit.POINTS);
                d4 = this.computeAscent(d5, n);
                d3 = d5 - d4;
                measure = this.info.insertion.getY();
                if (this.info.ascender.greaterThan(this.info.embedAscent)) {
                    measure.add(this.info.ascender);
                } else {
                    measure.add(this.info.embedAscent);
                }
                measure.subtract(new JCUnit.Measure(JCUnit.POINTS, d4));
                point = render.getLocation();
                point.setY(measure);
            } else {
                point = render.getLocation();
                measure = point.getY();
                measure.add(new JCUnit.Measure(JCUnit.POINTS, d));
                point.setY(measure);
            }
            ++n2;
        }
    }

    private boolean isVariable(int n) {
        switch (n) {
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    private double computeAscent(double d, int n) {
        double d2;
        switch (n) {
            case 1: {
                d2 = d;
                break;
            }
            case 2: {
                d2 = 0.0;
                break;
            }
            case 3: {
                d2 = d / 2.0;
                break;
            }
            case 4: {
                double d3 = this.info.ascender.getAs(JCUnit.POINTS) / 2.0;
                d2 = d3 + d / 2.0;
                break;
            }
            case 5: {
                double d4 = (this.info.ascender.getAs(JCUnit.POINTS) - this.info.descender.getAs(JCUnit.POINTS)) / 2.0;
                d2 = d4 + d / 2.0;
                break;
            }
            case 6: {
                d2 = this.info.ascender.getAs(JCUnit.POINTS);
                break;
            }
            case 7: {
                d2 = d - this.info.descender.getAs(JCUnit.POINTS);
                break;
            }
            default: {
                d2 = -1.0;
            }
        }
        return d2;
    }

    private void pasteFloats() {
        if (this.info.floatList.size() == 0) {
            return;
        }
        if (this.info.currentTextStyle == null) {
            this.info.currentTextStyle = JCTextStyle.DEFAULT_TEXT;
        }
        if (!this.isInfoInitialised()) {
            this.initialiseInfo();
        }
        Floatable floatable = (Floatable)this.info.floatList.firstElement();
        JCUnit.Dimension dimension = floatable.getSize();
        JCUnit.Measure measure = this.size.getHeight();
        measure.subtract(this.margin.getBottom());
        if (this.info.insertion.getY().distance == 0.0) {
            this.info.insertion.setY(this.getFirstLineOffset(this.info.currentTextStyle));
        }
        measure.subtract(this.info.insertion.getY());
        while (dimension.getHeight().lessThan(measure)) {
            JCUnit.Point point = floatable.getLocation();
            switch (floatable.getAlignment()) {
                case 1: 
                case 2: {
                    point.setX(this.info.leftOfColumn);
                    break;
                }
                case 3: {
                    JCUnit.Measure measure2 = (JCUnit.Measure)this.info.rightOfColumn.clone();
                    measure2.subtract(dimension.getWidth());
                    point.setX(measure2);
                    break;
                }
                case 4: 
                case 5: {
                    JCUnit.Measure measure2 = (JCUnit.Measure)this.info.rightOfColumn.clone();
                    measure2.add(this.info.leftOfColumn);
                    measure2.subtract(dimension.getWidth());
                    measure2.divide(2.0);
                    point.setX(measure2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid alignment");
                }
            }
            JCUnit.Measure measure3 = this.info.insertion.getY();
            point.setY(measure3);
            this.info.floatList.remove(0);
            this.renderList.add(floatable);
            JCUnit.Measure measure4 = this.getFirstLineOffset(this.info.currentTextStyle);
            measure4.add(dimension.getHeight());
            measure.subtract(measure4);
            measure3.add(measure4);
            this.info.insertion.setY(measure3);
            if (this.info.floatList.size() == 0) break;
            floatable = (Floatable)this.info.floatList.firstElement();
            dimension = floatable.getSize();
        }
    }
}

