/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page;

import com.klg.jclass.page.EPSImage;
import com.klg.jclass.page.EndOfFrameException;
import com.klg.jclass.page.JCDocument;
import com.klg.jclass.page.JCDrawStyle;
import com.klg.jclass.page.JCFlowEvent;
import com.klg.jclass.page.JCFlowInfo;
import com.klg.jclass.page.JCFlowListener;
import com.klg.jclass.page.JCFrame;
import com.klg.jclass.page.JCPage;
import com.klg.jclass.page.JCPageTable;
import com.klg.jclass.page.JCTextStyle;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.TextMacro;
import com.klg.jclass.page.render.MacroRender;
import com.klg.jclass.page.render.TableMarker;
import com.klg.jclass.util.JCListenerList;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;

public class JCFlow {
    protected JCDocument document;
    protected JCPage currentPage;
    protected JCFrame currentFrame;
    protected int currentPageNumber;
    protected int currentSectionNumber;
    protected int startingPageNumber;
    protected JCTextStyle currentTextStyle;
    protected JCDrawStyle currentDrawStyle;
    protected List flowFrameList;
    protected int nextFrameIndex;
    protected Vector floatList;
    protected int documentPageCount;
    protected int sectionPageCount;
    protected int documentTotalPages;
    protected int sectionTotalPages;
    protected JCListenerList flowListeners = null;
    protected int flowStatus;
    protected boolean sectionComplete = false;
    protected int deferredPageCount = 0;
    public static final int FLOW_INIT = 0;
    public static final int FLOW_ACTIVE = 1;
    public static final int FLOW_COMPLETE = 2;

    public JCFlow(JCDocument jCDocument) {
        this(jCDocument, null, null);
    }

    public JCFlow(JCDocument jCDocument, JCFlowListener jCFlowListener) {
        this(jCDocument, jCFlowListener, null);
    }

    public JCFlow(JCDocument jCDocument, List list) {
        this(jCDocument, null, list);
    }

    public JCFlow(JCDocument jCDocument, JCFlowListener jCFlowListener, List list) {
        JCPage jCPage = null;
        this.floatList = new Vector();
        this.startingPageNumber = jCDocument.getStartingPageNumber();
        this.currentPageNumber = this.startingPageNumber - 1;
        this.currentSectionNumber = 1;
        this.documentPageCount = 0;
        this.documentTotalPages = -1;
        this.sectionPageCount = 0;
        this.sectionTotalPages = -1;
        this.document = jCDocument;
        this.flowStatus = 0;
        if (list != null) {
            jCDocument.setTemplates(list);
        }
        if (this.document.getTemplates().size() == 0) {
            this.createDefaultTemplate(this.document);
        }
        jCPage = this.document.findFirstTemplate();
        this.currentTextStyle = JCTextStyle.stringToStyle("default text");
        this.currentDrawStyle = JCDrawStyle.stringToStyle("default line");
        if (jCFlowListener != null) {
            this.flowListeners = JCListenerList.add(this.flowListeners, jCFlowListener);
        }
        jCDocument.setFlow(this);
        this.startPage(jCPage);
        while (!this.startFrame()) {
            this.startPage();
        }
        this.flowStatus = 1;
    }

    public boolean isFlowComplete() {
        return this.flowStatus == 2;
    }

    public boolean isFlowActive() {
        return this.flowStatus == 1;
    }

    public boolean isSectionComplete() {
        return this.sectionComplete;
    }

    public int getSectionTotalPages() {
        return this.sectionTotalPages;
    }

    public int getSectionPageNumber() {
        return this.sectionPageCount;
    }

    public int getDocumentTotalPages() {
        return this.documentTotalPages;
    }

    public int getCurrentPageNumber() {
        return this.currentPageNumber;
    }

    public void setCurrentPageNumber(int n) {
        this.currentPageNumber = n;
        if (this.currentPage != null) {
            this.currentPage.setPageNumber(n);
            this.currentPage.updateLayoutStatus(this, this.currentPage);
        }
    }

    public int getCurrentSectionNumber() {
        return this.currentSectionNumber;
    }

    public void setCurrentSectionNumber(int n) {
        this.currentSectionNumber = n;
        if (this.currentPage != null) {
            this.currentPage.setPageNumber(n);
            this.currentPage.updateLayoutStatus(this, this.currentPage);
        }
    }

    public JCPage getCurrentPage() {
        return this.currentPage;
    }

    public JCFrame getCurrentFrame() {
        return this.currentFrame;
    }

    public JCTextStyle getCurrentTextStyle() {
        return this.currentTextStyle;
    }

    public void setCurrentTextStyle(JCTextStyle jCTextStyle) {
        this.currentTextStyle = jCTextStyle;
    }

    public JCDrawStyle getCurrentDrawStyle() {
        return this.currentDrawStyle;
    }

    public void setCurrentDrawStyle(JCDrawStyle jCDrawStyle) {
        this.currentDrawStyle = jCDrawStyle;
    }

    public List getTemplates() {
        return this.document.getTemplates();
    }

    public void print(String string) {
        try {
            this.currentFrame.print(this.currentTextStyle, string);
        }
        catch (EndOfFrameException endOfFrameException) {
            this.nextFlowFrame(endOfFrameException.getCurrentLine(), endOfFrameException.isFirstLine(), endOfFrameException.getFloatList());
        }
    }

    public void print(TextMacro textMacro) {
        textMacro.evaluate(this, this.currentPage);
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        MacroRender macroRender = new MacroRender(graphics2D, textMacro, this.currentTextStyle);
        try {
            this.currentFrame.print(this.currentTextStyle, macroRender);
        }
        catch (EndOfFrameException endOfFrameException) {
            this.nextFlowFrame(endOfFrameException.getCurrentLine(), endOfFrameException.isFirstLine(), endOfFrameException.getFloatList());
            macroRender.evaluateMacro(this, this.currentPage);
        }
    }

    public void print(JCPageTable jCPageTable) {
        JCFlowInfo jCFlowInfo = this.currentFrame.getFlowInfo();
        if (jCFlowInfo.currentLine.size() != 0) {
            this.currentFrame.doLineBreak(jCFlowInfo.currentTextStyle, false);
        }
        TableMarker tableMarker = new TableMarker(jCPageTable, this.currentTextStyle);
        this.currentFrame.getRenderList().add(tableMarker);
        int n = jCPageTable.getRowCount();
        int n2 = jCPageTable.getColumnCount();
        int n3 = 0;
        int n4 = 0;
        Vector vector = jCFlowInfo.floatList;
        jCFlowInfo.floatList = this.floatList;
        this.print(jCPageTable, n3, n4, n, n2);
        jCFlowInfo = this.currentFrame.getFlowInfo();
        jCFlowInfo.floatList = vector;
    }

    protected void print(JCPageTable jCPageTable, int n, int n2, int n3, int n4) {
        this.print(jCPageTable, n, n2, n3, n4, false);
    }

    protected void print(JCPageTable jCPageTable, int n, int n2, int n3, int n4, boolean bl) {
        boolean bl2 = false;
        while (!(bl2 || n >= n3 && n3 != 0 || n2 >= n4)) {
            try {
                if (jCPageTable.getOverflowMode() == 4 && !bl && n2 > 0 && n == 0) {
                    this.newColumn();
                }
                this.currentFrame.print(jCPageTable, n, n2, n3 - 1, n4 - 1);
                bl2 = true;
            }
            catch (EndOfFrameException endOfFrameException) {
                JCPageTable jCPageTable2 = endOfFrameException.getTable();
                this.nextFlowFrame(endOfFrameException.getCurrentLine(), endOfFrameException.isFirstLine(), endOfFrameException.getFloatList());
                bl = true;
                if (jCPageTable == jCPageTable2) {
                    n = endOfFrameException.getTableStartRow();
                    n2 = endOfFrameException.getTableStartColumn();
                    int n5 = endOfFrameException.getTableEndColumn();
                    if (n < n3 && n5 != -1 && n5 < n4) {
                        this.print(jCPageTable, n, n2, n3, n5 + 1, true);
                        bl = false;
                        n = 0;
                        n2 = n5 + 1;
                    }
                } else {
                    n = n3;
                    n2 = n4;
                }
                Object var8_8 = null;
            }
        }
    }

    public void tab() {
        this.currentFrame.tab(this.currentTextStyle);
    }

    public void floatImage(Image image) {
        this.currentFrame.floatImage(image);
    }

    public void floatImage(Image image, int n) {
        this.currentFrame.floatImage(image, n);
    }

    public void floatImage(Image image, JCUnit.Dimension dimension) {
        this.currentFrame.floatImage(image, dimension);
    }

    public void floatImage(Image image, int n, JCUnit.Dimension dimension) {
        this.currentFrame.floatImage(image, n, dimension);
    }

    public void floatIcon(Icon icon) {
        this.currentFrame.floatIcon(icon);
    }

    public void floatIcon(Icon icon, int n) {
        this.currentFrame.floatIcon(icon, n);
    }

    public void floatIcon(Icon icon, JCUnit.Dimension dimension) {
        this.currentFrame.floatIcon(icon, dimension);
    }

    public void floatIcon(Icon icon, int n, JCUnit.Dimension dimension) {
        this.currentFrame.floatIcon(icon, n, dimension);
    }

    public void floatComponent(Component component) {
        this.currentFrame.floatComponent(component);
    }

    public void floatComponent(Component component, int n) {
        this.currentFrame.floatComponent(component, n);
    }

    public void floatComponent(Component component, JCUnit.Dimension dimension) {
        this.currentFrame.floatComponent(component, dimension);
    }

    public void floatComponent(Component component, int n, JCUnit.Dimension dimension) {
        this.currentFrame.floatComponent(component, n, dimension);
    }

    public void floatEPS(EPSImage ePSImage) {
        this.currentFrame.floatEPS(ePSImage);
    }

    public void floatEPS(EPSImage ePSImage, int n) {
        this.currentFrame.floatEPS(ePSImage, n);
    }

    public void floatEPS(EPSImage ePSImage, JCUnit.Dimension dimension) {
        this.currentFrame.floatEPS(ePSImage, dimension);
    }

    public void floatEPS(EPSImage ePSImage, int n, JCUnit.Dimension dimension) {
        this.currentFrame.floatEPS(ePSImage, n, dimension);
    }

    public void embedImage(Image image) {
        try {
            this.currentFrame.embedImage(this.currentTextStyle, image);
        }
        catch (EndOfFrameException endOfFrameException) {
            this.nextFlowFrame(endOfFrameException.getCurrentLine(), endOfFrameException.isFirstLine(), endOfFrameException.getFloatList());
        }
    }

    public void embedImage(Image image, int n) {
        try {
            this.currentFrame.embedImage(this.currentTextStyle, image, n);
        }
        catch (EndOfFrameException endOfFrameException) {
            this.nextFlowFrame(endOfFrameException.getCurrentLine(), endOfFrameException.isFirstLine(), endOfFrameException.getFloatList());
        }
    }

    public void embedImage(Image image, JCUnit.Dimension dimension) {
        try {
            this.currentFrame.embedImage(this.currentTextStyle, image, dimension);
        }
        catch (EndOfFrameException endOfFrameException) {
            this.nextFlowFrame(endOfFrameException.getCurrentLine(), endOfFrameException.isFirstLine(), endOfFrameException.getFloatList());
        }
    }

    public void embedImage(Image image, int n, JCUnit.Dimension dimension) {
        try {
            this.currentFrame.embedImage(this.currentTextStyle, image, n, dimension);
        }
        catch (EndOfFrameException endOfFrameException) {
            this.nextFlowFrame(endOfFrameException.getCurrentLine(), endOfFrameException.isFirstLine(), endOfFrameException.getFloatList());
        }
    }

    public void embedIcon(Icon icon) {
        try {
            this.currentFrame.embedIcon(this.currentTextStyle, icon);
        }
        catch (EndOfFrameException endOfFrameException) {
            this.nextFlowFrame(endOfFrameException.getCurrentLine(), endOfFrameException.isFirstLine(), endOfFrameException.getFloatList());
        }
    }

    public void embedIcon(Icon icon, int n) {
        try {
            this.currentFrame.embedIcon(this.currentTextStyle, icon, n);
        }
        catch (EndOfFrameException endOfFrameException) {
            this.nextFlowFrame(endOfFrameException.getCurrentLine(), endOfFrameException.isFirstLine(), endOfFrameException.getFloatList());
        }
    }

    public void embedIcon(Icon icon, JCUnit.Dimension dimension) {
        try {
            this.currentFrame.embedIcon(this.currentTextStyle, icon, dimension);
        }
        catch (EndOfFrameException endOfFrameException) {
            this.nextFlowFrame(endOfFrameException.getCurrentLine(), endOfFrameException.isFirstLine(), endOfFrameException.getFloatList());
        }
    }

    public void embedIcon(Icon icon, int n, JCUnit.Dimension dimension) {
        try {
            this.currentFrame.embedIcon(this.currentTextStyle, icon, n, dimension);
        }
        catch (EndOfFrameException endOfFrameException) {
            this.nextFlowFrame(endOfFrameException.getCurrentLine(), endOfFrameException.isFirstLine(), endOfFrameException.getFloatList());
        }
    }

    public void embedComponent(Component component) {
        try {
            this.currentFrame.embedComponent(this.currentTextStyle, component);
        }
        catch (EndOfFrameException endOfFrameException) {
            this.nextFlowFrame(endOfFrameException.getCurrentLine(), endOfFrameException.isFirstLine(), endOfFrameException.getFloatList());
        }
    }

    public void embedComponent(Component component, int n) {
        try {
            this.currentFrame.embedComponent(this.currentTextStyle, component, n);
        }
        catch (EndOfFrameException endOfFrameException) {
            this.nextFlowFrame(endOfFrameException.getCurrentLine(), endOfFrameException.isFirstLine(), endOfFrameException.getFloatList());
        }
    }

    public void embedComponent(Component component, JCUnit.Dimension dimension) {
        try {
            this.currentFrame.embedComponent(this.currentTextStyle, component, dimension);
        }
        catch (EndOfFrameException endOfFrameException) {
            this.nextFlowFrame(endOfFrameException.getCurrentLine(), endOfFrameException.isFirstLine(), endOfFrameException.getFloatList());
        }
    }

    public void embedComponent(Component component, int n, JCUnit.Dimension dimension) {
        try {
            this.currentFrame.embedComponent(this.currentTextStyle, component, n, dimension);
        }
        catch (EndOfFrameException endOfFrameException) {
            this.nextFlowFrame(endOfFrameException.getCurrentLine(), endOfFrameException.isFirstLine(), endOfFrameException.getFloatList());
        }
    }

    public void embedEPS(EPSImage ePSImage) {
        try {
            this.currentFrame.embedEPS(this.currentTextStyle, ePSImage);
        }
        catch (EndOfFrameException endOfFrameException) {
            this.nextFlowFrame(endOfFrameException.getCurrentLine(), endOfFrameException.isFirstLine(), endOfFrameException.getFloatList());
        }
    }

    public void embedEPS(EPSImage ePSImage, int n) {
        try {
            this.currentFrame.embedEPS(this.currentTextStyle, ePSImage, n);
        }
        catch (EndOfFrameException endOfFrameException) {
            this.nextFlowFrame(endOfFrameException.getCurrentLine(), endOfFrameException.isFirstLine(), endOfFrameException.getFloatList());
        }
    }

    public void embedEPS(EPSImage ePSImage, JCUnit.Dimension dimension) {
        try {
            this.currentFrame.embedEPS(this.currentTextStyle, ePSImage, dimension);
        }
        catch (EndOfFrameException endOfFrameException) {
            this.nextFlowFrame(endOfFrameException.getCurrentLine(), endOfFrameException.isFirstLine(), endOfFrameException.getFloatList());
        }
    }

    public void embedEPS(EPSImage ePSImage, int n, JCUnit.Dimension dimension) {
        try {
            this.currentFrame.embedEPS(this.currentTextStyle, ePSImage, n, dimension);
        }
        catch (EndOfFrameException endOfFrameException) {
            this.nextFlowFrame(endOfFrameException.getCurrentLine(), endOfFrameException.isFirstLine(), endOfFrameException.getFloatList());
        }
    }

    public void hRule(double d) {
        boolean bl = false;
        while (!bl) {
            try {
                this.currentFrame.hRule(this.currentTextStyle, this.currentDrawStyle, d);
                bl = true;
            }
            catch (EndOfFrameException endOfFrameException) {
                this.nextFlowFrame(endOfFrameException.getCurrentLine(), endOfFrameException.isFirstLine(), endOfFrameException.getFloatList());
            }
        }
    }

    public void hRule(JCUnit.Measure measure) {
        boolean bl = false;
        while (!bl) {
            try {
                this.currentFrame.hRule(this.currentTextStyle, this.currentDrawStyle, measure);
                bl = true;
            }
            catch (EndOfFrameException endOfFrameException) {
                this.nextFlowFrame(endOfFrameException.getCurrentLine(), endOfFrameException.isFirstLine(), endOfFrameException.getFloatList());
            }
        }
    }

    public void newLine() {
        this.currentFrame.newLine(this.currentTextStyle);
    }

    public void newParagraph() {
        this.currentFrame.newParagraph(this.currentTextStyle);
    }

    public void newColumn() {
        try {
            this.currentFrame.newColumn(this.currentTextStyle);
        }
        catch (EndOfFrameException endOfFrameException) {
            this.nextFlowFrame(endOfFrameException.getCurrentLine(), endOfFrameException.isFirstLine(), endOfFrameException.getFloatList());
        }
    }

    public void newFrame() {
        this.currentFrame.doLineBreak(this.currentTextStyle, true);
        int n = this.currentFrame.getColumnCount() - this.currentFrame.getCurrentColumn();
        int n2 = 1;
        while (n2 < n) {
            this.newColumn();
            ++n2;
        }
        JCFlowInfo jCFlowInfo = this.currentFrame.getFlowInfo();
        this.advanceFrame(jCFlowInfo.firstLine, jCFlowInfo.floatList);
    }

    public void newPage() {
        this.endSection();
        JCPage jCPage = this.currentPage.getFlowPageTemplate();
        this.newFlowedPage(jCPage);
    }

    public void newSection() {
        this.endSection();
        ++this.currentSectionNumber;
        this.sectionTotalPages = this.sectionPageCount;
        this.sectionPageCount = 0;
        JCPage jCPage = this.currentPage.getFlowSectionTemplate();
        this.newFlowedPage(jCPage);
        this.sectionComplete = true;
        List list = this.document.getPages();
        int n = this.documentPageCount - this.sectionTotalPages - 1;
        while (n < this.documentPageCount - 1) {
            JCPage jCPage2 = (JCPage)list.get(n);
            jCPage2.updateLayoutStatus(this, jCPage2);
            ++n;
        }
        this.sectionTotalPages = -1;
        this.sectionComplete = false;
    }

    public void endFlow() {
        this.newLine();
        int n = this.currentFrame.getColumnCount() - this.currentFrame.getCurrentColumn();
        int n2 = 1;
        while (n2 < n) {
            this.newColumn();
            ++n2;
        }
        JCFlowInfo jCFlowInfo = this.currentFrame.getFlowInfo();
        while (jCFlowInfo.getFloatList().size() > 0) {
            this.advanceFrame(jCFlowInfo.firstLine, jCFlowInfo.floatList);
            n2 = 1;
            while (n2 < this.currentFrame.getColumnCount()) {
                this.newColumn();
                ++n2;
            }
            jCFlowInfo = this.currentFrame.getFlowInfo();
        }
        this.endFrame();
        this.endPage(null);
        this.sectionTotalPages = this.sectionPageCount;
        this.sectionComplete = true;
        this.flowStatus = 2;
        this.documentTotalPages = this.documentPageCount + this.startingPageNumber - 1;
        Iterator iterator = this.document.getPages().iterator();
        while (iterator.hasNext()) {
            JCPage jCPage = (JCPage)iterator.next();
            jCPage.updateLayoutStatus(this, jCPage);
        }
    }

    public void addFlowListener(JCFlowListener jCFlowListener) {
        this.flowListeners = JCListenerList.add(this.flowListeners, jCFlowListener);
    }

    public void removeFlowListener(JCFlowListener jCFlowListener) {
        this.flowListeners = JCListenerList.remove(this.flowListeners, jCFlowListener);
    }

    private void endSection() {
        this.newLine();
        int n = this.currentFrame.getColumnCount() - this.currentFrame.getCurrentColumn();
        int n2 = 1;
        while (n2 < n) {
            this.newColumn();
            ++n2;
        }
        JCFlowInfo jCFlowInfo = this.currentFrame.getFlowInfo();
        while (jCFlowInfo.getFloatList().size() > 0) {
            this.advanceFrame(jCFlowInfo.firstLine, jCFlowInfo.floatList);
            n2 = 1;
            while (n2 < this.currentFrame.getColumnCount()) {
                this.newColumn();
                ++n2;
            }
            jCFlowInfo = this.currentFrame.getFlowInfo();
        }
        this.endFrame();
    }

    private void newFlowedPage(JCPage jCPage) {
        this.startPage(jCPage);
        while (!this.startFrame()) {
            this.startPage();
        }
    }

    private void nextFlowFrame(List list, boolean bl, List list2) {
        boolean bl2 = false;
        while (!bl2) {
            this.advanceFrame(bl, list2);
            if (list != null) {
                try {
                    this.currentFrame.setCurrentLine(list);
                    bl2 = true;
                }
                catch (EndOfFrameException endOfFrameException) {
                    bl = endOfFrameException.isFirstLine();
                    list2 = endOfFrameException.getFloatList();
                    list = endOfFrameException.getCurrentLine();
                }
                continue;
            }
            bl2 = true;
        }
    }

    private void advanceFrame() {
        this.endFrame();
        while (!this.startFrame()) {
            this.startPage();
        }
    }

    private void advanceFrame(boolean bl, List list) {
        this.endFrame();
        while (!this.startFrame(bl, list)) {
            this.startPage();
        }
    }

    private JCFrame nextFrame() {
        if (this.nextFrameIndex == this.flowFrameList.size()) {
            return null;
        }
        return (JCFrame)this.flowFrameList.get(this.nextFrameIndex);
    }

    private void incrementFrame() {
        ++this.nextFrameIndex;
    }

    private boolean startFrame(boolean bl, List list) {
        this.currentFrame = this.nextFrame();
        if (this.currentFrame == null) {
            return false;
        }
        this.incrementFrame();
        this.currentFrame.getFlowInfo().currentTextStyle = this.currentTextStyle;
        this.currentFrame.initialiseInfo(bl);
        JCFlowEvent jCFlowEvent = new JCFlowEvent(this, 4, this.currentFrame);
        Enumeration enumeration = JCListenerList.elements(this.flowListeners);
        while (enumeration.hasMoreElements()) {
            JCFlowListener jCFlowListener = (JCFlowListener)enumeration.nextElement();
            jCFlowListener.frameBegin(jCFlowEvent);
        }
        this.currentFrame.addFloats(list);
        return true;
    }

    private boolean startFrame() {
        this.currentFrame = this.nextFrame();
        if (this.currentFrame == null) {
            return false;
        }
        this.incrementFrame();
        this.currentFrame.getFlowInfo().currentTextStyle = this.currentTextStyle;
        this.currentFrame.initialiseInfo();
        JCFlowEvent jCFlowEvent = new JCFlowEvent(this, 4, this.currentFrame);
        Enumeration enumeration = JCListenerList.elements(this.flowListeners);
        while (enumeration.hasMoreElements()) {
            JCFlowListener jCFlowListener = (JCFlowListener)enumeration.nextElement();
            jCFlowListener.frameBegin(jCFlowEvent);
        }
        return true;
    }

    private void endFrame() {
        JCFlowEvent jCFlowEvent = new JCFlowEvent(this, 5, this.currentFrame, this.nextFrame());
        Enumeration enumeration = JCListenerList.elements(this.flowListeners);
        while (enumeration.hasMoreElements()) {
            JCFlowListener jCFlowListener = (JCFlowListener)enumeration.nextElement();
            jCFlowListener.frameEnd(jCFlowEvent);
        }
        this.currentFrame.complete();
    }

    protected void fireFrameCompleted(JCFrame jCFrame) {
        JCFlowEvent jCFlowEvent = new JCFlowEvent(this, 6, this.currentFrame);
        Enumeration enumeration = JCListenerList.elements(this.flowListeners);
        while (enumeration.hasMoreElements()) {
            JCFlowListener jCFlowListener = (JCFlowListener)enumeration.nextElement();
            jCFlowListener.frameComplete(jCFlowEvent);
        }
    }

    private void startPage(JCPage jCPage) {
        this.endPage(jCPage);
        this.currentPage = new JCPage(Integer.toString(this.currentPageNumber + 1), this.document, jCPage);
        this.document.addPage(this.currentPage, true, true);
        this.currentPage.updateLayoutStatus(this, this.currentPage);
        this.flowFrameList = this.currentPage.getFlowFrameList();
        this.nextFrameIndex = 0;
        JCFlowEvent jCFlowEvent = new JCFlowEvent(this, 1, this.currentPage);
        Enumeration enumeration = JCListenerList.elements(this.flowListeners);
        while (enumeration.hasMoreElements()) {
            JCFlowListener jCFlowListener = (JCFlowListener)enumeration.nextElement();
            jCFlowListener.pageBegin(jCFlowEvent);
        }
        this.flowFrameList = this.currentPage.getFlowFrameList();
    }

    private void startPage() {
        JCPage jCPage = this.currentPage.getFlowPageTemplate();
        this.endPage(jCPage);
        this.currentPage = new JCPage(Integer.toString(this.currentPageNumber + 1), this.document, jCPage);
        this.document.addPage(this.currentPage, true, true);
        this.currentPage.updateLayoutStatus(this, this.currentPage);
        this.flowFrameList = this.currentPage.getFlowFrameList();
        this.nextFrameIndex = 0;
        JCFlowEvent jCFlowEvent = new JCFlowEvent(this, 1, this.currentPage);
        Enumeration enumeration = JCListenerList.elements(this.flowListeners);
        while (enumeration.hasMoreElements()) {
            JCFlowListener jCFlowListener = (JCFlowListener)enumeration.nextElement();
            jCFlowListener.pageBegin(jCFlowEvent);
        }
        this.flowFrameList = this.currentPage.getFlowFrameList();
    }

    protected void updatePageNumbers(JCPage jCPage) {
        int n = 0;
        if (jCPage != null) {
            n = 1;
        }
        this.deferredPageCount = 0;
        this.currentPageNumber += (n += this.deferredPageCount);
        this.sectionPageCount += n;
        this.documentPageCount += n;
        if (jCPage != null) {
            jCPage.setPageNumber(this.documentPageCount);
        }
    }

    protected void deferCountingNewPage(JCPage jCPage) {
        ++this.deferredPageCount;
        if (jCPage != null) {
            jCPage.setPageNumber(this.documentPageCount + this.deferredPageCount);
        }
    }

    private void endPage(JCPage jCPage) {
        JCFlowListener jCFlowListener;
        if (this.currentPage == null) {
            return;
        }
        Iterator iterator = this.currentPage.getFrameList().iterator();
        while (iterator.hasNext()) {
            JCFrame jCFrame = (JCFrame)iterator.next();
            jCFrame.complete();
        }
        JCFlowEvent jCFlowEvent = new JCFlowEvent(this, 2, this.currentPage, jCPage);
        Enumeration enumeration = JCListenerList.elements(this.flowListeners);
        while (enumeration.hasMoreElements()) {
            jCFlowListener = (JCFlowListener)enumeration.nextElement();
            jCFlowListener.pageEnd(jCFlowEvent);
        }
        this.currentPage.calcLayoutStatus();
        if (this.currentPage.getLayoutStatus() == 4) {
            jCFlowEvent = new JCFlowEvent(this, 3, this.currentPage);
            enumeration = JCListenerList.elements(this.flowListeners);
            while (enumeration.hasMoreElements()) {
                jCFlowListener = (JCFlowListener)enumeration.nextElement();
                jCFlowListener.pageComplete(jCFlowEvent);
            }
            this.document.checkOutputPage(this.currentPage);
        }
        if (this.deferredPageCount > 0) {
            this.updatePageNumbers(null);
        }
    }

    private void createDefaultTemplate(JCDocument jCDocument) {
        JCPage jCPage = new JCPage("default", jCDocument);
        jCPage.setPageType(1);
        jCDocument.getTemplates().add(jCPage);
        jCPage.setSize(new JCUnit.Dimension(JCUnit.INCHES, 8.5, 11.0));
        jCPage.setFlowPageTemplate(jCPage);
        jCPage.setFlowSectionTemplate(jCPage);
        List list = jCPage.getFrameList();
        JCFrame jCFrame = new JCFrame("header", jCDocument);
        jCFrame.setLocation(new JCUnit.Point(JCUnit.INCHES, 0.5, 0.5));
        jCFrame.setSize(new JCUnit.Dimension(JCUnit.INCHES, 7.5, 0.25));
        list.add(jCFrame);
        jCFrame = new JCFrame("footer", jCDocument);
        jCFrame.setLocation(new JCUnit.Point(JCUnit.INCHES, 0.5, 10.25));
        jCFrame.setSize(new JCUnit.Dimension(JCUnit.INCHES, 7.5, 0.25));
        list.add(jCFrame);
        jCFrame = new JCFrame("body", jCDocument);
        jCFrame.setLocation(new JCUnit.Point(JCUnit.INCHES, 0.5, 1.0));
        jCFrame.setSize(new JCUnit.Dimension(JCUnit.INCHES, 7.5, 9.0));
        list.add(jCFrame);
        list = jCPage.getFlowFrameList();
        list.add(jCFrame);
    }
}

