/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid.customizer;

import com.klg.jclass.higrid.CellFormat;
import com.klg.jclass.higrid.LocaleBundle;
import com.klg.jclass.higrid.SummaryColumn;
import com.klg.jclass.higrid.beans.JCHiGridEvent;
import com.klg.jclass.higrid.beans.JCHiGridNode;
import com.klg.jclass.higrid.customizer.CellFormatPage;
import com.klg.jclass.higrid.customizer.ColorEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JPanel;

public class CellColorPage
extends CellFormatPage
implements ActionListener,
ItemListener {
    ColorEditor cellForegroundColor;
    ColorEditor cellBackgroundColor;
    ColorEditor cellSelectedForegroundColor;
    ColorEditor cellSelectedBackgroundColor;

    public CellColorPage() {
        super(LocaleBundle.string("Color"));
        this.init();
    }

    public void init() {
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                CellColorPage.this.cellForegroundColor.checkColorSource(focusEvent.getSource());
                CellColorPage.this.cellBackgroundColor.checkColorSource(focusEvent.getSource());
                CellColorPage.this.cellSelectedForegroundColor.checkColorSource(focusEvent.getSource());
                CellColorPage.this.cellSelectedForegroundColor.checkColorSource(focusEvent.getSource());
                CellColorPage.this.valueChanged();
            }
        };
        this.cellForegroundColor = new ColorEditor(this, this, focusAdapter, LocaleBundle.string("ForegroundColor"), false);
        this.cellBackgroundColor = new ColorEditor(this, this, focusAdapter, LocaleBundle.string("BackgroundColor"), false);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.cellSelectedForegroundColor = new ColorEditor(this, this, focusAdapter, LocaleBundle.string("SelectedForegroundColor"), false);
        this.cellSelectedBackgroundColor = new ColorEditor(this, this, focusAdapter, LocaleBundle.string("SelectedBackgroundColor"), false);
        jPanel.add((Component)this.cellForegroundColor, "North");
        jPanel.add((Component)this.cellBackgroundColor, "South");
        jPanel2.add((Component)this.cellSelectedForegroundColor, "North");
        jPanel2.add((Component)this.cellSelectedBackgroundColor, "South");
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)jPanel2, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel3, "North");
    }

    public void valueChanged() {
        if (this.cellFormat == null) {
            return;
        }
        boolean bl = false;
        Color color = this.cellForegroundColor.getColor();
        if (color != null && !color.equals(this.cellFormat.getForeground())) {
            this.cellFormat.setForeground(color);
            bl = true;
        }
        if ((color = this.cellBackgroundColor.getColor()) != null && !color.equals(this.cellFormat.getBackground())) {
            this.cellFormat.setBackground(color);
            bl = true;
        }
        if (this.section == 2) {
            color = this.cellSelectedForegroundColor.getColor();
            if (color != null && !color.equals(this.cellFormat.getSelectedForeground())) {
                this.cellFormat.setSelectedForeground(color);
                bl = true;
            }
            if ((color = this.cellSelectedBackgroundColor.getColor()) != null && !color.equals(this.cellFormat.getSelectedBackground())) {
                this.cellFormat.setSelectedBackground(color);
                bl = true;
            }
        }
        if (bl) {
            this.getJCHiGridNode().setChanged();
            this.getJCHiGridNode().getGridProperties().fireJCHiGridEvent(new JCHiGridEvent((Object)this.getJCHiGridNode().getGridProperties(), this.getJCHiGridNode()));
        }
    }

    public void showValue() {
        if (this.cellFormat == null) {
            return;
        }
        this.cellForegroundColor.selectColor(this.cellFormat.getForeground());
        this.cellBackgroundColor.selectColor(this.cellFormat.getBackground());
        this.cellSelectedForegroundColor.setEnabled(this.section == 2);
        this.cellSelectedBackgroundColor.setEnabled(this.section == 2);
        if (this.section == 2) {
            this.cellSelectedForegroundColor.selectColor(this.cellFormat.getSelectedForeground());
            this.cellSelectedBackgroundColor.selectColor(this.cellFormat.getSelectedBackground());
        }
    }

    public void setJCHiGridNode(JCHiGridNode jCHiGridNode, CellFormat cellFormat, SummaryColumn summaryColumn) {
        this.showValue();
    }

    public void setSelectedColumn(CellFormat cellFormat, SummaryColumn summaryColumn) {
        super.setSelectedColumn(cellFormat, summaryColumn);
        this.showValue();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isInitializing()) {
            return;
        }
        this.checkColorEditors(actionEvent.getSource());
        this.valueChanged();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.isInitializing()) {
            return;
        }
        this.checkColorEditors(itemEvent.getSource());
        this.valueChanged();
    }

    void checkColorEditors(Object object) {
        if (this.cellForegroundColor.checkColorSource(object) || this.cellBackgroundColor.checkColorSource(object) || this.section != 2 || this.cellSelectedForegroundColor.checkColorSource(object) || !this.cellSelectedBackgroundColor.checkColorSource(object)) {
            // empty if block
        }
    }
}

