/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.higrid.LocaleBundle;
import com.klg.jclass.higrid.PrintGrid12;
import com.klg.jclass.higrid.PrintPage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PrintPreview
extends JDialog
implements WindowListener,
ActionListener {
    static final long serialVersionUID = -3450555077594570366L;
    protected transient JButton firstButton;
    protected transient JButton prevButton;
    protected transient JButton nextButton;
    protected transient JButton lastButton;
    protected transient JButton printButton;
    protected transient JButton printAllButton;
    protected transient JButton pageFormatButton;
    protected transient JButton closeButton;
    protected transient JLabel status;
    protected transient JScrollPane pane;
    protected transient PrinterJob job;
    protected transient PageFormat pageFormat;
    protected transient PrintGrid12 printGrid;
    protected transient HiGrid grid;
    protected transient PrintPage printPage;
    protected transient int currentPage = 0;

    public int getNumPages() {
        return this.printGrid.getTotalNumPages();
    }

    public int getPageWidth() {
        return this.printGrid.getPageWidth();
    }

    public int getPageHeight() {
        return this.printGrid.getPageHeight();
    }

    public PrintPreview(Frame frame, String string, HiGrid hiGrid) {
        super(frame, string);
        this.setModal(true);
        this.grid = hiGrid;
        this.job = PrinterJob.getPrinterJob();
        if (this.job == null) {
            return;
        }
        this.printGrid = hiGrid.getPrintGrid();
        hiGrid.setPrinting(true);
        this.pageFormat = this.job.defaultPage();
        this.printGrid.initialize(this.pageFormat);
        this.job.setJobName("HiGrid Print");
        this.job.setPrintable(this.printGrid, this.pageFormat);
        this.job.setPageable(this.printGrid);
        this.getContentPane().setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 1, 1));
        this.firstButton = new JButton(LocaleBundle.string("PrintPreviewFirst"));
        jPanel.add(this.firstButton);
        this.firstButton.addActionListener(this);
        this.prevButton = new JButton(LocaleBundle.string("PrintPreviewPrevious"));
        jPanel.add(this.prevButton);
        this.prevButton.addActionListener(this);
        this.nextButton = new JButton(LocaleBundle.string("PrintPreviewNext"));
        jPanel.add(this.nextButton);
        this.nextButton.addActionListener(this);
        this.lastButton = new JButton(LocaleBundle.string("PrintPreviewLast"));
        jPanel.add(this.lastButton);
        this.lastButton.addActionListener(this);
        this.printButton = new JButton(LocaleBundle.string("PrintPreviewPrint"));
        jPanel.add(this.printButton);
        this.printButton.addActionListener(this);
        this.printAllButton = new JButton(LocaleBundle.string("PrintPreviewPrintAll"));
        jPanel.add(this.printAllButton);
        this.printAllButton.addActionListener(this);
        this.pageFormatButton = new JButton(LocaleBundle.string("PrintPreviewPageFormat"));
        jPanel.add(this.pageFormatButton);
        this.pageFormatButton.addActionListener(this);
        this.closeButton = new JButton(LocaleBundle.string("PrintPreviewClose"));
        jPanel.add(this.closeButton);
        this.closeButton.addActionListener(this);
        this.pane = new JScrollPane();
        this.createPage();
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)this.pane, "Center");
        this.status = new JLabel("", 2);
        this.getContentPane().add((Component)this.status, "South");
        this.addWindowListener(this);
        this.setSize(650, 500);
        this.showPage(0);
    }

    public void createPage() {
        if (this.printPage != null) {
            this.pane.remove(this.printPage);
        }
        this.printPage = new PrintPage(new Dimension(this.getPageWidth(), this.getPageHeight()));
        this.pane.add(this.printPage);
        this.pane.setViewportView(this.printPage);
        this.printPage.setSize(this.printPage.getPreferredSize());
        this.pane.setSize(new Dimension((int)((double)this.getPageWidth() * 1.05), (int)((double)this.getPageHeight() * 1.05)));
        this.getContentPane().doLayout();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            if (this.job == null || this.printGrid == null) {
                this.grid.setPrinting(false);
            } else {
                this.showPage(0);
            }
        }
        super.setVisible(bl);
    }

    public void showPage(int n) {
        if (this.job == null) {
            this.grid.setPrinting(false);
            return;
        }
        this.currentPage = n;
        Image image = this.grid.getGridArea().createImage(this.getPageWidth(), this.getPageHeight());
        Graphics graphics = image.getGraphics();
        this.printGrid.print(graphics, this.printGrid.getPageFormat(), n);
        this.printPage.setImage(image);
        graphics.dispose();
        this.status.setText(" " + LocaleBundle.string("PrintTextPage") + " " + (this.currentPage + 1) + " " + LocaleBundle.string("PrintTextOf") + " " + this.getNumPages() + ".");
    }

    public void close() {
        this.grid.setPrinting(false);
        this.setVisible(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton.equals(this.firstButton)) {
                this.showPage(0);
            } else if (jButton.equals(this.prevButton)) {
                if (this.currentPage > 0) {
                    this.showPage(this.currentPage - 1);
                }
            } else if (jButton.equals(this.nextButton)) {
                if (this.currentPage < this.getNumPages() - 1) {
                    this.showPage(this.currentPage + 1);
                }
            } else if (jButton.equals(this.lastButton)) {
                this.showPage(this.getNumPages() - 1);
            } else if (jButton.equals(this.printButton)) {
                if (this.job != null) {
                    try {
                        if (this.job.printDialog()) {
                            this.job.print();
                        }
                    }
                    catch (PrinterException printerException) {
                        System.out.println(printerException);
                    }
                }
            } else if (jButton.equals(this.printAllButton)) {
                if (this.job != null) {
                    try {
                        this.job.print();
                    }
                    catch (PrinterException printerException) {
                        System.out.println(printerException);
                    }
                }
            } else if (jButton.equals(this.pageFormatButton)) {
                this.pageFormat = this.job.pageDialog(this.pageFormat);
                this.job.setPrintable(this.printGrid, this.pageFormat);
                this.job.setPageable(this.printGrid);
                this.printGrid.initialize(this.pageFormat);
                this.createPage();
                this.showPage(0);
            } else if (jButton.equals(this.closeButton)) {
                this.close();
            }
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.close();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

