/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.higrid.RowNode;
import com.klg.jclass.higrid.Walkable;

class PixelCountWalk
implements Walkable {
    static final long serialVersionUID = -7960339023128286143L;
    private boolean downward;
    private int pixelCount;
    private int maxPixels;
    private boolean found;
    private RowNode lastNode;

    public PixelCountWalk(RowNode rowNode, int n, boolean bl) {
        this.lastNode = rowNode;
        this.pixelCount = 0;
        this.maxPixels = n;
        this.found = false;
        this.downward = bl;
    }

    public boolean getDownward() {
        return this.downward;
    }

    public boolean done() {
        return this.found;
    }

    public void next(RowNode rowNode) {
        this.pixelCount += rowNode.getHeight();
    }

    public void previous(RowNode rowNode) {
    }

    public boolean find(RowNode rowNode) {
        if (rowNode == this.lastNode) {
            this.found = true;
            if (this.downward) {
                this.pixelCount -= rowNode.getHeight();
            }
        }
        if (this.pixelCount > this.maxPixels) {
            this.found = true;
        }
        return this.found;
    }

    public int getPixelCount() {
        return this.pixelCount;
    }
}

