/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.cell.JCCellInfo;
import com.klg.jclass.datasource.ColumnModel;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.higrid.CellStyle;
import com.klg.jclass.higrid.CellStyleModel;
import com.klg.jclass.higrid.FormatNode;
import com.klg.jclass.higrid.HeaderFormat;
import com.klg.jclass.higrid.RecordFormat;
import com.klg.jclass.higrid.RowFormat;
import com.klg.jclass.higrid.SortLabelCellRenderer;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Comparator;

public class CellFormat
extends CellStyle
implements JCCellInfo,
Serializable {
    static final long serialVersionUID = -6948816648665420216L;
    protected static final int MINIMUM_INITIAL_HEADER_WIDTH = 40;
    protected int height = 0;
    protected int width = 0;
    protected boolean editable = true;
    protected String editorName = null;
    protected String rendererName = null;
    protected transient Class editor = null;
    protected transient Class renderer = null;
    protected RowFormat parent = null;
    protected String text = null;
    protected String name = null;
    protected int type = 1010;
    protected Rectangle drawingArea = new Rectangle();
    protected Rectangle totalArea = new Rectangle();
    protected Rectangle preferredTotalArea = new Rectangle();
    protected Point translationOffset = new Point();
    protected boolean drawingAreaValid = false;
    protected boolean totalAreaValid = false;
    protected boolean preferredTotalAreaValid = false;
    protected boolean translationOffsetValid = false;
    protected boolean rowHeightIsValid = false;
    protected boolean showing = true;
    protected Comparator sortable = null;

    public CellFormat() {
    }

    public CellFormat(CellStyleModel cellStyleModel) {
        this.copyFromCellStyle(cellStyleModel);
    }

    public boolean isShowing() {
        return this.showing;
    }

    public void setShowing(boolean bl) {
        this.showing = bl;
        CellFormat cellFormat = this.getOtherCellFormat();
        if (cellFormat != null) {
            cellFormat.setOtherShowing(bl);
        }
    }

    public void setOtherShowing(boolean bl) {
        this.showing = bl;
    }

    public void setBorderInsets(Insets insets) {
        super.setBorderInsets(insets);
        this.drawingAreaValid = false;
        this.totalAreaValid = false;
        this.preferredTotalAreaValid = false;
        this.translationOffsetValid = false;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
        this.preferredTotalAreaValid = false;
        this.parent.heightChanged();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
        CellFormat cellFormat = this.getOtherCellFormat();
        if (cellFormat != null) {
            cellFormat.setOtherWidth(n);
        }
        this.drawingAreaValid = false;
        this.totalAreaValid = false;
        this.preferredTotalAreaValid = false;
    }

    protected void setOtherWidth(int n) {
        this.width = n;
        this.drawingAreaValid = false;
        this.totalAreaValid = false;
        this.preferredTotalAreaValid = false;
    }

    public void setWidth(int n, boolean bl) {
        if (bl && this.allowWidthSizing || !bl) {
            this.setWidth(n);
        }
    }

    public void setMarginInsets(Insets insets) {
        super.setMarginInsets(insets);
        this.drawingAreaValid = false;
        this.totalAreaValid = false;
        this.preferredTotalAreaValid = false;
        this.translationOffsetValid = false;
    }

    public void setFont(FontMetrics fontMetrics, Font font) {
        this.setFont(font);
        this.setHeight(this.getFontHeight(fontMetrics, font));
    }

    public void setAllowWidthSizing(boolean bl) {
        super.setAllowWidthSizing(bl);
        CellFormat cellFormat = this.getOtherCellFormat();
        if (cellFormat != null) {
            cellFormat.setOtherAllowWidthSizing(bl);
        }
    }

    public CellFormat getOtherCellFormat() {
        CellFormat cellFormat = null;
        if (this.parent != null && this.parent.getParent() != null) {
            FormatNode formatNode = this.parent.getParent();
            int n = this.parent.getDataFormats().indexOf(this);
            boolean bl = false;
            if (n == -1 && (n = this.parent.getIndicatorFormats().indexOf(this)) != -1) {
                bl = true;
            }
            if (this.parent instanceof HeaderFormat) {
                RecordFormat recordFormat = formatNode.getRecordFormat();
                if (n != -1 && recordFormat != null) {
                    cellFormat = bl ? (CellFormat)recordFormat.getIndicatorFormats().elementAt(n) : (CellFormat)recordFormat.getDataFormats().elementAt(n);
                }
            } else if (this.parent instanceof RecordFormat) {
                HeaderFormat headerFormat = formatNode.getHeaderFormat();
                if (n != -1 && headerFormat != null) {
                    cellFormat = bl ? (CellFormat)headerFormat.getIndicatorFormats().elementAt(n) : (CellFormat)headerFormat.getDataFormats().elementAt(n);
                }
            }
        }
        return cellFormat;
    }

    public Class getDataType() {
        String string;
        switch (this.getType()) {
            case 1000: {
                string = "java.lang.Boolean";
                break;
            }
            case 1001: {
                string = "java.sql.Date";
                break;
            }
            case 1002: {
                string = "java.lang.Double";
                break;
            }
            case 1003: {
                string = "java.lang.Float";
                break;
            }
            case 1004: {
                string = "java.lang.Integer";
                break;
            }
            case 1005: {
                string = "java.lang.String";
                break;
            }
            case 1006: {
                string = "java.math.BigDecimal";
                break;
            }
            case 1007: {
                string = "java.lang.Long";
                break;
            }
            case 1008: {
                string = "java.sql.Time";
                break;
            }
            case 1009: {
                string = "java.sql.Timestamp";
                break;
            }
            case 1011: {
                string = "java.lang.Byte";
                break;
            }
            case 1012: {
                string = "java.lang.Short";
                break;
            }
            case 1013: {
                string = "java.lang.String";
                break;
            }
            case 1014: {
                string = "java.util.Date";
                break;
            }
            default: {
                string = "java.lang.Object";
            }
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println(classNotFoundException);
        }
        return clazz;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        MetaDataModel metaDataModel;
        if (this.parent != null && (metaDataModel = this.parent.getMetaData()) != null) {
            try {
                ColumnModel columnModel = metaDataModel.getColumnObject(this.name);
                if (columnModel != null && columnModel.isReadOnly()) {
                    bl = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.editable = bl;
    }

    public Class getCellEditor() {
        if (this.editor == null && this.editorName != null) {
            this.setCellEditorName(this.editorName);
        }
        return this.editor;
    }

    public void setCellEditor(Class clazz) {
        this.editor = clazz;
        this.editorName = clazz.getName();
    }

    public String getCellEditorName() {
        return this.editorName;
    }

    public void setCellEditorName(String string) {
        this.editorName = new String(string);
        try {
            this.editor = Class.forName(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Class getCellRenderer() {
        if (this.renderer == null && this.rendererName != null) {
            this.setCellRendererName(this.rendererName);
        }
        return this.renderer;
    }

    public void setCellRenderer(Class clazz) {
        this.renderer = clazz;
        this.rendererName = clazz.getName();
    }

    public String getCellRendererName() {
        return this.rendererName;
    }

    public void setCellRendererName(String string) {
        this.rendererName = new String(string);
        try {
            this.renderer = Class.forName(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public RowFormat getParent() {
        return this.parent;
    }

    public void setParent(RowFormat rowFormat) {
        this.parent = rowFormat;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public Comparator getSortable() {
        return this.sortable;
    }

    public void setSortable(Comparator comparator) {
        this.sortable = comparator;
    }

    public Rectangle getDrawingArea() {
        if (!this.drawingAreaValid) {
            this.calculateDrawingArea();
        }
        return this.drawingArea;
    }

    public Rectangle getTotalArea() {
        if (!this.totalAreaValid) {
            this.calculateTotalArea();
        }
        return this.totalArea;
    }

    public Rectangle getPreferredTotalArea() {
        if (!this.preferredTotalAreaValid) {
            this.calculatePreferredTotalArea();
        }
        return this.preferredTotalArea;
    }

    protected Point getTranslationOffset() {
        if (!this.translationOffsetValid) {
            this.calculateTranslationOffset();
        }
        return this.translationOffset;
    }

    protected int getStringWidth(FontMetrics fontMetrics, Font font, String string) {
        return fontMetrics.stringWidth(string) + (font.isItalic() ? font.getSize() / 3 + 1 : 0);
    }

    protected int getFontHeight(FontMetrics fontMetrics, Font font) {
        return fontMetrics.getLeading() + fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
    }

    protected int getFontHeight(Component component, Font font) {
        return this.getFontHeight(component.getFontMetrics(font), font);
    }

    public void setDefaultSize(Component component, boolean bl) {
        if (this.font == null) {
            return;
        }
        FontMetrics fontMetrics = component.getFontMetrics(this.font);
        int n = this.getFontHeight(fontMetrics, this.font);
        int n2 = bl ? SortLabelCellRenderer.getAscendingImage().getHeight(null) : 0;
        this.setHeight(Math.max(n, n2));
        int n3 = bl ? SortLabelCellRenderer.getAscendingImage().getWidth(null) : 0;
        int n4 = this.getStringWidth(fontMetrics, this.font, this.name) + this.getMarginInsets().left + this.getMarginInsets().right + this.getBorderInsets().left + this.getBorderInsets().right + n3;
        this.setWidth(Math.max(n4, 40));
    }

    protected void rowHeightChanged() {
        this.calculateDrawingArea();
        this.calculateTotalArea();
    }

    protected void widthChanged() {
        this.calculateDrawingArea();
        this.calculateTotalArea();
        this.calculatePreferredTotalArea();
    }

    protected void calculateDrawingArea() {
        this.drawingArea.setBounds(0, 0, this.getWidth(), this.getParent().getHeight());
        this.drawingArea.height -= this.getMarginInsets().top + this.getMarginInsets().bottom + this.getBorderInsets().top + this.getBorderInsets().bottom;
        this.drawingAreaValid = true;
    }

    protected void calculateTotalArea() {
        this.totalArea.setBounds(0, 0, this.getWidth(), this.getParent().getHeight());
        this.totalArea.width += this.getMarginInsets().left + this.getMarginInsets().right + this.getBorderInsets().left + this.getBorderInsets().right;
        this.totalAreaValid = true;
    }

    protected void calculatePreferredTotalArea() {
        this.preferredTotalArea.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.preferredTotalArea.width += this.getMarginInsets().left + this.getMarginInsets().right + this.getBorderInsets().left + this.getBorderInsets().right;
        this.preferredTotalArea.height += this.getMarginInsets().top + this.getMarginInsets().bottom + this.getBorderInsets().top + this.getBorderInsets().bottom;
        this.preferredTotalAreaValid = true;
    }

    protected void calculateTranslationOffset() {
        this.translationOffset.setLocation(this.getMarginInsets().left + this.getBorderInsets().left, this.getMarginInsets().top + this.getBorderInsets().top);
        this.translationOffsetValid = true;
    }
}

