/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.field.validate;

import com.klg.jclass.field.validate.AbstractValidator;
import com.klg.jclass.field.validate.TextCursorEvent;
import com.klg.jclass.field.validate.TextEvent;
import java.util.Locale;
import javax.swing.ListModel;

public class JCStringValidator
extends AbstractValidator {
    static final int NUMBER = 0;
    static final int DIGIT = 1;
    static final int HEX = 2;
    static final int UPPER = 3;
    static final int LOWER = 4;
    static final int NOCONVERT = 5;
    static final int STAR = 6;
    static final int ALPHANUMERIC = 7;
    static final int LITERAL = 8;
    static final String HEXDIGITS = "AaBbCcDdEeFf";
    static final String NUMBERDIGITS = "+-,.";
    protected int[] compiled_mask_sym;
    protected char[] compiled_mask_ch;
    protected int mask_length = 0;
    protected int num_editable_pos = 0;
    protected String mask = "";
    protected String place_holder_chars = null;
    protected String mask_chars = "#@HULA*^\\";
    protected int num_mask_match = -1;
    protected Object defaultValue = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$StringBuffer;

    public JCStringValidator() {
        this.spin_policy = 2;
        this.supportedClasses = this.getSupportedClasses();
    }

    public JCStringValidator(Locale locale, String string, int n, String string2, ListModel listModel, boolean bl, String string3, String string4, boolean bl2, Object object) {
        this();
        this.setLocale(locale);
        this.setMask(string);
        this.setPickList(listModel);
        this.setMatchPickList(bl);
        this.setNumMaskMatch(n);
        this.setPlaceHolderChars(string2);
        this.setValidChars(string3);
        this.setInvalidChars(string4);
        this.setAllowNull(bl2);
        this.setDefaultValue(object);
    }

    protected Class[] getSupportedClasses() {
        Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = JCStringValidator.class$("java.lang.String")) : class$java$lang$String, class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = JCStringValidator.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer};
        return classArray;
    }

    public Object copyValue(Object object) {
        return object;
    }

    public void setNumMaskMatch(int n) {
        this.num_mask_match = n;
    }

    public int getNumMaskMatch() {
        return this.num_mask_match;
    }

    public void setMask(String string) {
        this.mask = string;
        this.compileMask();
    }

    public String getMask() {
        return this.mask;
    }

    public void setPlaceHolderChars(String string) {
        this.place_holder_chars = string;
    }

    public String getPlaceHolderChars() {
        return this.place_holder_chars;
    }

    public void setMaskChars(String string) {
        if (string.length() != this.mask_chars.length()) {
            throw new IllegalArgumentException("Missing mask chars");
        }
        this.mask_chars = string;
        this.compileMask();
    }

    public String getMaskChars() {
        return this.mask_chars;
    }

    public String getParsedMask() {
        if (this.mask != null && this.mask_length != 0) {
            return String.copyValueOf(this.compiled_mask_ch);
        }
        return "";
    }

    public boolean inRange(Object object) {
        return true;
    }

    protected void compileMask() {
        int n;
        int n2 = n = this.mask == null ? 0 : this.mask.length();
        if (n == 0) {
            this.mask_length = 0;
            return;
        }
        this.compiled_mask_sym = new int[n];
        this.compiled_mask_ch = new char[n];
        this.num_editable_pos = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            int n5 = this.mask_chars.indexOf(this.mask.charAt(n4));
            if (n5 < 0) {
                this.compiled_mask_sym[n3] = 8;
                this.compiled_mask_ch[n3] = this.mask.charAt(n4);
            } else if (this.mask.charAt(n4) == this.mask_chars.charAt(8)) {
                if (++n4 < n) {
                    this.compiled_mask_sym[n3] = 8;
                    this.compiled_mask_ch[n3] = this.mask.charAt(n4);
                } else {
                    --n3;
                }
            } else {
                this.compiled_mask_sym[n3] = n5;
                this.compiled_mask_ch[n3] = 32;
                ++this.num_editable_pos;
            }
            ++n4;
            ++n3;
        }
        this.mask_length = n3;
    }

    protected boolean isValidChar(StringBuffer stringBuffer, int n, int n2) {
        char c = stringBuffer.charAt(n);
        if (n2 >= this.mask_length) {
            return false;
        }
        switch (this.compiled_mask_sym[n2]) {
            case 0: {
                return Character.isDigit(c) || NUMBERDIGITS.indexOf(c) >= 0;
            }
            case 2: {
                return Character.isDigit(c) || HEXDIGITS.indexOf(c) >= 0;
            }
            case 1: {
                return Character.isDigit(c);
            }
            case 3: {
                if (Character.isLetter(c)) {
                    stringBuffer.setCharAt(n, Character.toUpperCase(c));
                    return true;
                }
                return false;
            }
            case 4: {
                if (Character.isLetter(c)) {
                    stringBuffer.setCharAt(n, Character.toLowerCase(c));
                    return true;
                }
                return false;
            }
            case 5: {
                return Character.isLetter(c);
            }
            case 6: {
                return true;
            }
            case 8: {
                return c == this.compiled_mask_ch[n2];
            }
            case 7: {
                return Character.isLetter(c) || Character.isDigit(c);
            }
        }
        return false;
    }

    public int getNextCursorPosition(int n, boolean bl) {
        if (this.mask == null || this.mask_length == 0) {
            return n;
        }
        if (n == this.mask_length) {
            return n;
        }
        if (bl) {
            int n2 = n;
            while (n2 < this.mask_length) {
                if (this.compiled_mask_sym[n2] != 8) {
                    return n2;
                }
                ++n2;
            }
        } else {
            int n3 = n;
            while (n3 < this.mask_length && n3 >= 0) {
                if (this.compiled_mask_sym[n3] != 8) {
                    return n3;
                }
                --n3;
            }
        }
        return -1;
    }

    private void addPlaceHolder(StringBuffer stringBuffer, int n) {
        int n2 = 0;
        if (this.place_holder_chars != null) {
            n2 = this.place_holder_chars.length();
        }
        if (n2 > 0 && n < n2) {
            stringBuffer.append(this.place_holder_chars.charAt(n));
        } else {
            stringBuffer.append(" ");
        }
    }

    public void changeText(TextEvent textEvent) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(50);
        super.changeText(textEvent);
        int n = textEvent.getStartPosition();
        int n2 = textEvent.getEndPosition();
        if (textEvent.isDeletion() && n2 - n > 0 && this.mask != null && this.mask_length != 0 && n < this.mask_length && n2 <= this.mask_length) {
            if (this.compiled_mask_sym[n] == 8 && n2 - n == 1) {
                int n3 = this.getNextCursorPosition(n, false);
                if (n3 == -1) {
                    textEvent.setStartPosition(n2);
                    textEvent.setAllowChange(false);
                    return;
                }
                this.addPlaceHolder(stringBuffer, n3);
                int n4 = n3 + 1;
                while (n4 <= n) {
                    if (this.compiled_mask_sym[n4] == 8) {
                        stringBuffer.append(this.compiled_mask_ch[n4]);
                    } else {
                        this.addPlaceHolder(stringBuffer, n4);
                    }
                    ++n4;
                }
                textEvent.setStartPosition(n3);
                textEvent.setText(stringBuffer.toString());
            } else if (n2 - n > 1) {
                StringBuffer stringBuffer2 = new StringBuffer(textEvent.getText());
                int n5 = stringBuffer2.length();
                int n6 = 0;
                int n7 = n;
                while (n7 < n2) {
                    if (this.compiled_mask_sym[n7] == 8) {
                        stringBuffer.append(this.compiled_mask_ch[n7]);
                    } else if (!stringBuffer2.equals("") && n6 < n5 && this.isValidChar(stringBuffer2, n6, n7)) {
                        stringBuffer.append(stringBuffer2.charAt(n6));
                        ++n6;
                    } else {
                        this.addPlaceHolder(stringBuffer, n7);
                    }
                    ++n7;
                }
                textEvent.setStartPosition(n);
                textEvent.setText(stringBuffer.toString());
            } else {
                this.addPlaceHolder(stringBuffer, n);
                textEvent.setText(stringBuffer.toString());
            }
            return;
        }
        String string = textEvent.getText();
        if (string != null && string.length() != 0) {
            StringBuffer stringBuffer3 = new StringBuffer(50);
            StringBuffer stringBuffer4 = this.checkValidInvalid(string);
            if (stringBuffer4 != null && stringBuffer4.length() != 0) {
                int n8 = n;
                if (this.mask != null && this.mask_length != 0) {
                    int n9 = 0;
                    while (n9 < stringBuffer4.length()) {
                        bl = this.isValidChar(stringBuffer4, n9, n8);
                        if (bl) {
                            stringBuffer3.append(stringBuffer4.charAt(n9));
                            ++n8;
                            if (n2 - n != 1) {
                                int n10 = n8;
                                while (n10 < this.mask_length && this.compiled_mask_sym[n10] == 8) {
                                    char c = this.compiled_mask_ch[n10];
                                    stringBuffer3.append(c);
                                    if (n9 + 1 < stringBuffer4.length() && c == stringBuffer4.charAt(n9 + 1)) {
                                        ++n9;
                                    }
                                    ++n10;
                                }
                            }
                            n8 = this.getNextCursorPosition(n8, true);
                        }
                        ++n9;
                    }
                    if (n2 - n != 1) {
                        textEvent.setEndPosition(textEvent.getStartPosition() + stringBuffer3.length());
                    }
                } else {
                    stringBuffer3.append(stringBuffer4.toString());
                }
            }
            textEvent.setText(stringBuffer3.toString());
            if (stringBuffer3.length() == 0) {
                textEvent.setAllowChange(false);
            }
        }
    }

    public void setCursor(TextCursorEvent textCursorEvent) {
        int n;
        int n2 = textCursorEvent.getNewPosition();
        int n3 = textCursorEvent.getCurrentPosition();
        boolean bl = true;
        if (n3 > n2) {
            bl = false;
        }
        if ((n = this.getNextCursorPosition(n2, bl)) == -1 && (n = this.getNextCursorPosition(n2, !bl)) == -1) {
            textCursorEvent.setNewPosition(textCursorEvent.getCurrentPosition());
            return;
        }
        textCursorEvent.setNewPosition(n);
    }

    public int getLastValidInputCharPosition(String string) {
        int n = 0;
        if (string == null) {
            return n;
        }
        if (this.mask == null || this.mask_length == 0) {
            return string.length();
        }
        n = string.length();
        while (n > 0) {
            int n2 = n - 1;
            if (this.place_holder_chars == null || n > this.place_holder_chars.length() ? string.charAt(n2) != ' ' && this.compiled_mask_sym[n2] != 8 : string.charAt(n2) != this.place_holder_chars.charAt(n2) && this.compiled_mask_sym[n2] != 8) break;
            --n;
        }
        return n;
    }

    public Object parse(Class clazz, String string) {
        String string2 = null;
        if ((string == null || string.length() == 0) && this.getAllowNull() || this.mask == null || this.mask_length == 0) {
            string2 = string;
        } else {
            StringBuffer stringBuffer = new StringBuffer(50);
            int n = this.getLastValidInputCharPosition(string);
            int n2 = 0;
            while (n2 < n) {
                if (this.compiled_mask_sym[n2] != 8 || this.compiled_mask_ch[n2] != string.charAt(n2)) {
                    stringBuffer.append(string.charAt(n2));
                }
                ++n2;
            }
            string2 = stringBuffer.toString();
        }
        Object object = string2;
        if (object.getClass() != clazz) {
            object = this.convertFromSupported(object, clazz);
        }
        return object;
    }

    public boolean validate(Object object) {
        Object object2 = this.convertToSupported(object);
        boolean bl = this.internalValidate(object2);
        return bl;
    }

    protected boolean internalValidate(Object object) {
        boolean bl = super.validate(object);
        String string = (String)object;
        if (!(string != null && string.length() != 0 || this.getAllowNull())) {
            return false;
        }
        int n = 0;
        int n2 = -1;
        if (bl && this.mask != null && this.mask_length > 0 && string != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n3 = 0;
            while (n3 < stringBuffer.length()) {
                int n4 = n;
                while (n4 < this.mask_length && this.compiled_mask_sym[n4] == 8) {
                    ++n;
                    ++n4;
                }
                if (!this.isValidChar(stringBuffer, n3, n)) {
                    bl = false;
                    break;
                }
                ++n;
                n2 = n3++;
            }
            if (this.num_mask_match >= 0) {
                bl = this.num_mask_match <= n2 + 1;
            } else if (stringBuffer.length() != this.num_editable_pos) {
                bl = false;
            }
        }
        return bl;
    }

    public String format(Object object) {
        boolean bl = false;
        if (object != null && (bl = this.isClassSupported(object.getClass()))) {
            object = this.convertToSupported(object);
        }
        String string = null;
        string = object == null || !bl ? "" : (String)object;
        StringBuffer stringBuffer = new StringBuffer(50);
        if (this.mask != null && this.mask_length != 0) {
            int n;
            if (string.length() == 0 && this.place_holder_chars != null && this.place_holder_chars.length() != 0) {
                stringBuffer.append(this.place_holder_chars);
                int n2 = this.place_holder_chars.length();
                while (n2 < this.mask_length) {
                    if (this.compiled_mask_sym[n2] == 8) {
                        stringBuffer.append(this.compiled_mask_ch[n2]);
                    } else {
                        this.addPlaceHolder(stringBuffer, n2);
                    }
                    ++n2;
                }
                return stringBuffer.toString();
            }
            int n3 = 0;
            int n4 = 0;
            while (n4 < string.length() && n4 < this.num_editable_pos) {
                if (string.charAt(n4) == this.compiled_mask_ch[n3] && this.compiled_mask_sym[n3] != 8) {
                    stringBuffer.append(this.compiled_mask_ch[n3]);
                } else {
                    n = n3;
                    while (this.compiled_mask_sym[n] == 8) {
                        stringBuffer.append(this.compiled_mask_ch[n]);
                        ++n3;
                        ++n;
                    }
                    stringBuffer.append(string.charAt(n4));
                }
                ++n3;
                ++n4;
            }
            n = n3;
            while (n < this.mask_length) {
                if (this.compiled_mask_sym[n] == 8) {
                    stringBuffer.append(this.compiled_mask_ch[n]);
                } else {
                    this.addPlaceHolder(stringBuffer, n);
                }
                ++n;
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public int getFirstValidCursorPosition() {
        if (this.mask != null && this.mask_length != 0) {
            int n = this.getNextCursorPosition(0, true);
            if (n >= 0) {
                return n;
            }
            return this.mask_length;
        }
        return 0;
    }

    public String formatForEdit(Object object) {
        return null;
    }

    public boolean hasEditFormat() {
        return false;
    }

    protected Object addIncrement(Object object) {
        return null;
    }

    protected Object subtractIncrement(Object object) {
        return null;
    }

    public Object convertToSupported(Object object) {
        if (object instanceof String) {
            return object;
        }
        if (object instanceof StringBuffer) {
            return object.toString();
        }
        return null;
    }

    public Object convertFromSupported(Object object, Class clazz) {
        if (object == null || clazz == null) {
            return null;
        }
        String string = clazz.getName();
        if (string.equals("java.lang.String")) {
            return object;
        }
        if (string.equals("java.lang.StringBuffer")) {
            return new StringBuffer((String)object);
        }
        return null;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object object) {
        this.defaultValue = object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

