/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.field.cell;

import com.klg.jclass.cell.JCCellEditor;
import com.klg.jclass.cell.JCCellEditorEvent;
import com.klg.jclass.cell.JCCellEditorListener;
import com.klg.jclass.cell.JCCellEditorSupport;
import com.klg.jclass.cell.JCCellInfo;
import com.klg.jclass.cell.JCKeyModifier;
import com.klg.jclass.field.JCPopupField;
import com.klg.jclass.field.validate.JCValidator;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class JCPopupFieldCellEditor
extends JCPopupField
implements JCCellEditor,
ItemListener,
KeyListener {
    protected JCCellEditorSupport support = new JCCellEditorSupport();
    protected boolean ignoreEnterKey = false;
    private AWTEvent initialEvent;
    private boolean showPopupLater = false;
    private Object data;
    protected JCKeyModifier[] key_modifiers = new JCKeyModifier[]{new JCKeyModifier(40, 16), new JCKeyModifier(38, 16)};

    public JCPopupFieldCellEditor() {
        this.addItemListener(this);
        this.getEditor().getEditorComponent().addKeyListener(this);
        this.setBorder(null);
    }

    public JCPopupFieldCellEditor(Class clazz, JCValidator jCValidator) {
        super(clazz, jCValidator);
        this.addItemListener(this);
        this.getEditor().getEditorComponent().addKeyListener(this);
        this.setBorder(null);
    }

    public void initialize(AWTEvent aWTEvent, JCCellInfo jCCellInfo, Object object) {
        if (aWTEvent != null && aWTEvent instanceof KeyEvent && ((KeyEvent)aWTEvent).getKeyCode() == 10) {
            this.ignoreEnterKey = true;
        }
        this.initialEvent = aWTEvent;
        this.data = object;
        this.setValue(object);
        this.setBackground(jCCellInfo.getBackground());
        this.setForeground(jCCellInfo.getForeground());
        if (jCCellInfo.isEditable()) {
            this.setBackground(jCCellInfo.getBackground().brighter());
        }
        this.showPopupLater = !this.isEditable() && aWTEvent != null && aWTEvent instanceof MouseEvent && aWTEvent.getID() == 502;
        this.field.setCellEditor(true);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.showPopupLater) {
            this.showPopupLater = false;
            SwingUtilities.invokeLater(new PopupInvoker());
        }
    }

    public Component getComponent() {
        return this;
    }

    public Object getCellEditorValue() {
        this.field.commitEdit();
        return this.getValue();
    }

    public boolean isModified() {
        Object object = this.getCellEditorValue();
        if (this.data == null || this.data.equals("")) {
            return object != null && !object.equals("");
        }
        return !this.data.equals(object);
    }

    public boolean stopCellEditing() {
        return true;
    }

    public void cancelCellEditing() {
    }

    public JCKeyModifier[] getReservedKeys() {
        return this.key_modifiers;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.support.fireStopEditing(new JCCellEditorEvent(itemEvent));
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        Object var2_2 = null;
        if (keyEvent.getKeyCode() == 27) {
            this.support.fireStopEditing(new JCCellEditorEvent(keyEvent));
        } else if (keyEvent.getKeyCode() == 10 && !this.ignoreEnterKey) {
            this.support.fireStopEditing(new JCCellEditorEvent(keyEvent));
        }
        this.ignoreEnterKey = false;
    }

    public void addCellEditorListener(JCCellEditorListener jCCellEditorListener) {
        this.support.addCellEditorListener(jCCellEditorListener);
    }

    public void removeCellEditorListener(JCCellEditorListener jCCellEditorListener) {
        this.support.removeCellEditorListener(jCCellEditorListener);
    }

    public void addNotify() {
        super.addNotify();
        if (this.initialEvent != null && this.isVisible()) {
            this.setPopupVisible(true);
        }
    }

    private class PopupInvoker
    implements Runnable {
        private PopupInvoker() {
        }

        public void run() {
            if (JCPopupFieldCellEditor.this.isShowing() && !JCPopupFieldCellEditor.this.isPopupVisible()) {
                JCPopupFieldCellEditor.this.showPopup();
            }
        }
    }
}

