/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.customizer;

import com.klg.jclass.datasource.LocaleBundle;
import com.klg.jclass.datasource.beans.NodeProperties;
import com.klg.jclass.datasource.customizer.DataModelPage;
import com.klg.jclass.datasource.customizer.Join;
import com.klg.jclass.datasource.customizer.JoinDialog;
import com.klg.jclass.datasource.customizer.JoinView;
import com.klg.jclass.datasource.customizer.Table;
import com.klg.jclass.datasource.customizer.TableChooser;
import com.klg.jclass.datasource.customizer.TableChooserParent;
import com.klg.jclass.datasource.customizer.TableView;
import com.klg.jclass.datasource.util.ColumnMap;
import com.klg.jclass.datasource.util.SqlParser;
import com.klg.jclass.datasource.util.SqlStatement;
import com.klg.jclass.datasource.util.SqlStatementTable;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SqlBuilderPanel
extends DataModelPage
implements TableChooserParent,
ActionListener,
ListSelectionListener,
MouseListener,
MouseMotionListener {
    Hashtable tables = new Hashtable();
    Vector tableViews = new Vector();
    Vector joinViews = new Vector();
    JDesktopPane desktopPane;
    JPopupMenu popup;
    JMenu mnAdd;
    JMenu mnDelete;
    JMenuItem miAutoJoin;
    JMenuItem miRefresh;
    JMenuItem miAddTable;
    JMenuItem miAddJoin;
    JMenuItem miDeleteTable;
    JMenuItem miDeleteJoin;
    Connection connection;
    boolean isConnectionChanged = false;
    TableChooser tableChooser;
    SqlStatement sqlStatement;
    boolean moving = false;
    TableView selectedTableView;
    JoinView selectedJoinView;
    private static final boolean TRACE = false;
    static /* synthetic */ Class class$javax$swing$JScrollPane;

    public SqlBuilderPanel() {
        this((Connection)null);
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public SqlBuilderPanel(Connection connection) {
        super("SQL Statement");
        this.connection = connection;
        this.sqlStatement = new SqlStatement();
        this.setLayout(new BorderLayout(0, 0));
        this.desktopPane = new JDesktopPane();
        this.desktopPane.setDesktopManager(new SimpleDesktopManager());
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.desktopPane.setOpaque(false);
        this.add(this.desktopPane);
        this.createPopupMenu();
        this.addMouseListener(this);
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
        this.isConnectionChanged = true;
    }

    protected void createPopupMenu() {
        this.popup = new JPopupMenu();
        this.mnAdd = new JMenu(LocaleBundle.string("Add"));
        this.miAddTable = new JMenuItem(LocaleBundle.string("Table"));
        this.miAddJoin = new JMenuItem(LocaleBundle.string("Join"));
        this.mnDelete = new JMenu(LocaleBundle.string("Delete"));
        this.miDeleteTable = new JMenuItem(LocaleBundle.string("Table"));
        this.miDeleteJoin = new JMenuItem(LocaleBundle.string("Join"));
        this.miAutoJoin = new JMenuItem(LocaleBundle.string("Auto Join"));
        this.miRefresh = new JMenuItem(LocaleBundle.string("Refresh"));
        this.mnAdd.setActionCommand("Add");
        this.miAddTable.setActionCommand("AddTable");
        this.miAddTable.addActionListener(this);
        this.miAddJoin.setActionCommand("AddJoin");
        this.miAddJoin.addActionListener(this);
        this.mnAdd.add(this.miAddTable);
        this.mnAdd.add(this.miAddJoin);
        this.mnDelete.setActionCommand("Delete");
        this.miDeleteTable.setActionCommand("DeleteTable");
        this.miDeleteTable.addActionListener(this);
        this.miDeleteJoin.setActionCommand("DeleteJoin");
        this.miDeleteJoin.addActionListener(this);
        this.mnDelete.add(this.miDeleteTable);
        this.mnDelete.add(this.miDeleteJoin);
        this.miAutoJoin.setActionCommand("Auto Join");
        this.miAutoJoin.addActionListener(this);
        this.miRefresh.setActionCommand("Refresh");
        this.miRefresh.addActionListener(this);
        this.popup.add(this.mnAdd);
        this.popup.add(this.mnDelete);
        this.popup.addSeparator();
        this.popup.add(this.miAutoJoin);
        this.popup.addSeparator();
        this.popup.add(this.miRefresh);
    }

    public void showTableChooser() {
        if (this.tableChooser == null) {
            this.tableChooser = new TableChooser(this);
        } else if (this.isConnectionChanged) {
            this.tableChooser.refresh();
        }
        this.isConnectionChanged = false;
        this.tableChooser.show();
    }

    public void addTable(String string) {
        this.addTable(string, null);
    }

    public void addTable(String string, String string2) {
        if (string == null) {
            return;
        }
        String string3 = string2 == null ? string : new String(string + " " + string2);
        SqlStatementTable sqlStatementTable = SqlParser.parseTable(string3);
        String string4 = sqlStatementTable.getAlias();
        Table table = (Table)this.tables.get(sqlStatementTable.getQualifiedName());
        if (table == null) {
            table = new Table(this.connection, sqlStatementTable.getQualifier(), sqlStatementTable.getTableName());
            if (sqlStatementTable.getQualifier() == null) {
                sqlStatementTable.setQualifier(table.schema);
            }
            this.tables.put(sqlStatementTable.getQualifiedName(), table);
        }
        sqlStatementTable = this.sqlStatement.addTable(sqlStatementTable.getQualifiedName(), sqlStatementTable.getAlias());
        this.sqlStatement.notifyObservers(this);
        if (sqlStatementTable != null) {
            string4 = sqlStatementTable.getAlias();
        }
        if (this.getTableView(table, string4) == null) {
            this.addTableView(table, string4);
        }
    }

    public void addTableView(String string, String string2) {
        if (string == null) {
            return;
        }
        String string3 = string2 == null ? string : new String(string + " " + string2);
        SqlStatementTable sqlStatementTable = SqlParser.parseTable(string3);
        Table table = (Table)this.tables.get(sqlStatementTable.getQualifiedName());
        if (table == null) {
            table = new Table(this.connection, sqlStatementTable.getQualifier(), sqlStatementTable.getTableName());
            if (sqlStatementTable.getQualifier() == null) {
                sqlStatementTable.setQualifier(table.schema);
            }
            this.tables.put(sqlStatementTable.getQualifiedName(), table);
        }
        if (this.getTableView(table, string2) == null) {
            this.addTableView(table, string2);
        }
    }

    public void addTableView(Table table, String string) {
        TableView tableView = new TableView(table, string);
        tableView.setVisible(true);
        tableView.setResizable(true);
        tableView.addMouseListener(this);
        tableView.column_list.addMouseListener(this);
        this.tableViews.addElement(tableView);
        tableView.pack();
        this.desktopPane.add(tableView);
        this.desktopPane.revalidate();
        this.refresh();
    }

    public void deleteTable(TableView tableView) {
        if (tableView == null) {
            return;
        }
        this.sqlStatement.removeTable(tableView.getAlias());
        this.sqlStatement.notifyObservers(this);
        tableView.column_list.removeListSelectionListener(this);
        tableView.removeMouseListener(this);
        tableView.column_list.removeMouseListener(this);
        this.desktopPane.remove(tableView);
        this.desktopPane.revalidate();
        this.deleteJoin(tableView);
        Table table = tableView.table;
        this.tableViews.removeElement(tableView);
        Vector vector = this.getTableViews(table);
        if (vector == null || vector.size() <= 0) {
            this.tables.remove(table.getFullName());
        }
        tableView = null;
        this.refresh();
    }

    public void setNodeProperties(NodeProperties nodeProperties) {
        this.sqlStatement.setExpertMode(nodeProperties.isExpertMode());
        this.clear();
        this.sqlStatement.setText(nodeProperties.getStatement());
        this.sqlStatement.notifyObservers(this);
        if (nodeProperties.isExpertMode()) {
            return;
        }
        this.convertSqlStatement();
        this.refresh();
    }

    private void clear() {
        this.selectedTableView = null;
        this.selectedJoinView = null;
        this.desktopPane.removeAll();
        this.tables = new Hashtable();
        this.tableViews = new Vector();
        this.joinViews = new Vector();
        this.sqlStatement.clear();
    }

    void convertSqlStatement() {
        Object object;
        Enumeration enumeration = this.sqlStatement.getTables();
        while (enumeration.hasMoreElements()) {
            object = (SqlStatementTable)enumeration.nextElement();
            this.addTableView(((SqlStatementTable)object).getQualifiedName(), ((SqlStatementTable)object).getAlias());
        }
        object = this.sqlStatement.getJoins();
        while (object.hasMoreElements()) {
            ColumnMap columnMap = (ColumnMap)object.nextElement();
            String string = columnMap.getParentColumn();
            String string2 = columnMap.getChildColumn();
            String string3 = null;
            String string4 = null;
            if (string.lastIndexOf(".") > -1) {
                string3 = string.substring(0, string.lastIndexOf("."));
                string = string.substring(string.lastIndexOf(".") + 1);
            }
            if (string2.lastIndexOf(".") > -1) {
                string4 = string2.substring(0, string2.lastIndexOf("."));
                string2 = string2.substring(string2.lastIndexOf(".") + 1);
            }
            TableView tableView = this.getTableView(string3, string);
            TableView tableView2 = this.getTableView(string4, string2);
            if (tableView == null || tableView2 == null) continue;
            this.addJoin(tableView, string, tableView2, string2);
        }
    }

    public final void setLayoutManager(LayoutManager layoutManager) {
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.isInitializing()) {
            return;
        }
        if (!(listSelectionEvent.getSource() instanceof JList) || ((JList)listSelectionEvent.getSource()).getParent() instanceof TableView) {
            // empty if block
        }
    }

    void addColumn() {
        this.addColumn(this.selectedTableView);
    }

    void addColumn(TableView tableView) {
        if (tableView == null) {
            return;
        }
        int[] nArray = tableView.column_list.getSelectedIndices();
        if (nArray != null) {
            boolean bl = false;
            int n = 0;
            while (n < nArray.length) {
                Object e = tableView.column_list.getModel().getElementAt(nArray[n]);
                String string = e.toString();
                String string2 = string != null && string.endsWith("*") ? null : string;
                this.sqlStatement.addColumn(string, string2, tableView.table.getFullName(), tableView.getAlias());
                bl = true;
                ++n;
            }
            if (bl) {
                this.sqlStatement.notifyObservers(this);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isInitializing()) {
            return;
        }
        if (actionEvent.getActionCommand().equals("AddTable")) {
            this.showTableChooser();
        } else if (actionEvent.getActionCommand().equals("AddJoin")) {
            this.addJoin();
        } else if (actionEvent.getActionCommand().equals("DeleteTable")) {
            if (this.selectedTableView != null) {
                this.deleteTable(this.selectedTableView);
                this.repaint();
            }
        } else if (actionEvent.getActionCommand().equals("DeleteJoin")) {
            if (this.selectedJoinView != null) {
                this.deleteJoin(this.selectedJoinView);
                this.repaint();
            }
        } else if (actionEvent.getActionCommand().equals("Refresh")) {
            this.refresh();
            this.repaint();
        } else if (actionEvent.getActionCommand().equals("Auto Join")) {
            this.autoJoin();
            this.repaint();
        }
    }

    void addJoin() {
        Serializable serializable;
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.sqlStatement.getJoins();
        while (enumeration.hasMoreElements()) {
            serializable = (ColumnMap)enumeration.nextElement();
            vector.addElement(((ColumnMap)serializable).getParentColumn() + " = " + ((ColumnMap)serializable).getChildColumn());
        }
        serializable = new SqlStatement(this.sqlStatement.getText());
        SqlStatement sqlStatement = new SqlStatement(this.sqlStatement.getText());
        JoinDialog joinDialog = new JoinDialog(null, vector, (SqlStatement)serializable, this.getNodeProperties(), sqlStatement, this.getNodeProperties(), true, false);
        joinDialog.pack();
        joinDialog.show();
        this.deleteAllJoins();
        this.addJoinFromStrings(joinDialog.getJoinStrings());
        this.repaint();
    }

    void addJoinFromStrings(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = string.substring(0, string.indexOf("."));
            String string3 = string.substring(string.indexOf(".") + 1, string.indexOf(" = "));
            String string4 = string.substring(string.indexOf(" = ") + 3, string.lastIndexOf("."));
            String string5 = string.substring(string.lastIndexOf(".") + 1);
            TableView tableView = this.getTableView(string2, string3);
            TableView tableView2 = this.getTableView(string4, string5);
            if (tableView != null && tableView2 != null) {
                this.addJoin(tableView, string3, tableView2, string5);
                continue;
            }
            this.sqlStatement.addJoin(string2 + "." + string3, string4 + "." + string5);
            this.sqlStatement.notifyObservers(this);
        }
    }

    JoinView getJoinView(TableView tableView, TableView tableView2) {
        Enumeration enumeration = this.joinViews.elements();
        while (enumeration.hasMoreElements()) {
            JoinView joinView = (JoinView)enumeration.nextElement();
            if ((!joinView.parent.equals(tableView) || !joinView.child.equals(tableView2)) && (!joinView.parent.equals(tableView2) || !joinView.child.equals(tableView))) continue;
            return joinView;
        }
        return null;
    }

    JoinView getJoinView(Join join) {
        Enumeration enumeration = this.joinViews.elements();
        while (enumeration.hasMoreElements()) {
            JoinView joinView = (JoinView)enumeration.nextElement();
            if ((!joinView.join.parent.equals(join.parent) || !joinView.join.child.equals(join.child)) && (!joinView.join.parent.equals(join.child) || !joinView.join.child.equals(join.parent))) continue;
            return joinView;
        }
        return null;
    }

    private TableView getTableView(Component component) {
        Component component2 = component;
        while (component2 != null) {
            if (component2 instanceof TableView) break;
            component2 = component2.getParent();
        }
        return (TableView)component2;
    }

    Vector getTableViews(Table table) {
        Vector<TableView> vector = new Vector<TableView>();
        Enumeration enumeration = this.tableViews.elements();
        while (enumeration.hasMoreElements()) {
            TableView tableView = (TableView)enumeration.nextElement();
            if (!tableView.table.equals(table)) continue;
            vector.addElement(tableView);
        }
        return vector;
    }

    TableView getTableView(Table table, String string) {
        Enumeration enumeration = this.getTableViews(table).elements();
        while (enumeration.hasMoreElements()) {
            TableView tableView = (TableView)enumeration.nextElement();
            if (!tableView.getAlias().equals(string)) continue;
            return tableView;
        }
        return null;
    }

    TableView getTableView(String string, String string2) {
        if (string == null) {
            Enumeration enumeration = this.tables.elements();
            while (enumeration.hasMoreElements()) {
                Vector vector;
                Table table = (Table)enumeration.nextElement();
                if (!table.containsColumn(string2) || (vector = this.getTableViews(table)) == null || vector.size() <= 0) continue;
                return (TableView)vector.elementAt(0);
            }
        } else {
            Enumeration enumeration = this.tableViews.elements();
            while (enumeration.hasMoreElements()) {
                TableView tableView = (TableView)enumeration.nextElement();
                if (!tableView.getAlias().equals(string)) continue;
                return tableView;
            }
        }
        return null;
    }

    void deleteAllJoins() {
        Enumeration enumeration = this.joinViews.elements();
        while (enumeration.hasMoreElements()) {
            JoinView joinView = (JoinView)enumeration.nextElement();
            this.deleteJoin(joinView);
        }
    }

    void deleteJoin(JoinView joinView) {
        this.sqlStatement.removeJoin(joinView.parent.getAlias());
        this.sqlStatement.removeJoin(joinView.child.getAlias());
        this.sqlStatement.notifyObservers(this);
        this.joinViews.removeElement(joinView);
        joinView = null;
    }

    void deleteJoin(TableView tableView) {
        Enumeration enumeration = this.joinViews.elements();
        while (enumeration.hasMoreElements()) {
            JoinView joinView = (JoinView)enumeration.nextElement();
            if (!joinView.parent.equals(tableView) && !joinView.child.equals(tableView)) continue;
            this.deleteJoin(joinView);
        }
    }

    void addJoin(TableView tableView, String string, TableView tableView2, String string2) {
        if (tableView == null || tableView2 == null) {
            return;
        }
        JoinView joinView = this.getJoinView(tableView, tableView2);
        if (joinView == null) {
            Join join = new Join(tableView.table, tableView.getAlias(), tableView2.table, tableView2.getAlias());
            join.add(string, string2);
            joinView = new JoinView(join, tableView, tableView2);
            this.joinViews.addElement(joinView);
        } else {
            joinView.join.add(string, string2);
        }
        this.sqlStatement.addJoin(tableView.getAlias() + "." + string, tableView2.getAlias() + "." + string2);
        this.sqlStatement.notifyObservers(this);
    }

    void addJoin(Vector vector, String string, Vector vector2, String string2) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            TableView tableView = (TableView)enumeration.nextElement();
            Enumeration enumeration2 = vector2.elements();
            while (enumeration2.hasMoreElements()) {
                TableView tableView2 = (TableView)enumeration2.nextElement();
                this.addJoin(tableView, string, tableView2, string2);
            }
        }
    }

    void autoJoin() {
        Enumeration enumeration = this.tables.elements();
        while (enumeration.hasMoreElements()) {
            Table table = (Table)enumeration.nextElement();
            Vector vector = this.getTableViews(table);
            Enumeration enumeration2 = table.getForeignKeys().elements();
            while (enumeration2.hasMoreElements()) {
                ColumnMap columnMap = (ColumnMap)enumeration2.nextElement();
                String string = columnMap.getParentColumn().substring(0, columnMap.getParentColumn().lastIndexOf("."));
                String string2 = columnMap.getParentColumn().substring(columnMap.getParentColumn().lastIndexOf(".") + 1);
                String string3 = columnMap.getChildColumn().substring(columnMap.getChildColumn().lastIndexOf(".") + 1);
                Table table2 = (Table)this.tables.get(string);
                if (table2 == null) continue;
                Vector vector2 = this.getTableViews(table2);
                this.addJoin(vector2, string2, vector, string3);
            }
        }
    }

    void refresh() {
        Serializable serializable;
        Object object;
        int n = 20;
        JDesktopPane jDesktopPane = this.desktopPane;
        Enumeration enumeration = this.joinViews.elements();
        Vector<TableView> vector = new Vector<TableView>();
        int n2 = this.getSize().width;
        int n3 = this.getInsets().left;
        int n4 = this.getInsets().top;
        int n5 = 0;
        while (enumeration.hasMoreElements()) {
            Cloneable cloneable;
            object = (JoinView)enumeration.nextElement();
            if (!vector.contains(object.parent)) {
                cloneable = object.parent.getPreferredSize();
                serializable = object.parent.getBounds();
                n5 = Math.max(n4 + ((Rectangle)serializable).height + n, n5);
                if (n3 + ((Rectangle)serializable).width + n > n2) {
                    n3 = this.getInsets().left;
                    n4 = n5;
                }
                object.parent.setLocation(n3, n4);
                n3 += ((Rectangle)serializable).width + n;
                vector.addElement(object.parent);
            }
            if (vector.contains(object.child)) continue;
            cloneable = object.child.getBounds();
            n5 = Math.max(n4 + ((Rectangle)cloneable).height + n, n5);
            if (n3 + ((Rectangle)cloneable).width + n > n2) {
                n3 = this.getInsets().left;
                n4 = n5;
            }
            object.child.setLocation(n3, n4);
            n3 += ((Rectangle)cloneable).width + n;
            vector.addElement(object.child);
        }
        object = jDesktopPane.getComponents();
        int n6 = 0;
        while (n6 < ((Component[])object).length) {
            serializable = object[n6];
            if (serializable instanceof TableView && !vector.contains(serializable)) {
                Rectangle rectangle = ((Component)serializable).getBounds();
                n5 = Math.max(n4 + rectangle.height + n, n5);
                if (n3 + rectangle.width + n > n2) {
                    n3 = this.getInsets().left;
                    n4 = n5;
                }
                ((Component)serializable).setLocation(n3, n4);
                n3 += rectangle.width + n;
            }
            ++n6;
        }
        this.setSize(this.getMinimumSize());
        if (this.getParent() != null) {
            this.getParent().doLayout();
        }
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JScrollPane == null ? (class$javax$swing$JScrollPane = SqlBuilderPanel.class$("javax.swing.JScrollPane")) : class$javax$swing$JScrollPane, this);
        if (jScrollPane == null || this.getComponentCount() == 0) {
            return super.getPreferredSize();
        }
        return this.getMaxBounds(this.desktopPane);
    }

    protected Dimension getMaxBounds(JComponent jComponent) {
        Rectangle rectangle = new Rectangle();
        int n = 0;
        while (n < jComponent.getComponentCount()) {
            rectangle = rectangle.union(jComponent.getComponent(n).getBounds());
            ++n;
        }
        return rectangle.getSize();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.moving) {
            return;
        }
        graphics.setColor(Color.blue);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(3.0f));
        Point point = new Point();
        Point point2 = new Point();
        Enumeration enumeration = this.joinViews.elements();
        while (enumeration.hasMoreElements()) {
            JoinView joinView = (JoinView)enumeration.nextElement();
            joinView.getLocations(point, point2);
            graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
        }
    }

    public JoinView mouseEventToJoinView(MouseEvent mouseEvent) {
        Enumeration enumeration = this.joinViews.elements();
        Point point = mouseEvent.getPoint();
        while (enumeration.hasMoreElements()) {
            JoinView joinView = (JoinView)enumeration.nextElement();
            if (!joinView.getPolygon().contains(point)) continue;
            return joinView;
        }
        return null;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void tableSelected(Vector vector) {
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addTable((String)enumeration.nextElement());
        }
        this.doLayout();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        JoinView joinView;
        if (mouseEvent.getSource() instanceof JList && ((JList)mouseEvent.getSource()).getParent().getParent().getParent() instanceof TableView) {
            if (mouseEvent.getClickCount() == 2) {
                this.addColumn((TableView)((JList)mouseEvent.getSource()).getParent().getParent().getParent());
            }
        } else if ((mouseEvent.getModifiers() & 0x10) == 16 && (joinView = this.mouseEventToJoinView(mouseEvent)) != null) {
            Serializable serializable;
            Vector<String> vector = new Vector<String>();
            Enumeration enumeration = joinView.join.elements();
            while (enumeration.hasMoreElements()) {
                serializable = (ColumnMap)enumeration.nextElement();
                vector.addElement(joinView.parent.getAlias() + "." + ((ColumnMap)serializable).getParentColumn() + " = " + joinView.child.getAlias() + "." + ((ColumnMap)serializable).getChildColumn());
            }
            serializable = new JoinDialog(null, vector, this.sqlStatement, this.getNodeProperties());
            ((Window)serializable).pack();
            ((Dialog)serializable).show();
            this.deleteJoin(joinView);
            this.addJoinFromStrings(((JoinDialog)serializable).getJoinStrings());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof Component) {
            this.selectedTableView = this.getTableView((Component)mouseEvent.getSource());
        }
        this.selectedJoinView = this.mouseEventToJoinView(mouseEvent);
        if ((mouseEvent.getModifiers() & 4) == 4) {
            this.miDeleteTable.setEnabled(this.selectedTableView != null);
            this.miDeleteJoin.setEnabled(this.selectedJoinView != null);
            if (!this.getNodeProperties().isExpertMode()) {
                this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public Frame getFrame() {
        return new JFrame();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class SimpleDesktopManager
    extends DefaultDesktopManager {
        SimpleDesktopManager() {
        }

        public void endDraggingFrame(JComponent jComponent) {
            super.endDraggingFrame(jComponent);
            SqlBuilderPanel.this.moving = false;
            SqlBuilderPanel.this.repaint();
        }

        public void dragFrame(JComponent jComponent, int n, int n2) {
            super.dragFrame(jComponent, n, n2);
            SqlBuilderPanel.this.moving = true;
        }
    }
}

