/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.customizer;

import com.klg.jclass.datasource.ErrorDialog;
import com.klg.jclass.datasource.LocaleBundle;
import com.klg.jclass.datasource.beans.JCDataEvent;
import com.klg.jclass.datasource.beans.NodeProperties;
import com.klg.jclass.datasource.customizer.DataModelPage;
import com.klg.jclass.datasource.customizer.Table;
import com.klg.jclass.datasource.util.SqlStatement;
import com.klg.jclass.datasource.util.SqlStatementTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DriverTablePage
extends DataModelPage
implements ActionListener,
ItemListener {
    JComboBox driverTable;
    JComboBox column;
    JList primaryKeys;
    JButton btnAdd;
    JButton btnDelete;
    DefaultListModel listModel;

    public DriverTablePage() {
        super(LocaleBundle.string("Driver Table"));
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.driverTable = new JComboBox();
        JLabel jLabel = new JLabel(LocaleBundle.string("Table"));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 5.0;
        jPanel.add((Component)this.driverTable, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        JLabel jLabel2 = new JLabel(LocaleBundle.string("Primary Key"));
        this.listModel = new DefaultListModel();
        this.primaryKeys = new JList(this.listModel);
        JPanel jPanel3 = new JPanel();
        this.column = new JComboBox();
        JLabel jLabel3 = new JLabel(LocaleBundle.string("Column Name"));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jLabel2, "North");
        jPanel2.add((Component)new JScrollPane(this.primaryKeys), "Center");
        jPanel3.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        jPanel3.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 5.0;
        jPanel3.add((Component)this.column, gridBagConstraints);
        jPanel2.add((Component)jPanel3, "South");
        JPanel jPanel4 = new JPanel();
        this.btnAdd = new JButton(LocaleBundle.string("Add"));
        this.btnDelete = new JButton(LocaleBundle.string("Delete"));
        jPanel4.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        jPanel4.add((Component)this.btnAdd, gridBagConstraints);
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.fill = 0;
        jPanel4.add((Component)this.btnDelete, gridBagConstraints);
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel4, "South");
        this.primaryKeys.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (DriverTablePage.this.isInitializing()) {
                    return;
                }
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                String string = (String)DriverTablePage.this.primaryKeys.getSelectedValue();
                DriverTablePage.this.column.setSelectedItem(string);
            }
        });
        this.driverTable.addItemListener(this);
        this.column.addItemListener(this);
        this.btnAdd.addActionListener(this);
        this.btnDelete.addActionListener(this);
    }

    public void setNodeProperties(NodeProperties nodeProperties) {
        SqlStatement sqlStatement = new SqlStatement(nodeProperties.getStatement());
        if (this.driverTable.getItemCount() > 0) {
            this.driverTable.removeAllItems();
        }
        String string = null;
        Enumeration enumeration = sqlStatement.getTables();
        while (enumeration.hasMoreElements()) {
            SqlStatementTable sqlStatementTable = (SqlStatementTable)enumeration.nextElement();
            this.driverTable.addItem(sqlStatementTable.getAlias());
            if (!sqlStatementTable.getAlias().equals(nodeProperties.getDriverTable())) continue;
            string = sqlStatementTable.getQualifiedName();
        }
        this.loadColumns(string);
        if (nodeProperties.getDriverTable() != null) {
            this.driverTable.setSelectedItem(nodeProperties.getDriverTable());
        }
    }

    void setAllowPrimaryKeysEntered(boolean bl) {
        this.primaryKeys.setEnabled(bl);
        this.column.setEnabled(bl);
        this.btnAdd.setEnabled(bl);
        this.btnDelete.setEnabled(bl);
    }

    void loadColumns(String string) {
        Vector vector;
        boolean bl = true;
        if (this.column.getItemCount() > 0) {
            this.column.removeAllItems();
        }
        this.listModel.removeAllElements();
        if (string == null) {
            return;
        }
        Connection connection = null;
        try {
            connection = this.getNodeProperties().getConnection() == null ? null : this.getNodeProperties().getConnection().getConnection();
        }
        catch (Exception exception) {
            ErrorDialog.showError(this, exception.toString());
            return;
        }
        if (connection == null) {
            return;
        }
        Table table = new Table(connection, string);
        bl = table == null || table.getPrimaryKeys() == null || table.getPrimaryKeys().size() <= 0;
        this.setAllowPrimaryKeysEntered(bl);
        String[] stringArray = table.getColumnNames();
        int n = 0;
        while (n < stringArray.length) {
            this.column.addItem(stringArray[n]);
            ++n;
        }
        Vector vector2 = vector = table.getPrimaryKeys() != null && table.getPrimaryKeys().size() > 0 ? table.getPrimaryKeys() : this.getNodeProperties().getDriverTablePrimaryKeys();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                this.listModel.addElement(string2);
            }
        }
        if (this.listModel.getSize() > 0) {
            this.primaryKeys.setSelectedIndex(0);
            this.column.setSelectedItem(this.primaryKeys.getSelectedValue());
        } else {
            ErrorDialog.showError(this, LocaleBundle.string("Primary key of driver table must be entered."));
        }
        if (!bl) {
            this.setDriverTablePrimaryKeys();
        }
    }

    private boolean columnExists(String string) {
        boolean bl = false;
        int n = 0;
        while (n < this.listModel.getSize()) {
            if (this.listModel.getElementAt(n).equals(string)) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private void addColumn() {
        String string = (String)this.column.getSelectedItem();
        if (string == null || string.length() == 0) {
            return;
        }
        if (!this.columnExists(string)) {
            this.listModel.addElement(string);
            this.setDriverTablePrimaryKeys();
        }
    }

    private void deleteColumn() {
        int n = this.primaryKeys.getSelectedIndex();
        if (n > -1) {
            this.primaryKeys.remove(n);
            this.setDriverTablePrimaryKeys();
        }
    }

    private void setDriverTablePrimaryKeys() {
        Vector vector = new Vector();
        int n = 0;
        while (n < this.listModel.getSize()) {
            vector.addElement(this.listModel.getElementAt(n));
            ++n;
        }
        try {
            this.getNodeProperties().setDriverTablePrimaryKeys(vector);
            this.getNodeProperties().fireJCDataEvent(new JCDataEvent((Object)this.getNodeProperties()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isInitializing()) {
            return;
        }
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton.equals(this.btnAdd)) {
                this.addColumn();
            } else if (jButton.equals(this.btnDelete)) {
                this.deleteColumn();
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.isInitializing()) {
            return;
        }
        if (itemEvent.getStateChange() == 1 && !itemEvent.getSource().equals(this.primaryKeys) && itemEvent.getSource().equals(this.driverTable)) {
            String string = (String)this.driverTable.getSelectedItem();
            try {
                this.getNodeProperties().setDriverTable(string);
                this.getNodeProperties().fireJCDataEvent(new JCDataEvent((Object)this.getNodeProperties()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

