/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource;

import com.klg.jclass.datasource.DataModel;
import com.klg.jclass.datasource.DataModelEvent;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataModelListener;
import com.klg.jclass.datasource.DataSourceTreeModel;
import com.klg.jclass.datasource.DataSourceTreeNode;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.util.JCListenerList;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class TreeData
implements DataModel,
Serializable {
    static final long serialVersionUID = -280385478977847078L;
    protected DataSourceTreeModel meta_tree = new DataSourceTreeModel(DataSourceTreeModel.NullRoot);
    protected transient DataSourceTreeModel data_tree = new DataSourceTreeModel(DataSourceTreeModel.NullRoot);
    protected JCListenerList listeners;
    protected transient DataTableModel currentDataTable;
    protected long currentBookmark = -1L;
    protected boolean eventsEnabled = true;
    protected static int nameCounter = 0;
    protected String modelName = "TreeData" + nameCounter++;

    public TreeModel getMetaDataTree() {
        return this.meta_tree;
    }

    public TreeModel getDataTableTree() {
        return this.data_tree;
    }

    public void addDataModelListener(DataModelListener dataModelListener) {
        this.listeners = JCListenerList.add(this.listeners, dataModelListener);
    }

    public void removeDataModelListener(DataModelListener dataModelListener) {
        this.listeners = JCListenerList.remove(this.listeners, dataModelListener);
    }

    public Object getListeners() {
        return this.listeners;
    }

    public boolean moveToRow(DataModelListener dataModelListener, DataTableModel dataTableModel, long l) throws DataModelException {
        return this.moveToRow(dataModelListener, dataTableModel, l, true);
    }

    public boolean moveToRow(DataModelListener dataModelListener, DataTableModel dataTableModel, long l, boolean bl) throws DataModelException {
        if (this.currentDataTable != null && l == this.currentBookmark) {
            return true;
        }
        if (!this.fireDataModelEvent(new DataModelEvent(this, dataModelListener, dataTableModel, l, "", 11))) {
            return false;
        }
        if (this.currentDataTable == null) {
            this.currentDataTable = (DataTableModel)this.getDataTableTree().getRoot();
            this.currentBookmark = this.currentDataTable.first() ? this.currentDataTable.getCurrentBookmark() : l;
        }
        int n = dataTableModel.getRowIndex(l);
        if (this.currentDataTable.getRootAncestorBookmark(this.currentBookmark) == dataTableModel.getRootAncestorBookmark(l) ? this.currentDataTable.getMetaData().getCommitPolicy() == 1 && this.currentDataTable.getRowStatus(this.currentBookmark) != 4 && this.currentDataTable.getRowStatus(this.currentBookmark) != 5 && this.currentBookmark != l && !this.currentDataTable.commitRow(dataModelListener, this.currentBookmark) : ((DataTableModel)this.getDataTableTree().getRoot()).isSubTreeModified(this.currentDataTable.getRootAncestorBookmark(this.currentBookmark)) && !this.conditionallyCommitSubTreeRootedAt(dataModelListener, this.currentDataTable.getRootAncestorBookmark(this.currentBookmark))) {
            return false;
        }
        if (this.resetHappened(dataTableModel, l)) {
            l = this.currentDataTable.getRowIdentifier(n);
        } else {
            this.currentDataTable = dataTableModel;
        }
        this.currentBookmark = l;
        if (bl) {
            this.currentDataTable.moveToRow(l);
        }
        this.fireDataModelEvent(new DataModelEvent(this, dataModelListener, this.currentDataTable, l, "", 106));
        return true;
    }

    private boolean resetHappened(DataTableModel dataTableModel, long l) {
        DataTableModel dataTableModel2 = (DataTableModel)this.getDataTableTree().getRoot();
        if (((TreeNode)((Object)dataTableModel)).getParent() == null && dataTableModel != dataTableModel2) {
            return true;
        }
        return dataTableModel2.getRowIndex(dataTableModel.getRootAncestorBookmark(l)) == -1;
    }

    private boolean conditionallyCommitSubTreeRootedAt(DataModelListener dataModelListener, long l) throws DataModelException {
        DataTableModel dataTableModel = (DataTableModel)this.data_tree.getRoot();
        MetaDataModel metaDataModel = (MetaDataModel)this.getMetaDataTree().getRoot();
        if (!this.fireDataModelEvent(new DataModelEvent(this, dataModelListener, dataTableModel, l, "", 9))) {
            return false;
        }
        try {
            if (dataTableModel.getMetaData().getCommitPolicy() == 1 && dataTableModel.getRowStatus(l) != 4 && dataTableModel.getRowStatus(l) != 5) {
                dataTableModel.commitRow(dataModelListener, l);
            }
            Enumeration<? extends TreeNode> enumeration = ((TreeNode)((Object)dataTableModel)).children();
            while (enumeration.hasMoreElements()) {
                DataTableModel dataTableModel2 = (DataTableModel)((Object)enumeration.nextElement());
                if (dataTableModel2.getParentBookmark() != l) continue;
                dataTableModel2.conditionallyCommitYourselfAndChildren(dataModelListener);
            }
            metaDataModel.commitTransaction();
            dataTableModel.processEventQueue(dataModelListener);
        }
        catch (DataModelException dataModelException) {
            try {
                metaDataModel.rollbackTransaction();
            }
            catch (DataModelException dataModelException2) {
                // empty catch block
            }
            dataTableModel.clearEventQueue();
            this.fireDataModelEvent(new DataModelEvent(this, dataModelListener, dataTableModel, -2L, "", 105));
            throw dataModelException;
        }
        return true;
    }

    public void updateAll(DataModelListener dataModelListener) throws DataModelException {
        DataTableModel dataTableModel = (DataTableModel)this.getDataTableTree().getRoot();
        MetaDataModel metaDataModel = (MetaDataModel)this.getMetaDataTree().getRoot();
        if (!this.fireDataModelEvent(new DataModelEvent(this, dataModelListener, dataTableModel, -2L, "", 6))) {
            return;
        }
        this.fireDataModelEvent(new DataModelEvent(this, dataModelListener, dataTableModel, -2L, "", 104));
        try {
            dataTableModel.commitAll(dataModelListener);
            metaDataModel.commitTransaction();
            dataTableModel.processEventQueue(dataModelListener);
        }
        catch (DataModelException dataModelException) {
            try {
                metaDataModel.rollbackTransaction();
            }
            catch (DataModelException dataModelException2) {
                // empty catch block
            }
            dataTableModel.clearEventQueue();
            this.fireDataModelEvent(new DataModelEvent(this, dataModelListener, dataTableModel, -2L, "", 105));
            throw dataModelException;
        }
        this.fireDataModelEvent(new DataModelEvent(this, dataModelListener, dataTableModel, -2L, "", 105));
    }

    public void cancelAll(DataModelListener dataModelListener) throws DataModelException {
        DataTableModel dataTableModel = (DataTableModel)this.getDataTableTree().getRoot();
        if (!this.fireDataModelEvent(new DataModelEvent(this, dataModelListener, dataTableModel, -2L, "", 7))) {
            return;
        }
        this.fireDataModelEvent(new DataModelEvent(this, dataModelListener, dataTableModel, -2L, "", 104));
        if (this.currentDataTable != null && this.currentBookmark != -1L) {
            this.currentDataTable.cancelRowChanges(dataModelListener, this.currentBookmark);
        }
        dataTableModel.cancelAllRowChanges(dataModelListener);
        this.fireDataModelEvent(new DataModelEvent(this, dataModelListener, dataTableModel, -2L, "", 105));
    }

    public void requeryAll(DataModelListener dataModelListener) throws DataModelException {
        DataTableModel dataTableModel = (DataTableModel)this.data_tree.getRoot();
        if (!this.fireDataModelEvent(new DataModelEvent(this, dataModelListener, dataTableModel, -2L, "", 2))) {
            return;
        }
        ((DataSourceTreeNode)((Object)dataTableModel)).removeAllChildren();
        MetaDataModel metaDataModel = (MetaDataModel)this.getMetaDataTree().getRoot();
        this.clearCurrentPath(metaDataModel);
        metaDataModel.setCurrentDataTable(null);
        metaDataModel.setCurrentBookmark(-1L);
        DataTableModel dataTableModel2 = dataTableModel.requeryLevel();
        this.data_tree.setRoot((TreeNode)((Object)dataTableModel2));
        metaDataModel.setCurrentDataTable(dataTableModel2);
        dataTableModel2.first();
        long l = dataTableModel2.getCurrentBookmark();
        metaDataModel.setCurrentBookmark(l);
        this.currentDataTable = dataTableModel2;
        this.currentBookmark = l;
        DataModelEvent dataModelEvent = new DataModelEvent(this, dataModelListener, dataTableModel2, l, "", 103);
        this.fireDataModelEvent(dataModelEvent);
    }

    public void clearCurrentPath(MetaDataModel metaDataModel) {
        if (metaDataModel == null) {
            return;
        }
        Enumeration<? extends TreeNode> enumeration = metaDataModel.children();
        while (enumeration.hasMoreElements()) {
            MetaDataModel metaDataModel2 = (MetaDataModel)enumeration.nextElement();
            this.clearCurrentPath2(metaDataModel2);
        }
    }

    void clearCurrentPath2(MetaDataModel metaDataModel) {
        if (metaDataModel == null) {
            return;
        }
        Enumeration<? extends TreeNode> enumeration = metaDataModel.children();
        while (enumeration.hasMoreElements()) {
            MetaDataModel metaDataModel2 = (MetaDataModel)enumeration.nextElement();
            this.clearCurrentPath2(metaDataModel2);
        }
        metaDataModel.setCurrentDataTable(null);
        metaDataModel.setCurrentBookmark(-1L);
    }

    public boolean fireDataModelEvent(DataModelEvent dataModelEvent, DataModelListener dataModelListener) {
        return this.sendDataModelEvent(dataModelEvent, dataModelListener);
    }

    public boolean fireDataModelEvent(DataModelEvent dataModelEvent) {
        return this.sendDataModelEvent(dataModelEvent, null);
    }

    protected boolean sendDataModelEvent(DataModelEvent dataModelEvent, DataModelListener dataModelListener) {
        Object object;
        Enumeration enumeration;
        boolean bl = true;
        if (!this.eventsEnabled) {
            return bl;
        }
        if (dataModelListener == null) {
            enumeration = JCListenerList.elements(this.listeners);
        } else {
            object = new Vector<DataModelListener>(1);
            ((Vector)object).addElement(dataModelListener);
            enumeration = ((Vector)object).elements();
        }
        while (enumeration.hasMoreElements()) {
            object = (DataModelListener)enumeration.nextElement();
            this.fireDataModelEventInternal(dataModelEvent, (DataModelListener)object);
            if (dataModelEvent == null || !dataModelEvent.getCancelled()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    protected void fireDataModelEventInternal(DataModelEvent dataModelEvent, DataModelListener dataModelListener) {
        switch (dataModelEvent.getCommand()) {
            case 1: {
                dataModelListener.beforeInsertRow(dataModelEvent);
                break;
            }
            case 2: {
                dataModelListener.beforeReset(dataModelEvent);
                break;
            }
            case 3: {
                dataModelListener.beforeRequery(dataModelEvent);
                break;
            }
            case 4: {
                dataModelListener.beforeEditCell(dataModelEvent);
                break;
            }
            case 5: {
                dataModelListener.beforeDeleteRow(dataModelEvent);
                break;
            }
            case 6: {
                dataModelListener.beforeCommitAll(dataModelEvent);
                break;
            }
            case 7: {
                dataModelListener.beforeCancelAll(dataModelEvent);
                break;
            }
            case 8: {
                dataModelListener.beforeCancelRowChanges(dataModelEvent);
                break;
            }
            case 9: {
                dataModelListener.beforeCommitConditional(dataModelEvent);
                break;
            }
            case 10: {
                dataModelListener.beforeCommitRow(dataModelEvent);
                break;
            }
            case 11: {
                dataModelListener.beforeMoveToCurrentRow(dataModelEvent);
                break;
            }
            case 12: {
                dataModelListener.beforeDeleteTable(dataModelEvent);
                break;
            }
            case 100: {
                dataModelListener.afterChangeOfRowData(dataModelEvent);
                break;
            }
            case 101: {
                dataModelListener.afterInsertRow(dataModelEvent);
                break;
            }
            case 102: {
                dataModelListener.afterDeleteRow(dataModelEvent);
                break;
            }
            case 103: {
                dataModelListener.afterReset(dataModelEvent);
                break;
            }
            case 106: {
                dataModelListener.afterMoveToCurrentRow(dataModelEvent);
                break;
            }
            case 109: {
                dataModelListener.afterRequeryRowAndDetails(dataModelEvent);
                break;
            }
            case 110: {
                dataModelListener.afterRequeryTable(dataModelEvent);
                break;
            }
            case 104: {
                dataModelListener.beginEvents(dataModelEvent);
                break;
            }
            case 105: {
                dataModelListener.endEvents(dataModelEvent);
                break;
            }
            case 107: {
                dataModelListener.initialize(dataModelEvent);
                break;
            }
            case 108: {
                dataModelListener.originatorNavigateRow(dataModelEvent);
                break;
            }
        }
    }

    public void enableDataModelEvents(boolean bl) {
        this.eventsEnabled = bl;
    }

    public boolean getEventsEnabled() {
        return this.eventsEnabled;
    }

    public void setModelName(String string) {
        this.modelName = string;
    }

    public String getModelName() {
        return this.modelName;
    }

    public DataTableModel getCurrentGlobalTable() {
        return this.currentDataTable;
    }

    public long getCurrentGlobalBookmark() {
        return this.currentBookmark;
    }

    public DataTableModel getCurrentDataTable(DataModelListener dataModelListener, MetaDataModel metaDataModel) throws DataModelException {
        this.setOrCreatePathFromRootToMe(dataModelListener, metaDataModel);
        return metaDataModel.getCurrentDataTable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setOrCreatePathFromRootToMe(DataModelListener dataModelListener, MetaDataModel metaDataModel) throws DataModelException {
        MetaDataModel metaDataModel2 = (MetaDataModel)metaDataModel.getParent();
        if (metaDataModel2 == null) {
            metaDataModel.setCurrentDataTable((DataTableModel)this.getDataTableTree().getRoot());
            return;
        }
        DataTableModel dataTableModel = metaDataModel.getCurrentDataTable();
        long l = metaDataModel.getCurrentBookmark();
        if (dataTableModel != null) {
            if (this.ancestorPathPointsToMe(dataTableModel)) return;
            this.setOrCreatePathFromRootToMe(dataModelListener, (MetaDataModel)metaDataModel.getParent());
        } else {
            this.setOrCreatePathFromRootToMe(dataModelListener, (MetaDataModel)metaDataModel.getParent());
        }
        DataTableModel dataTableModel2 = metaDataModel2.getCurrentDataTable();
        if (dataTableModel2 == null) {
            this.setOrCreatePathFromRootToMe(dataModelListener, metaDataModel2);
            dataTableModel2 = metaDataModel2.getCurrentDataTable();
        }
        DataTableModel dataTableModel3 = null;
        long l2 = -1L;
        if (dataTableModel2 != null && (dataTableModel3 = dataTableModel2.createTable(dataModelListener, metaDataModel2.getCurrentBookmark(), metaDataModel)) != null) {
            dataTableModel3.first();
            if (dataTableModel3.getRowCount() > 0) {
                l2 = dataTableModel3.getCurrentBookmark();
            }
        }
        metaDataModel.setCurrentDataTable(dataTableModel3);
        metaDataModel.setCurrentBookmark(l2);
    }

    private boolean ancestorPathPointsToMe(DataTableModel dataTableModel) {
        Vector vector = new Vector();
        dataTableModel.getAncestors(vector);
        int n = 0;
        while (n < vector.size()) {
            DataTableModel dataTableModel2 = (DataTableModel)((Object)((TreeNode)((Object)dataTableModel)).getParent());
            if (dataTableModel2 == null) {
                return false;
            }
            MetaDataModel metaDataModel = dataTableModel2.getMetaData();
            if (metaDataModel == null || !vector.contains(new Long(metaDataModel.getCurrentBookmark()))) {
                return false;
            }
            dataTableModel = (DataTableModel)((Object)((TreeNode)((Object)dataTableModel)).getParent());
            ++n;
        }
        return true;
    }

    public Object getCurrentDataItem(DataModelListener dataModelListener, MetaDataModel metaDataModel, String string) throws DataModelException {
        DataTableModel dataTableModel = this.getCurrentDataTable(dataModelListener, metaDataModel);
        long l = metaDataModel.getCurrentBookmark();
        if (dataTableModel != null && l != -1L && dataTableModel.getRowStatus(l) != 5 && dataTableModel.getRowStatus(l) != 3) {
            return dataTableModel.getResultData(l, string);
        }
        return null;
    }

    public MetaDataModel getMetaData(String string) {
        MetaDataModel metaDataModel = (MetaDataModel)this.getMetaDataTree().getRoot();
        return this.getMetaDataByName(metaDataModel, string);
    }

    private MetaDataModel getMetaDataByName(MetaDataModel metaDataModel, String string) {
        if (metaDataModel == null || metaDataModel.getDescription().equals(string)) {
            return metaDataModel;
        }
        Enumeration<? extends TreeNode> enumeration = metaDataModel.children();
        MetaDataModel metaDataModel2 = null;
        while (enumeration.hasMoreElements()) {
            MetaDataModel metaDataModel3 = (MetaDataModel)enumeration.nextElement();
            metaDataModel2 = this.getMetaDataByName(metaDataModel3, string);
            if (metaDataModel2 != null) break;
        }
        return metaDataModel2;
    }

    public boolean isModified() {
        DataTableModel dataTableModel;
        boolean bl = false;
        TreeModel treeModel = this.getDataTableTree();
        if (treeModel != null && (dataTableModel = (DataTableModel)treeModel.getRoot()) != null) {
            bl = dataTableModel.isModified() ? true : dataTableModel.isTableOrChildrenModified();
        }
        return bl;
    }

    public void clearDataTableTreeUserData(Object object) {
        DataTableModel dataTableModel = (DataTableModel)this.getDataTableTree().getRoot();
        Enumeration<TreeNode> enumeration = ((DataSourceTreeNode)((Object)dataTableModel)).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DataTableModel dataTableModel2 = (DataTableModel)((Object)enumeration.nextElement());
            dataTableModel2.setUserData(object, null);
        }
    }

    public void clearDataTableTreeInternalData(Object object) {
        DataTableModel dataTableModel = (DataTableModel)this.getDataTableTree().getRoot();
        Enumeration<TreeNode> enumeration = ((DataSourceTreeNode)((Object)dataTableModel)).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DataTableModel dataTableModel2 = (DataTableModel)((Object)enumeration.nextElement());
            dataTableModel2.setInternalData(object, null);
        }
    }
}

