/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.util.table;

import com.agentpp.util.table.TableGregorianRenderer;
import com.agentpp.util.table.TableSorter;
import com.agentpp.util.table.ToolTipTableCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TablePanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    protected JFrame myFrame = null;
    protected JTable tableView = null;
    protected TableSorter sorter = null;
    protected JScrollPane scrollpane = null;
    protected TableModel data = null;
    protected int sortedColumn = -1;
    public static boolean SORT_MODE_ONCE = true;
    public static boolean SORT_MODE_ALWAYS = false;
    protected boolean sortmode = SORT_MODE_ONCE;

    public TablePanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.tableView = new JTable();
        this.scrollpane = new JScrollPane(this.tableView);
        this.scrollpane.setBackground(this.getBackground());
        this.scrollpane.setVerticalScrollBarPolicy(22);
        this.scrollpane.setHorizontalScrollBarPolicy(32);
        this.add((Component)this.scrollpane, "Center");
    }

    public void setRendererForTable() {
        TableGregorianRenderer gregor = new TableGregorianRenderer();
        this.tableView.setDefaultRenderer(GregorianCalendar.class, gregor);
        this.tableView.setDefaultRenderer(String.class, new ToolTipTableCellRenderer());
    }

    public void setSortedColumn(int i) {
        this.sortedColumn = i;
    }

    public int getSortedColumn() {
        return this.sortedColumn;
    }

    public void setSortMode(boolean mode) {
        this.sortmode = mode;
    }

    public boolean getSortMode() {
        return this.sortmode;
    }

    public void setTableModel(TableModel model) {
        this.data = model;
    }

    public void setFrame(JFrame f) {
        this.myFrame = f;
    }

    public void setModel(TableModel m) {
        this.data = m;
    }

    public void updateSort() {
        if (this.sortmode == SORT_MODE_ALWAYS && this.sortedColumn != -1) {
            this.sort(this.sortedColumn);
        }
    }

    public void create() {
        if (this.data != null) {
            this.sorter = new TableSorter(this.data);
            this.tableView.setModel(this.sorter);
            this.tableView.getTableHeader().setReorderingAllowed(false);
            this.tableView.setSelectionMode(2);
            this.setRendererForTable();
            this.tableView.createDefaultColumnsFromModel();
            this.tableView.tableChanged(new TableModelEvent(this.sorter));
            this.addMouseListenerToHeaderInTable(this.tableView);
            this.updateSort();
        } else {
            this.sorter = new TableSorter(this.data);
            this.tableView.setModel(this.sorter);
            this.setRendererForTable();
            this.tableView.createDefaultColumnsFromModel();
            this.tableView.tableChanged(new TableModelEvent(this.sorter));
        }
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        this.tableView.setColumnSelectionAllowed(false);
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TablePanel.this.clearSelection();
                TableColumnModel columnModel = TablePanel.this.tableView.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = TablePanel.this.tableView.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    int shiftPressed = e.getModifiers() & 1;
                    boolean ascending = shiftPressed == 0;
                    TablePanel.this.sorter.sortByColumn(column, ascending);
                    TablePanel.this.sortedColumn = column;
                }
            }
        };
        JTableHeader th = this.tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
    }

    public void clearSelection() {
        TableCellEditor ed = this.tableView.getCellEditor();
        if (ed != null) {
            ed.stopCellEditing();
        }
        this.tableView.clearSelection();
    }

    public void sort(int n) {
        this.sorter.sortByColumn(n);
        this.sortedColumn = n;
    }

    public int getSelectedRow() {
        if (this.tableView != null) {
            return this.tableView.getSelectedRow();
        }
        return -1;
    }

    public int getRowInTableModel(int r) {
        return this.sorter.getRowInTableModel(r);
    }

    public int getRowInView(int r) {
        if (this.sorter == null) {
            return -1;
        }
        for (int i = 0; i < this.sorter.getRowCount(); ++i) {
            if (this.getRowInTableModel(i) != r) continue;
            return i;
        }
        return -1;
    }

    public int getSelectedRowInTableModel() {
        int r = this.getSelectedRow();
        if (r < 0) {
            return r;
        }
        return this.sorter.getRowInTableModel(r);
    }

    public int[] getSelectedRowsInTableModel() {
        int[] i = null;
        boolean len = false;
        if (this.tableView != null && this.sorter != null && this.data != null) {
            int[] s = this.tableView.getSelectedRows();
            i = new int[s.length];
            for (int j = 0; j < s.length; ++j) {
                if (s[j] == -1) continue;
                i[j] = this.sorter.getRowInTableModel(s[j]);
            }
            return i;
        }
        return null;
    }

    public int[] getSelectedRows() {
        if (this.tableView != null) {
            return this.tableView.getSelectedRows();
        }
        return null;
    }

    public void setSelectedRow(int r) {
        if (this.tableView != null && r >= 0 && r < this.tableView.getRowCount()) {
            this.tableView.setRowSelectionInterval(r, r);
        }
    }

    public void addSelectedRow(int r) {
        if (this.tableView != null && r >= 0 && r < this.tableView.getRowCount()) {
            this.tableView.addRowSelectionInterval(r, r);
        }
    }

    public JTable getJTable() {
        return this.tableView;
    }

    public void setColumnsToFit() {
        TableColumn column = null;
        Component comp = null;
        int headerWidth = 0;
        int cellWidth = 0;
        for (int i = 0; i < this.data.getColumnCount(); ++i) {
            column = this.tableView.getColumnModel().getColumn(i);
            TableCellRenderer defaultRenderer = column.getHeaderRenderer();
            if (defaultRenderer == null) {
                JTableHeader th = this.tableView.getTableHeader();
                try {
                    Method m = th.getClass().getMethod("getDefaultRenderer", null);
                    defaultRenderer = (TableCellRenderer)m.invoke((Object)th, (Object[])null);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (defaultRenderer != null) {
                comp = defaultRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            }
            headerWidth = comp.getPreferredSize().width;
            cellWidth = 0;
            for (int j = 0; j < this.data.getRowCount(); ++j) {
                comp = this.tableView.getDefaultRenderer(this.data.getColumnClass(i)).getTableCellRendererComponent(this.tableView, this.data.getValueAt(j, i), false, false, 0, i);
                if (comp.getPreferredSize().width <= cellWidth) continue;
                cellWidth = comp.getPreferredSize().width;
            }
            column.setPreferredWidth(Math.max(headerWidth, cellWidth));
        }
    }

    public void removeSelectedRows() {
        if (!(this.data instanceof DefaultTableModel)) {
            return;
        }
        int[] rows = this.getSelectedRowsInTableModel();
        if (rows == null) {
            return;
        }
        this.clearSelection();
        for (int i = 0; i < rows.length; ++i) {
            ((DefaultTableModel)this.data).removeRow(rows[i]);
            for (int j = i + 1; j < rows.length; ++j) {
                if (rows[j] <= rows[i]) continue;
                int n = j;
                rows[n] = rows[n] - 1;
            }
        }
    }

    public void addTableModelListener(TableModelListener l) {
        this.sorter.addTableModelListener(l);
    }

    public Vector sortVectorByView(Vector modelVector) {
        if (this.sorter.getRowCount() != modelVector.size()) {
            return modelVector;
        }
        Vector v = new Vector(modelVector.size() + 1);
        for (int i = 0; i < this.sorter.getRowCount(); ++i) {
            v.addElement(modelVector.elementAt(this.sorter.getRowInTableModel(i)));
        }
        return v;
    }
}

