/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.util;

import com.agentpp.util.ConfigFile;
import com.agentpp.util.UserConfigEvent;
import com.agentpp.util.UserConfigListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseConfig
extends ConfigFile {
    protected transient boolean allowZeroLengthValues = false;
    private transient List _$6247;
    private transient boolean _$8649 = false;

    public BaseConfig(boolean init) {
        super(init);
    }

    public void setConfigName(String s) {
        super.setConfigFile("" + System.getProperty("user.home") + System.getProperty("file.separator") + s);
    }

    public synchronized void addChangeListener(UserConfigListener l) {
        if (this._$6247 == null) {
            this._$6247 = new ArrayList(2);
        }
        this._$6247.add(l);
    }

    public synchronized boolean removeChangeListener(UserConfigListener l) {
        if (this._$6247 != null) {
            return this._$6247.remove(l);
        }
        return false;
    }

    public void setDisableChangeEvents(boolean disableChangeEvents) {
        this._$8649 = disableChangeEvents;
    }

    public void put(String key, String s) {
        Object oldValue = this.properties.remove(key);
        if (s != null) {
            this.properties.put(key, s);
        }
        if (this._$6247 != null && (s != null && !s.equals(oldValue) || oldValue != null && s == null)) {
            this._$8657(new UserConfigEvent(this, key, oldValue, s));
        }
    }

    public String get(String key, String def) {
        return this.properties.getProperty(key, def);
    }

    public Vector getArray(String key) {
        String s = null;
        Vector<String> v = new Vector<String>();
        int i = 0;
        while ((s = this.get(key + i++, null)) != null) {
            if (this.allowZeroLengthValues || s.length() > 0) {
                v.add(s);
                continue;
            }
            v.add(null);
        }
        return v;
    }

    public String[] getStringArray(String key, String[] def) {
        String s = null;
        ArrayList<String> v = new ArrayList<String>();
        int i = 0;
        while ((s = this.get(key + i++, null)) != null) {
            if (this.allowZeroLengthValues || s.length() > 0) {
                v.add(s);
                continue;
            }
            v.add(null);
        }
        if (v.size() == 0) {
            return def;
        }
        return v.toArray(new String[v.size()]);
    }

    public Vector getArray(String key, int size) {
        String s = null;
        Vector<String> v = new Vector<String>(size);
        for (int i = 0; i < size; ++i) {
            s = this.get(key + i, null);
            if (this.allowZeroLengthValues || s != null && s.length() > 0) {
                v.add(s);
                continue;
            }
            v.add(null);
        }
        return v;
    }

    public void putArray(String key, List v) {
        int i = 0;
        while (this.get(key + i, null) != null) {
            this.remove(key + i);
            ++i;
        }
        if (v == null) {
            return;
        }
        for (i = 0; i < v.size(); ++i) {
            if (v.get(i) != null) {
                this.put(key + i, v.get(i).toString());
                continue;
            }
            this.remove(key + i);
        }
        this.remove(key + i);
    }

    public final void putTable(String[] keys, List<String[]> values) {
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            ArrayList<String> vlist = new ArrayList<String>(values.size());
            for (String[] row : values) {
                vlist.add(row[i]);
            }
            this.putArray(key, vlist);
        }
    }

    public List<String[]> getTable(String[] keys) {
        ArrayList<String[]> v = new ArrayList<String[]>();
        ArrayList<Vector> cols = new ArrayList<Vector>(keys.length);
        int max = 0;
        for (int k = 0; k < keys.length; ++k) {
            cols.add(this.getArray(keys[k]));
            int cur = ((List)cols.get(cols.size() - 1)).size();
            if (cur <= max) continue;
            max = cur;
        }
        for (int i = 0; i < max; ++i) {
            String[] row = new String[keys.length];
            for (int k = 0; k < keys.length; ++k) {
                if (((List)cols.get(k)).size() <= i) continue;
                row[k] = (String)((List)cols.get(k)).get(i);
            }
            v.add(row);
        }
        return v;
    }

    public void putInteger(String key, int value) {
        this.put(key, "" + value);
    }

    public int getInteger(String key, int defValue) {
        try {
            return Integer.parseInt(this.get(key, "" + defValue));
        }
        catch (NumberFormatException nfex) {
            return defValue;
        }
    }

    public void putLong(String key, long value) {
        this.put(key, "" + value);
    }

    public long getLong(String key, long defValue) {
        try {
            return Long.parseLong(this.get(key, "" + defValue));
        }
        catch (NumberFormatException nfex) {
            return defValue;
        }
    }

    public void putBoolean(String key, boolean value) {
        this.put(key, "" + value);
    }

    public boolean getBoolean(String key, boolean defValue) {
        return Boolean.valueOf(this.get(key, "" + defValue));
    }

    public void putEnumeration(String key, Enumeration e) {
        int i = 0;
        while (e.hasMoreElements()) {
            this.put(key + i, e.nextElement().toString());
            ++i;
        }
        this.remove(key + i);
    }

    public void remove(String key) {
        Object oldValue = this.properties.remove(key);
        if (this._$6247 != null) {
            this._$8657(new UserConfigEvent(this, key, oldValue, null));
        }
    }

    public void removeAll(String keyPrefix) {
        Enumeration<?> en = this.properties.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!key.startsWith(keyPrefix)) continue;
            this.remove(key);
        }
    }

    private synchronized void _$8657(UserConfigEvent event) {
        if (this._$6247 != null && !this._$8649) {
            Iterator it = this._$6247.iterator();
            while (it.hasNext()) {
                ((UserConfigListener)it.next()).configChanged(event);
            }
        }
    }
}

