/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.smiparser.FileError;
import java.util.List;
import java.util.Vector;

public class SMIParseException
extends Exception {
    public static final int UNKNOWN = 0;
    public static final int FILE_NOT_FOUND = 10;
    public static final int IO_ERROR = 20;
    public static final int LEXICAL_ERROR = 50;
    public static final int PARSE = 1000;
    public static final int PARSE_DISPLAYHINT = 1001;
    public static final int PARSE_EXTUTCTIME = 1002;
    public static final int IDENTIFIER_TOO_LONG = 1010;
    public static final int DUPLICATE_IDENTIFIER = 1020;
    public static final int ILLEGAL_CLAUSE = 1050;
    public static final int IMPORT_UNKNOWN = 1100;
    public static final int CIRCULAR_IMPORT = 1101;
    public static final int DUPLICATE_IMPORT_SOURCE = 1102;
    public static final int WRONG_IMPORT = 1110;
    public static final int MISSING_IMPORT = 1111;
    public static final int INCONSISTENT_IMPORT = 1112;
    public static final int DUPLICATE_IMPORT = 1113;
    public static final int ILLEGAL_IMPORT = 1114;
    public static final int MODULE_ORDER = 1150;
    public static final int INCONSISTENT_SYNTAX = 1200;
    public static final int INCONSISTENT_STATUS = 1201;
    public static final int INCONSISTENT_ACCESS = 1202;
    public static final int CONDITIONAL_GROUP_IS_ALSO_MANDATORY = 1210;
    public static final int VARIATION_NOT_IN_GROUP = 1211;
    public static final int ILLEGAL_ACCESS_FOR_NOTIFY_VARIATION = 1212;
    public static final int CREATION_REQUIRES_NOT_ALLOWED = 1220;
    public static final int CREATION_REQUIRES_ONLY_READCREATE_COLS = 1221;
    public static final int UNDEF_SYNTAX = 1500;
    public static final int UNDEF_OBJECT = 1501;
    public static final int UNDEF_NAME = 1502;
    public static final int REFERENCE_IS_NOT_A_TABLE = 1600;
    public static final int REFERENCE_IS_NOT_GROUP = 1601;
    public static final int REFERENCE_IS_NOT_OBJECTTYPE = 1602;
    public static final int WRONG_TYPE = 1700;
    public static final int INCONSISTENT_TABLE = 1800;
    public static final int INCONSISTENT_TABLE_DEF = 1801;
    public static final int INVALID_INDEX = 1810;
    public static final int INVALID_INDEX_LENGTH = 1812;
    public static final int INVALID_INDEX_IMPLIED_LENGTH = 1813;
    public static final int MISSING_INDEX = 1811;
    public static final int NEGATIVE_INDEX = 1820;
    public static final int SCALAR_INDEX = 1850;
    public static final int SCALAR_WITH_INDEX = 1851;
    public static final int DUPLICATE_REGISTRATION = 2000;
    public static final int ILLEGAL_REGISTRATION = 2010;
    public static final int DEFAULT_VALUE_OUT_OF_RANGE = 3000;
    public static final int DEFAULT_VALUE_SIZE_OUT_OF_RANGE = 3001;
    public static final int DEFAULT_VALUE_INVALID = 3002;
    public static final int DEFAULT_VALUE_ILLEGAL = 3003;
    public static final int INVALID_SYNTAX_REFINEMENT = 4000;
    public static final int INVALID_RANGE = 4010;
    public static final int DISPLAYHINT_NOT_ALLOWED = 4100;
    public static final int DISPLAYHINT_WRONG_TYPE = 4101;
    public static final int NOT_IN_GROUP = 5000;
    public static final int NOACCESS_IN_GROUP = 5100;
    public static final int PIB_INDEX_NOT_INSTANCEID = 1815;
    public boolean typedException = false;
    public int errorType = 0;
    public FileError fileError = null;
    public Vector objects = null;
    private List errorList = null;

    public SMIParseException() {
    }

    public SMIParseException(String message) {
        super(message);
    }

    public SMIParseException(String message, int errType) {
        super(message);
        this.typedException = true;
        this.errorType = errType;
    }

    public SMIParseException(String message, int errType, Vector objects) {
        super(message);
        this.typedException = true;
        this.errorType = errType;
        this.objects = objects;
    }

    public SMIParseException(String message, int errType, FileError err) {
        super(message);
        this.typedException = true;
        this.errorType = errType;
        this.fileError = err;
    }

    public SMIParseException(FileError ex, int errType) {
        this.typedException = true;
        this.errorType = errType;
        this.fileError = ex;
    }

    public SMIParseException(FileError ex, int errType, Vector objects) {
        this.typedException = true;
        this.errorType = errType;
        this.fileError = ex;
        this.objects = objects;
    }

    public List getErrorList() {
        return this.errorList;
    }

    public void setErrorList(List errorList) {
        this.errorList = errorList;
    }

    public static boolean addUniqueException(List errors, Exception ex) {
        if (!errors.contains(ex)) {
            if (!(ex instanceof SMIParseException) && ex instanceof FileError) {
                FileError err = (FileError)((Object)ex);
                errors.add(new SMIParseException(ex.getMessage(), err.getErrorType(), err));
            } else {
                errors.add(ex);
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SMIParseException) {
            SMIParseException pex = (SMIParseException)obj;
            return pex.errorType == this.errorType && (pex.fileError != null && pex.fileError.equals(this.fileError) || pex.fileError == null && this.fileError == null && pex.getMessage().equals(this.getMessage()));
        }
        return false;
    }

    public void freeUnusedTokens() {
        if (this.fileError != null && this.fileError != this) {
            this.fileError.freeUnusedTokens();
        }
        if (this.errorList != null) {
            for (Object fe : this.errorList) {
                if (fe == this) continue;
                if (fe instanceof FileError) {
                    ((FileError)fe).freeUnusedTokens();
                    continue;
                }
                if (!(fe instanceof SMIParseException)) continue;
                ((SMIParseException)fe).freeUnusedTokens();
            }
        }
    }

    public boolean hasLocationInfo() {
        return this.fileError != null;
    }
}

