/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.smiparser.Node;
import com.agentpp.smiparser.SMIObjectIdentifier;
import com.agentpp.smiparser.SMIRepository;
import com.agentpp.smiparser.SimpleNode;
import com.agentpp.smiparser.StringToken;
import java.util.Vector;

public class SMIObject
extends SimpleNode {
    private String name;
    private String status = null;
    private int type = 0;
    public String asn1Comment = null;
    public String inlineAsn1Comment;
    public Integer sequenceID = null;
    public static final int ID = -1;

    public SMIObject() {
        super(-1);
    }

    public void setType(int newType) {
        this.type = newType;
    }

    public int getType() {
        return this.type;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public static Vector getUpTreeSMIObjects(Node o) {
        Vector<SMIObject> v = new Vector<SMIObject>();
        if (o == null) {
            return v;
        }
        SMIObject n = SMIObject.getParentSMIObject(o);
        while (n != null) {
            v.addElement(n);
            Node p = n.jjtGetParent();
            if (p != null) {
                int sz = p.jjtGetNumChildren();
                for (int i = 0; i < sz; ++i) {
                    if (((SimpleNode)p.jjtGetChild((int)i)).id != -1) continue;
                    v.addElement((SMIObject)p.jjtGetChild(i));
                }
            }
            n = SMIObject.getParentSMIObject(n);
        }
        return v;
    }

    public static SMIObject getParentSMIObject(Node o) {
        if (o.jjtGetParent() == null) {
            return null;
        }
        if (((SimpleNode)o.jjtGetParent()).id == -1) {
            return (SMIObject)o.jjtGetParent();
        }
        return SMIObject.getParentSMIObject(o.jjtGetParent());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getOid(SMIRepository smiRep) {
        int sz = this.jjtGetNumChildren();
        for (int i = 0; i < sz; ++i) {
            if (!(this.jjtGetChild(i) instanceof SMIObjectIdentifier)) continue;
            return ((SMIObjectIdentifier)this.jjtGetChild(i)).getOid(smiRep);
        }
        return new String[0];
    }

    public StringToken getFirstUnresolvedSubId(SMIRepository smiRep) {
        int sz = this.jjtGetNumChildren();
        for (int i = 0; i < sz; ++i) {
            if (!(this.jjtGetChild(i) instanceof SMIObjectIdentifier)) continue;
            return ((SMIObjectIdentifier)this.jjtGetChild(i)).getFirstUnresolvedSubId(smiRep);
        }
        return null;
    }

    public String getPrintableOid(SMIRepository smiRep) {
        String[] subids = this.getOid(smiRep);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < subids.length; ++i) {
            buf.append(subids[i]);
            if (i + 1 >= subids.length) continue;
            buf.append(".");
        }
        return buf.toString();
    }
}

