/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.smiparser.FileError;
import com.agentpp.smiparser.Token;
import java.util.ArrayList;

public class ParseException
extends Exception
implements FileError {
    private boolean next = true;
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    public int errorType = 1000;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException(String message, Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super(message);
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException(String message, Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal, int errorType) {
        super(message);
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
        this.errorType = errorType;
        this.next = false;
    }

    public ParseException(String message, Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal, int errorType, boolean next) {
        super(message);
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
        this.errorType = errorType;
        this.next = next;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String message) {
        super(message);
        this.specialConstructor = false;
    }

    public void freeUnusedTokens() {
        int maxSize = 0;
        if (this.expectedTokenSequences != null) {
            for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
                if (maxSize >= this.expectedTokenSequences[i].length) continue;
                maxSize = this.expectedTokenSequences[i].length;
            }
        }
        if (this.next) {
            ++maxSize;
        }
        Token tok = this.currentToken;
        for (int i = 0; i < maxSize && tok != null; ++i) {
            tok.specialToken = null;
            tok = tok.next;
        }
        if (tok != null) {
            tok.next = null;
            tok.specialToken = null;
        }
    }

    public Token getToken() {
        if (this.next) {
            return this.currentToken.next;
        }
        return this.currentToken;
    }

    public int getErrorType() {
        return this.errorType;
    }

    private String getEntcountered(int maxSize) {
        String retval = "";
        if (super.getMessage().length() > 0) {
            retval = retval + "\n";
        }
        retval = retval + "Encountered \"";
        Token tok = this.getToken();
        for (int i = 0; i < maxSize && tok != null; ++i) {
            if (i != 0) {
                retval = retval + " ";
            }
            if (tok.kind == 0) {
                retval = retval + this.tokenImage[0];
                break;
            }
            retval = retval + this.add_escapes(tok.image);
            tok = tok.next;
        }
        retval = retval + "\"";
        return retval;
    }

    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        String expected = "";
        int maxSize = 0;
        if (this.expectedTokenSequences != null) {
            for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
                if (maxSize < this.expectedTokenSequences[i].length) {
                    maxSize = this.expectedTokenSequences[i].length;
                }
                for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                    expected = expected + this.tokenImage[this.expectedTokenSequences[i][j]] + " ";
                }
                if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                    expected = expected + "...";
                }
                expected = expected + this.eol + "  ";
            }
        } else if (this.tokenImage != null && this.tokenImage.length > 0) {
            maxSize = 1;
            for (String expectedToken : this.tokenImage) {
                expected = expected + "\"" + expectedToken + "\"" + " ";
            }
        } else {
            maxSize = 1;
        }
        String retval = "";
        switch (this.errorType) {
            case 1001: 
            case 1002: 
            case 1020: {
                Token tok = this.getToken();
                if (tok != null) {
                    retval = retval + super.getMessage();
                    retval = retval + " at line " + tok.beginLine + ", column " + tok.beginColumn;
                    return retval;
                }
            }
            case 1102: 
            case 1811: 
            case 4010: {
                return super.getMessage();
            }
        }
        retval = retval + super.getMessage();
        retval = retval + this.getEntcountered(maxSize);
        Token tok = this.getToken();
        if (tok == null) {
            tok = this.currentToken;
        }
        retval = retval + " at line " + tok.beginLine + ", column " + tok.beginColumn + ": " + this.eol;
        if (maxSize > 0) {
            retval = maxSize == 1 ? retval + "Was expecting: " + this.eol + "  " : retval + "Was expecting one of: " + this.eol + "  ";
        }
        retval = retval + expected;
        return retval;
    }

    public String[] getExpected() {
        if (!this.specialConstructor) {
            return new String[0];
        }
        int len = 0;
        if (this.expectedTokenSequences != null) {
            len = this.expectedTokenSequences.length;
        }
        String[] expected = new String[len];
        if (len == 0) {
            return expected;
        }
        expected[0] = "";
        for (int i = 0; i < len; ++i) {
            expected[i] = new String();
            for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                int n = i;
                expected[n] = expected[n] + this.tokenImage[this.expectedTokenSequences[i][j]] + " ";
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] == 0) continue;
            int n = i;
            expected[n] = expected[n] + "...";
        }
        return expected;
    }

    public String[] getExpectedImages() {
        if (!this.specialConstructor) {
            return new String[0];
        }
        int len = 0;
        if (this.expectedTokenSequences != null) {
            len = this.expectedTokenSequences.length;
        }
        String[] expected = new String[len];
        if (len == 0) {
            return expected;
        }
        expected[0] = "";
        for (int i = 0; i < len; ++i) {
            expected[i] = new String();
            for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                int n = i;
                expected[n] = expected[n] + this.tokenImage[this.expectedTokenSequences[i][j]] + " ";
            }
        }
        return expected;
    }

    private int getMaxExpectedTokenSequenceLength() {
        int len = 0;
        if (this.expectedTokenSequences != null) {
            len = this.expectedTokenSequences.length;
        }
        int max = 0;
        for (int i = 0; i < len; ++i) {
            if (this.expectedTokenSequences[i].length <= max) continue;
            max = this.expectedTokenSequences[i].length;
        }
        return max;
    }

    public String[] getLastExpectedImages() {
        if (!this.specialConstructor) {
            return new String[0];
        }
        int len = 0;
        if (this.expectedTokenSequences != null) {
            len = this.expectedTokenSequences.length;
        }
        ArrayList<String> expected = new ArrayList<String>(len);
        if (len == 0) {
            return new String[0];
        }
        int max = this.getMaxExpectedTokenSequenceLength();
        for (int i = 0; i < len; ++i) {
            String s = "";
            if (this.expectedTokenSequences[i].length >= max) {
                for (int j = max - 1; j < this.expectedTokenSequences[i].length; ++j) {
                    s = s + this.tokenImage[this.expectedTokenSequences[i][j]] + " ";
                }
            }
            expected.add(s);
        }
        return expected.toArray(new String[0]);
    }

    public String getFoundTokenImage() {
        switch (this.errorType) {
            case 1020: {
                return super.getMessage();
            }
        }
        String found = "";
        int maxSize = 0;
        if (this.expectedTokenSequences != null) {
            for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
                if (maxSize >= this.expectedTokenSequences[i].length) continue;
                maxSize = this.expectedTokenSequences[i].length;
            }
        }
        Token tok = this.getToken();
        for (int i = 0; i < maxSize && tok != null; ++i) {
            if (i != 0) {
                found = found + " ";
            }
            if (tok.kind == 0) {
                found = found + this.tokenImage[0];
                break;
            }
            found = found + tok.image;
            tok = tok.next;
        }
        return found;
    }

    public String getFound() {
        switch (this.errorType) {
            case 1020: 
            case 1102: 
            case 4010: {
                return super.getMessage();
            }
        }
        String found = "";
        int maxSize = 0;
        if (this.expectedTokenSequences != null) {
            for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
                if (maxSize >= this.expectedTokenSequences[i].length) continue;
                maxSize = this.expectedTokenSequences[i].length;
            }
        }
        Token tok = this.getToken();
        for (int i = 0; i < maxSize && tok != null; ++i) {
            if (i != 0) {
                found = found + " ";
            }
            if (tok.kind == 0) {
                found = found + this.tokenImage[0];
                break;
            }
            found = found + this.add_escapes(tok.image);
            tok = tok.next;
        }
        return found;
    }

    public int getLine() {
        if (!this.specialConstructor) {
            return 0;
        }
        Token tok = this.getToken();
        if (tok == null) {
            tok = this.currentToken;
        }
        return tok.beginLine;
    }

    public Token getEndToken() {
        Token tok = this.getLastToken();
        if (tok == null) {
            tok = this.getToken();
        }
        return tok;
    }

    private Token getLastToken() {
        Token tok;
        switch (this.errorType) {
            case 1020: {
                return this.getToken();
            }
        }
        int maxSize = 0;
        if (this.expectedTokenSequences != null) {
            for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
                if (maxSize >= this.expectedTokenSequences[i].length) continue;
                maxSize = this.expectedTokenSequences[i].length;
            }
        }
        Token endtok = tok = this.getToken();
        for (int i = 0; i < maxSize && tok != null && tok.kind != 0; ++i) {
            endtok = tok;
            tok = tok.next;
        }
        return endtok;
    }

    public int getLastEndPosition() {
        Token tok = this.getLastToken();
        return tok.endPos;
    }

    public int getEndPosition() {
        if (!this.specialConstructor) {
            return 0;
        }
        Token tok = this.getToken();
        if (tok == null) {
            tok = this.currentToken;
        }
        return tok.endPos;
    }

    public int getColumn() {
        if (!this.specialConstructor) {
            return 0;
        }
        Token tok = this.getToken();
        if (tok == null) {
            tok = this.currentToken;
        }
        return tok.beginColumn;
    }

    public int getEndLine() {
        if (!this.specialConstructor) {
            return 0;
        }
        return this.getEndToken().endLine;
    }

    public int getEndColumn() {
        if (!this.specialConstructor) {
            return 0;
        }
        return this.getEndToken().endColumn;
    }

    public String toString() {
        return this.getMessage();
    }

    protected String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        block11: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block11;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileError) {
            FileError pex = (FileError)obj;
            return pex.getErrorType() == this.getErrorType() && pex.getEndPosition() == this.getEndPosition() && pex.getToken() == pex.getToken();
        }
        return false;
    }
}

