/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.MIBVariation;
import com.agentpp.smiparser.SMI;
import com.agentpp.smiparser.SMI2Java;
import com.agentpp.smiparser.SMIAgentCapabilities;
import com.agentpp.smiparser.SMICompliance;
import com.agentpp.smiparser.SMIDefaultValue;
import com.agentpp.smiparser.SMIDescription;
import com.agentpp.smiparser.SMIFile;
import com.agentpp.smiparser.SMIImportList;
import com.agentpp.smiparser.SMIIndex;
import com.agentpp.smiparser.SMIMib;
import com.agentpp.smiparser.SMIModule;
import com.agentpp.smiparser.SMINotifyType;
import com.agentpp.smiparser.SMIObject;
import com.agentpp.smiparser.SMIObjectType;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIRepository;
import com.agentpp.smiparser.SMIRevision;
import com.agentpp.smiparser.SMISeqEntries;
import com.agentpp.smiparser.SMISyntax;
import com.agentpp.smiparser.SMITextualConvention;
import com.agentpp.smiparser.SimpleNode;
import com.agentpp.smiparser.StringToken;
import com.agentpp.smiparser.Token;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

public class LenientSMI2Java
extends SMI2Java {
    public LenientSMI2Java(SMIRepository r, int options) {
        super(r, options);
    }

    protected void checkVariation(String s, MIBVariation v, Token t) {
    }

    protected void checkAgentCaps(MIBAgentCaps ac) throws SMIParseException {
    }

    protected void checkSyntax(String oname, String syntax) throws SMIParseException {
        String s = (String)this.nameToSyntax.get(oname);
        this.nameToSyntax.put(oname, syntax);
    }

    protected void checkWhetherIndexIsPositive(MIBObjectType ot) throws SMIParseException {
    }

    protected String readImports(SMIImportList list) throws SMIParseException {
        String cyclic;
        String source = list.getSource();
        Vector entries = list.getImports();
        if (!(this.smiRep.isModuleAlreadyImported(source) || this.smiRep.importModule(source, this.rep, false) || this.failedImports.contains(source))) {
            this.failedImports.add(source);
            this.throwLocalizedError(list.getToken(), new Vector<String>(Arrays.asList(source)), 1100, source);
        }
        if ((cyclic = this.smiRep.hasCircularImport(source, this.currentModule.getModuleName())) != null) {
            this.throwLocalizedError(list.getToken(), new Vector<String>(Arrays.asList(cyclic)), 1101, source);
        }
        Enumeration en = entries.elements();
        while (en.hasMoreElements()) {
            MIBObject o;
            String oname = (String)en.nextElement();
            if (SMI.isASN1KeyWord(oname) || (o = this.smiRep.getObject(source, oname)) == null) continue;
            Vector sources = this.currentModule.getImportSources(oname);
            if (sources.size() > 0) {
                MIBObject dup;
                String moduleName;
                if (!sources.contains(source) && (moduleName = this.smiRep.getModuleName((dup = this.smiRep.getKnownObject(oname)).getModuleID())) != null) {
                    dup = dup.getClone();
                    dup.setName(moduleName + "." + dup.getName());
                    this.smiRep.replaceKnownObject(oname, dup);
                }
                o = o.getClone();
                o.setName(source + "." + o.getName());
                this.smiRep.addKnownObject(o);
                continue;
            }
            this.smiRep.addKnownObject(o);
        }
        MIBImport mi = new MIBImport(source, entries, list.comment);
        this.currentModule.addImport(mi);
        ((SMIRepository)list.jjtGetRoot()).createOids(this.currentModule.getModuleName());
        this.currentModuleInfo.addImport(source);
        return source;
    }

    public Object visit(SimpleNode node, Object data) throws SMIParseException {
        if (this.currentModuleInfo != null || node.getId() == -4) {
            switch (node.getId()) {
                case -5: {
                    this.currentFile = ((SMIFile)node).getName();
                    break;
                }
                case -4: {
                    this.smiRep.setScope(((SMIMib)node).getName(), this);
                    this.currentModuleInfo = this.readModule((SMIMib)node);
                    ((Vector)data).addElement(this.currentModuleInfo);
                    break;
                }
                case -3: {
                    this.readModuleIdentity((SMIModule)node);
                    break;
                }
                case -1: {
                    this.currentSyntax = null;
                    if (((SMIObject)node).getType() == 11) break;
                    this.readObject((SMIObject)node);
                    break;
                }
                case -16: {
                    this.readObjectType((SMIObjectType)node);
                    break;
                }
                case -15: {
                    this.readNotifyType((SMINotifyType)node);
                    break;
                }
                case -12: {
                    break;
                }
                case -20: {
                    this.readSeqEntries((SMISeqEntries)node);
                    break;
                }
                case -7: {
                    if (this.currentObject == null) break;
                    this.currentObject.setDescription(((SMIDescription)node).getValue());
                    break;
                }
                case -24: {
                    if (this.currentObject == null) break;
                    this.currentObject.setReference(node.toString());
                    break;
                }
                case -19: {
                    this.readRevision((SMIRevision)node);
                    break;
                }
                case -8: {
                    if (!(this.currentObject instanceof MIBObjectType)) break;
                    MIBObjectType ot = (MIBObjectType)this.currentObject;
                    ot.setDefaultValue(((SMIDefaultValue)node).getDefaultValue());
                    break;
                }
                case -21: {
                    this.readSyntax((SMISyntax)node);
                    break;
                }
                case -23: {
                    this.readVariable(new StringToken(node.toString(), node.getToken()));
                    break;
                }
                case -14: {
                    this.readIndex((SMIIndex)node);
                    break;
                }
                case -22: {
                    MIBTextualConvention tc = (MIBTextualConvention)this.currentObject;
                    SMITextualConvention t = (SMITextualConvention)node;
                    tc.setDisplayHint(t.getDisplayHint());
                    tc.setSyntax(t.syntax);
                    this.currentSyntax = t.syntax;
                    this.checkSyntax(tc.getName(), this.currentSyntax.getSyntax());
                    switch (this.currentSyntax.getType()) {
                        case 2: 
                        case 3: {
                            this.smiRep.checkUnresolvedSyntax((StringToken)this.currentSyntax.userObject);
                        }
                    }
                    this.smiRep.replaceKnownObject(tc.getName(), tc);
                    break;
                }
                case -9: {
                    this.readAgentCaps((SMIAgentCapabilities)node);
                    break;
                }
                case -11: {
                    this.readCompliance((SMICompliance)node);
                    break;
                }
                case -13: {
                    this.currentModuleInfo.addImport(this.readImports((SMIImportList)node));
                    break;
                }
            }
        }
        node.childrenAccept(this, data);
        switch (node.getId()) {
            case -4: {
                this.smiRep.resolveSyntaxes();
                ++this.moduleCount;
            }
        }
        return data;
    }
}

