/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.smiparser.ModuleInfo;
import com.agentpp.smiparser.SMIAgentCapabilities;
import com.agentpp.smiparser.SMICompliance;
import com.agentpp.smiparser.SMIImportList;
import com.agentpp.smiparser.SMIMib;
import com.agentpp.smiparser.SMIModule;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIParserVisitor;
import com.agentpp.smiparser.SMIRepository;
import com.agentpp.smiparser.SimpleNode;
import java.util.Vector;

public class FindImportsVisitor
implements SMIParserVisitor {
    private Vector result = new Vector();
    protected ModuleInfo currentModuleInfo = null;
    private SMIRepository smiRep;

    public FindImportsVisitor(SMIRepository smiRep) {
        this.smiRep = smiRep;
    }

    protected ModuleInfo readModule(SMIMib current) throws SMIParseException {
        return new ModuleInfo(current.getName());
    }

    public Object visit(SimpleNode node, Object data) throws SMIParseException {
        if (this.currentModuleInfo != null || node.getId() == -4) {
            switch (node.getId()) {
                case -4: {
                    this.smiRep.setScope(((SMIMib)node).getName(), null);
                    this.currentModuleInfo = this.readModule((SMIMib)node);
                    ((Vector)data).addElement(this.currentModuleInfo);
                    break;
                }
                case -3: {
                    String lastUpdated = ((SMIModule)node).getLastUpdated();
                    if (lastUpdated == null) break;
                    try {
                        this.currentModuleInfo.setLastUpdated(MIBModule.getDateFromUTC(lastUpdated));
                    }
                    catch (Exception ex) {}
                    break;
                }
                case -13: {
                    this.currentModuleInfo.addImport(((SMIImportList)node).getSource());
                    break;
                }
                case -9: {
                    SMIAgentCapabilities n = (SMIAgentCapabilities)node;
                    for (int i = 0; i < n.acModules.size(); ++i) {
                        MIBSupportedModule m = (MIBSupportedModule)n.acModules.get(i);
                        if (m.getSupports() == null || m.getSupports().length() <= 0) continue;
                        this.currentModuleInfo.addImport(m.getSupports());
                    }
                    break;
                }
                case -11: {
                    SMICompliance n = (SMICompliance)node;
                    for (int i = 0; i < n.modules.size(); ++i) {
                        MIBComplianceModule m = (MIBComplianceModule)n.modules.get(i);
                        if (m.getModuleName() == null || m.getModuleName().length() <= 0) continue;
                        this.currentModuleInfo.addImport(m.getModuleName());
                    }
                    break;
                }
            }
        }
        node.childrenAccept(this, data);
        return data;
    }

    public Vector getResult() {
        return this.result;
    }
}

