/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smi.examples;

import com.agentpp.smi.IModule;
import com.agentpp.smi.IModuleInfo;
import com.agentpp.smi.IModuleInfoSorter;
import com.agentpp.smi.IObject;
import com.agentpp.smi.IRepository;
import com.agentpp.smi.SMIRepository;
import com.agentpp.smi.SMIRepositoryManager;
import com.agentpp.smi.event.ImportModuleEvent;
import com.agentpp.smi.event.ImportModuleListener;
import com.agentpp.smiparser.SMIParseException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DumpObjectNames
implements ImportModuleListener {
    private SMIRepositoryManager repMan;
    private String mibFileDir;
    private boolean useCache = false;
    private Hashtable moduleHash = new Hashtable();
    private Hashtable moduleFileNames = new Hashtable();
    private static int moduleID = 1;

    public DumpObjectNames(String license, String licenseKey, String mibFileDir, String cache) {
        this.useCache = Boolean.valueOf(cache);
        this.repMan = new SMIRepositoryManager(license, licenseKey);
        this.mibFileDir = mibFileDir;
    }

    public void run() {
        File f = new File(this.mibFileDir);
        Vector v = DumpObjectNames.getSubtree(f);
        Vector<IModuleInfo> moduleInfos = new Vector<IModuleInfo>();
        Vector<File> files = new Vector<File>();
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            f = (File)en.nextElement();
            try {
                IModuleInfo[] mi = this.repMan.getModuleInfo(f);
                for (int i = 0; i < mi.length; ++i) {
                    moduleInfos.addElement(mi[i]);
                    this.moduleFileNames.put(mi[i].getModuleName(), f);
                }
                files.addElement(f);
            }
            catch (Exception ex) {
                System.err.println("Error in file " + f.getPath() + ": " + ex.toString());
            }
        }
        Object[] infoList = new IModuleInfo[moduleInfos.size()];
        moduleInfos.copyInto(infoList);
        IModuleInfoSorter sorter = new IModuleInfoSorter((IModuleInfo[])infoList);
        if (!sorter.sort()) {
            System.err.println("Could not resolve all imports!");
        }
        infoList = sorter.getSortedList();
        SMIRepository repository = new SMIRepository();
        for (int i = 0; i < infoList.length; ++i) {
            try {
                f = (File)this.moduleFileNames.get(infoList[i].getModuleName());
                if (f == null) continue;
                FileInputStream fis = new FileInputStream(f);
                IModule[] modules = this.repMan.getModules(fis, this);
                fis.close();
                for (int j = 0; j < modules.length; ++j) {
                    if (this.useCache) {
                        this.moduleHash.put(modules[j].getModuleName(), modules[j]);
                    }
                    repository.addObject(modules[j]);
                    Enumeration en2 = modules[j].objects();
                    while (en2.hasMoreElements()) {
                        repository.addObject((IObject)en2.nextElement());
                    }
                }
                repository.structureChanged();
                continue;
            }
            catch (SMIParseException pex) {
                System.out.println("Errors of " + infoList[i].getModuleName() + ":");
                if (pex.getErrorList() != null && pex.getErrorList().size() > 0) {
                    for (int j = 0; j < pex.getErrorList().size(); ++j) {
                        SMIParseException p = (SMIParseException)pex.getErrorList().get(j);
                        System.out.println("#" + (j + 1) + ": " + this.repMan.getErrorText(p));
                    }
                    continue;
                }
                System.out.println(this.repMan.getErrorText(pex));
                continue;
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
        DumpObjectNames.dumpRepository(repository);
    }

    private static void dumpRepository(IRepository repository) {
        try {
            Vector v = repository.getObjectClassOID("sysDescr.0");
            System.out.println("Resolved OID 'sysDescr.0': class=" + v.elementAt(0) + ", instance suffix=" + v.elementAt(1));
        }
        catch (Exception ex) {
            System.out.println("MIB modules do not include sysDescr.0!");
        }
        Enumeration en = repository.objects();
        while (en.hasMoreElements()) {
            IObject o = (IObject)en.nextElement();
            System.out.println(o.getName() + " = " + o.getPrintableOid());
        }
    }

    public Integer createModuleID(String moduleName) {
        return new Integer(moduleID++);
    }

    public void freeModuleID(Integer i, String moduleName) {
    }

    public void importModule(ImportModuleEvent e) {
        if (this.useCache) {
            IModule m = (IModule)this.moduleHash.get(e.getModuleName());
            if (m != null) {
                Vector v = m.getObjectsVector();
                Object[] objs = new IObject[v.size()];
                v.copyInto(objs);
                e.setObjects((IObject[])objs);
            }
        } else {
            File f = (File)this.moduleFileNames.get(e.getModuleName());
            if (f != null) {
                try {
                    FileInputStream fis = new FileInputStream(f);
                    IModule[] modules = this.repMan.getModules(fis, this);
                    fis.close();
                    for (int i = 0; i < modules.length; ++i) {
                        if (!modules[i].getModuleName().equals(e.getModuleName())) continue;
                        Object[] objs = new IObject[modules[i].size()];
                        Vector v = modules[i].getObjectsVector();
                        v.copyInto(objs);
                        e.setObjects((IObject[])objs);
                        return;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static Vector getSubtree(File directory) {
        if (directory.isDirectory()) {
            int i;
            File[] files = directory.listFiles(new FileFilter(){

                public boolean accept(File f) {
                    return !f.isDirectory();
                }
            });
            File[] dirs = directory.listFiles(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory();
                }
            });
            Vector<File> v = new Vector<File>(files.length, 10);
            for (i = 0; i < files.length; ++i) {
                v.addElement(files[i]);
            }
            for (i = 0; i < dirs.length; ++i) {
                v.addAll(DumpObjectNames.getSubtree(dirs[i]));
            }
            return v;
        }
        return new Vector();
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Usage: DumpObjectNames <license> <licenseKey> <mibFileDir> <useCache>");
            System.out.println("where: <useCache>   is \"true\" or \"false\"");
            System.out.println("       <mibFileDir> is a directory containing SMIv1/v2 MIB files.");
            System.exit(1);
        }
        DumpObjectNames dumpObjectNames = new DumpObjectNames(args[0], args[1], args[2], args[3]);
        dumpObjectNames.run();
    }
}

